/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.generator;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import gregtech.api.GTValues;
import gregtech.api.capability.IRotorHolder;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.MultiblockFuelRecipeLogic;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.ProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.TemplateBarBuilder;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.sync.FixedIntArraySyncValue;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.metatileentities.multi.electric.generator.LargeTurbineWorkableHandler;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLargeTurbine
extends FuelMultiblockController
implements ITieredMetaTileEntity,
ProgressBarMultiblock {
    public final int tier;
    public final IBlockState casingState;
    public final IBlockState gearboxState;
    public final ICubeRenderer casingRenderer;
    public final boolean hasMufflerHatch;
    public final ICubeRenderer frontOverlay;
    private static final int MIN_DURABILITY_TO_WARN = 10;
    public IFluidHandler exportFluidHandler;

    public MetaTileEntityLargeTurbine(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, int tier, IBlockState casingState, IBlockState gearboxState, ICubeRenderer casingRenderer, boolean hasMufflerHatch, ICubeRenderer frontOverlay) {
        super(metaTileEntityId, recipeMap, tier);
        this.casingState = casingState;
        this.gearboxState = gearboxState;
        this.casingRenderer = casingRenderer;
        this.hasMufflerHatch = hasMufflerHatch;
        this.frontOverlay = frontOverlay;
        this.tier = tier;
        this.recipeMapWorkable = new LargeTurbineWorkableHandler((RecipeMapMultiblockController)this, tier);
        this.recipeMapWorkable.setMaximumOverclockVoltage(GTValues.V[tier]);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeTurbine(this.metaTileEntityId, this.recipeMap, this.tier, this.casingState, this.gearboxState, this.casingRenderer, this.hasMufflerHatch, this.frontOverlay);
    }

    public IRotorHolder getRotorHolder() {
        List<IRotorHolder> abilities = this.getAbilities(MultiblockAbility.ROTOR_HOLDER);
        if (abilities.isEmpty()) {
            return null;
        }
        return abilities.get(0);
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.exportFluidHandler = null;
    }

    public boolean isRotorFaceFree() {
        IRotorHolder rotorHolder = this.getRotorHolder();
        if (rotorHolder != null) {
            return this.isStructureFormed() && this.getRotorHolder().isFrontFaceFree();
        }
        return false;
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.exportFluidHandler = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
        ((LargeTurbineWorkableHandler)this.recipeMapWorkable).updateTanks();
    }

    @Override
    protected long getMaxVoltage() {
        long maxProduction = this.recipeMapWorkable.getMaxVoltage();
        long currentProduction = ((LargeTurbineWorkableHandler)this.recipeMapWorkable).boostProduction((int)maxProduction);
        if (this.isActive() && currentProduction <= maxProduction) {
            return this.recipeMapWorkable.getMaxVoltage();
        }
        return 0L;
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        MultiblockFuelRecipeLogic recipeLogic = (MultiblockFuelRecipeLogic)this.recipeMapWorkable;
        builder.setWorkingStatus(recipeLogic.isWorkingEnabled(), recipeLogic.isActive()).addEnergyProductionLine(this.getMaxVoltage(), recipeLogic.getRecipeEUt()).addCustom((keyList, syncer) -> {
            if (!this.isStructureFormed()) {
                return;
            }
            int rotorEfficiency = syncer.syncInt(() -> this.getRotorHolder().getRotorEfficiency());
            int totalEfficiency = syncer.syncInt(() -> this.getRotorHolder().getTotalEfficiency());
            if (rotorEfficiency > 0) {
                IKey efficiencyInfo = KeyUtil.number(TextFormatting.AQUA, (long)totalEfficiency, "%");
                keyList.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.turbine.efficiency", efficiencyInfo));
            }
        }).addFuelNeededLine(recipeLogic.getRecipeFluidInputInfo(), recipeLogic.getPreviousRecipeDuration()).addWorkingStatusLine();
    }

    @Override
    protected void configureWarningText(MultiblockUIBuilder builder) {
        builder.addCustom((keyList, syncer) -> {
            if (!this.isStructureFormed() || syncer.syncBoolean(() -> this.getRotorHolder() == null)) {
                return;
            }
            int rotorEfficiency = syncer.syncInt(() -> this.getRotorHolder().getRotorEfficiency());
            int rotorDurability = syncer.syncInt(() -> this.getRotorHolder().getRotorDurabilityPercent());
            if (rotorEfficiency > 0 && rotorDurability <= 10) {
                keyList.add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.turbine.rotor_durability_low", new Object[0]));
            }
        });
        super.configureWarningText(builder);
    }

    @Override
    protected void configureErrorText(MultiblockUIBuilder builder) {
        super.configureErrorText(builder);
        builder.addCustom((keyList, syncer) -> {
            int rotorEfficiency;
            if (!this.isStructureFormed() || syncer.syncBoolean(() -> this.getRotorHolder() == null)) {
                return;
            }
            if (syncer.syncBoolean(!this.isRotorFaceFree())) {
                keyList.add((IDrawable)KeyUtil.lang(TextFormatting.RED, "gregtech.multiblock.turbine.obstructed", new Object[0]));
                keyList.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.turbine.obstructed.desc", new Object[0]));
            }
            if ((rotorEfficiency = syncer.syncInt(() -> this.getRotorHolder().getRotorEfficiency())) <= 0) {
                keyList.add((IDrawable)KeyUtil.lang(TextFormatting.RED, "gregtech.multiblock.turbine.no_rotor", new Object[0]));
            }
        });
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.base_production_eut", (Object[])new Object[]{GTValues.V[this.tier] * 2L}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.turbine.efficiency_tooltip", (Object[])new Object[]{GTValues.VNF[this.tier]}));
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("CCCC", "CHHC", "CCCC").aisle("CHHC", "RGGR", "CHHC").aisle("CCCC", "CSHC", "CCCC").where('S', this.selfPredicate()).where('G', MetaTileEntityLargeTurbine.states(this.getGearBoxState())).where('C', MetaTileEntityLargeTurbine.states(this.getCasingState())).where('R', MetaTileEntityLargeTurbine.metaTileEntities((MetaTileEntity[])MultiblockAbility.REGISTRY.get(MultiblockAbility.ROTOR_HOLDER).stream().filter(mte -> mte instanceof ITieredMetaTileEntity && ((ITieredMetaTileEntity)((Object)mte)).getTier() >= this.tier).toArray(MetaTileEntity[]::new)).addTooltips("gregtech.multiblock.pattern.clear_amount_3").addTooltip("gregtech.multiblock.pattern.error.limited.1", GTValues.VN[this.tier]).setExactLimit(1).or(MetaTileEntityLargeTurbine.abilities(MultiblockAbility.OUTPUT_ENERGY)).setExactLimit(1)).where('H', MetaTileEntityLargeTurbine.states(this.getCasingState()).or(this.autoAbilities(false, true, false, false, true, true, true))).build();
    }

    @Override
    public String[] getDescription() {
        return new String[]{I18n.func_135052_a((String)"gregtech.multiblock.large_turbine.description", (Object[])new Object[0])};
    }

    public IBlockState getCasingState() {
        return this.casingState;
    }

    public IBlockState getGearBoxState() {
        return this.gearboxState;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return this.casingRenderer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return this.frontOverlay;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return this.hasMufflerHatch;
    }

    @Override
    public boolean isStructureObstructed() {
        return super.isStructureObstructed() || !this.isRotorFaceFree();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public boolean canVoidRecipeItemOutputs() {
        return true;
    }

    @Override
    public boolean canVoidRecipeFluidOutputs() {
        return true;
    }

    @Override
    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    public int getProgressBarCount() {
        return 3;
    }

    @Override
    public void registerBars(List<UnaryOperator<TemplateBarBuilder>> bars, PanelSyncManager syncManager) {
        FixedIntArraySyncValue fuelValue = new FixedIntArraySyncValue(this::getFuelAmount, null);
        StringSyncValue fuelNameValue = new StringSyncValue(() -> {
            FluidStack stack = ((MultiblockFuelRecipeLogic)this.recipeMapWorkable).getInputFluidStack();
            if (stack == null) {
                return null;
            }
            Fluid fluid = stack.getFluid();
            if (fluid == null) {
                return null;
            }
            return fluid.getName();
        });
        syncManager.syncValue("fuel_amount", (SyncHandler)fuelValue);
        syncManager.syncValue("fuel_name", (SyncHandler)fuelNameValue);
        IntSyncValue rotorSpeedValue = new IntSyncValue(() -> {
            IRotorHolder rotorHolder = this.getRotorHolder();
            if (rotorHolder == null) {
                return 0;
            }
            return rotorHolder.getRotorSpeed();
        });
        IntSyncValue rotorMaxSpeedValue = new IntSyncValue(() -> {
            IRotorHolder rotorHolder = this.getRotorHolder();
            if (rotorHolder == null) {
                return 0;
            }
            return rotorHolder.getMaxRotorHolderSpeed();
        });
        syncManager.syncValue("rotor_speed", (SyncHandler)rotorSpeedValue);
        syncManager.syncValue("rotor_max_speed", (SyncHandler)rotorMaxSpeedValue);
        IntSyncValue durabilityValue = new IntSyncValue(() -> {
            IRotorHolder rotorHolder = this.getRotorHolder();
            if (rotorHolder == null) {
                return 0;
            }
            return rotorHolder.getRotorDurabilityPercent();
        });
        IntSyncValue efficiencyValue = new IntSyncValue(() -> {
            IRotorHolder rotorHolder = this.getRotorHolder();
            if (rotorHolder == null) {
                return 0;
            }
            return rotorHolder.getRotorEfficiency();
        });
        syncManager.syncValue("rotor_durability", (SyncHandler)durabilityValue);
        syncManager.syncValue("rotor_efficiency", (SyncHandler)efficiencyValue);
        bars.add(barTest -> barTest.progress(() -> fuelValue.getValue(1) == 0 ? 0.0 : 1.0 * (double)fuelValue.getValue(0) / (double)fuelValue.getValue(1)).texture(GTGuiTextures.PROGRESS_BAR_LCE_FUEL).tooltipBuilder(t -> this.createFuelTooltip((RichTooltip)t, fuelValue, fuelNameValue)));
        bars.add(barTest -> barTest.progress(() -> rotorMaxSpeedValue.getIntValue() == 0 ? 0.0 : 1.0 * (double)rotorSpeedValue.getIntValue() / (double)rotorMaxSpeedValue.getIntValue()).texture(GTGuiTextures.PROGRESS_BAR_TURBINE_ROTOR_SPEED).tooltipBuilder(t -> {
            if (this.isStructureFormed()) {
                int speed = rotorSpeedValue.getIntValue();
                int maxSpeed = rotorMaxSpeedValue.getIntValue();
                t.addLine((IDrawable)KeyUtil.lang("gregtech.multiblock.turbine.rotor_speed", this.getSpeedFormat(maxSpeed, speed), speed, maxSpeed));
            } else {
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.invalid_structure"));
            }
        }));
        bars.add(barTest -> barTest.progress(() -> (double)durabilityValue.getIntValue() / 100.0).texture(GTGuiTextures.PROGRESS_BAR_TURBINE_ROTOR_DURABILITY).tooltipBuilder(t -> {
            if (this.isStructureFormed()) {
                if (efficiencyValue.getIntValue() <= 0) {
                    t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.turbine.no_rotor"));
                } else {
                    int durability = durabilityValue.getIntValue();
                    if (durability > 40) {
                        t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.turbine.rotor_durability.high", (Object[])new Object[]{durability}));
                    } else if (durability > 10) {
                        t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.turbine.rotor_durability.medium", (Object[])new Object[]{durability}));
                    } else {
                        t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.turbine.rotor_durability.low", (Object[])new Object[]{durability}));
                    }
                }
            } else {
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.invalid_structure"));
            }
        }));
    }

    @NotNull
    private TextFormatting getSpeedFormat(int maxSpeed, int speed) {
        float percent;
        float f = percent = maxSpeed == 0 ? 0.0f : 1.0f * (float)speed / (float)maxSpeed;
        if ((double)percent < 0.4) {
            return TextFormatting.RED;
        }
        if ((double)percent < 0.8) {
            return TextFormatting.YELLOW;
        }
        return TextFormatting.GREEN;
    }

    private int[] getFuelAmount() {
        MultiblockFuelRecipeLogic recipeLogic;
        if (this.getInputFluidInventory() != null && (recipeLogic = (MultiblockFuelRecipeLogic)this.recipeMapWorkable).getInputFluidStack() != null) {
            FluidStack testStack = recipeLogic.getInputFluidStack().copy();
            testStack.amount = Integer.MAX_VALUE;
            return this.getTotalFluidAmount(testStack, this.getInputFluidInventory());
        }
        return new int[2];
    }
}

