/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.generator;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.MultiblockFuelRecipeLogic;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.ProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.TemplateBarBuilder;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.sync.FixedIntArraySyncValue;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLargeCombustionEngine
extends FuelMultiblockController
implements ProgressBarMultiblock {
    private final int tier;
    private final boolean isExtreme;
    private boolean boostAllowed;
    private boolean hasLubricant;

    public MetaTileEntityLargeCombustionEngine(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, RecipeMaps.COMBUSTION_GENERATOR_FUELS, tier);
        this.recipeMapWorkable = new LargeCombustionEngineWorkableHandler(this, tier > 4);
        this.recipeMapWorkable.setMaximumOverclockVoltage(GTValues.V[tier]);
        this.tier = tier;
        this.isExtreme = tier > 4;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeCombustionEngine(this.metaTileEntityId, this.tier);
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        LargeCombustionEngineWorkableHandler recipeLogic = (LargeCombustionEngineWorkableHandler)this.recipeMapWorkable;
        builder.setWorkingStatus(recipeLogic.isWorkingEnabled(), recipeLogic.isActive() && !this.isDynamoFull());
        if (this.isExtreme) {
            builder.addEnergyProductionLine(GTValues.V[this.tier + 1], recipeLogic.getRecipeEUt());
        } else {
            builder.addEnergyProductionAmpsLine(GTValues.V[this.tier] * 3L, 3);
        }
        builder.addFuelNeededLine(recipeLogic.getRecipeFluidInputInfo(), recipeLogic.getPreviousRecipeDuration()).addCustom((richText, syncer) -> {
            if (this.isStructureFormed() && syncer.syncBoolean(recipeLogic.isOxygenBoosted)) {
                String key = this.isExtreme ? "gregtech.multiblock.large_combustion_engine.liquid_oxygen_boosted" : "gregtech.multiblock.large_combustion_engine.oxygen_boosted";
                richText.add((IDrawable)KeyUtil.lang(TextFormatting.AQUA, key, new Object[0]));
            }
        }).addWorkingStatusLine();
    }

    @Override
    protected void configureErrorText(MultiblockUIBuilder builder) {
        super.configureErrorText(builder);
        LargeCombustionEngineWorkableHandler recipeLogic = (LargeCombustionEngineWorkableHandler)this.recipeMapWorkable;
        builder.addCustom((keyList, syncer) -> {
            if (!this.isStructureFormed()) {
                return;
            }
            if (syncer.syncBoolean(this.checkIntakesObstructed())) {
                keyList.add((IDrawable)KeyUtil.lang(TextFormatting.RED, "gregtech.multiblock.large_combustion_engine.obstructed", new Object[0]));
                keyList.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.large_combustion_engine.obstructed.desc", new Object[0]));
            }
            if (syncer.syncBoolean(!recipeLogic.checkLubricant())) {
                keyList.add((IDrawable)KeyUtil.lang(TextFormatting.RED, "gregtech.multiblock.large_combustion_engine.no_lubricant", new Object[0]));
            }
        });
    }

    @Override
    protected void configureWarningText(MultiblockUIBuilder builder) {
        super.configureWarningText(builder);
        builder.addCustom((manager, syncer) -> {
            if (syncer.syncBoolean(this::isDynamoFull)) {
                manager.add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.large_combustion_engine.dynamo_hatch_full", new Object[0]));
            }
        });
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.base_production_eut", (Object[])new Object[]{GTValues.V[this.tier]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.uses_per_hour_lubricant", (Object[])new Object[]{1000}));
        if (this.isExtreme) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.large_combustion_engine.tooltip.boost_extreme", (Object[])new Object[]{GTValues.V[this.tier] * 4L}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.large_combustion_engine.tooltip.boost_regular", (Object[])new Object[]{GTValues.V[this.tier] * 3L}));
        }
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XDX", "XXX").aisle("XCX", "CGC", "XCX").aisle("XCX", "CGC", "XCX").aisle("AAA", "AYA", "AAA").where('X', MetaTileEntityLargeCombustionEngine.states(this.getCasingState())).where('G', MetaTileEntityLargeCombustionEngine.states(this.getGearboxState())).where('C', MetaTileEntityLargeCombustionEngine.states(this.getCasingState()).setMinGlobalLimited(3).or(this.autoAbilities(false, true, true, true, true, true, true))).where('D', MetaTileEntityLargeCombustionEngine.metaTileEntities((MetaTileEntity[])MultiblockAbility.REGISTRY.get(MultiblockAbility.OUTPUT_ENERGY).stream().filter(mte -> {
            IEnergyContainer container = mte.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null);
            return container != null && container.getOutputVoltage() * container.getOutputAmperage() >= GTValues.V[this.tier];
        }).toArray(MetaTileEntity[]::new)).addTooltip("gregtech.multiblock.pattern.error.limited.1", GTValues.VN[this.tier])).where('A', MetaTileEntityLargeCombustionEngine.states(this.getIntakeState()).addTooltips("gregtech.multiblock.pattern.clear_amount_1")).where('Y', this.selfPredicate()).build();
    }

    public IBlockState getCasingState() {
        return this.isExtreme ? MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST) : MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE);
    }

    public IBlockState getGearboxState() {
        return this.isExtreme ? MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.TUNGSTENSTEEL_GEARBOX) : MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.TITANIUM_GEARBOX);
    }

    public IBlockState getIntakeState() {
        return this.isExtreme ? MetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.EXTREME_ENGINE_INTAKE_CASING) : MetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.ENGINE_INTAKE_CASING);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return this.isExtreme ? Textures.ROBUST_TUNGSTENSTEEL_CASING : Textures.STABLE_TITANIUM_CASING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return this.isExtreme ? Textures.EXTREME_COMBUSTION_ENGINE_OVERLAY : Textures.LARGE_COMBUSTION_ENGINE_OVERLAY;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return true;
    }

    @Override
    public boolean isStructureObstructed() {
        return super.isStructureObstructed() || this.checkIntakesObstructed();
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        IEnergyContainer energyContainer = this.getEnergyContainer();
        this.boostAllowed = energyContainer != null && energyContainer.getOutputVoltage() >= GTValues.V[this.tier + 1];
    }

    private boolean checkIntakesObstructed() {
        for (int left = -1; left <= 1; ++left) {
            for (int up = -1; up <= 1; ++up) {
                if (left == 0 && up == 0) continue;
                BlockPos checkPos = RelativeDirection.offsetPos(this.getPos(), this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped(), up, left, 1);
                IBlockState state = this.getWorld().func_180495_p(checkPos);
                if (state.func_177230_c().isAir(state, (IBlockAccess)this.getWorld(), checkPos)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    public boolean isBoostAllowed() {
        return this.boostAllowed;
    }

    @Override
    public int getProgressBarCount() {
        return 3;
    }

    @Override
    public void registerBars(List<UnaryOperator<TemplateBarBuilder>> bars, PanelSyncManager syncManager) {
        FixedIntArraySyncValue fuelValue = new FixedIntArraySyncValue(this::getFuelAmount, null);
        syncManager.syncValue("fuel_amount", (SyncHandler)fuelValue);
        StringSyncValue fuelNameValue = new StringSyncValue(() -> {
            FluidStack stack = ((MultiblockFuelRecipeLogic)this.recipeMapWorkable).getInputFluidStack();
            if (stack == null) {
                return null;
            }
            Fluid fluid = stack.getFluid();
            if (fluid == null) {
                return null;
            }
            return fluid.getName();
        });
        syncManager.syncValue("fuel_name", (SyncHandler)fuelNameValue);
        FixedIntArraySyncValue lubricantValue = new FixedIntArraySyncValue(this::getLubricantAmount, null);
        syncManager.syncValue("lubricant_amount", (SyncHandler)lubricantValue);
        FixedIntArraySyncValue oxygenValue = new FixedIntArraySyncValue(this::getOxygenAmount, null);
        syncManager.syncValue("oxygen_amount", (SyncHandler)oxygenValue);
        BooleanSyncValue boostValue = new BooleanSyncValue(this::isBoostAllowed);
        syncManager.syncValue("boost_allowed", (SyncHandler)boostValue);
        bars.add(barTest -> barTest.progress(() -> fuelValue.getValue(1) == 0 ? 0.0 : 1.0 * (double)fuelValue.getValue(0) / (double)fuelValue.getValue(1)).texture(GTGuiTextures.PROGRESS_BAR_LCE_FUEL).tooltipBuilder(t -> this.createFuelTooltip((RichTooltip)t, fuelValue, fuelNameValue)));
        bars.add(barTest -> barTest.progress(() -> lubricantValue.getValue(1) == 0 ? 0.0 : 1.0 * (double)lubricantValue.getValue(0) / (double)lubricantValue.getValue(1)).texture(GTGuiTextures.PROGRESS_BAR_LCE_LUBRICANT).tooltipBuilder(t -> {
            if (this.isStructureFormed()) {
                if (lubricantValue.getValue(0) == 0) {
                    t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.large_combustion_engine.no_lubricant"));
                } else {
                    t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.large_combustion_engine.lubricant_amount", (Object[])new Object[]{lubricantValue.getValue(0), lubricantValue.getValue(1)}));
                }
            } else {
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.invalid_structure"));
            }
        }));
        bars.add(barTest -> barTest.progress(() -> oxygenValue.getValue(1) == 0 ? 0.0 : 1.0 * (double)oxygenValue.getValue(0) / (double)oxygenValue.getValue(1)).texture(GTGuiTextures.PROGRESS_BAR_LCE_OXYGEN).tooltipBuilder(t -> {
            if (this.isStructureFormed()) {
                if (boostValue.getBoolValue()) {
                    if (oxygenValue.getValue(0) == 0) {
                        t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.large_combustion_engine.oxygen_none"));
                    } else if (this.isExtreme) {
                        t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.large_combustion_engine.liquid_oxygen_amount", (Object[])new Object[]{oxygenValue.getValue(0), oxygenValue.getValue(1)}));
                    } else {
                        t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.large_combustion_engine.oxygen_amount", (Object[])new Object[]{oxygenValue.getValue(0), oxygenValue.getValue(1)}));
                    }
                } else if (this.isExtreme) {
                    t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.large_combustion_engine.liquid_oxygen_boost_disallowed"));
                } else {
                    t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.large_combustion_engine.oxygen_boost_disallowed"));
                }
            } else {
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.invalid_structure"));
            }
        }));
    }

    private int[] getFuelAmount() {
        MultiblockFuelRecipeLogic recipeLogic;
        if (this.getInputFluidInventory() != null && (recipeLogic = (MultiblockFuelRecipeLogic)this.recipeMapWorkable).getInputFluidStack() != null) {
            FluidStack testStack = recipeLogic.getInputFluidStack().copy();
            testStack.amount = Integer.MAX_VALUE;
            return this.getTotalFluidAmount(testStack, this.getInputFluidInventory());
        }
        return new int[2];
    }

    private int[] getLubricantAmount() {
        if (this.getInputFluidInventory() != null) {
            return this.getTotalFluidAmount(Materials.Lubricant.getFluid(Integer.MAX_VALUE), this.getInputFluidInventory());
        }
        return new int[2];
    }

    private int[] getOxygenAmount() {
        if (this.getInputFluidInventory() != null && this.isBoostAllowed()) {
            FluidStack oxygenStack = this.isExtreme ? Materials.Oxygen.getFluid(FluidStorageKeys.LIQUID, Integer.MAX_VALUE) : Materials.Oxygen.getFluid(Integer.MAX_VALUE);
            return this.getTotalFluidAmount(oxygenStack, this.getInputFluidInventory());
        }
        return new int[2];
    }

    public boolean isDynamoFull() {
        return this.getEnergyContainer().getEnergyCanBeInserted() < this.recipeMapWorkable.getRecipeEUt();
    }

    private static class LargeCombustionEngineWorkableHandler
    extends MultiblockFuelRecipeLogic {
        private boolean isOxygenBoosted = false;
        private final MetaTileEntityLargeCombustionEngine combustionEngine;
        private final boolean isExtreme;
        private final int tier;
        private static final FluidStack OXYGEN_STACK = Materials.Oxygen.getFluid(20);
        private static final FluidStack LIQUID_OXYGEN_STACK = Materials.Oxygen.getFluid(FluidStorageKeys.LIQUID, 80);
        private static final FluidStack LUBRICANT_STACK = Materials.Lubricant.getFluid(1);

        public LargeCombustionEngineWorkableHandler(RecipeMapMultiblockController tileEntity, boolean isExtreme) {
            super(tileEntity);
            this.combustionEngine = (MetaTileEntityLargeCombustionEngine)tileEntity;
            this.isExtreme = isExtreme;
            this.tier = isExtreme ? 5 : 4;
        }

        @Override
        protected void updateRecipeProgress() {
            if (this.canRecipeProgress && this.drawEnergy(this.recipeEUt, true)) {
                this.drainLubricant();
                this.drainOxygen();
                this.drawEnergy(this.recipeEUt, false);
                if (++this.progressTime > this.maxProgressTime) {
                    this.completeRecipe();
                }
            }
        }

        protected void checkOxygen() {
            if (this.combustionEngine.isBoostAllowed()) {
                IMultipleTankHandler inputTank = this.combustionEngine.getInputFluidInventory();
                FluidStack boosterStack = this.isExtreme ? LIQUID_OXYGEN_STACK : OXYGEN_STACK;
                this.isOxygenBoosted = boosterStack.isFluidStackIdentical(inputTank.drain(boosterStack, false));
            }
        }

        protected void drainOxygen() {
            if (this.isOxygenBoosted && this.totalContinuousRunningTime % 20L == 0L) {
                FluidStack boosterStack = this.isExtreme ? LIQUID_OXYGEN_STACK : OXYGEN_STACK;
                this.combustionEngine.getInputFluidInventory().drain(boosterStack, true);
            }
        }

        protected boolean checkLubricant() {
            IMultipleTankHandler inputTank = this.combustionEngine.getInputFluidInventory();
            if (LUBRICANT_STACK.isFluidStackIdentical(inputTank.drain(LUBRICANT_STACK, false))) {
                return true;
            }
            this.invalidate();
            return false;
        }

        protected void drainLubricant() {
            if (this.totalContinuousRunningTime == 1L || this.totalContinuousRunningTime % 72L == 0L) {
                IMultipleTankHandler inputTank = this.combustionEngine.getInputFluidInventory();
                inputTank.drain(LUBRICANT_STACK, true);
            }
        }

        @Override
        protected boolean shouldSearchForRecipes() {
            this.checkOxygen();
            return super.shouldSearchForRecipes() && this.checkLubricant();
        }

        @Override
        protected boolean canProgressRecipe() {
            return super.canProgressRecipe() && this.checkLubricant();
        }

        @Override
        public long getMaxVoltage() {
            if (this.isOxygenBoosted) {
                return GTValues.V[this.tier] * 2L;
            }
            return GTValues.V[this.tier];
        }

        @Override
        protected long boostProduction(long production) {
            if (this.isOxygenBoosted) {
                if (!this.isExtreme) {
                    return production * 3L / 2L;
                }
                return production * 2L;
            }
            return production;
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.isOxygenBoosted = false;
        }
    }
}

