/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.generator;

import gregtech.api.GTValues;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.IRotorHolder;
import gregtech.api.capability.impl.MultiblockFuelRecipeLogic;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTUtility;
import gregtech.common.metatileentities.multi.electric.generator.MetaTileEntityLargeTurbine;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LargeTurbineWorkableHandler
extends MultiblockFuelRecipeLogic {
    private final int BASE_EU_OUTPUT;
    private long excessVoltage;

    public LargeTurbineWorkableHandler(RecipeMapMultiblockController metaTileEntity, int tier) {
        super(metaTileEntity);
        this.BASE_EU_OUTPUT = (int)GTValues.V[tier] * 2;
    }

    @Override
    protected void updateRecipeProgress() {
        if (this.canRecipeProgress) {
            this.drawEnergy(this.recipeEUt, false);
            if (++this.progressTime > this.maxProgressTime) {
                this.completeRecipe();
            }
        }
    }

    @Override
    public FluidStack getInputFluidStack() {
        if (this.previousRecipe == null) {
            Recipe recipe = super.findRecipe(Integer.MAX_VALUE, this.getInputInventory(), this.getInputTank());
            return recipe == null ? null : this.getInputTank().drain(new FluidStack(recipe.getFluidInputs().get(0).getInputFluidStack().getFluid(), Integer.MAX_VALUE), false);
        }
        FluidStack fuelStack = this.previousRecipe.getFluidInputs().get(0).getInputFluidStack();
        return this.getInputTank().drain(new FluidStack(fuelStack.getFluid(), Integer.MAX_VALUE), false);
    }

    @Override
    public long getMaxVoltage() {
        IRotorHolder rotorHolder = ((MetaTileEntityLargeTurbine)this.metaTileEntity).getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            return (long)this.BASE_EU_OUTPUT * (long)rotorHolder.getTotalPower() / 100L;
        }
        return 0L;
    }

    @Override
    protected long boostProduction(long production) {
        IRotorHolder rotorHolder = ((MetaTileEntityLargeTurbine)this.metaTileEntity).getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            int maxSpeed = rotorHolder.getMaxRotorHolderSpeed();
            int currentSpeed = rotorHolder.getRotorSpeed();
            if (currentSpeed >= maxSpeed) {
                return production;
            }
            return (long)((double)production * Math.pow(1.0 * (double)currentSpeed / (double)maxSpeed, 2.0));
        }
        return 0L;
    }

    private int getParallel(@NotNull Recipe recipe, double totalHolderEfficiencyCoefficient, long turbineMaxVoltage) {
        return MathHelper.func_76143_f((double)((double)(turbineMaxVoltage - this.excessVoltage) / ((double)recipe.getEUt() * totalHolderEfficiencyCoefficient)));
    }

    private boolean canDoRecipeWithParallel(Recipe recipe) {
        IRotorHolder rotorHolder = ((MetaTileEntityLargeTurbine)this.metaTileEntity).getRotorHolder();
        if (rotorHolder == null || !rotorHolder.hasRotor()) {
            return false;
        }
        double totalHolderEfficiencyCoefficient = (double)rotorHolder.getTotalEfficiency() / 100.0;
        long turbineMaxVoltage = this.getMaxVoltage();
        int parallel = this.getParallel(recipe, totalHolderEfficiencyCoefficient, turbineMaxVoltage);
        FluidStack recipeFluidStack = recipe.getFluidInputs().get(0).getInputFluidStack();
        FluidStack inputFluid = this.getInputTank().drain(new FluidStack(recipeFluidStack.getFluid(), Integer.MAX_VALUE), false);
        return inputFluid != null && inputFluid.amount >= recipeFluidStack.amount * parallel;
    }

    @Override
    protected boolean checkPreviousRecipe() {
        return super.checkPreviousRecipe() && this.canDoRecipeWithParallel(this.previousRecipe);
    }

    @Override
    @Nullable
    protected Recipe findRecipe(long maxVoltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
        RecipeMap<?> map = this.getRecipeMap();
        if (map == null || !this.isRecipeMapValid(map)) {
            return null;
        }
        List<ItemStack> items = GTUtility.itemHandlerToList(inputs).stream().filter(s -> !s.func_190926_b()).collect(Collectors.toList());
        List<FluidStack> fluids = GTUtility.fluidHandlerToList(fluidInputs).stream().filter(f -> f != null && f.amount != 0).collect(Collectors.toList());
        return map.find(items, fluids, recipe -> {
            if (recipe.getEUt() > maxVoltage) {
                return false;
            }
            return recipe.matches(false, inputs, fluidInputs) && this.canDoRecipeWithParallel((Recipe)recipe);
        });
    }

    @Override
    public boolean prepareRecipe(Recipe recipe) {
        IRotorHolder rotorHolder = ((MetaTileEntityLargeTurbine)this.metaTileEntity).getRotorHolder();
        if (rotorHolder == null || !rotorHolder.hasRotor()) {
            return false;
        }
        long turbineMaxVoltage = this.getMaxVoltage();
        FluidStack recipeFluidStack = recipe.getFluidInputs().get(0).getInputFluidStack();
        int parallel = 0;
        if (this.excessVoltage >= turbineMaxVoltage) {
            this.excessVoltage -= turbineMaxVoltage;
        } else {
            double holderEfficiency = (double)rotorHolder.getTotalEfficiency() / 100.0;
            parallel = this.getParallel(recipe, holderEfficiency, turbineMaxVoltage);
            FluidStack inputFluid = this.getInputFluidStack();
            if (inputFluid == null || this.getInputFluidStack().amount < recipeFluidStack.amount * parallel) {
                return false;
            }
            this.excessVoltage += (long)((double)((long)parallel * recipe.getEUt()) * holderEfficiency - (double)turbineMaxVoltage);
        }
        Object recipeBuilder = this.getRecipeMap().recipeBuilder();
        ((RecipeBuilder)((RecipeBuilder)recipeBuilder).append(recipe, parallel, false)).EUt(turbineMaxVoltage);
        this.applyParallelBonus((RecipeBuilder<?>)recipeBuilder);
        recipe = ((RecipeBuilder)recipeBuilder).build().getResult();
        if (recipe != null && (recipe = this.setupAndConsumeRecipeInputs(recipe, this.getInputInventory())) != null) {
            this.setupRecipe(recipe);
            return true;
        }
        return false;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.excessVoltage = 0L;
    }

    public void updateTanks() {
        FuelMultiblockController controller = (FuelMultiblockController)this.metaTileEntity;
        List<IFluidHandler> tanks = controller.getNotifiedFluidInputList();
        for (IFluidTank tank : controller.getAbilities(MultiblockAbility.IMPORT_FLUIDS)) {
            tanks.add((IFluidHandler)tank);
        }
    }
}

