/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.centralmonitor;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.cover.Cover;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIFactory;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.util.FacingPos;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.covers.CoverDigitalInterface;
import gregtech.common.gui.widget.monitor.WidgetScreenGrid;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityMonitorScreen;
import gregtech.common.pipelike.cable.net.EnergyNet;
import gregtech.common.pipelike.cable.net.WorldENet;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class MetaTileEntityCentralMonitor
extends MultiblockWithDisplayBase
implements IFastRenderMetaTileEntity {
    private static final long ENERGY_COST = ConfigHolder.machines.centralMonitorEuCost;
    public static final int MAX_HEIGHT = 9;
    public static final int MAX_WIDTH = 14;
    public int width;
    private long lastUpdate;
    private WeakReference<EnergyNet> currentEnergyNet;
    private List<BlockPos> activeNodes;
    private Set<FacingPos> netCovers;
    private Set<FacingPos> remoteCovers;
    @SideOnly(value=Side.CLIENT)
    public List<BlockPos> parts;
    public MetaTileEntityMonitorScreen[][] screens;
    private boolean isActive;
    private EnergyContainerList inputEnergy;
    public int height = 3;

    public MetaTileEntityCentralMonitor(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    private EnergyNet getEnergyNet() {
        TileEntity te;
        if (!this.getWorld().field_72995_K && (te = this.getNeighbor(this.frontFacing.func_176734_d())) instanceof TileEntityCable) {
            TileEntityCable tileEntityCable = (TileEntityCable)te;
            EnergyNet currentEnergyNet = (EnergyNet)this.currentEnergyNet.get();
            if (currentEnergyNet != null && currentEnergyNet.isValid() && currentEnergyNet.containsNode(tileEntityCable.getPipePos())) {
                return currentEnergyNet;
            }
            WorldENet worldENet = (WorldENet)((Object)((TileEntityPipeBase)tileEntityCable).getPipeBlock().getWorldPipeNet(tileEntityCable.getPipeWorld()));
            currentEnergyNet = (EnergyNet)worldENet.getNetFromPos(tileEntityCable.getPipePos());
            if (currentEnergyNet != null) {
                this.currentEnergyNet = new WeakReference<EnergyNet>(currentEnergyNet);
            }
            return currentEnergyNet;
        }
        return null;
    }

    private void updateNodes() {
        EnergyNet energyNet = this.getEnergyNet();
        if (energyNet == null) {
            this.activeNodes.clear();
            return;
        }
        if (energyNet.getLastUpdate() == this.lastUpdate) {
            return;
        }
        this.lastUpdate = energyNet.getLastUpdate();
        this.activeNodes.clear();
        energyNet.getAllNodes().forEach((pos, node) -> {
            if (node.isActive) {
                this.activeNodes.add((BlockPos)pos);
            }
        });
    }

    public void addRemoteCover(FacingPos cover) {
        if (this.remoteCovers != null && this.remoteCovers.add(cover)) {
            this.writeCustomData(GregtechDataCodes.UPDATE_COVERS, this::writeCovers);
        }
    }

    private boolean checkCovers() {
        boolean dirty = false;
        this.updateNodes();
        HashSet<FacingPos> checkCovers = new HashSet<FacingPos>();
        World world = this.getWorld();
        for (BlockPos pos : this.activeNodes) {
            TileEntity tileEntityCable = world.func_175625_s(pos);
            if (!(tileEntityCable instanceof TileEntityPipeBase)) continue;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                CoverDigitalInterface digitalInterface;
                Cover cover;
                MetaTileEntity metaTileEntity;
                TileEntity tileEntity;
                if (!((IPipeTile)tileEntityCable).isConnected(facing) || !((tileEntity = world.func_175625_s(pos.func_177972_a(facing))) instanceof IGregTechTileEntity) || (metaTileEntity = ((IGregTechTileEntity)tileEntity).getMetaTileEntity()) == null || !((cover = metaTileEntity.getCoverAtSide(facing.func_176734_d())) instanceof CoverDigitalInterface) || !(digitalInterface = (CoverDigitalInterface)cover).isProxy()) continue;
                checkCovers.add(new FacingPos(metaTileEntity.getPos(), cover.getAttachedSide()));
            }
        }
        Iterator<FacingPos> iterator = this.remoteCovers.iterator();
        while (iterator.hasNext()) {
            CoverDigitalInterface digitalInterface;
            Cover cover;
            MetaTileEntity metaTileEntity;
            FacingPos blockPosFace = iterator.next();
            TileEntity tileEntity = world.func_175625_s(blockPosFace.getPos());
            if (tileEntity instanceof IGregTechTileEntity && (metaTileEntity = ((IGregTechTileEntity)tileEntity).getMetaTileEntity()) != null && (cover = metaTileEntity.getCoverAtSide(blockPosFace.getFacing())) instanceof CoverDigitalInterface && (digitalInterface = (CoverDigitalInterface)cover).isProxy()) continue;
            iterator.remove();
            dirty = true;
        }
        if (checkCovers.size() != this.netCovers.size() || !this.netCovers.containsAll(checkCovers)) {
            this.netCovers = checkCovers;
            dirty = true;
        }
        return dirty;
    }

    private void writeCovers(PacketBuffer buf) {
        if (this.netCovers == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.netCovers.size());
            for (FacingPos cover : this.netCovers) {
                buf.func_179255_a(cover.getPos());
                buf.writeByte(cover.getFacing().func_176745_a());
            }
        }
        if (this.remoteCovers == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.remoteCovers.size());
            for (FacingPos cover : this.remoteCovers) {
                buf.func_179255_a(cover.getPos());
                buf.writeByte(cover.getFacing().func_176745_a());
            }
        }
    }

    private void readCovers(PacketBuffer buf) {
        int i;
        this.netCovers = new HashSet<FacingPos>();
        this.remoteCovers = new HashSet<FacingPos>();
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.netCovers.add(new FacingPos(buf.func_179259_c(), EnumFacing.func_82600_a((int)buf.readByte())));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            this.remoteCovers.add(new FacingPos(buf.func_179259_c(), EnumFacing.func_82600_a((int)buf.readByte())));
        }
    }

    private void writeParts(PacketBuffer buf) {
        buf.writeInt((int)this.getMultiblockParts().stream().filter(MetaTileEntityMonitorScreen.class::isInstance).count());
        this.getMultiblockParts().forEach(part -> {
            if (part instanceof MetaTileEntityMonitorScreen) {
                buf.func_179255_a(((MetaTileEntityMonitorScreen)part).getPos());
            }
        });
    }

    private void readParts(PacketBuffer buf) {
        this.parts = new ArrayList<BlockPos>();
        this.clearScreens();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.parts.add(buf.func_179259_c());
        }
    }

    public void setHeight(int height) {
        if (this.height == height || height < 2 || height > 9) {
            return;
        }
        this.height = height;
        this.reinitializeStructurePattern();
        this.checkStructurePattern();
        this.writeCustomData(GregtechDataCodes.UPDATE_HEIGHT, buf -> buf.writeInt(height));
    }

    private void setActive(boolean isActive) {
        if (isActive == this.isActive) {
            return;
        }
        this.isActive = isActive;
        this.writeCustomData(GregtechDataCodes.UPDATE_ACTIVE, buf -> buf.writeBoolean(this.isActive));
    }

    @Override
    public boolean isActive() {
        return this.isStructureFormed() && this.isActive;
    }

    private void clearScreens() {
        if (this.screens != null) {
            MetaTileEntityMonitorScreen[][] metaTileEntityMonitorScreenArray = this.screens;
            int n = metaTileEntityMonitorScreenArray.length;
            for (int i = 0; i < n; ++i) {
                MetaTileEntityMonitorScreen[] screen;
                for (MetaTileEntityMonitorScreen s : screen = metaTileEntityMonitorScreenArray[i]) {
                    if (s == null) continue;
                    s.removeFromMultiBlock(this);
                }
            }
        }
        this.screens = new MetaTileEntityMonitorScreen[this.width][this.height];
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.SCREEN.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        Textures.COVER_INTERFACE_PROXY.renderSided(this.getFrontFacing().func_176734_d(), renderState, translation, pipeline);
    }

    @Override
    protected MultiblockUIFactory createUIFactory() {
        return super.createUIFactory().createFlexButton((posGuiData, panelSyncManager) -> {
            IntSyncValue intSync = new IntSyncValue(() -> this.height, this::setHeight);
            panelSyncManager.syncValue("height", (SyncHandler)intSync);
            return ((ButtonWidget)new ButtonWidget().addTooltipLine((IDrawable)IKey.lang((String)"gregtech.multiblock.central_monitor.button_tooltip"))).onMousePressed(mouseData -> {
                int currentHeight = intSync.getIntValue();
                if (mouseData == 0 && currentHeight < 9) {
                    intSync.setIntValue(currentHeight + 1);
                    return true;
                }
                if (mouseData == 1 && currentHeight > 3) {
                    intSync.setIntValue(currentHeight - 1);
                    return true;
                }
                if (mouseData == 2) {
                    intSync.setIntValue(3);
                }
                return false;
            });
        });
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.addCustom((list, syncer) -> {
            list.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.central_monitor.height", syncer.syncInt(this.height)));
            if (this.isStructureFormed()) {
                list.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.central_monitor.width", syncer.syncInt(this.width)));
            }
        });
    }

    @Override
    protected void configureWarningText(MultiblockUIBuilder builder) {
        builder.addCustom((list, syncer) -> {
            if (this.isStructureFormed() && syncer.syncBoolean(() -> !this.drainEnergy(true))) {
                list.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.central_monitor.low_power", new Object[0]));
            }
        });
    }

    @Override
    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.width);
        buf.writeInt(this.height);
        buf.writeBoolean(this.isActive);
        this.writeCovers(buf);
        this.writeParts(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.width = buf.readInt();
        this.height = buf.readInt();
        this.isActive = buf.readBoolean();
        this.readCovers(buf);
        this.readParts(buf);
    }

    @Override
    public void receiveCustomData(int id, PacketBuffer buf) {
        super.receiveCustomData(id, buf);
        if (id == GregtechDataCodes.UPDATE_ALL) {
            this.width = buf.readInt();
            this.height = buf.readInt();
            this.readCovers(buf);
            this.readParts(buf);
        } else if (id == GregtechDataCodes.UPDATE_COVERS) {
            this.readCovers(buf);
        } else if (id == GregtechDataCodes.UPDATE_HEIGHT) {
            this.height = buf.readInt();
            this.reinitializeStructurePattern();
        } else if (id == GregtechDataCodes.UPDATE_ACTIVE) {
            this.isActive = buf.readBoolean();
        } else if (id == GregtechDataCodes.STRUCTURE_FORMED && !this.isStructureFormed()) {
            this.clearScreens();
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74768_a("screenH", this.height);
        return super.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.height = data.func_74764_b("screenH") ? data.func_74762_e("screenH") : this.height;
        this.reinitializeStructurePattern();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity metaTileEntityHolder) {
        return new MetaTileEntityCentralMonitor(this.metaTileEntityId);
    }

    @Override
    protected void updateFormedValid() {
        if (this.getOffsetTimer() % 20L == 0L) {
            this.setActive(this.drainEnergy(false));
            if (this.checkCovers()) {
                this.getMultiblockParts().forEach(part -> {
                    Set<FacingPos> covers = this.getAllCovers();
                    if (part instanceof MetaTileEntityMonitorScreen) {
                        ((MetaTileEntityMonitorScreen)part).updateCoverValid(covers);
                    }
                });
                this.writeCustomData(GregtechDataCodes.UPDATE_COVERS, this::writeCovers);
            }
        }
    }

    private boolean drainEnergy(boolean simulate) {
        long energyToDrain = ENERGY_COST * (long)this.getMultiblockParts().size();
        long resultEnergy = this.inputEnergy.getEnergyStored() - energyToDrain;
        if (resultEnergy >= 0L && resultEnergy <= this.inputEnergy.getEnergyCapacity()) {
            if (!simulate) {
                this.inputEnergy.changeEnergy(-energyToDrain);
            }
            return true;
        }
        return false;
    }

    public Set<FacingPos> getAllCovers() {
        HashSet<FacingPos> allCovers = new HashSet<FacingPos>();
        if (this.netCovers != null) {
            allCovers.addAll(this.netCovers);
        }
        if (this.remoteCovers != null) {
            allCovers.addAll(this.remoteCovers);
        }
        return allCovers;
    }

    @Override
    protected BlockPattern createStructurePattern() {
        StringBuilder start = new StringBuilder("AS");
        StringBuilder slice = new StringBuilder("BB");
        StringBuilder end = new StringBuilder("AA");
        for (int i = 0; i < this.height - 2; ++i) {
            start.append('A');
            slice.append('B');
            end.append('A');
        }
        return FactoryBlockPattern.start(RelativeDirection.UP, RelativeDirection.BACK, RelativeDirection.RIGHT).aisle(start.toString()).aisle(slice.toString()).setRepeatable(3, 14).aisle(end.toString()).where('S', this.selfPredicate()).where('A', MetaTileEntityCentralMonitor.states(MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID)).or(MetaTileEntityCentralMonitor.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3).setPreviewCount(1))).where('B', MetaTileEntityCentralMonitor.metaTileEntities(MetaTileEntities.MONITOR_SCREEN)).build();
    }

    @Override
    public String[] getDescription() {
        return new String[]{I18n.func_135052_a((String)"gregtech.multiblock.central_monitor.tooltip.1", (Object[])new Object[0])};
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.lastUpdate = 0L;
        this.currentEnergyNet = new WeakReference<Object>(null);
        this.activeNodes = new ArrayList<BlockPos>();
        this.netCovers = new HashSet<FacingPos>();
        this.remoteCovers = new HashSet<FacingPos>();
        this.inputEnergy = new EnergyContainerList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        this.width = 0;
        this.checkCovers();
        for (IMultiblockPart part : this.getMultiblockParts()) {
            if (!(part instanceof MetaTileEntityMonitorScreen)) continue;
            ++this.width;
        }
        this.width /= this.height;
        this.screens = new MetaTileEntityMonitorScreen[this.width][this.height];
        for (IMultiblockPart part : this.getMultiblockParts()) {
            MetaTileEntityMonitorScreen screen;
            if (!(part instanceof MetaTileEntityMonitorScreen)) continue;
            this.screens[screen.getX()][screen.getY()] = screen = (MetaTileEntityMonitorScreen)part;
        }
        this.writeCustomData(GregtechDataCodes.UPDATE_ALL, packetBuffer -> {
            packetBuffer.writeInt(this.width);
            packetBuffer.writeInt(this.height);
            this.writeCovers((PacketBuffer)packetBuffer);
            this.writeParts((PacketBuffer)packetBuffer);
        });
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (side == this.frontFacing.func_176734_d() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return (T)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)IEnergyContainer.DEFAULT);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return Textures.SOLID_STEEL_CASING;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        if (this.isStructureFormed()) {
            return pass == 0;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isGlobalRenderer() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(double x, double y, double z, float partialTicks) {
        if (!this.isStructureFormed()) {
            return;
        }
        RenderUtil.useStencil(() -> {
            GlStateManager.func_179094_E();
            RenderUtil.moveToFace(x, y, z, this.frontFacing);
            RenderUtil.rotateToFace(this.frontFacing, this.upwardsFacing);
            RenderUtil.renderRect(0.5f, -0.5f - (float)(this.height - 2), this.width, this.height, 0.001f, -16777216);
            GlStateManager.func_179121_F();
        }, () -> {
            if (this.isActive) {
                GlStateManager.func_179094_E();
                GL11.glPushAttrib((int)64);
                RenderHelper.func_74518_a();
                float lastBrightnessX = OpenGlHelper.lastBrightnessX;
                float lastBrightnessY = OpenGlHelper.lastBrightnessY;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                RayTraceResult rayTraceResult = player == null ? null : player.func_174822_a((double)Minecraft.func_71410_x().field_71442_b.func_78757_d(), partialTicks);
                int size = 0;
                for (int w = 0; w < this.width; ++w) {
                    for (int h = 0; h < this.height; ++h) {
                        MetaTileEntityMonitorScreen screen = this.screens[w][h];
                        if (screen == null) continue;
                        ++size;
                        if (!screen.isActive()) continue;
                        BlockPos pos = screen.getPos();
                        BlockPos pos2 = this.getPos();
                        GlStateManager.func_179094_E();
                        RenderUtil.moveToFace(x + (double)pos.func_177958_n() - (double)pos2.func_177958_n(), y + (double)pos.func_177956_o() - (double)pos2.func_177956_o(), z + (double)pos.func_177952_p() - (double)pos2.func_177952_p(), this.frontFacing);
                        RenderUtil.rotateToFace(this.frontFacing, this.upwardsFacing);
                        screen.renderScreen(partialTicks, rayTraceResult);
                        GlStateManager.func_179121_F();
                    }
                }
                if (size != this.parts.size()) {
                    this.clearScreens();
                    for (BlockPos pos : this.parts) {
                        TileEntity tileEntity = this.getWorld().func_175625_s(pos);
                        if (!(tileEntity instanceof IGregTechTileEntity) || !(((IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof MetaTileEntityMonitorScreen)) continue;
                        MetaTileEntityMonitorScreen screen = (MetaTileEntityMonitorScreen)((IGregTechTileEntity)tileEntity).getMetaTileEntity();
                        screen.addToMultiBlock(this);
                        int sx = screen.getX();
                        int sy = screen.getY();
                        if (sx < 0 || sx >= this.width || sy < 0 || sy >= this.height) {
                            this.parts.clear();
                            this.clearScreens();
                            break;
                        }
                        this.screens[sx][sy] = screen;
                    }
                }
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
                RenderHelper.func_74519_b();
                GL11.glPopAttrib();
                GlStateManager.func_179121_F();
            }
        }, true);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos ep;
        BlockPos sp;
        EnumFacing spin = this.upwardsFacing;
        if (this.frontFacing.func_176740_k() == EnumFacing.Axis.Y) {
            sp = this.getPos().func_177967_a(spin, -2);
            ep = sp.func_177967_a(spin, this.height + 1).func_177967_a(spin.func_176746_e(), (this.width + 2) * this.frontFacing.func_96559_d());
        } else if (spin == EnumFacing.NORTH) {
            sp = this.getPos().func_177967_a(EnumFacing.DOWN, 2);
            ep = sp.func_177967_a(EnumFacing.UP, this.height + 1).func_177967_a(this.frontFacing.func_176746_e(), -this.width - 2);
        } else if (spin == EnumFacing.SOUTH) {
            sp = this.getPos().func_177967_a(EnumFacing.UP, 2);
            ep = sp.func_177967_a(EnumFacing.DOWN, this.height + 1).func_177967_a(this.frontFacing.func_176746_e(), this.width + 2);
        } else if (spin == EnumFacing.WEST) {
            sp = this.getPos().func_177967_a(this.frontFacing.func_176746_e(), -2);
            ep = sp.func_177967_a(this.frontFacing.func_176746_e(), this.height + 1).func_177967_a(EnumFacing.UP, this.width + 2);
        } else {
            sp = this.getPos().func_177967_a(this.frontFacing.func_176746_e(), 2);
            ep = sp.func_177967_a(this.frontFacing.func_176746_e(), -this.height - 1).func_177967_a(EnumFacing.DOWN, this.width + 2);
        }
        return new AxisAlignedBB(sp, ep);
    }

    @Override
    public boolean allowsFlip() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        if (!this.isActive()) {
            return super.createUI(entityPlayer);
        }
        WidgetScreenGrid[][] screenGrids = new WidgetScreenGrid[this.width][this.height];
        WidgetGroup group = new WidgetGroup();
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                screenGrids[i][j] = new WidgetScreenGrid(4 * this.width, 4 * this.height, i, j);
                group.addWidget(screenGrids[i][j]);
            }
        }
        if (!this.getWorld().field_72995_K) {
            this.getMultiblockParts().forEach(part -> {
                if (part instanceof MetaTileEntityMonitorScreen) {
                    int x = ((MetaTileEntityMonitorScreen)part).getX();
                    int y = ((MetaTileEntityMonitorScreen)part).getY();
                    screenGrids[x][y].setScreen((MetaTileEntityMonitorScreen)part);
                }
            });
        } else {
            this.parts.forEach(partPos -> {
                TileEntity tileEntity = this.getWorld().func_175625_s(partPos);
                if (tileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof MetaTileEntityMonitorScreen) {
                    MetaTileEntityMonitorScreen part = (MetaTileEntityMonitorScreen)((IGregTechTileEntity)tileEntity).getMetaTileEntity();
                    int x = part.getX();
                    int y = part.getY();
                    screenGrids[x][y].setScreen(part);
                }
            });
        }
        return ModularUI.builder(GuiTextures.BOXED_BACKGROUND, 28 * this.width, 28 * this.height).widget(group).build(this.getHolder(), entityPlayer);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.central_monitor.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.central_monitor.tooltip.2", (Object[])new Object[]{14, 9}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.central_monitor.tooltip.3", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.central_monitor.tooltip.4", (Object[])new Object[]{ENERGY_COST}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return false;
    }
}

