/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.utils.serialization.ByteBufAdapters;
import gregtech.api.capability.IObjectHolder;
import gregtech.api.capability.IOpticalComputationHatch;
import gregtech.api.capability.IOpticalComputationProvider;
import gregtech.api.capability.IOpticalComputationReceiver;
import gregtech.api.capability.impl.ComputationRecipeLogic;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.AssemblyLineManager;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.RelativeDirection;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockComputerCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.behaviors.DataItemBehavior;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityResearchStation
extends RecipeMapMultiblockController
implements IOpticalComputationReceiver {
    private IOpticalComputationProvider computationProvider;
    private IObjectHolder objectHolder;

    public MetaTileEntityResearchStation(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.RESEARCH_STATION_RECIPES);
        this.recipeMapWorkable = new ResearchStationRecipeLogic(this);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityResearchStation(this.metaTileEntityId);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        List<IObjectHolder> holders;
        super.formStructure(context);
        List<IOpticalComputationHatch> providers = this.getAbilities(MultiblockAbility.COMPUTATION_DATA_RECEPTION);
        if (providers != null && providers.size() >= 1) {
            this.computationProvider = providers.get(0);
        }
        if ((holders = this.getAbilities(MultiblockAbility.OBJECT_HOLDER)) != null && holders.size() >= 1) {
            this.objectHolder = holders.get(0);
            this.inputInventory = new ItemHandlerList(Collections.singletonList(this.objectHolder.getAsHandler()));
        }
        if (this.computationProvider == null || this.objectHolder == null) {
            this.invalidateStructure();
        }
    }

    @Override
    public void checkStructurePattern() {
        super.checkStructurePattern();
        if (this.isStructureFormed() && this.objectHolder.getFrontFacing() != this.getFrontFacing().func_176734_d()) {
            this.invalidateStructure();
        }
    }

    @Override
    public ComputationRecipeLogic getRecipeMapWorkable() {
        return (ComputationRecipeLogic)this.recipeMapWorkable;
    }

    @Override
    public void invalidateStructure() {
        this.computationProvider = null;
        List<IObjectHolder> holders = this.getAbilities(MultiblockAbility.OBJECT_HOLDER);
        if (holders != null && holders.size() >= 1 && holders.get(0) == this.objectHolder) {
            this.objectHolder.setLocked(false);
        }
        this.objectHolder = null;
        super.invalidateStructure();
    }

    @Override
    public IOpticalComputationProvider getComputationProvider() {
        return this.computationProvider;
    }

    public IObjectHolder getObjectHolder() {
        return this.objectHolder;
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "VVV", "PPP", "PPP", "PPP", "VVV", "XXX").aisle("XXX", "VAV", "AAA", "AAA", "AAA", "VAV", "XXX").aisle("XXX", "VAV", "XAX", "XSX", "XAX", "VAV", "XXX").aisle("XXX", "XAX", "---", "---", "---", "XAX", "XXX").aisle(" X ", "XAX", "---", "---", "---", "XAX", " X ").aisle(" X ", "XAX", "-A-", "-H-", "-A-", "XAX", " X ").aisle("   ", "XXX", "---", "---", "---", "XXX", "   ").where('S', this.selfPredicate()).where('X', MetaTileEntityResearchStation.states(MetaTileEntityResearchStation.getCasingState())).where(' ', MetaTileEntityResearchStation.any()).where('-', MetaTileEntityResearchStation.air()).where('V', MetaTileEntityResearchStation.states(MetaTileEntityResearchStation.getVentState())).where('A', MetaTileEntityResearchStation.states(MetaTileEntityResearchStation.getAdvancedState())).where('P', MetaTileEntityResearchStation.states(MetaTileEntityResearchStation.getCasingState()).or(MetaTileEntityResearchStation.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1)).or(this.maintenancePredicate()).or(MetaTileEntityResearchStation.abilities(MultiblockAbility.COMPUTATION_DATA_RECEPTION).setExactLimit(1))).where('H', MetaTileEntityResearchStation.abilities(MultiblockAbility.OBJECT_HOLDER)).build();
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        return Collections.singletonList(MultiblockShapeInfo.builder(RelativeDirection.RIGHT, RelativeDirection.DOWN, RelativeDirection.FRONT).aisle("XXX", "VVV", "POP", "PEP", "PMP", "VVV", "XXX").aisle("XXX", "VAV", "AAA", "AAA", "AAA", "VAV", "XXX").aisle("XXX", "VAV", "XAX", "XSX", "XAX", "VAV", "XXX").aisle("XXX", "XAX", "---", "---", "---", "XAX", "XXX").aisle("-X-", "XAX", "---", "---", "---", "XAX", "-X-").aisle("-X-", "XAX", "-A-", "-H-", "-A-", "XAX", "-X-").aisle("---", "XXX", "---", "---", "---", "XXX", "---").where('S', MetaTileEntities.RESEARCH_STATION, EnumFacing.SOUTH).where('X', MetaTileEntityResearchStation.getCasingState()).where('-', Blocks.field_150350_a.func_176223_P()).where('V', MetaTileEntityResearchStation.getVentState()).where('A', MetaTileEntityResearchStation.getAdvancedState()).where('P', MetaTileEntityResearchStation.getCasingState()).where('O', MetaTileEntities.COMPUTATION_HATCH_RECEIVER, EnumFacing.NORTH).where('E', MetaTileEntities.ENERGY_INPUT_HATCH[6], EnumFacing.NORTH).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : MetaTileEntityResearchStation.getCasingState(), EnumFacing.NORTH).where('H', MetaTileEntities.OBJECT_HOLDER, EnumFacing.NORTH).build());
    }

    @NotNull
    private static IBlockState getVentState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.COMPUTER_HEAT_VENT);
    }

    @NotNull
    private static IBlockState getAdvancedState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.ADVANCED_COMPUTER_CASING);
    }

    @NotNull
    private static IBlockState getCasingState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.COMPUTER_CASING);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (sourcePart == null || sourcePart instanceof IObjectHolder) {
            return Textures.ADVANCED_COMPUTER_CASING;
        }
        return Textures.COMPUTER_CASING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.RESEARCH_STATION_OVERLAY;
    }

    @Override
    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    public boolean canVoidRecipeItemOutputs() {
        return true;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.research_station.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.research_station.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.research_station.tooltip.3", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.research_station.tooltip.4", (Object[])new Object[0]));
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addEnergyTierLine(GTUtility.getTierByVoltage(this.recipeMapWorkable.getMaxVoltage())).addComputationUsageExactLine(this.getRecipeMapWorkable().getCurrentDrawnCWUt()).addParallelsLine(this.recipeMapWorkable.getParallelLimit());
        if (!this.recipeMapWorkable.isWorkingEnabled()) {
            builder.addWorkPausedLine(false);
        } else if (this.recipeMapWorkable.isWorking()) {
            builder.addCustom(this::researchingLine);
        } else {
            builder.addIdlingLine(false);
        }
        builder.addComputationProgressLine(this.getRecipeMapWorkable());
    }

    @Override
    protected void configureWarningText(MultiblockUIBuilder builder) {
        builder.addLowComputationLine(this.getRecipeMapWorkable().isHasNotEnoughComputation());
        super.configureWarningText(builder);
    }

    private void researchingLine(KeyManager manager, UISyncer syncer) {
        Recipe recipe = this.getRecipeMapWorkable().getPreviousRecipe();
        if (syncer.syncBoolean(recipe == null)) {
            return;
        }
        ItemStack stack = ItemStack.field_190927_a;
        if (recipe != null) {
            List<ItemStack> outputs = recipe.getOutputs();
            stack = outputs.get(outputs.size() - 1);
        }
        if ((stack = syncer.syncObject(stack, ByteBufAdapters.ITEM_STACK)).func_190926_b()) {
            return;
        }
        String id = AssemblyLineManager.readResearchId(stack);
        if (id == null) {
            return;
        }
        ArrayList<String> stacks = new ArrayList<String>();
        DataItemBehavior.collectResearchItems(id, stacks);
        stacks.remove(0);
        manager.add((IDrawable)KeyUtil.lang(TextFormatting.GREEN, "gregtech.machine.research_station.researching", new Object[0]));
        for (String line : stacks) {
            manager.add((IDrawable)KeyUtil.string(line));
        }
    }

    private static class ResearchStationRecipeLogic
    extends ComputationRecipeLogic {
        public ResearchStationRecipeLogic(MetaTileEntityResearchStation metaTileEntity) {
            super((RecipeMapMultiblockController)metaTileEntity, ComputationRecipeLogic.ComputationType.SPORADIC);
        }

        @Override
        @NotNull
        public MetaTileEntityResearchStation getMetaTileEntity() {
            return (MetaTileEntityResearchStation)super.getMetaTileEntity();
        }

        @Override
        public boolean isAllowOverclocking() {
            return false;
        }

        @Override
        @Nullable
        protected Recipe setupAndConsumeRecipeInputs(@NotNull Recipe recipe, @NotNull IItemHandlerModifiable importInventory) {
            if (!this.hasEnoughPower(recipe.getEUt(), recipe.getDuration())) {
                return null;
            }
            if (recipe.matches(false, importInventory, this.getInputTank())) {
                this.metaTileEntity.addNotifiedInput(importInventory);
                return recipe;
            }
            return null;
        }

        @Override
        protected void setupRecipe(@NotNull Recipe recipe) {
            IObjectHolder holder = this.getMetaTileEntity().getObjectHolder();
            holder.setLocked(true);
            super.setupRecipe(recipe);
        }

        @Override
        protected void outputRecipeOutputs() {
            IObjectHolder holder = this.getMetaTileEntity().getObjectHolder();
            holder.setHeldItem(ItemStack.field_190927_a);
            ItemStack outputItem = ItemStack.field_190927_a;
            if (this.itemOutputs != null && this.itemOutputs.size() >= 1) {
                outputItem = (ItemStack)this.itemOutputs.get(0);
            }
            holder.setDataItem(outputItem);
            holder.setLocked(false);
        }
    }
}

