/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.logic.OCResult;
import gregtech.api.recipes.properties.RecipePropertyStorage;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityPyrolyseOven
extends RecipeMapMultiblockController {
    private int coilTier;

    public MetaTileEntityPyrolyseOven(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.PYROLYSE_RECIPES);
        this.recipeMapWorkable = new PyrolyseOvenWorkableHandler(this);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPyrolyseOven(this.metaTileEntityId);
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("CCC", "C#C", "CCC").aisle("CCC", "C#C", "CCC").aisle("XXX", "XSX", "XXX").where('S', this.selfPredicate()).where('X', MetaTileEntityPyrolyseOven.states(this.getCasingState()).setMinGlobalLimited(6).or(this.autoAbilities())).where('C', MetaTileEntityPyrolyseOven.heatingCoils()).where('#', MetaTileEntityPyrolyseOven.air()).build();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.VOLTAGE_CASINGS[0];
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.MACHINE_CASING.getState(BlockMachineCasing.MachineCasingType.ULV);
    }

    @Override
    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.PYROLYSE_OVEN_OVERLAY;
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        Object type = context.get("CoilType");
        this.coilTier = type instanceof IHeatingCoilBlockStats ? ((IHeatingCoilBlockStats)type).getTier() : 0;
    }

    private TextFormatting getSpeedColor(int speed) {
        if (speed < 100) {
            return TextFormatting.RED;
        }
        if (speed == 100) {
            return TextFormatting.GRAY;
        }
        if (speed < 250) {
            return TextFormatting.GREEN;
        }
        return TextFormatting.LIGHT_PURPLE;
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addEnergyTierLine(GTUtility.getTierByVoltage(this.recipeMapWorkable.getMaxVoltage())).addCustom((textList, syncer) -> {
            if (!this.isStructureFormed()) {
                return;
            }
            int tier = syncer.syncInt(this.coilTier);
            int processingSpeed = tier == 0 ? 75 : 50 * (tier + 1);
            IKey speed = KeyUtil.number(() -> this.getSpeedColor(processingSpeed), (long)processingSpeed, "%");
            IKey body = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.pyrolyse_oven.speed", speed);
            IKey hover = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.pyrolyse_oven.speed_hover", new Object[0]);
            textList.add(KeyUtil.setHover(body, new IDrawable[]{hover}));
        }).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgress(), this.recipeMapWorkable.getMaxProgress()).addRecipeOutputLine(this.recipeMapWorkable);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.pyrolyse_oven.tooltip.1", (Object[])new Object[0]));
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.coilTier = -1;
    }

    protected int getCoilTier() {
        return this.coilTier;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return true;
    }

    @Override
    public boolean canBeDistinct() {
        return true;
    }

    private class PyrolyseOvenWorkableHandler
    extends MultiblockRecipeLogic {
        public PyrolyseOvenWorkableHandler(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        @Override
        protected void modifyOverclockPost(@NotNull OCResult ocResult, @NotNull RecipePropertyStorage storage) {
            super.modifyOverclockPost(ocResult, storage);
            int coilTier = ((MetaTileEntityPyrolyseOven)this.metaTileEntity).getCoilTier();
            if (coilTier == -1) {
                return;
            }
            if (coilTier == 0) {
                ocResult.setDuration(Math.max(1, (int)((double)ocResult.duration() * 4.0 / 3.0)));
            } else {
                ocResult.setDuration(Math.max(1, (int)((double)ocResult.duration() * 2.0 / (double)(coilTier + 1))));
            }
        }
    }
}

