/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IBatteryData;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.TemplateBarBuilder;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.sync.BigIntegerSyncValue;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class MetaTileEntityPowerSubstation
extends MultiblockWithDisplayBase
implements IControllable,
ProgressBarMultiblock {
    public static final int MAX_BATTERY_LAYERS = 18;
    private static final int MIN_CASINGS = 14;
    public static final long PASSIVE_DRAIN_DIVISOR = 172800000L;
    public static final long PASSIVE_DRAIN_MAX_PER_STORAGE = 100000L;
    private static final String NBT_ENERGY_BANK = "EnergyBank";
    private static final String PMC_BATTERY_HEADER = "PSSBattery_";
    private static final BigInteger BIG_INTEGER_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private PowerStationEnergyBank energyBank;
    private EnergyContainerList inputHatches;
    private EnergyContainerList outputHatches;
    private long passiveDrain;
    private boolean isActive;
    private boolean isWorkingEnabled = true;
    private long netInLastSec;
    private long averageInLastSec;
    private long netOutLastSec;
    private long averageOutLastSec;
    protected static final Supplier<TraceabilityPredicate> BATTERY_PREDICATE = () -> new TraceabilityPredicate(blockWorldState -> {
        IBlockState state = blockWorldState.getBlockState();
        if (GregTechAPI.PSS_BATTERIES.containsKey((Object)state)) {
            IBatteryData battery = (IBatteryData)GregTechAPI.PSS_BATTERIES.get((Object)state);
            if (battery.getTier() != -1 && battery.getCapacity() > 0L) {
                String key = PMC_BATTERY_HEADER + battery.getBatteryName();
                BatteryMatchWrapper wrapper = (BatteryMatchWrapper)blockWorldState.getMatchContext().get(key);
                if (wrapper == null) {
                    wrapper = new BatteryMatchWrapper(battery);
                }
                blockWorldState.getMatchContext().set(key, wrapper.increment());
            }
            return true;
        }
        return false;
    }, () -> (BlockInfo[])GregTechAPI.PSS_BATTERIES.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((IBatteryData)entry.getValue()).getTier())).map(entry -> new BlockInfo((IBlockState)entry.getKey(), null)).toArray(BlockInfo[]::new)).addTooltips("gregtech.multiblock.pattern.error.batteries");

    public MetaTileEntityPowerSubstation(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPowerSubstation(this.metaTileEntityId);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        ArrayList<IEnergyContainer> inputs = new ArrayList<IEnergyContainer>();
        inputs.addAll(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        inputs.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_INPUT_ENERGY));
        inputs.addAll(this.getAbilities(MultiblockAbility.INPUT_LASER));
        this.inputHatches = new EnergyContainerList(inputs);
        ArrayList<IEnergyContainer> outputs = new ArrayList<IEnergyContainer>();
        outputs.addAll(this.getAbilities(MultiblockAbility.OUTPUT_ENERGY));
        outputs.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_OUTPUT_ENERGY));
        outputs.addAll(this.getAbilities(MultiblockAbility.OUTPUT_LASER));
        this.outputHatches = new EnergyContainerList(outputs);
        ArrayList<IBatteryData> parts = new ArrayList<IBatteryData>();
        for (Map.Entry<String, Object> battery : context.entrySet()) {
            Object object;
            if (!battery.getKey().startsWith(PMC_BATTERY_HEADER) || !((object = battery.getValue()) instanceof BatteryMatchWrapper)) continue;
            BatteryMatchWrapper wrapper = (BatteryMatchWrapper)object;
            for (int i = 0; i < wrapper.amount; ++i) {
                parts.add(wrapper.partType);
            }
        }
        if (parts.isEmpty()) {
            this.invalidateStructure();
            return;
        }
        if (this.energyBank == null) {
            this.energyBank = new PowerStationEnergyBank(parts);
        } else {
            this.energyBank.rebuild(parts);
        }
        this.passiveDrain = this.energyBank.getPassiveDrainPerTick();
    }

    @Override
    public void invalidateStructure() {
        this.inputHatches = null;
        this.outputHatches = null;
        this.passiveDrain = 0L;
        this.netInLastSec = 0L;
        this.averageInLastSec = 0L;
        this.netOutLastSec = 0L;
        this.averageOutLastSec = 0L;
        super.invalidateStructure();
    }

    @Override
    protected void updateFormedValid() {
        if (!this.getWorld().field_72995_K) {
            if (this.getOffsetTimer() % 20L == 0L) {
                this.setActive(this.energyBank.hasEnergy());
                this.averageInLastSec = this.netInLastSec / 20L;
                this.averageOutLastSec = this.netOutLastSec / 20L;
                this.netInLastSec = 0L;
                this.netOutLastSec = 0L;
            }
            if (this.isWorkingEnabled()) {
                long energyBanked = this.energyBank.fill(this.inputHatches.getEnergyStored());
                this.inputHatches.changeEnergy(-energyBanked);
                this.netInLastSec += energyBanked;
                long energyPassiveDrained = this.energyBank.drain(this.getPassiveDrain());
                this.netOutLastSec += energyPassiveDrained;
                long energyDebanked = this.energyBank.drain(this.outputHatches.getEnergyCapacity() - this.outputHatches.getEnergyStored());
                this.outputHatches.changeEnergy(energyDebanked);
                this.netOutLastSec += energyDebanked;
            }
        }
    }

    public long getPassiveDrain() {
        if (ConfigHolder.machines.enableMaintenance) {
            int multiplier = 1 + this.getNumMaintenanceProblems();
            double modifier = this.getMaintenanceDurationMultiplier();
            return (long)((double)(this.passiveDrain * (long)multiplier) * modifier);
        }
        return this.passiveDrain;
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.isActive;
    }

    public void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.markDirty();
            World world = this.getWorld();
            if (world != null && !world.field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, buf -> buf.writeBoolean(active));
            }
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.isWorkingEnabled = isWorkingAllowed;
        this.markDirty();
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(this.isWorkingEnabled));
        }
    }

    @Override
    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start(RelativeDirection.RIGHT, RelativeDirection.FRONT, RelativeDirection.UP).aisle("XXSXX", "XXXXX", "XXXXX", "XXXXX", "XXXXX").aisle("XXXXX", "XCCCX", "XCCCX", "XCCCX", "XXXXX").aisle("GGGGG", "GBBBG", "GBBBG", "GBBBG", "GGGGG").setRepeatable(1, 18).aisle("GGGGG", "GGGGG", "GGGGG", "GGGGG", "GGGGG").where('S', this.selfPredicate()).where('C', MetaTileEntityPowerSubstation.states(this.getCasingState())).where('X', MetaTileEntityPowerSubstation.states(this.getCasingState()).setMinGlobalLimited(14).or(this.maintenancePredicate()).or(MetaTileEntityPowerSubstation.abilities(MultiblockAbility.INPUT_ENERGY, MultiblockAbility.SUBSTATION_INPUT_ENERGY, MultiblockAbility.INPUT_LASER).setMinGlobalLimited(1)).or(MetaTileEntityPowerSubstation.abilities(MultiblockAbility.OUTPUT_ENERGY, MultiblockAbility.SUBSTATION_OUTPUT_ENERGY, MultiblockAbility.OUTPUT_LASER).setMinGlobalLimited(1))).where('G', MetaTileEntityPowerSubstation.states(this.getGlassState())).where('B', BATTERY_PREDICATE.get()).build();
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder(RelativeDirection.RIGHT, RelativeDirection.DOWN, RelativeDirection.FRONT).aisle("CCCCC", "CCCCC", "GGGGG", "GGGGG", "GGGGG").aisle("CCCCC", "CCCCC", "GBBBG", "GBBBG", "GGGGG").aisle("CCCCC", "CCCCC", "GBBBG", "GBBBG", "GGGGG").aisle("CCCCC", "CCCCC", "GBBBG", "GBBBG", "GGGGG").aisle("ICSCO", "NCMCT", "GGGGG", "GGGGG", "GGGGG").where('S', MetaTileEntities.POWER_SUBSTATION, EnumFacing.SOUTH).where('C', this.getCasingState()).where('G', this.getGlassState()).where('I', MetaTileEntities.ENERGY_INPUT_HATCH[3], EnumFacing.SOUTH).where('N', MetaTileEntities.SUBSTATION_ENERGY_INPUT_HATCH[0], EnumFacing.SOUTH).where('O', MetaTileEntities.ENERGY_OUTPUT_HATCH[3], EnumFacing.SOUTH).where('T', MetaTileEntities.SUBSTATION_ENERGY_OUTPUT_HATCH[0], EnumFacing.SOUTH).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.PALLADIUM_SUBSTATION), EnumFacing.SOUTH);
        GregTechAPI.PSS_BATTERIES.entrySet().stream().filter(entry -> ((IBatteryData)entry.getValue()).getCapacity() > 0L).sorted(Comparator.comparingInt(entry -> ((IBatteryData)entry.getValue()).getTier())).forEach(entry -> shapeInfo.add(builder.where('B', (IBlockState)entry.getKey()).build()));
        return shapeInfo;
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.PALLADIUM_SUBSTATION);
    }

    protected IBlockState getGlassState() {
        return MetaBlocks.TRANSPARENT_CASING.getState(BlockGlassCasing.CasingType.LAMINATED_GLASS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.PALLADIUM_SUBSTATION_CASING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.POWER_SUBSTATION_OVERLAY;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.isWorkingEnabled());
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.structureFormed(this.isStructureFormed());
        builder.setWorkingStatus(true, this.isActive() && this.isWorkingEnabled());
        builder.setWorkingStatusKeys("gregtech.multiblock.idling", "gregtech.multiblock.idling", "gregtech.machine.active_transformer.routing");
        builder.addCustom((manager, syncer) -> {
            if (this.isStructureFormed() && syncer.syncBoolean(this.energyBank != null)) {
                BigInteger energyStored = syncer.syncBigInt(this.energyBank == null ? BigInteger.ZERO : this.energyBank.getStored());
                BigInteger energyCapacity = syncer.syncBigInt(this.energyBank == null ? BigInteger.ZERO : this.energyBank.getCapacity());
                IKey storedFormatted = KeyUtil.string(TextFormattingUtil.formatNumbers(energyStored) + " EU");
                IKey truncated = KeyUtil.string(TextFormatting.GOLD, TextFormattingUtil.formatBigIntToCompactString(energyStored, 7) + " EU");
                IKey bodyStored = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.power_substation.stored", truncated);
                manager.add(KeyUtil.setHover(bodyStored, new IDrawable[]{storedFormatted}));
                IKey capacityFormatted = KeyUtil.string(TextFormattingUtil.formatNumbers(energyCapacity) + " EU");
                IKey capCompact = KeyUtil.string(TextFormatting.GOLD, TextFormattingUtil.formatBigIntToCompactString(energyCapacity, 7) + " EU");
                IKey bodyCap = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.power_substation.capacity", capCompact);
                manager.add(KeyUtil.setHover(bodyCap, new IDrawable[]{capacityFormatted}));
                IKey passiveDrain = KeyUtil.string(TextFormatting.DARK_RED, TextFormattingUtil.formatNumbers(syncer.syncLong(this.getPassiveDrain())) + " EU/t");
                manager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.power_substation.passive_drain", passiveDrain));
                long avgIn = syncer.syncLong(this.averageInLastSec);
                long avgOut = syncer.syncLong(this.averageOutLastSec);
                IKey avgValue = KeyUtil.number(TextFormatting.GREEN, avgIn, " EU/t");
                IKey base = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.power_substation.average_in", avgValue);
                IKey hover = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.power_substation.average_in_hover", new Object[0]);
                manager.add(KeyUtil.setHover(base, new IDrawable[]{hover}));
                avgValue = KeyUtil.number(TextFormatting.RED, avgOut, " EU/t");
                base = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.power_substation.average_out", avgValue);
                hover = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.power_substation.average_out_hover", new Object[0]);
                manager.add(KeyUtil.setHover(base, new IDrawable[]{hover}));
                if (avgIn > avgOut) {
                    IKey timeToFill = MetaTileEntityPowerSubstation.getTimeToFillDrainText(energyCapacity.subtract(energyStored).divide(BigInteger.valueOf((avgIn - avgOut) * 20L))).style(TextFormatting.GREEN);
                    manager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.power_substation.time_to_fill", timeToFill));
                } else if (avgIn < avgOut) {
                    IKey timeToDrain = MetaTileEntityPowerSubstation.getTimeToFillDrainText(energyStored.divide(BigInteger.valueOf((avgOut - avgIn) * 20L))).style(TextFormatting.RED);
                    manager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.power_substation.time_to_drain", timeToDrain));
                }
            }
        }).addWorkingStatusLine();
    }

    @Override
    protected void configureWarningText(MultiblockUIBuilder builder) {
        super.configureWarningText(builder);
        builder.addCustom((list, syncer) -> {
            BigInteger timeToDrainSeconds;
            if (this.isStructureFormed() && this.averageInLastSec < this.averageOutLastSec && (timeToDrainSeconds = this.energyBank.getStored().divide(BigInteger.valueOf((this.averageOutLastSec - this.averageInLastSec) * 20L))).compareTo(BigInteger.valueOf(3600L)) < 0) {
                list.add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.power_substation.under_one_hour_left", new Object[0]));
            }
        });
    }

    private static IKey getTimeToFillDrainText(BigInteger timeToFillSeconds) {
        String key;
        long fillTime;
        Duration duration;
        if (timeToFillSeconds.compareTo(BIG_INTEGER_MAX_LONG) > 0) {
            timeToFillSeconds = BIG_INTEGER_MAX_LONG;
        }
        if ((duration = Duration.ofSeconds(timeToFillSeconds.longValue())).getSeconds() <= 180L) {
            fillTime = duration.getSeconds();
            key = "gregtech.multiblock.power_substation.time_seconds";
        } else if (duration.toMinutes() <= 180L) {
            fillTime = duration.toMinutes();
            key = "gregtech.multiblock.power_substation.time_minutes";
        } else if (duration.toHours() <= 72L) {
            fillTime = duration.toHours();
            key = "gregtech.multiblock.power_substation.time_hours";
        } else if (duration.toDays() <= 730L) {
            fillTime = duration.toDays();
            key = "gregtech.multiblock.power_substation.time_days";
        } else if (duration.toDays() / 365L < 1000000L) {
            fillTime = duration.toDays() / 365L;
            key = "gregtech.multiblock.power_substation.time_years";
        } else {
            return KeyUtil.lang("gregtech.multiblock.power_substation.time_forever", new Object[0]);
        }
        return KeyUtil.lang(key, TextFormattingUtil.formatNumbers(fillTime));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("isActive", this.isActive);
        data.func_74757_a("isWorkingEnabled", this.isWorkingEnabled);
        if (this.energyBank != null) {
            data.func_74782_a(NBT_ENERGY_BANK, (NBTBase)this.energyBank.writeToNBT(new NBTTagCompound()));
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isActive = data.func_74767_n("isActive");
        this.isWorkingEnabled = data.func_74767_n("isWorkingEnabled");
        if (data.func_74764_b(NBT_ENERGY_BANK)) {
            this.energyBank = new PowerStationEnergyBank(data.func_74775_l(NBT_ENERGY_BANK));
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.isWorkingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
        this.isWorkingEnabled = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip3", (Object[])new Object[]{18}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip4", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip5", (Object[])new Object[]{100000L}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip6", (Object[])new Object[0]) + TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip6.5", (Object[])new Object[0]));
    }

    public String getStored() {
        if (this.energyBank == null) {
            return "0";
        }
        return TextFormattingUtil.formatNumbers(this.energyBank.getStored());
    }

    public long getStoredLong() {
        if (this.energyBank == null) {
            return 0L;
        }
        return this.energyBank.getStored().longValue() & Long.MAX_VALUE;
    }

    public long getCapacityLong() {
        if (this.energyBank == null) {
            return 0L;
        }
        return this.energyBank.getCapacity().longValue() & Long.MAX_VALUE;
    }

    public String getCapacity() {
        if (this.energyBank == null) {
            return "0";
        }
        return TextFormattingUtil.formatNumbers(this.energyBank.getCapacity());
    }

    public long getAverageInLastSec() {
        return this.averageInLastSec;
    }

    public long getAverageOutLastSec() {
        return this.averageOutLastSec;
    }

    @Override
    public int getProgressBarCount() {
        return 1;
    }

    @Override
    public void registerBars(List<UnaryOperator<TemplateBarBuilder>> bars, PanelSyncManager syncManager) {
        BigIntegerSyncValue energyStoredValue = new BigIntegerSyncValue(() -> this.energyBank == null ? BigInteger.ZERO : this.energyBank.getStored(), null);
        BigIntegerSyncValue energyCapacityValue = new BigIntegerSyncValue(() -> this.energyBank == null ? BigInteger.ZERO : this.energyBank.getCapacity(), null);
        syncManager.syncValue("energy_stored", (SyncHandler)energyStoredValue);
        syncManager.syncValue("energy_capacity", (SyncHandler)energyCapacityValue);
        bars.add(b -> b.progress(() -> energyStoredValue.getValue().doubleValue() / energyCapacityValue.getValue().doubleValue()).texture(GTGuiTextures.PROGRESS_BAR_MULTI_ENERGY_YELLOW).tooltipBuilder(t -> {
            if (this.isStructureFormed()) {
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.energy_stored", (Object[])new Object[]{energyStoredValue.getValue(), energyCapacityValue.getValue()}));
            } else {
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.invalid_structure"));
            }
        }));
    }

    private static class BatteryMatchWrapper {
        private final IBatteryData partType;
        private int amount;

        public BatteryMatchWrapper(IBatteryData partType) {
            this.partType = partType;
        }

        public BatteryMatchWrapper increment() {
            ++this.amount;
            return this;
        }
    }

    public static class PowerStationEnergyBank {
        private static final String NBT_SIZE = "Size";
        private static final String NBT_STORED = "Stored";
        private static final String NBT_MAX = "Max";
        private final long[] stored = new long[2];
        private final long[] max = new long[2];
        private BigInteger capacity;
        private long drain;
        private long drainMod;

        public PowerStationEnergyBank(List<IBatteryData> batteries) {
            for (IBatteryData i : batteries) {
                PowerStationEnergyBank.add(this.max, i.getCapacity());
                this.updateDrain(i.getCapacity());
            }
            this.capacity = PowerStationEnergyBank.summarize(this.max);
        }

        public PowerStationEnergyBank(NBTTagCompound storageTag) {
            if (storageTag.func_150297_b(NBT_SIZE, 3)) {
                int size = storageTag.func_74762_e(NBT_SIZE);
                for (int i = 0; i < size; ++i) {
                    NBTTagCompound tag = storageTag.func_74775_l(String.valueOf(i));
                    if (tag.func_74764_b(NBT_STORED)) {
                        PowerStationEnergyBank.add(this.stored, tag.func_74763_f(NBT_STORED));
                    }
                    long store = tag.func_74763_f(NBT_MAX);
                    PowerStationEnergyBank.add(this.max, store);
                    this.updateDrain(store);
                }
            } else {
                this.stored[0] = storageTag.func_74763_f("Stored0");
                this.stored[1] = storageTag.func_74763_f("Stored1");
                this.drain = storageTag.func_74763_f("drain");
                this.drainMod = storageTag.func_74763_f("drainMod");
            }
            this.capacity = PowerStationEnergyBank.summarize(this.max);
        }

        public NBTTagCompound writeToNBT(NBTTagCompound compound) {
            compound.func_74772_a("Stored0", this.stored[0]);
            compound.func_74772_a("Stored1", this.stored[1]);
            compound.func_74772_a("drain", this.drain);
            compound.func_74772_a("drainMod", this.drainMod);
            return compound;
        }

        private void updateDrain(long val) {
            if (val / 172800000L >= 100000L) {
                this.drain += 100000L;
            } else {
                this.drain += val / 172800000L;
                this.drainMod += val % 172800000L;
                if (this.drainMod >= 172800000L) {
                    ++this.drain;
                    this.drainMod -= 172800000L;
                }
            }
        }

        public void rebuild(@NotNull List<IBatteryData> batteries) {
            if (batteries.isEmpty()) {
                throw new IllegalArgumentException("Cannot rebuild Power Substation power bank with no batteries!");
            }
            Arrays.fill(this.max, 0L);
            this.drain = 0L;
            for (IBatteryData i : batteries) {
                PowerStationEnergyBank.add(this.max, i.getCapacity());
                this.updateDrain(i.getCapacity());
            }
            if (this.stored[0] > this.max[0]) {
                this.stored[0] = this.max[0];
                this.stored[1] = this.max[1];
            } else if (this.stored[0] == this.max[0]) {
                this.stored[1] = Math.min(this.stored[1], this.max[1]);
            }
            this.capacity = PowerStationEnergyBank.summarize(this.max);
        }

        public long fill(long amount) {
            if (amount < 0L) {
                throw new IllegalArgumentException("Amount cannot be negative!");
            }
            if (this.max[0] == this.stored[0]) {
                amount = Math.min(this.max[1] - this.stored[1], amount);
                this.stored[1] = this.stored[1] + amount;
                return amount;
            }
            if (this.stored[1] + amount < 0L) {
                this.stored[0] = this.stored[0] + 1L;
                this.stored[1] = this.stored[1] + Long.MIN_VALUE;
                if (this.max[0] == this.stored[0] && this.max[1] < this.stored[1] + amount) {
                    amount = this.max[1] - this.stored[1];
                }
            }
            this.stored[1] = this.stored[1] + amount;
            return amount;
        }

        public long drain(long amount) {
            if (amount < 0L) {
                throw new IllegalArgumentException("Amount cannot be negative!");
            }
            if (this.stored[0] == 0L) {
                long sub = Math.min(this.stored[1], amount);
                this.stored[1] = this.stored[1] - sub;
                return sub;
            }
            if (this.stored[1] < amount) {
                this.stored[0] = this.stored[0] - 1L;
                this.stored[1] = this.stored[1] - (amount + Long.MIN_VALUE);
            } else {
                this.stored[1] = this.stored[1] - amount;
            }
            return amount;
        }

        public BigInteger getCapacity() {
            return this.capacity;
        }

        public BigInteger getStored() {
            return PowerStationEnergyBank.summarize(this.stored);
        }

        public boolean hasEnergy() {
            return this.stored[0] != 0L && this.stored[1] != 0L;
        }

        private static BigInteger summarize(long[] num) {
            return BigInteger.valueOf(num[0]).shiftLeft(63).add(BigInteger.valueOf(num[1]));
        }

        private static void add(long[] num, long val) {
            num[1] = num[1] + val;
            if (num[1] < 0L) {
                num[0] = num[0] + 1L;
                num[1] = num[1] - Long.MIN_VALUE;
            }
        }

        @VisibleForTesting
        public long getPassiveDrainPerTick() {
            return this.drain;
        }
    }
}

