/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import gregtech.api.GTValues;
import gregtech.api.capability.IOpticalComputationHatch;
import gregtech.api.capability.IOpticalComputationProvider;
import gregtech.api.capability.IOpticalComputationReceiver;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockComputerCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityDataBank;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityNetworkSwitch
extends MetaTileEntityDataBank
implements IOpticalComputationProvider {
    private static final int EUT_PER_HATCH = GTValues.VA[5];
    private final MultipleComputationHandler computationHandler = new MultipleComputationHandler();

    public MetaTileEntityNetworkSwitch(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityNetworkSwitch(this.metaTileEntityId);
    }

    @Override
    protected int calculateEnergyUsage() {
        int receivers = this.getAbilities(MultiblockAbility.COMPUTATION_DATA_RECEPTION).size();
        int transmitters = this.getAbilities(MultiblockAbility.COMPUTATION_DATA_TRANSMISSION).size();
        return GTValues.VA[5] * (receivers + transmitters);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.computationHandler.onStructureForm(this.getAbilities(MultiblockAbility.COMPUTATION_DATA_RECEPTION), this.getAbilities(MultiblockAbility.COMPUTATION_DATA_TRANSMISSION));
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.computationHandler.reset();
    }

    @Override
    protected int getEnergyUsage() {
        return this.isStructureFormed() ? this.computationHandler.getEUt() : 0;
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isActive() && !this.hasNotEnoughEnergy ? this.computationHandler.requestCWUt(cwut, simulate, seen) : 0;
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isStructureFormed() ? this.computationHandler.getMaxCWUt(seen) : 0;
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return true;
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "XAX", "XXX").aisle("XXX", "XSX", "XXX").where('S', this.selfPredicate()).where('A', MetaTileEntityNetworkSwitch.states(MetaTileEntityNetworkSwitch.getAdvancedState())).where('X', MetaTileEntityNetworkSwitch.states(MetaTileEntityNetworkSwitch.getCasingState()).setMinGlobalLimited(7).or(MetaTileEntityNetworkSwitch.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1, 1)).or(this.maintenancePredicate()).or(MetaTileEntityNetworkSwitch.abilities(MultiblockAbility.COMPUTATION_DATA_RECEPTION).setMinGlobalLimited(1, 2)).or(MetaTileEntityNetworkSwitch.abilities(MultiblockAbility.COMPUTATION_DATA_TRANSMISSION).setMinGlobalLimited(1, 1))).build();
    }

    @NotNull
    private static IBlockState getCasingState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.COMPUTER_CASING);
    }

    @NotNull
    private static IBlockState getAdvancedState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.ADVANCED_COMPUTER_CASING);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.COMPUTER_CASING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.NETWORK_SWITCH_OVERLAY;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.network_switch.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.network_switch.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.network_switch.tooltip.3", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.network_switch.tooltip.4", (Object[])new Object[]{TextFormattingUtil.formatNumbers(EUT_PER_HATCH)}));
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.setWorkingStatus(true, this.isActive() && this.isWorkingEnabled()).setWorkingStatusKeys("gregtech.multiblock.idling", "gregtech.multiblock.idling", "gregtech.multiblock.data_bank.providing").addEnergyUsageExactLine(this.getEnergyUsage()).addComputationUsageLine(this.computationHandler.getMaxCWUtForDisplay()).addWorkingStatusLine();
    }

    @Override
    protected void configureWarningText(MultiblockUIBuilder builder) {
        super.configureWarningText(builder);
        builder.addCustom((list, syncer) -> {
            if (this.isStructureFormed() && syncer.syncBoolean(this.computationHandler.hasNonBridgingConnections())) {
                list.add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.computation.non_bridging.detailed", new Object[0]));
            }
        });
    }

    private static class MultipleComputationHandler
    implements IOpticalComputationProvider,
    IOpticalComputationReceiver {
        private final Set<IOpticalComputationHatch> providers = new ObjectOpenHashSet();
        private final Set<IOpticalComputationHatch> transmitters = new ObjectOpenHashSet();
        private int EUt;

        private MultipleComputationHandler() {
        }

        private void onStructureForm(Collection<IOpticalComputationHatch> providers, Collection<IOpticalComputationHatch> transmitters) {
            this.reset();
            this.providers.addAll(providers);
            this.transmitters.addAll(transmitters);
            this.EUt = (providers.size() + transmitters.size()) * EUT_PER_HATCH;
        }

        private void reset() {
            this.providers.clear();
            this.transmitters.clear();
            this.EUt = 0;
        }

        @Override
        public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
            if (seen.contains(this)) {
                return 0;
            }
            seen.add(this);
            ArrayList<IOpticalComputationProvider> bridgeSeen = new ArrayList<IOpticalComputationProvider>(seen);
            int allocatedCWUt = 0;
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(bridgeSeen)) continue;
                int allocated = provider.requestCWUt(cwut, simulate, seen);
                allocatedCWUt += allocated;
                if ((cwut -= allocated) != 0) continue;
                break;
            }
            return allocatedCWUt;
        }

        public int getMaxCWUtForDisplay() {
            ArrayList<IOpticalComputationProvider> seen = new ArrayList<IOpticalComputationProvider>();
            seen.add(this);
            ArrayList<IOpticalComputationProvider> bridgeSeen = new ArrayList<IOpticalComputationProvider>(seen);
            int maximumCWUt = 0;
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(bridgeSeen)) continue;
                maximumCWUt += provider.getMaxCWUt(seen);
            }
            return maximumCWUt;
        }

        @Override
        public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
            if (seen.contains(this)) {
                return 0;
            }
            seen.add(this);
            ArrayList<IOpticalComputationProvider> bridgeSeen = new ArrayList<IOpticalComputationProvider>(seen);
            int maximumCWUt = 0;
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(bridgeSeen)) continue;
                maximumCWUt += provider.getMaxCWUt(seen);
            }
            return maximumCWUt;
        }

        @Override
        public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
            if (seen.contains(this)) {
                return false;
            }
            seen.add(this);
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(seen)) continue;
                return true;
            }
            return false;
        }

        private int getEUt() {
            return this.EUt;
        }

        private boolean hasNonBridgingConnections() {
            ArrayList<IOpticalComputationProvider> seen = new ArrayList<IOpticalComputationProvider>();
            for (IOpticalComputationHatch provider : this.providers) {
                if (provider.canBridge(seen)) continue;
                return true;
            }
            return false;
        }

        @Override
        public IOpticalComputationProvider getComputationProvider() {
            return this;
        }
    }
}

