/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IIntValue;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.widgets.CycleButtonWidget;
import com.google.common.collect.Lists;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMiner;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.miner.MultiblockMinerLogic;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIFactory;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLargeMiner
extends MultiblockWithDisplayBase
implements IMiner,
IControllable,
IDataInfoProvider {
    private static final int CHUNK_LENGTH = 16;
    private final Material material;
    private final int tier;
    private IEnergyContainer energyContainer;
    protected IMultipleTankHandler inputFluidInventory;
    protected IItemHandlerModifiable outputInventory;
    private boolean silkTouch = false;
    private boolean chunkMode = false;
    private boolean isInventoryFull = false;
    private final int drillingFluidConsumePerTick;
    private final MultiblockMinerLogic minerLogic;

    public MetaTileEntityLargeMiner(ResourceLocation metaTileEntityId, int tier, int speed, int maximumChunkDiameter, int fortune, Material material, int drillingFluidConsumePerTick) {
        super(metaTileEntityId);
        this.material = material;
        this.tier = tier;
        this.drillingFluidConsumePerTick = drillingFluidConsumePerTick;
        this.minerLogic = new MultiblockMinerLogic((MetaTileEntity)this, fortune, speed, maximumChunkDiameter * 16 / 2, RecipeMaps.MACERATOR_RECIPES);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeMiner(this.metaTileEntityId, this.tier, this.minerLogic.getSpeed(), this.minerLogic.getMaximumRadius() * 2 / 16, this.minerLogic.getFortune(), this.getMaterial(), this.getDrillingFluidConsumePerTick());
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
        if (this.minerLogic.isActive()) {
            this.minerLogic.setActive(false);
        }
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    private void initializeAbilities() {
        this.inputFluidInventory = new FluidTankList(false, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.outputInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.EXPORT_ITEMS));
        this.energyContainer = new EnergyContainerList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        this.minerLogic.setVoltageTier(GTUtility.getTierByVoltage(this.energyContainer.getInputVoltage()));
        this.minerLogic.setOverclockAmount(Math.max(1, GTUtility.getTierByVoltage(this.energyContainer.getInputVoltage()) - this.tier));
        this.minerLogic.initPos(this.getPos(), this.minerLogic.getCurrentRadius());
    }

    private void resetTileAbilities() {
        this.inputFluidInventory = new FluidTankList(true, new IFluidTank[0]);
        this.outputInventory = new GTItemStackHandler((MetaTileEntity)this, 0);
        this.energyContainer = new EnergyContainerList(Lists.newArrayList());
    }

    public int getEnergyTier() {
        if (this.energyContainer == null) {
            return this.tier;
        }
        return Math.min(this.tier + 1, Math.max(this.tier, GTUtility.getFloorTierByVoltage(this.energyContainer.getInputVoltage())));
    }

    @Override
    public boolean drainEnergy(boolean simulate) {
        long energyToDrain = GTValues.VA[this.getEnergyTier()];
        long resultEnergy = this.energyContainer.getEnergyStored() - energyToDrain;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.changeEnergy(-energyToDrain);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean drainFluid(boolean simulate) {
        FluidStack drillingFluid = Materials.DrillingFluid.getFluid(this.drillingFluidConsumePerTick * this.minerLogic.getOverclockAmount());
        FluidStack fluidStack = this.inputFluidInventory.getTankAt(0).getFluid();
        if (fluidStack != null && fluidStack.isFluidEqual(Materials.DrillingFluid.getFluid(1)) && fluidStack.amount >= drillingFluid.amount) {
            if (!simulate) {
                this.inputFluidInventory.drain(drillingFluid, true);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.minerLogic.isWorking(), this.isWorkingEnabled());
        this.minerLogic.renderPipe(renderState, translation, pipeline);
    }

    @Override
    protected void updateFormedValid() {
        this.minerLogic.performMining();
        if (!this.getWorld().field_72995_K && this.minerLogic.wasActiveAndNeedsUpdate()) {
            this.minerLogic.setWasActiveAndNeedsUpdate(false);
            this.minerLogic.setActive(false);
        }
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "#F#", "#F#", "#F#", "###", "###", "###").aisle("XXX", "FCF", "FCF", "FCF", "#F#", "#F#", "#F#").aisle("XSX", "#F#", "#F#", "#F#", "###", "###", "###").where('S', this.selfPredicate()).where('X', MetaTileEntityLargeMiner.states(this.getCasingState()).or(MetaTileEntityLargeMiner.abilities(MultiblockAbility.EXPORT_ITEMS).setMaxGlobalLimited(1).setPreviewCount(1)).or(MetaTileEntityLargeMiner.abilities(MultiblockAbility.IMPORT_FLUIDS).setExactLimit(1).setPreviewCount(1)).or(MetaTileEntityLargeMiner.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3).setPreviewCount(1))).where('C', MetaTileEntityLargeMiner.states(this.getCasingState())).where('F', this.getFramePredicate()).where('#', MetaTileEntityLargeMiner.any()).build();
    }

    @Override
    public String[] getDescription() {
        return new String[]{I18n.func_135052_a((String)"gregtech.machine.miner.multi.description", (Object[])new Object[0])};
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        int workingAreaChunks = this.minerLogic.getCurrentRadius() * 2 / 16;
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.miner.multi.modes", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.miner.multi.production", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.miner.fluid_usage", (Object[])new Object[]{this.getDrillingFluidConsumePerTick(), Materials.DrillingFluid.getLocalizedName()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.working_area_chunks_max", (Object[])new Object[]{workingAreaChunks, workingAreaChunks}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_tier_range", (Object[])new Object[]{GTValues.VNF[this.tier], GTValues.VNF[this.tier + 1]}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.toggle_mode_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        if (this.getSound() != null) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.hammer", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.crowbar", (Object[])new Object[0]));
    }

    @Override
    protected MultiblockUIFactory createUIFactory() {
        return super.createUIFactory().createFlexButton((posGuiData, panelSyncManager) -> {
            IntSyncValue buttonSync = new IntSyncValue(this::getCurrentMode, this::setCurrentMode);
            return ((CycleButtonWidget)new CycleButtonWidget(){

                @NotNull
                public Interactable.Result onMousePressed(int mouseButton) {
                    if (MetaTileEntityLargeMiner.this.minerLogic.isWorking()) {
                        Interactable.playButtonClickSound();
                        return Interactable.Result.IGNORE;
                    }
                    return super.onMousePressed(mouseButton);
                }
            }.stateCount(4).value((IIntValue)buttonSync).stateBackground(GTGuiTextures.BUTTON_MINER_MODES)).addTooltip(0, (IDrawable)IKey.lang((String)"gregtech.multiblock.miner.neither_mode")).addTooltip(1, (IDrawable)IKey.lang((String)"gregtech.multiblock.miner.chunk_mode")).addTooltip(2, (IDrawable)IKey.lang((String)"gregtech.multiblock.miner.silk_touch_mode")).addTooltip(3, (IDrawable)IKey.lang((String)"gregtech.multiblock.miner.both_modes"));
        });
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.setWorkingStatus(this.minerLogic.isWorkingEnabled(), this.minerLogic.isActive()).addEnergyUsageLine(this.energyContainer).addCustom((list, syncer) -> {
            if (this.isStructureFormed()) {
                int workingAreaChunks = syncer.syncInt(this.minerLogic.getCurrentRadius() * 2 / 16);
                int workingArea = syncer.syncInt(this.getWorkingArea(this.minerLogic.getCurrentRadius()));
                list.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.machine.miner.mining_at", new Object[0]));
                list.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.machine.miner.mining_pos", syncer.syncInt(this.minerLogic.getMineX().get()), syncer.syncInt(this.minerLogic.getMineY().get()), syncer.syncInt(this.minerLogic.getMineZ().get())));
                if (syncer.syncBoolean(this.minerLogic.isChunkMode())) {
                    list.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.machine.miner.working_area_chunks", workingAreaChunks, workingAreaChunks));
                } else {
                    list.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.machine.miner.working_area", workingArea, workingArea));
                }
                if (syncer.syncBoolean(this.minerLogic.isDone())) {
                    list.add((IDrawable)KeyUtil.lang(TextFormatting.GREEN, "gregtech.machine.miner.done", new Object[0]));
                } else if (syncer.syncBoolean(this.minerLogic.isWorking())) {
                    list.add((IDrawable)KeyUtil.lang(TextFormatting.GOLD, "gregtech.machine.miner.working", new Object[0]));
                } else if (!syncer.syncBoolean(this.isWorkingEnabled())) {
                    list.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.work_paused", new Object[0]));
                }
            }
        });
    }

    @Override
    protected void configureErrorText(MultiblockUIBuilder builder) {
        super.configureErrorText(builder);
        builder.addCustom((list, syncer) -> {
            if (this.isStructureFormed() && syncer.syncBoolean(() -> !this.drainFluid(false))) {
                list.add((IDrawable)KeyUtil.lang(TextFormatting.RED, "gregtech.machine.miner.multi.needsfluid", new Object[0]));
            }
        });
    }

    @Override
    protected void configureWarningText(MultiblockUIBuilder builder) {
        boolean lowPower = false;
        if (this.isStructureFormed() && !this.getWorld().field_72995_K) {
            lowPower = !this.drainEnergy(true);
        }
        builder.addLowPowerLine(lowPower).addCustom((list, syncer) -> {
            if (this.isStructureFormed() && syncer.syncBoolean(this.isInventoryFull)) {
                list.add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.machine.miner.invfull", new Object[0]));
            }
        });
        super.configureWarningText(builder);
    }

    public IBlockState getCasingState() {
        if (this.material.equals(Materials.Titanium)) {
            return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE);
        }
        if (this.material.equals(Materials.TungstenSteel)) {
            return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST);
        }
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    @NotNull
    private TraceabilityPredicate getFramePredicate() {
        if (this.material.equals(Materials.Titanium)) {
            return MetaTileEntityLargeMiner.frames(Materials.Titanium);
        }
        if (this.material.equals(Materials.TungstenSteel)) {
            return MetaTileEntityLargeMiner.frames(Materials.TungstenSteel);
        }
        return MetaTileEntityLargeMiner.frames(Materials.Steel);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (this.material.equals(Materials.Titanium)) {
            return Textures.STABLE_TITANIUM_CASING;
        }
        if (this.material.equals(Materials.TungstenSteel)) {
            return Textures.ROBUST_TUNGSTENSTEEL_CASING;
        }
        return Textures.SOLID_STEEL_CASING;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("chunkMode", (NBTBase)new NBTTagInt(this.chunkMode ? 1 : 0));
        data.func_74782_a("silkTouch", (NBTBase)new NBTTagInt(this.silkTouch ? 1 : 0));
        return this.minerLogic.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.chunkMode = data.func_74762_e("chunkMode") != 0;
        this.silkTouch = data.func_74762_e("silkTouch") != 0;
        this.minerLogic.readFromNBT(data);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.minerLogic.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.minerLogic.receiveInitialSyncData(buf);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        this.minerLogic.receiveCustomData(dataId, buf);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        if (this.tier == 5) {
            return Textures.LARGE_MINER_OVERLAY_ADVANCED;
        }
        if (this.tier == 6) {
            return Textures.LARGE_MINER_OVERLAY_ADVANCED_2;
        }
        return Textures.LARGE_MINER_OVERLAY_BASIC;
    }

    public long getMaxVoltage() {
        return GTValues.V[GTUtility.getTierByVoltage(this.energyContainer.getInputVoltage())];
    }

    private int getCurrentMode() {
        if (!this.minerLogic.isChunkMode() && !this.minerLogic.isSilkTouchMode()) {
            return 0;
        }
        if (this.minerLogic.isChunkMode() && !this.minerLogic.isSilkTouchMode()) {
            return 1;
        }
        if (!this.minerLogic.isChunkMode() && this.minerLogic.isSilkTouchMode()) {
            return 2;
        }
        return 3;
    }

    private void setCurrentMode(int mode) {
        switch (mode) {
            case 0: {
                this.minerLogic.setChunkMode(false);
                this.minerLogic.setSilkTouchMode(false);
                break;
            }
            case 1: {
                this.minerLogic.setChunkMode(true);
                this.minerLogic.setSilkTouchMode(false);
                break;
            }
            case 2: {
                this.minerLogic.setChunkMode(false);
                this.minerLogic.setSilkTouchMode(true);
                break;
            }
            default: {
                this.minerLogic.setChunkMode(true);
                this.minerLogic.setSilkTouchMode(true);
            }
        }
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.getWorld().field_72995_K || !this.isStructureFormed()) {
            return true;
        }
        if (!this.isActive()) {
            int currentRadius = this.minerLogic.getCurrentRadius();
            if (this.minerLogic.isChunkMode()) {
                if (currentRadius - 16 <= 0) {
                    this.minerLogic.setCurrentRadius(this.minerLogic.getMaximumRadius());
                } else {
                    this.minerLogic.setCurrentRadius(currentRadius - 16);
                }
                int workingAreaChunks = this.minerLogic.getCurrentRadius() * 2 / 16;
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.working_area_chunks", new Object[]{workingAreaChunks, workingAreaChunks}));
            } else {
                if (currentRadius - 8 <= 0) {
                    this.minerLogic.setCurrentRadius(this.minerLogic.getMaximumRadius());
                } else {
                    this.minerLogic.setCurrentRadius(currentRadius - 8);
                }
                int workingArea = this.getWorkingArea(this.minerLogic.getCurrentRadius());
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.universal.tooltip.working_area", new Object[]{workingArea, workingArea}));
            }
            this.minerLogic.resetArea();
        } else {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.errorradius", new Object[0]));
        }
        return true;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return false;
    }

    @Override
    public boolean isInventoryFull() {
        return this.isInventoryFull;
    }

    @Override
    public void setInventoryFull(boolean isFull) {
        this.isInventoryFull = isFull;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getTier() {
        return this.tier;
    }

    public int getDrillingFluidConsumePerTick() {
        return this.drillingFluidConsumePerTick;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.minerLogic.isWorkingEnabled();
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.minerLogic.setWorkingEnabled(isActivationAllowed);
    }

    public int getMaxChunkRadius() {
        return this.minerLogic.getMaximumRadius() / 16;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public IItemHandlerModifiable getExportItems() {
        return this.outputInventory;
    }

    @Override
    public SoundEvent getSound() {
        return GTSoundEvents.MINER;
    }

    @Override
    public boolean isActive() {
        return this.minerLogic.isActive() && this.isWorkingEnabled();
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        int workingArea = this.getWorkingArea(this.minerLogic.getCurrentRadius());
        return Collections.singletonList(new TextComponentTranslation("gregtech.machine.miner.working_area", new Object[]{workingArea, workingArea}));
    }

    @Override
    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    public boolean allowsExtendedFacing() {
        return false;
    }
}

