/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.drawable.IRichTextBuilder;
import com.cleanroommc.modularui.api.value.IDoubleValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.DynamicDrawable;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.value.sync.DoubleSyncValue;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ProgressWidget;
import com.cleanroommc.modularui.widgets.layout.Grid;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IHPCAComponentHatch;
import gregtech.api.capability.IHPCAComputationProvider;
import gregtech.api.capability.IHPCACoolantProvider;
import gregtech.api.capability.IOpticalComputationProvider;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIFactory;
import gregtech.api.metatileentity.multiblock.ui.TemplateBarBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.function.impl.TimedProgressSupplier;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockComputerCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.core.sound.GTSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.DoubleSupplier;
import java.util.function.UnaryOperator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityHPCA
extends MultiblockWithDisplayBase
implements IOpticalComputationProvider,
IControllable,
ProgressBarMultiblock {
    private static final double IDLE_TEMPERATURE = 200.0;
    private static final double DAMAGE_TEMPERATURE = 1000.0;
    private IEnergyContainer energyContainer = new EnergyContainerList(new ArrayList<IEnergyContainer>());
    private IFluidHandler coolantHandler;
    private final HPCAGridHandler hpcaHandler;
    private boolean isActive;
    private boolean isWorkingEnabled = true;
    private boolean hasNotEnoughEnergy;
    private double temperature = 200.0;
    private final TimedProgressSupplier progressSupplier = new TimedProgressSupplier(200, 47, false);

    public MetaTileEntityHPCA(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        this.hpcaHandler = new HPCAGridHandler(this);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityHPCA(this.metaTileEntityId);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.energyContainer = new EnergyContainerList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        this.coolantHandler = new FluidTankList(false, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.hpcaHandler.onStructureForm(this.getAbilities(MultiblockAbility.HPCA_COMPONENT));
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.energyContainer = new EnergyContainerList(new ArrayList<IEnergyContainer>());
        this.hpcaHandler.onStructureInvalidate();
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isActive() && this.isWorkingEnabled() && !this.hasNotEnoughEnergy ? this.hpcaHandler.allocateCWUt(cwut, simulate) : 0;
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isActive() && this.isWorkingEnabled() ? this.hpcaHandler.getMaxCWUt() : 0;
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return !this.isStructureFormed() || this.hpcaHandler.hasHPCABridge();
    }

    @Override
    public void update() {
        super.update();
        if (this.getWorld().field_72995_K) {
            if (this.isStructureFormed()) {
                this.hpcaHandler.tryGatherClientComponents(this.getWorld(), this.getPos(), this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
            } else {
                this.hpcaHandler.clearClientComponents();
            }
        }
    }

    @Override
    protected void updateFormedValid() {
        if (this.isWorkingEnabled()) {
            this.consumeEnergy();
        }
        if (this.isActive()) {
            double midpoint = 400.0;
            double temperatureChange = this.hpcaHandler.calculateTemperatureChange(this.coolantHandler, this.temperature >= midpoint) / 2.0;
            this.temperature = this.temperature + temperatureChange <= 200.0 ? 200.0 : (this.temperature += temperatureChange);
            if (this.temperature >= 1000.0) {
                this.hpcaHandler.attemptDamageHPCA();
            }
            this.hpcaHandler.tick();
        } else {
            this.hpcaHandler.clearComputationCache();
            this.temperature = Math.max(200.0, this.temperature - 0.25);
        }
    }

    private void consumeEnergy() {
        boolean hasMaintenance;
        long energyToConsume = this.hpcaHandler.getCurrentEUt();
        boolean bl = hasMaintenance = ConfigHolder.machines.enableMaintenance && this.hasMaintenanceMechanics();
        if (hasMaintenance) {
            energyToConsume += (long)this.getNumMaintenanceProblems() * energyToConsume / 10L;
        }
        if (this.hasNotEnoughEnergy && this.energyContainer.getInputPerSec() > 19L * energyToConsume) {
            this.hasNotEnoughEnergy = false;
        }
        if (this.energyContainer.getEnergyStored() >= energyToConsume) {
            if (!this.hasNotEnoughEnergy) {
                long consumed = this.energyContainer.removeEnergy(energyToConsume);
                if (consumed == -energyToConsume) {
                    this.setActive(true);
                } else {
                    this.hasNotEnoughEnergy = true;
                    this.setActive(false);
                }
            }
        } else {
            this.hasNotEnoughEnergy = true;
            this.setActive(false);
        }
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("AA", "CC", "CC", "CC", "AA").aisle("VA", "XV", "XV", "XV", "VA").aisle("VA", "XV", "XV", "XV", "VA").aisle("VA", "XV", "XV", "XV", "VA").aisle("SA", "CC", "CC", "CC", "AA").where('S', this.selfPredicate()).where('A', MetaTileEntityHPCA.states(MetaTileEntityHPCA.getAdvancedState())).where('V', MetaTileEntityHPCA.states(MetaTileEntityHPCA.getVentState())).where('X', MetaTileEntityHPCA.abilities(MultiblockAbility.HPCA_COMPONENT)).where('C', MetaTileEntityHPCA.states(MetaTileEntityHPCA.getCasingState()).setMinGlobalLimited(5).or(this.maintenancePredicate()).or(MetaTileEntityHPCA.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1)).or(MetaTileEntityHPCA.abilities(MultiblockAbility.IMPORT_FLUIDS).setMaxGlobalLimited(1)).or(MetaTileEntityHPCA.abilities(MultiblockAbility.COMPUTATION_DATA_TRANSMISSION).setExactLimit(1))).build();
    }

    @NotNull
    private static IBlockState getCasingState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.COMPUTER_CASING);
    }

    @NotNull
    private static IBlockState getAdvancedState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.ADVANCED_COMPUTER_CASING);
    }

    @NotNull
    private static IBlockState getVentState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.COMPUTER_HEAT_VENT);
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder(RelativeDirection.RIGHT, RelativeDirection.DOWN, RelativeDirection.FRONT).aisle("AA", "EC", "MC", "HC", "AA").aisle("VA", "6V", "3V", "0V", "VA").aisle("VA", "7V", "4V", "1V", "VA").aisle("VA", "8V", "5V", "2V", "VA").aisle("SA", "CC", "CC", "OC", "AA").where('S', MetaTileEntities.HIGH_PERFORMANCE_COMPUTING_ARRAY, EnumFacing.SOUTH).where('A', MetaTileEntityHPCA.getAdvancedState()).where('V', MetaTileEntityHPCA.getVentState()).where('C', MetaTileEntityHPCA.getCasingState()).where('E', MetaTileEntities.ENERGY_INPUT_HATCH[6], EnumFacing.NORTH).where('H', MetaTileEntities.FLUID_IMPORT_HATCH[1], EnumFacing.NORTH).where('O', MetaTileEntities.COMPUTATION_HATCH_TRANSMITTER, EnumFacing.SOUTH).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : MetaTileEntityHPCA.getCasingState(), EnumFacing.NORTH);
        shapeInfo.add(builder.shallowCopy().where('0', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).where('1', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('2', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).where('3', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).where('4', MetaTileEntities.HPCA_COMPUTATION_COMPONENT, EnumFacing.WEST).where('5', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).where('6', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).where('7', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('8', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).build());
        shapeInfo.add(builder.shallowCopy().where('0', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('1', MetaTileEntities.HPCA_COMPUTATION_COMPONENT, EnumFacing.WEST).where('2', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('3', MetaTileEntities.HPCA_ACTIVE_COOLER_COMPONENT, EnumFacing.WEST).where('4', MetaTileEntities.HPCA_COMPUTATION_COMPONENT, EnumFacing.WEST).where('5', MetaTileEntities.HPCA_BRIDGE_COMPONENT, EnumFacing.WEST).where('6', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('7', MetaTileEntities.HPCA_COMPUTATION_COMPONENT, EnumFacing.WEST).where('8', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).build());
        shapeInfo.add(builder.shallowCopy().where('0', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('1', MetaTileEntities.HPCA_COMPUTATION_COMPONENT, EnumFacing.WEST).where('2', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('3', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('4', MetaTileEntities.HPCA_ADVANCED_COMPUTATION_COMPONENT, EnumFacing.WEST).where('5', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('6', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('7', MetaTileEntities.HPCA_BRIDGE_COMPONENT, EnumFacing.WEST).where('8', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).build());
        shapeInfo.add(builder.shallowCopy().where('0', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('1', MetaTileEntities.HPCA_ADVANCED_COMPUTATION_COMPONENT, EnumFacing.WEST).where('2', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('3', MetaTileEntities.HPCA_ACTIVE_COOLER_COMPONENT, EnumFacing.WEST).where('4', MetaTileEntities.HPCA_BRIDGE_COMPONENT, EnumFacing.WEST).where('5', MetaTileEntities.HPCA_ACTIVE_COOLER_COMPONENT, EnumFacing.WEST).where('6', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('7', MetaTileEntities.HPCA_ADVANCED_COMPUTATION_COMPONENT, EnumFacing.WEST).where('8', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).build());
        return shapeInfo;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (sourcePart == null) {
            return Textures.ADVANCED_COMPUTER_CASING;
        }
        return Textures.COMPUTER_CASING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.HPCA_OVERLAY;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.isWorkingEnabled());
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.isActive;
    }

    public void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.markDirty();
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, buf -> buf.writeBoolean(active));
            }
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (this.isWorkingEnabled != isWorkingAllowed) {
            this.isWorkingEnabled = isWorkingAllowed;
            this.markDirty();
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(this.isWorkingEnabled));
            }
        }
    }

    @Override
    protected MultiblockUIFactory createUIFactory() {
        return super.createUIFactory().addScreenChildren((parent, syncManager) -> {
            MultiblockUIBuilder builder = MultiblockUIFactory.builder("hpca_tooltip", syncManager);
            builder.setAction(b -> b.addCustom(this.hpcaHandler::addInfo));
            parent.child((IWidget)((ParentWidget)((ParentWidget)((ParentWidget)((ParentWidget)new ParentWidget().leftRel(0.5f)).bottom(5)).size(50)).child((IWidget)((ProgressWidget)new ProgressWidget().sizeRel(1.0f)).value((IDoubleValue)new DoubleSyncValue((DoubleSupplier)this.progressSupplier)).texture(GTGuiTextures.HPCA_COMPONENT_OUTLINE, 47).direction(ProgressWidget.Direction.LEFT).tooltipAutoUpdate(true))).child((IWidget)((Grid)((Grid)new Grid().sizeRel(1.0f)).padding(1)).mapTo(3, 9, value -> (Widget)((Widget)((Widget)((Widget)new Widget().overlay(new IDrawable[]{new DynamicDrawable(() -> this.hpcaHandler.getComponentTexture(value)).asIcon().size(14).marginLeft(2).marginTop(2)}).tooltipAutoUpdate(true)).tooltipBuilder(tooltip -> {
                if (this.isStructureFormed()) {
                    tooltip.addLine((IDrawable)this.hpcaHandler.getComponentKey(value));
                    tooltip.spaceLine(2);
                }
                builder.build((IRichTextBuilder<?>)tooltip);
            })).size(16)).padding(1))));
        });
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.setWorkingStatus(true, this.hpcaHandler.getAllocatedCWUt() > 0).setWorkingStatusKeys("gregtech.multiblock.idling", "gregtech.multiblock.idling", "gregtech.multiblock.data_bank.providing").addCustom((manager, syncer) -> {
            if (!this.isStructureFormed()) {
                return;
            }
            String voltageName = syncer.syncString(GTValues.VNF[GTUtility.getTierByVoltage(this.hpcaHandler.getMaxEUt())]);
            manager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.hpca.energy", KeyUtil.number(syncer.syncLong(this.hpcaHandler.cachedEUt)), KeyUtil.number(syncer.syncLong(this.hpcaHandler.getMaxEUt())), IKey.str((String)voltageName)));
            manager.add((IDrawable)KeyUtil.lang("gregtech.multiblock.hpca.computation", syncer.syncInt(this.hpcaHandler.cachedCWUt), syncer.syncInt(this.hpcaHandler.getMaxCWUt())));
        }).addWorkingStatusLine();
    }

    @Override
    protected void configureWarningText(MultiblockUIBuilder builder) {
        builder.addLowPowerLine(this.hasNotEnoughEnergy).addCustom((manager, syncer) -> {
            if (!this.isStructureFormed()) {
                return;
            }
            if (syncer.syncDouble(this.temperature) > 500.0) {
                manager.add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.hpca.warning_temperature", new Object[0]));
                manager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.hpca.warning_temperature_active_cool", new Object[0]));
            }
            this.hpcaHandler.addWarnings((KeyManager)manager, (UISyncer)syncer);
        });
        super.configureWarningText(builder);
    }

    @Override
    protected void configureErrorText(MultiblockUIBuilder builder) {
        super.configureErrorText(builder);
        builder.addCustom((manager, syncer) -> {
            if (!this.isStructureFormed()) {
                return;
            }
            if (syncer.syncDouble(this.temperature) > 1000.0) {
                manager.add((IDrawable)KeyUtil.lang(TextFormatting.RED, "gregtech.multiblock.hpca.error_temperature", new Object[0]));
            }
            this.hpcaHandler.addErrors((KeyManager)manager, (UISyncer)syncer);
        });
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.high_performance_computing_array.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.high_performance_computing_array.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.high_performance_computing_array.tooltip.3", (Object[])new Object[0]));
    }

    @Override
    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SoundEvent getSound() {
        return GTSoundEvents.COMPUTATION;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("isActive", this.isActive);
        data.func_74757_a("isWorkingEnabled", this.isWorkingEnabled);
        data.func_74780_a("temperature", this.temperature);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isActive = data.func_74767_n("isActive");
        this.isWorkingEnabled = data.func_74767_n("isWorkingEnabled");
        this.temperature = data.func_74769_h("temperature");
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.isWorkingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
        this.isWorkingEnabled = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.CACHED_CWU) {
            this.hpcaHandler.cachedCWUt = buf.readInt();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int getProgressBarCount() {
        return 2;
    }

    @Override
    public void registerBars(List<UnaryOperator<TemplateBarBuilder>> bars, PanelSyncManager syncManager) {
        IntSyncValue currentCWUtValue = new IntSyncValue(() -> this.hpcaHandler.cachedCWUt);
        IntSyncValue maxCWUtValue = new IntSyncValue(this.hpcaHandler::getMaxCWUt);
        syncManager.syncValue("current_cwut", (SyncHandler)currentCWUtValue);
        syncManager.syncValue("max_cwut", (SyncHandler)maxCWUtValue);
        DoubleSyncValue temperatureValue = new DoubleSyncValue(() -> this.temperature);
        syncManager.syncValue("temperature", (SyncHandler)temperatureValue);
        bars.add(barTest -> barTest.progress(() -> 1.0 * (double)currentCWUtValue.getIntValue() / (double)maxCWUtValue.getIntValue()).texture(GTGuiTextures.PROGRESS_BAR_HPCA_COMPUTATION).tooltipBuilder(t -> {
            if (this.isStructureFormed()) {
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.hpca.computation", (Object[])new Object[]{currentCWUtValue.getIntValue(), maxCWUtValue.getIntValue()}));
            } else {
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.invalid_structure"));
            }
        }));
        bars.add(barTest -> barTest.progress(() -> Math.min(1.0, temperatureValue.getDoubleValue() / 1000.0)).texture(GTGuiTextures.PROGRESS_BAR_FUSION_HEAT).tooltipBuilder(t -> {
            if (this.isStructureFormed()) {
                double temp = temperatureValue.getDoubleValue();
                int degrees = (int)Math.round(temp / 10.0);
                TextFormatting color = temp < 500.0 ? TextFormatting.GREEN : (temp < 750.0 ? TextFormatting.YELLOW : TextFormatting.RED);
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.hpca.temperature", (Object[])new Object[]{degrees}).style(color));
            } else {
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.invalid_structure"));
            }
        }));
    }

    public static class HPCAGridHandler {
        @Nullable
        private final MetaTileEntityHPCA controller;
        private final List<IHPCAComponentHatch> components = new ObjectArrayList();
        private final Set<IHPCACoolantProvider> coolantProviders = new ObjectOpenHashSet();
        private final Set<IHPCAComputationProvider> computationProviders = new ObjectOpenHashSet();
        private int numBridges;
        private int allocatedCWUt;
        private long cachedEUt;
        private int cachedCWUt;

        public HPCAGridHandler(@Nullable MetaTileEntityHPCA controller) {
            this.controller = controller;
        }

        public void onStructureForm(Collection<IHPCAComponentHatch> components) {
            this.reset();
            for (IHPCAComponentHatch component : components) {
                this.components.add(component);
                if (component instanceof IHPCACoolantProvider) {
                    IHPCACoolantProvider coolantProvider = (IHPCACoolantProvider)component;
                    this.coolantProviders.add(coolantProvider);
                }
                if (component instanceof IHPCAComputationProvider) {
                    IHPCAComputationProvider computationProvider = (IHPCAComputationProvider)component;
                    this.computationProviders.add(computationProvider);
                }
                if (!component.isBridge()) continue;
                ++this.numBridges;
            }
        }

        private void onStructureInvalidate() {
            this.reset();
        }

        private void reset() {
            this.clearComputationCache();
            this.components.clear();
            this.coolantProviders.clear();
            this.computationProviders.clear();
            this.numBridges = 0;
        }

        private void clearComputationCache() {
            this.allocatedCWUt = 0;
        }

        public void tick() {
            if (this.cachedCWUt != this.allocatedCWUt) {
                this.cachedCWUt = this.allocatedCWUt;
                if (this.controller != null) {
                    this.controller.writeCustomData(GregtechDataCodes.CACHED_CWU, buf -> buf.writeInt(this.cachedCWUt));
                }
            }
            this.cachedEUt = this.getCurrentEUt();
            if (this.allocatedCWUt != 0) {
                this.allocatedCWUt = 0;
            }
        }

        public double calculateTemperatureChange(IFluidHandler coolantTank, boolean forceCoolWithActive) {
            double temperatureToDecrease;
            int coolantToDrain;
            FluidStack coolantStack;
            int maxCWUt = Math.max(1, this.getMaxCWUt());
            int maxCoolingDemand = this.getMaxCoolingDemand();
            int temperatureIncrease = (int)Math.round(1.0 * (double)maxCoolingDemand * (double)this.allocatedCWUt / (double)maxCWUt);
            int maxPassiveCooling = 0;
            int maxActiveCooling = 0;
            int maxCoolantDrain = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                if (coolantProvider.isActiveCooler()) {
                    maxActiveCooling += coolantProvider.getCoolingAmount();
                    maxCoolantDrain += coolantProvider.getMaxCoolantPerTick();
                    continue;
                }
                maxPassiveCooling += coolantProvider.getCoolingAmount();
            }
            double temperatureChange = temperatureIncrease - maxPassiveCooling;
            if (maxActiveCooling == 0 && maxCoolantDrain == 0) {
                return temperatureChange;
            }
            if (forceCoolWithActive || (double)maxActiveCooling <= temperatureChange) {
                FluidStack coolantStack2 = coolantTank.drain(this.getCoolantStack(maxCoolantDrain), true);
                if (coolantStack2 != null) {
                    int coolantDrained = coolantStack2.amount;
                    temperatureChange = coolantDrained == maxCoolantDrain ? (temperatureChange -= (double)maxActiveCooling) : (temperatureChange -= (double)maxActiveCooling * (1.0 * (double)coolantDrained / (double)maxCoolantDrain));
                }
            } else if (temperatureChange > 0.0 && (coolantStack = coolantTank.drain(this.getCoolantStack(coolantToDrain = Math.max(1, (int)((double)maxCoolantDrain * ((temperatureToDecrease = Math.min(temperatureChange, (double)maxActiveCooling)) / (double)maxActiveCooling)))), true)) != null) {
                int coolantDrained = coolantStack.amount;
                if (coolantDrained == coolantToDrain) {
                    return 0.0;
                }
                temperatureChange -= temperatureToDecrease * (1.0 * (double)coolantDrained / (double)coolantToDrain);
            }
            return temperatureChange;
        }

        public FluidStack getCoolantStack(int amount) {
            return new FluidStack(this.getCoolant(), amount);
        }

        private Fluid getCoolant() {
            return Materials.PCBCoolant.getFluid();
        }

        public void attemptDamageHPCA() {
            if (GTValues.RNG.nextInt(200) == 0) {
                ArrayList<IHPCAComponentHatch> candidates = new ArrayList<IHPCAComponentHatch>();
                for (IHPCAComponentHatch component : this.components) {
                    if (!component.canBeDamaged()) continue;
                    candidates.add(component);
                }
                if (!candidates.isEmpty()) {
                    ((IHPCAComponentHatch)candidates.get(GTValues.RNG.nextInt(candidates.size()))).setDamaged(true);
                }
            }
        }

        public int allocateCWUt(int cwut, boolean simulate) {
            int maxCWUt = this.getMaxCWUt();
            int availableCWUt = maxCWUt - this.allocatedCWUt;
            int toAllocate = Math.min(cwut, availableCWUt);
            if (!simulate) {
                this.allocatedCWUt += toAllocate;
            }
            return toAllocate;
        }

        public int getAllocatedCWUt() {
            return this.allocatedCWUt;
        }

        public int getMaxCWUt() {
            int maxCWUt = 0;
            for (IHPCAComputationProvider computationProvider : this.computationProviders) {
                maxCWUt += computationProvider.getCWUPerTick();
            }
            return maxCWUt;
        }

        public long getCurrentEUt() {
            long upkeepEUt;
            int maximumCWUt = Math.max(1, this.getMaxCWUt());
            long maximumEUt = this.getMaxEUt();
            if (maximumEUt == (upkeepEUt = this.getUpkeepEUt())) {
                return maximumEUt;
            }
            return upkeepEUt + (maximumEUt - upkeepEUt) * (long)this.allocatedCWUt / (long)maximumCWUt;
        }

        public long getUpkeepEUt() {
            long upkeepEUt = 0L;
            for (IHPCAComponentHatch component : this.components) {
                upkeepEUt += (long)component.getUpkeepEUt();
            }
            return upkeepEUt;
        }

        public long getMaxEUt() {
            long maximumEUt = 0L;
            for (IHPCAComponentHatch component : this.components) {
                maximumEUt += (long)component.getMaxEUt();
            }
            return maximumEUt;
        }

        public boolean hasHPCABridge() {
            return this.numBridges > 0;
        }

        public boolean hasActiveCoolers() {
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                if (!coolantProvider.isActiveCooler()) continue;
                return true;
            }
            return false;
        }

        public int getMaxCoolingAmount() {
            int maxCooling = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                maxCooling += coolantProvider.getCoolingAmount();
            }
            return maxCooling;
        }

        public int getMaxCoolingDemand() {
            int maxCooling = 0;
            for (IHPCAComputationProvider computationProvider : this.computationProviders) {
                maxCooling += computationProvider.getCoolingPerTick();
            }
            return maxCooling;
        }

        public int getMaxCoolantDemand() {
            int maxCoolant = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                maxCoolant += coolantProvider.getMaxCoolantPerTick();
            }
            return maxCoolant;
        }

        public void addInfo(KeyManager manager, UISyncer syncer) {
            IKey data = KeyUtil.number(TextFormatting.AQUA, (long)syncer.syncInt(this.getMaxCWUt()));
            manager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.hpca.info_max_computation", data));
            int coolingAmt = syncer.syncInt(this.getMaxCoolingAmount());
            int coolingDemand = syncer.syncInt(this.getMaxCoolingDemand());
            int coolantNeeded = syncer.syncInt(this.getMaxCoolantDemand());
            TextFormatting coolingColor = coolingAmt < coolingDemand ? TextFormatting.RED : TextFormatting.GREEN;
            data = KeyUtil.number(coolingColor, (long)coolingDemand);
            manager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.hpca.info_max_cooling_demand", data));
            data = KeyUtil.number(coolingColor, (long)coolingAmt);
            manager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.hpca.info_max_cooling_available", data));
            if (coolantNeeded > 0) {
                data = KeyUtil.number(TextFormatting.YELLOW, (long)coolantNeeded, "L ");
                IKey coolantName = KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.hpca.info_coolant_name", new Object[0]);
                data = IKey.comp((IKey[])new IKey[]{data, coolantName});
            } else {
                data = KeyUtil.string(TextFormatting.GREEN, "0");
            }
            manager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.hpca.info_max_coolant_required", data));
            if (syncer.syncInt(this.numBridges) > 0) {
                manager.add((IDrawable)KeyUtil.lang(TextFormatting.GREEN, "gregtech.multiblock.hpca.info_bridging_enabled", new Object[0]));
            } else {
                manager.add((IDrawable)KeyUtil.lang(TextFormatting.RED, "gregtech.multiblock.hpca.info_bridging_disabled", new Object[0]));
            }
        }

        public void addWarnings(KeyManager keyManager, UISyncer syncer) {
            ArrayList<IKey> warnings = new ArrayList<IKey>();
            if (syncer.syncInt(this.numBridges) > 1) {
                warnings.add(KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.hpca.warning_multiple_bridges", new Object[0]));
            }
            if (syncer.syncBoolean(this.computationProviders.isEmpty())) {
                warnings.add(KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.hpca.warning_no_computation", new Object[0]));
            }
            if (syncer.syncBoolean(this.getMaxCoolingDemand() > this.getMaxCoolingAmount())) {
                warnings.add(KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.hpca.warning_low_cooling", new Object[0]));
            }
            if (!warnings.isEmpty()) {
                keyManager.add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.hpca.warning_structure_header", new Object[0]));
                keyManager.addAll(warnings);
            }
        }

        public void addErrors(KeyManager keyManager, UISyncer syncer) {
            for (IHPCAComponentHatch component : this.components) {
                if (!syncer.syncBoolean(component.isDamaged())) continue;
                keyManager.add((IDrawable)KeyUtil.lang(TextFormatting.RED, "gregtech.multiblock.hpca.error_damaged", new Object[0]));
                return;
            }
        }

        public UITexture getComponentTexture(int index) {
            if (this.components.size() <= index) {
                return GTGuiTextures.BLANK_TRANSPARENT;
            }
            return this.components.get(index).getComponentIcon();
        }

        public IKey getComponentKey(int index) {
            if (this.components.size() <= index) {
                return IKey.EMPTY;
            }
            return IKey.lang((String)this.components.get(index).getTileName());
        }

        public void tryGatherClientComponents(World world, BlockPos pos, EnumFacing frontFacing, EnumFacing upwardsFacing, boolean flip) {
            EnumFacing relativeUp = RelativeDirection.UP.getRelativeFacing(frontFacing, upwardsFacing, flip);
            if (this.components.isEmpty()) {
                BlockPos testPos = pos.func_177967_a(frontFacing.func_176734_d(), 3).func_177967_a(relativeUp, 3);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        IGregTechTileEntity igtte;
                        MetaTileEntity mte;
                        BlockPos tempPos = testPos.func_177967_a(frontFacing, j).func_177967_a(relativeUp.func_176734_d(), i);
                        TileEntity te = world.func_175625_s(tempPos);
                        if (te instanceof IHPCAComponentHatch) {
                            IHPCAComponentHatch hatch = (IHPCAComponentHatch)te;
                            this.components.add(hatch);
                            continue;
                        }
                        if (!(te instanceof IGregTechTileEntity) || !((mte = (igtte = (IGregTechTileEntity)te).getMetaTileEntity()) instanceof IHPCAComponentHatch)) continue;
                        IHPCAComponentHatch hatch = (IHPCAComponentHatch)((Object)mte);
                        this.components.add(hatch);
                    }
                }
            }
        }

        public void clearClientComponents() {
            this.components.clear();
        }
    }
}

