/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IDoubleValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.value.sync.DoubleSyncValue;
import com.cleanroommc.modularui.value.sync.LongSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ProgressWidget;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.google.common.collect.Lists;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.ProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIFactory;
import gregtech.api.metatileentity.multiblock.ui.TemplateBarBuilder;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.logic.OCParams;
import gregtech.api.recipes.properties.RecipePropertyStorage;
import gregtech.api.recipes.properties.impl.FusionEUToStartProperty;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.interpolate.Eases;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.IRenderSetup;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.shader.postprocessing.BloomEffect;
import gregtech.client.shader.postprocessing.BloomType;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.EffectRenderContext;
import gregtech.client.utils.IBloomEffect;
import gregtech.client.utils.RenderBufferHelper;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockFusionCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityFusionReactor
extends RecipeMapMultiblockController
implements IFastRenderMetaTileEntity,
IBloomEffect,
ProgressBarMultiblock {
    protected static final int NO_COLOR = 0;
    private final int tier;
    private EnergyContainerList inputEnergyContainers;
    private long heat = 0L;
    private int fusionRingColor = 0;
    @SideOnly(value=Side.CLIENT)
    private boolean registeredBloomRenderTicket;

    public MetaTileEntityFusionReactor(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, RecipeMaps.FUSION_RECIPES);
        this.recipeMapWorkable = new FusionRecipeLogic(this);
        this.tier = tier;
        this.energyContainer = new EnergyContainerHandler(this, 0L, 0L, 0L, 0L, 0L){

            @Override
            @NotNull
            public String getName() {
                return "EnergyContainerInternal";
            }
        };
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityFusionReactor(this.metaTileEntityId, this.tier);
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("###############", "######OGO######", "###############").aisle("######ICI######", "####GGAAAGG####", "######ICI######").aisle("####CC###CC####", "###EAAOGOAAE###", "####CC###CC####").aisle("###C#######C###", "##EKEG###GEKE##", "###C#######C###").aisle("##C#########C##", "#GAE#######EAG#", "##C#########C##").aisle("##C#########C##", "#GAG#######GAG#", "##C#########C##").aisle("#I###########I#", "OAO#########OAO", "#I###########I#").aisle("#C###########C#", "GAG#########GAG", "#C###########C#").aisle("#I###########I#", "OAO#########OAO", "#I###########I#").aisle("##C#########C##", "#GAG#######GAG#", "##C#########C##").aisle("##C#########C##", "#GAE#######EAG#", "##C#########C##").aisle("###C#######C###", "##EKEG###GEKE##", "###C#######C###").aisle("####CC###CC####", "###EAAOGOAAE###", "####CC###CC####").aisle("######ICI######", "####GGAAAGG####", "######ICI######").aisle("###############", "######OSO######", "###############").where('S', this.selfPredicate()).where('G', MetaTileEntityFusionReactor.states(this.getCasingState(), this.getGlassState())).where('E', MetaTileEntityFusionReactor.states(this.getCasingState(), this.getGlassState()).or(MetaTileEntityFusionReactor.metaTileEntities((MetaTileEntity[])Arrays.stream(MetaTileEntities.ENERGY_INPUT_HATCH).filter(mte -> mte != null && this.tier <= mte.getTier() && mte.getTier() <= 8).toArray(MetaTileEntity[]::new)).setMinGlobalLimited(1).setPreviewCount(16))).where('C', MetaTileEntityFusionReactor.states(this.getCasingState())).where('K', MetaTileEntityFusionReactor.states(this.getCoilState())).where('O', MetaTileEntityFusionReactor.states(this.getCasingState(), this.getGlassState()).or(MetaTileEntityFusionReactor.abilities(MultiblockAbility.EXPORT_FLUIDS))).where('A', MetaTileEntityFusionReactor.air()).where('I', MetaTileEntityFusionReactor.states(this.getCasingState()).or(MetaTileEntityFusionReactor.abilities(MultiblockAbility.IMPORT_FLUIDS).setMinGlobalLimited(2))).where('#', MetaTileEntityFusionReactor.any()).build();
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfos = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder baseBuilder = MultiblockShapeInfo.builder(RelativeDirection.RIGHT, RelativeDirection.DOWN, RelativeDirection.FRONT).aisle("###############", "######WGW######", "###############").aisle("######DCD######", "####GG###GG####", "######UCU######").aisle("####CC###CC####", "###w##EGE##s###", "####CC###CC####").aisle("###C#######C###", "##nKeG###GeKn##", "###C#######C###").aisle("##C#########C##", "#G#s#######w#G#", "##C#########C##").aisle("##C#########C##", "#G#G#######G#G#", "##C#########C##").aisle("#D###########D#", "N#S#########N#S", "#U###########U#").aisle("#C###########C#", "G#G#########G#G", "#C###########C#").aisle("#D###########D#", "N#S#########N#S", "#U###########U#").aisle("##C#########C##", "#G#G#######G#G#", "##C#########C##").aisle("##C#########C##", "#G#s#######w#G#", "##C#########C##").aisle("###C#######C###", "##eKnG###GnKe##", "###C#######C###").aisle("####CC###CC####", "###w##WGW##s###", "####CC###CC####").aisle("######DCD######", "####GG###GG####", "######UCU######").aisle("###############", "######EME######", "###############").where('M', MetaTileEntities.FUSION_REACTOR[this.tier - 6], EnumFacing.SOUTH).where('C', this.getCasingState()).where('G', MetaBlocks.TRANSPARENT_CASING.getState(BlockGlassCasing.CasingType.FUSION_GLASS)).where('K', this.getCoilState()).where('W', MetaTileEntities.FLUID_EXPORT_HATCH[this.tier], EnumFacing.NORTH).where('E', MetaTileEntities.FLUID_EXPORT_HATCH[this.tier], EnumFacing.SOUTH).where('S', MetaTileEntities.FLUID_EXPORT_HATCH[this.tier], EnumFacing.EAST).where('N', MetaTileEntities.FLUID_EXPORT_HATCH[this.tier], EnumFacing.WEST).where('w', MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.WEST).where('e', MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.SOUTH).where('s', MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.EAST).where('n', MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.NORTH).where('U', MetaTileEntities.FLUID_IMPORT_HATCH[this.tier], EnumFacing.UP).where('D', MetaTileEntities.FLUID_IMPORT_HATCH[this.tier], EnumFacing.DOWN).where('#', Blocks.field_150350_a.func_176223_P());
        shapeInfos.add(baseBuilder.shallowCopy().where('G', this.getCasingState()).build());
        shapeInfos.add(baseBuilder.build());
        return shapeInfos;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (this.recipeMapWorkable.isActive()) {
            return Textures.ACTIVE_FUSION_TEXTURE;
        }
        return Textures.FUSION_TEXTURE;
    }

    private IBlockState getGlassState() {
        return MetaBlocks.TRANSPARENT_CASING.getState(BlockGlassCasing.CasingType.FUSION_GLASS);
    }

    private IBlockState getCasingState() {
        if (this.tier == 6) {
            return MetaBlocks.FUSION_CASING.getState(BlockFusionCasing.CasingType.FUSION_CASING);
        }
        if (this.tier == 7) {
            return MetaBlocks.FUSION_CASING.getState(BlockFusionCasing.CasingType.FUSION_CASING_MK2);
        }
        return MetaBlocks.FUSION_CASING.getState(BlockFusionCasing.CasingType.FUSION_CASING_MK3);
    }

    private IBlockState getCoilState() {
        if (this.tier == 6) {
            return MetaBlocks.FUSION_CASING.getState(BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL);
        }
        return MetaBlocks.FUSION_CASING.getState(BlockFusionCasing.CasingType.FUSION_COIL);
    }

    protected int getFusionRingColor() {
        return this.fusionRingColor;
    }

    protected boolean hasFusionRingColor() {
        return this.fusionRingColor != 0;
    }

    protected void setFusionRingColor(int fusionRingColor) {
        if (this.fusionRingColor != fusionRingColor) {
            this.fusionRingColor = fusionRingColor;
            this.writeCustomData(GregtechDataCodes.UPDATE_COLOR, buf -> buf.func_150787_b(fusionRingColor));
        }
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        long energyStored = this.energyContainer.getEnergyStored();
        super.formStructure(context);
        this.initializeAbilities();
        ((EnergyContainerHandler)this.energyContainer).setEnergyStored(energyStored);
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.energyContainer = new EnergyContainerHandler(this, 0L, 0L, 0L, 0L, 0L){

            @Override
            @NotNull
            public String getName() {
                return "EnergyContainerInternal";
            }
        };
        this.inputEnergyContainers = new EnergyContainerList(Lists.newArrayList());
        this.heat = 0L;
        this.setFusionRingColor(0);
    }

    @Override
    protected void initializeAbilities() {
        super.initializeAbilities();
        List<IEnergyContainer> energyInputs = this.getAbilities(MultiblockAbility.INPUT_ENERGY);
        this.inputEnergyContainers = new EnergyContainerList(energyInputs);
        long euCapacity = this.calculateEnergyStorageFactor(energyInputs.size());
        this.energyContainer = new EnergyContainerHandler(this, euCapacity, GTValues.V[this.tier], 0L, 0L, 0L){

            @Override
            @NotNull
            public String getName() {
                return "EnergyContainerInternal";
            }
        };
    }

    private long calculateEnergyStorageFactor(int energyInputAmount) {
        return (long)energyInputAmount * (long)Math.pow(2.0, this.tier - 6) * 10000000L;
    }

    @Override
    protected void updateFormedValid() {
        long energyAdded;
        if (this.inputEnergyContainers.getEnergyStored() > 0L && (energyAdded = this.energyContainer.addEnergy(this.inputEnergyContainers.getEnergyStored())) > 0L) {
            this.inputEnergyContainers.removeEnergy(energyAdded);
        }
        super.updateFormedValid();
        if (this.recipeMapWorkable.isWorking() && this.fusionRingColor == 0) {
            if (this.recipeMapWorkable.getPreviousRecipe() != null && !this.recipeMapWorkable.getPreviousRecipe().getFluidOutputs().isEmpty()) {
                this.setFusionRingColor(0xFF000000 | this.recipeMapWorkable.getPreviousRecipe().getFluidOutputs().get(0).getFluid().getColor());
            }
        } else if (!this.recipeMapWorkable.isWorking() && this.isStructureFormed()) {
            this.setFusionRingColor(0);
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.fusionRingColor);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.fusionRingColor = buf.func_150792_a();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == GregtechDataCodes.UPDATE_COLOR) {
            this.fusionRingColor = buf.func_150792_a();
        } else {
            super.receiveCustomData(dataId, buf);
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fusion_reactor.capacity", (Object[])new Object[]{this.calculateEnergyStorageFactor(16) / 1000000L}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fusion_reactor.overclocking", (Object[])new Object[0]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.FUSION_REACTOR_OVERLAY;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public long getHeat() {
        return this.heat;
    }

    @Override
    protected MultiblockUIFactory createUIFactory() {
        UITexture title = this.tier == 6 ? GTGuiTextures.FUSION_REACTOR_MK1_TITLE : (this.tier == 7 ? GTGuiTextures.FUSION_REACTOR_MK2_TITLE : GTGuiTextures.FUSION_REACTOR_MK3_TITLE);
        DoubleSyncValue progress = new DoubleSyncValue(this.recipeMapWorkable::getProgressPercent);
        return new MultiblockUIFactory(this).setScreenHeight(138).disableDisplayText().addScreenChildren((arg_0, arg_1) -> this.lambda$createUIFactory$4((IDrawable)title, progress, arg_0, arg_1));
    }

    @Override
    public int getProgressBarCount() {
        return 2;
    }

    @Override
    public void registerBars(List<UnaryOperator<TemplateBarBuilder>> bars, PanelSyncManager syncManager) {
        LongSyncValue capacity = new LongSyncValue(this.energyContainer::getEnergyCapacity);
        syncManager.syncValue("capacity", (SyncHandler)capacity);
        LongSyncValue stored = new LongSyncValue(this.energyContainer::getEnergyStored);
        syncManager.syncValue("stored", (SyncHandler)stored);
        LongSyncValue heat = new LongSyncValue(this::getHeat);
        syncManager.syncValue("heat", (SyncHandler)heat);
        bars.add(barTest -> barTest.progress(() -> capacity.getLongValue() > 0L ? 1.0 * (double)stored.getLongValue() / (double)capacity.getLongValue() : 0.0).texture(GTGuiTextures.PROGRESS_BAR_FUSION_ENERGY).tooltipBuilder(tooltip -> tooltip.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.energy_stored", stored.getLongValue(), capacity.getLongValue()))));
        bars.add(barTest -> barTest.texture(GTGuiTextures.PROGRESS_BAR_FUSION_HEAT).tooltipBuilder(tooltip -> {
            IKey heatInfo = KeyUtil.string(TextFormatting.AQUA, "%,d / %,d EU", heat.getLongValue(), capacity.getLongValue());
            tooltip.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.fusion_reactor.heat", heatInfo));
        }).progress(() -> capacity.getLongValue() > 0L ? 1.0 * (double)heat.getLongValue() / (double)capacity.getLongValue() : 0.0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(double x, double y, double z, float partialTicks) {
        if (this.hasFusionRingColor() && !this.registeredBloomRenderTicket) {
            this.registeredBloomRenderTicket = true;
            BloomEffectUtil.registerBloomRender((IRenderSetup)FusionBloomSetup.INSTANCE, MetaTileEntityFusionReactor.getBloomType(), (IBloomEffect)this, this);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBloomEffect(@NotNull BufferBuilder buffer, @NotNull EffectRenderContext context) {
        if (!this.hasFusionRingColor()) {
            return;
        }
        int color = RenderUtil.interpolateColor(this.getFusionRingColor(), -1, Eases.QUAD_IN.getInterpolation(Math.abs((float)Math.abs(this.getOffsetTimer() % 50L) + context.partialTicks() - 25.0f) / 25.0f));
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        EnumFacing relativeBack = RelativeDirection.BACK.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing.Axis axis = RelativeDirection.UP.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped()).func_176740_k();
        buffer.func_181668_a(8, DefaultVertexFormats.field_181706_f);
        RenderBufferHelper.renderRing(buffer, (double)this.getPos().func_177958_n() - context.cameraX() + (double)(relativeBack.func_82601_c() * 7) + 0.5, (double)this.getPos().func_177956_o() - context.cameraY() + (double)(relativeBack.func_96559_d() * 7) + 0.5, (double)this.getPos().func_177952_p() - context.cameraZ() + (double)(relativeBack.func_82599_e() * 7) + 0.5, 6.0, 0.2, 10, 20, r, g, b, a, axis);
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderBloomEffect(@NotNull EffectRenderContext context) {
        return this.hasFusionRingColor() && context.camera().func_78546_a(this.getRenderBoundingBox());
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        EnumFacing relativeRight = RelativeDirection.RIGHT.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing relativeBack = RelativeDirection.BACK.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        return new AxisAlignedBB(this.getPos().func_177972_a(relativeBack).func_177967_a(relativeRight, 6), this.getPos().func_177967_a(relativeBack, 13).func_177967_a(relativeRight.func_176734_d(), 6));
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    @Override
    public boolean isGlobalRenderer() {
        return true;
    }

    private static BloomType getBloomType() {
        ConfigHolder.FusionBloom fusionBloom = ConfigHolder.client.shader.fusionBloom;
        return BloomType.fromValue(fusionBloom.useShader ? fusionBloom.bloomStyle : -1);
    }

    private /* synthetic */ void lambda$createUIFactory$4(IDrawable title, DoubleSyncValue progress, ParentWidget parent, PanelSyncManager syncManager) {
        MultiblockUIBuilder status = MultiblockUIFactory.builder("status", syncManager);
        status.setAction(b -> b.structureFormed(true).setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addWorkingStatusLine());
        parent.child((IWidget)((Flow)((Flow)((Flow)((Flow)new Column().padding(4)).expanded()).child((IWidget)((Widget)title.asWidget().marginBottom(8)).size(69, 12))).child((IWidget)((ProgressWidget)((ProgressWidget)((ProgressWidget)((ProgressWidget)new ProgressWidget().size(77, 77)).tooltipAutoUpdate(true)).tooltipBuilder(status::build)).background(new IDrawable[]{GTGuiTextures.FUSION_DIAGRAM.asIcon().size(89, 101).marginTop(11)})).direction(ProgressWidget.Direction.CIRCULAR_CW).value((IDoubleValue)progress).texture(null, GTGuiTextures.FUSION_PROGRESS, 77))).child((IWidget)((Widget)((Widget)GTGuiTextures.FUSION_LEGEND.asWidget().left(4)).bottom(4)).size(108, 41)));
    }

    private class FusionRecipeLogic
    extends MultiblockRecipeLogic {
        public FusionRecipeLogic(MetaTileEntityFusionReactor tileEntity) {
            super(tileEntity);
        }

        @Override
        protected double getOverclockingDurationFactor() {
            return 0.5;
        }

        @Override
        protected double getOverclockingVoltageFactor() {
            return 2.0;
        }

        @Override
        public long getMaxVoltage() {
            return Math.min(GTValues.V[MetaTileEntityFusionReactor.this.tier], super.getMaxVoltage());
        }

        @Override
        public void updateWorkable() {
            super.updateWorkable();
            if (MetaTileEntityFusionReactor.this.heat > 0L && (!this.isActive || !this.workingEnabled || this.hasNotEnoughEnergy && this.progressTime == 0)) {
                MetaTileEntityFusionReactor.this.heat = MetaTileEntityFusionReactor.this.heat <= 10000L ? 0L : MetaTileEntityFusionReactor.this.heat - 10000L;
            }
        }

        @Override
        public boolean checkRecipe(@NotNull Recipe recipe) {
            if (!super.checkRecipe(recipe)) {
                return false;
            }
            if (recipe.getProperty(FusionEUToStartProperty.getInstance(), 0L) > MetaTileEntityFusionReactor.this.energyContainer.getEnergyCapacity()) {
                return false;
            }
            long heatDiff = recipe.getProperty(FusionEUToStartProperty.getInstance(), 0L) - MetaTileEntityFusionReactor.this.heat;
            if (heatDiff <= 0L) {
                return true;
            }
            if (MetaTileEntityFusionReactor.this.energyContainer.getEnergyStored() < heatDiff) {
                return false;
            }
            MetaTileEntityFusionReactor.this.energyContainer.removeEnergy(heatDiff);
            MetaTileEntityFusionReactor.this.heat += heatDiff;
            return true;
        }

        @Override
        protected void modifyOverclockPre(@NotNull OCParams ocParams, @NotNull RecipePropertyStorage storage) {
            super.modifyOverclockPre(ocParams, storage);
            long euToStart = storage.get(FusionEUToStartProperty.getInstance(), 0L);
            int fusionTier = FusionEUToStartProperty.getFusionTier(euToStart);
            if (fusionTier != 0) {
                fusionTier = MetaTileEntityFusionReactor.this.tier - fusionTier;
            }
            ocParams.setOcAmount(Math.min(fusionTier, ocParams.ocAmount()));
        }

        @Override
        @NotNull
        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = super.serializeNBT();
            tag.func_74772_a("Heat", MetaTileEntityFusionReactor.this.heat);
            return tag;
        }

        @Override
        public void deserializeNBT(@NotNull NBTTagCompound compound) {
            super.deserializeNBT(compound);
            MetaTileEntityFusionReactor.this.heat = compound.func_74763_f("Heat");
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static final class FusionBloomSetup
    implements IRenderSetup {
        private static final FusionBloomSetup INSTANCE = new FusionBloomSetup();
        float lastBrightnessX;
        float lastBrightnessY;

        private FusionBloomSetup() {
        }

        @Override
        public void preDraw(@NotNull BufferBuilder buffer) {
            BloomEffect.strength = (float)ConfigHolder.client.shader.fusionBloom.strength;
            BloomEffect.baseBrightness = (float)ConfigHolder.client.shader.fusionBloom.baseBrightness;
            BloomEffect.highBrightnessThreshold = (float)ConfigHolder.client.shader.fusionBloom.highBrightnessThreshold;
            BloomEffect.lowBrightnessThreshold = (float)ConfigHolder.client.shader.fusionBloom.lowBrightnessThreshold;
            BloomEffect.step = 1.0f;
            this.lastBrightnessX = OpenGlHelper.lastBrightnessX;
            this.lastBrightnessY = OpenGlHelper.lastBrightnessY;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179090_x();
        }

        @Override
        public void postDraw(@NotNull BufferBuilder buffer) {
            GlStateManager.func_179098_w();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.lastBrightnessX, (float)this.lastBrightnessY);
        }
    }
}

