/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.google.common.collect.Lists;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidDrillLogic;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.TemplateBarBuilder;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityFluidDrill
extends MultiblockWithDisplayBase
implements ITieredMetaTileEntity,
IWorkable,
ProgressBarMultiblock {
    private final FluidDrillLogic minerLogic = new FluidDrillLogic(this);
    private final int tier;
    protected IMultipleTankHandler inputFluidInventory;
    protected IMultipleTankHandler outputFluidInventory;
    protected IEnergyContainer energyContainer;

    public MetaTileEntityFluidDrill(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId);
        this.tier = tier;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityFluidDrill(this.metaTileEntityId, this.tier);
    }

    protected void initializeAbilities() {
        this.inputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.outputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
        this.energyContainer = new EnergyContainerList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
    }

    private void resetTileAbilities() {
        this.inputFluidInventory = new FluidTankList(true, new IFluidTank[0]);
        this.outputFluidInventory = new FluidTankList(true, new IFluidTank[0]);
        this.energyContainer = new EnergyContainerList(Lists.newArrayList());
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
    }

    @Override
    protected void updateFormedValid() {
        this.minerLogic.performDrilling();
        if (!this.getWorld().field_72995_K && this.minerLogic.wasActiveAndNeedsUpdate()) {
            this.minerLogic.setWasActiveAndNeedsUpdate(false);
            this.minerLogic.setActive(false);
        }
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "#F#", "#F#", "#F#", "###", "###", "###").aisle("XXX", "FCF", "FCF", "FCF", "#F#", "#F#", "#F#").aisle("XSX", "#F#", "#F#", "#F#", "###", "###", "###").where('S', this.selfPredicate()).where('X', MetaTileEntityFluidDrill.states(this.getCasingState()).setMinGlobalLimited(3).or(MetaTileEntityFluidDrill.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3)).or(MetaTileEntityFluidDrill.abilities(MultiblockAbility.EXPORT_FLUIDS).setMaxGlobalLimited(1))).where('C', MetaTileEntityFluidDrill.states(this.getCasingState())).where('F', this.getFramePredicate()).where('#', MetaTileEntityFluidDrill.any()).build();
    }

    private IBlockState getCasingState() {
        if (this.tier == 2) {
            return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID);
        }
        if (this.tier == 3) {
            return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE);
        }
        if (this.tier == 4) {
            return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST);
        }
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    @NotNull
    private TraceabilityPredicate getFramePredicate() {
        if (this.tier == 2) {
            return MetaTileEntityFluidDrill.frames(Materials.Steel);
        }
        if (this.tier == 3) {
            return MetaTileEntityFluidDrill.frames(Materials.Titanium);
        }
        if (this.tier == 4) {
            return MetaTileEntityFluidDrill.frames(Materials.TungstenSteel);
        }
        return MetaTileEntityFluidDrill.frames(Materials.Steel);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (this.tier == 2) {
            return Textures.SOLID_STEEL_CASING;
        }
        if (this.tier == 3) {
            return Textures.STABLE_TITANIUM_CASING;
        }
        if (this.tier == 4) {
            return Textures.ROBUST_TUNGSTENSTEEL_CASING;
        }
        return Textures.SOLID_STEEL_CASING;
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.setWorkingStatus(this.minerLogic.isWorkingEnabled(), this.minerLogic.isActive()).setWorkingStatusKeys("gregtech.multiblock.idling", "gregtech.multiblock.work_paused", "gregtech.multiblock.miner.drilling").addEnergyUsageLine(this.energyContainer).addCustom((keyManager, syncer) -> {
            if (!this.isStructureFormed()) {
                return;
            }
            Fluid drilledFluid = syncer.syncFluid(this.minerLogic.getDrilledFluid());
            if (drilledFluid == null) {
                IKey noFluid = KeyUtil.lang(TextFormatting.RED, "gregtech.multiblock.fluid_rig.no_fluid_in_area", new Object[0]);
                keyManager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.fluid_rig.drilled_fluid", noFluid));
                return;
            }
            IKey fluidInfo = KeyUtil.fluid(drilledFluid).style(TextFormatting.GREEN);
            keyManager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.fluid_rig.drilled_fluid", fluidInfo));
            int fluidProduce = syncer.syncInt(this.minerLogic.getFluidToProduce());
            IKey amountInfo = KeyUtil.number(TextFormatting.BLUE, (long)fluidProduce * 20L / 20L, " L/s");
            keyManager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.fluid_rig.fluid_amount", amountInfo));
        }).addProgressLine(this.minerLogic.getProgressTime(), 20).addWorkingStatusLine();
    }

    @Override
    protected void configureWarningText(MultiblockUIBuilder builder) {
        builder.addLowPowerLine(() -> this.isStructureFormed() && !this.drainEnergy(true)).addCustom((list, syncer) -> {
            if (this.isStructureFormed() && syncer.syncBoolean(this.minerLogic.isInventoryFull())) {
                list.add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.machine.miner.invfull", new Object[0]));
            }
        });
        super.configureWarningText(builder);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_drilling_rig.description", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_drilling_rig.depletion", (Object[])new Object[]{TextFormattingUtil.formatNumbers(100.0 / (double)this.getDepletionChance())}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_tier_range", (Object[])new Object[]{GTValues.VNF[this.tier], GTValues.VNF[this.tier + 1]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_drilling_rig.production", (Object[])new Object[]{this.getRigMultiplier(), TextFormattingUtil.formatNumbers((double)this.getRigMultiplier() * 1.5)}));
        if (this.tier > 2) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_drilling_rig.shows_depletion", (Object[])new Object[0]));
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public int getRigMultiplier() {
        if (this.tier == 2) {
            return 1;
        }
        if (this.tier == 3) {
            return 16;
        }
        if (this.tier == 4) {
            return 64;
        }
        return 1;
    }

    public int getDepletionChance() {
        if (this.tier == 2) {
            return 1;
        }
        if (this.tier == 3) {
            return 2;
        }
        if (this.tier == 4) {
            return 8;
        }
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.FLUID_RIG_OVERLAY;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.minerLogic.isActive(), this.minerLogic.isWorkingEnabled());
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.minerLogic.isWorkingEnabled();
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.minerLogic.setWorkingEnabled(isActivationAllowed);
    }

    public boolean fillTanks(FluidStack stack, boolean simulate) {
        return GTTransferUtils.addFluidsToFluidHandler(this.outputFluidInventory, simulate, Collections.singletonList(stack));
    }

    public int getEnergyTier() {
        if (this.energyContainer == null) {
            return this.tier;
        }
        return Math.min(this.tier + 1, Math.max(this.tier, GTUtility.getFloorTierByVoltage(this.energyContainer.getInputVoltage())));
    }

    public long getEnergyInputPerSecond() {
        return this.energyContainer.getInputPerSec();
    }

    public boolean drainEnergy(boolean simulate) {
        long energyToDrain = GTValues.VA[this.getEnergyTier()];
        long resultEnergy = this.energyContainer.getEnergyStored() - energyToDrain;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.changeEnergy(-energyToDrain);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        return this.minerLogic.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.minerLogic.readFromNBT(data);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.minerLogic.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.minerLogic.receiveInitialSyncData(buf);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        this.minerLogic.receiveCustomData(dataId, buf);
    }

    @Override
    public int getProgress() {
        return this.minerLogic.getProgressTime();
    }

    @Override
    public int getMaxProgress() {
        return 20;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_WORKABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_WORKABLE.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    public boolean allowsExtendedFacing() {
        return false;
    }

    @Override
    public int getProgressBarCount() {
        return this.tier > 2 ? 1 : 0;
    }

    @Override
    public void registerBars(List<UnaryOperator<TemplateBarBuilder>> bars, PanelSyncManager syncManager) {
        IntSyncValue operationsValue = new IntSyncValue(() -> BedrockFluidVeinHandler.getOperationsRemaining(this.getWorld(), this.minerLogic.getChunkX(), this.minerLogic.getChunkZ()));
        syncManager.syncValue("operations_remaining", (SyncHandler)operationsValue);
        bars.add(bar -> bar.progress(() -> (double)operationsValue.getIntValue() * 1.0 / 100000.0).texture(GTGuiTextures.PROGRESS_BAR_FLUID_RIG_DEPLETION).tooltipBuilder(t -> {
            if (!this.isStructureFormed()) {
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.invalid_structure"));
                return;
            }
            if (operationsValue.getIntValue() == 0) {
                t.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.fluid_rig.vein_depleted"));
                return;
            }
            t.addLine((IDrawable)KeyUtil.string(() -> MetaTileEntityFluidDrill.getDepletionLang(operationsValue)));
        }));
    }

    @NotNull
    private static String getDepletionLang(IntSyncValue operationsValue) {
        int percent = (int)Math.round(100.0 * (double)operationsValue.getIntValue() / 100000.0);
        if (percent > 40) {
            return TextFormatting.GREEN + IKey.lang((String)"gregtech.multiblock.fluid_rig.vein_depletion.high", (Object[])new Object[]{percent}).get();
        }
        if (percent > 10) {
            return TextFormatting.YELLOW + IKey.lang((String)"gregtech.multiblock.fluid_rig.vein_depletion.medium", (Object[])new Object[]{percent}).get();
        }
        return TextFormatting.RED + IKey.lang((String)"gregtech.multiblock.fluid_rig.vein_depletion.low", (Object[])new Object[]{percent}).get();
    }
}

