/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.logic.OCResult;
import gregtech.api.recipes.properties.RecipePropertyStorage;
import gregtech.api.util.GTUtility;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityCrackingUnit
extends RecipeMapMultiblockController {
    private int coilTier;

    public MetaTileEntityCrackingUnit(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.CRACKING_RECIPES);
        this.recipeMapWorkable = new CrackingUnitWorkableHandler(this);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityCrackingUnit(this.metaTileEntityId);
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("HCHCH", "HCHCH", "HCHCH").aisle("HCHCH", "H###H", "HCHCH").aisle("HCHCH", "HCOCH", "HCHCH").where('O', this.selfPredicate()).where('H', MetaTileEntityCrackingUnit.states(this.getCasingState()).setMinGlobalLimited(12).or(this.autoAbilities())).where('#', MetaTileEntityCrackingUnit.air()).where('C', MetaTileEntityCrackingUnit.heatingCoils()).build();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.CLEAN_STAINLESS_STEEL_CASING;
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STAINLESS_CLEAN);
    }

    @Override
    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addEnergyTierLine(GTUtility.getTierByVoltage(this.recipeMapWorkable.getMaxVoltage())).addCustom((textList, syncer) -> {
            if (!this.isStructureFormed()) {
                return;
            }
            IKey energyDiscount = KeyUtil.number(TextFormatting.AQUA, syncer.syncLong(100L - 10L * (long)this.getCoilTier()), "%");
            IKey base = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.cracking_unit.energy", energyDiscount);
            IKey hover = KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.cracking_unit.energy_hover", new Object[0]);
            textList.add(KeyUtil.setHover(base, new IDrawable[]{hover}));
        }).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgress(), this.recipeMapWorkable.getMaxProgress()).addRecipeOutputLine(this.recipeMapWorkable);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.cracker.tooltip.1", (Object[])new Object[0]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.CRACKING_UNIT_OVERLAY;
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        Object type = context.get("CoilType");
        this.coilTier = type instanceof IHeatingCoilBlockStats ? ((IHeatingCoilBlockStats)type).getTier() : 0;
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.coilTier = -1;
    }

    protected int getCoilTier() {
        return this.coilTier;
    }

    private class CrackingUnitWorkableHandler
    extends MultiblockRecipeLogic {
        public CrackingUnitWorkableHandler(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        @Override
        protected void modifyOverclockPost(@NotNull OCResult ocResult, @NotNull RecipePropertyStorage storage) {
            super.modifyOverclockPost(ocResult, storage);
            int coilTier = ((MetaTileEntityCrackingUnit)this.metaTileEntity).getCoilTier();
            if (coilTier <= 0) {
                return;
            }
            ocResult.setEut(Math.max(1L, (long)((double)ocResult.eut() * (1.0 - (double)coilTier * 0.1))));
        }
    }
}

