/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IDataAccessHatch;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.properties.impl.ResearchProperty;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RelativeDirection;
import gregtech.client.particle.GTLaserBeamParticle;
import gregtech.client.particle.GTParticleManager;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiFluidHatch;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityAssemblyLine
extends RecipeMapMultiblockController {
    private static final ResourceLocation LASER_LOCATION = GTUtility.gregtechId("textures/fx/laser/laser.png");
    private static final ResourceLocation LASER_HEAD_LOCATION = GTUtility.gregtechId("textures/fx/laser/laser_start.png");
    @SideOnly(value=Side.CLIENT)
    private GTLaserBeamParticle[][] beamParticles;
    private int beamCount;
    private int beamTime;

    public MetaTileEntityAssemblyLine(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.ASSEMBLY_LINE_RECIPES);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityAssemblyLine(this.metaTileEntityId);
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        FactoryBlockPattern pattern = FactoryBlockPattern.start(RelativeDirection.FRONT, RelativeDirection.UP, RelativeDirection.RIGHT).aisle("FIF", "RTR", "SAG", " Y ").aisle("FIF", "RTR", "DAG", " Y ").setRepeatable(3, 15).aisle("FOF", "RTR", "DAG", " Y ").where('S', this.selfPredicate()).where('F', MetaTileEntityAssemblyLine.states(MetaTileEntityAssemblyLine.getCasingState()).or(this.autoAbilities(false, true, false, false, false, false, false)).or(MetaTileEntityAssemblyLine.fluidInputPredicate())).where('O', MetaTileEntityAssemblyLine.abilities(MultiblockAbility.EXPORT_ITEMS).addTooltips("gregtech.multiblock.pattern.location_end")).where('Y', MetaTileEntityAssemblyLine.states(MetaTileEntityAssemblyLine.getCasingState()).or(MetaTileEntityAssemblyLine.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3))).where('I', MetaTileEntityAssemblyLine.metaTileEntities(MetaTileEntities.ITEM_IMPORT_BUS[0])).where('G', MetaTileEntityAssemblyLine.states(MetaTileEntityAssemblyLine.getGrateState())).where('A', MetaTileEntityAssemblyLine.states(MetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.ASSEMBLY_CONTROL))).where('R', MetaTileEntityAssemblyLine.states(MetaBlocks.TRANSPARENT_CASING.getState(BlockGlassCasing.CasingType.LAMINATED_GLASS))).where('T', MetaTileEntityAssemblyLine.states(MetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.ASSEMBLY_LINE_CASING))).where('D', MetaTileEntityAssemblyLine.dataHatchPredicate()).where(' ', MetaTileEntityAssemblyLine.any());
        return pattern.build();
    }

    @NotNull
    protected static IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    @NotNull
    protected static IBlockState getGrateState() {
        return MetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.GRATE_CASING);
    }

    @NotNull
    protected static TraceabilityPredicate fluidInputPredicate() {
        if (ConfigHolder.machines.orderedFluidAssembly) {
            return MetaTileEntityAssemblyLine.metaTileEntities((MetaTileEntity[])MultiblockAbility.REGISTRY.get(MultiblockAbility.IMPORT_FLUIDS).stream().filter(mte -> !(mte instanceof MetaTileEntityMultiFluidHatch)).toArray(MetaTileEntity[]::new)).setMaxGlobalLimited(4);
        }
        return MetaTileEntityAssemblyLine.abilities(MultiblockAbility.IMPORT_FLUIDS);
    }

    @NotNull
    protected static TraceabilityPredicate dataHatchPredicate() {
        if (ConfigHolder.machines.enableResearch) {
            return MetaTileEntityAssemblyLine.abilities(MultiblockAbility.DATA_ACCESS_HATCH, MultiblockAbility.OPTICAL_DATA_RECEPTION).setExactLimit(1).or(MetaTileEntityAssemblyLine.states(MetaTileEntityAssemblyLine.getGrateState()));
        }
        return MetaTileEntityAssemblyLine.states(MetaTileEntityAssemblyLine.getGrateState());
    }

    @Override
    protected Function<BlockPos, Integer> multiblockPartSorter() {
        return RelativeDirection.LEFT.getSorter(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (sourcePart != null) {
            if (sourcePart instanceof IDataAccessHatch) {
                return Textures.GRATE_CASING_STEEL_FRONT;
            }
            return Textures.SOLID_STEEL_CASING;
        }
        if (this.isStructureFormed()) {
            return Textures.GRATE_CASING_STEEL_FRONT;
        }
        return Textures.SOLID_STEEL_CASING;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.recipeMapWorkable.isActive(), this.recipeMapWorkable.isWorkingEnabled());
    }

    @Override
    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_MECHANICAL;
    }

    @Override
    public void update() {
        super.update();
        if (ConfigHolder.client.shader.assemblyLineParticles) {
            if (this.getRecipeMapWorkable().isWorking()) {
                int maxBeams = this.getAbilities(MultiblockAbility.IMPORT_ITEMS).size() + 1;
                int maxProgress = this.getRecipeMapWorkable().getMaxProgress();
                int beamTime = Math.max(1, maxProgress / maxBeams);
                int beamCount = Math.min(maxBeams, this.getRecipeMapWorkable().getProgress() / beamTime + 1);
                if (beamCount != this.beamCount) {
                    if (beamCount < this.beamCount) {
                        this.beamCount = Math.max(0, beamCount - 1);
                        this.writeCustomData(GregtechDataCodes.UPDATE_PARTICLE, this::writeParticles);
                    }
                    this.beamTime = beamTime;
                    this.beamCount = beamCount;
                    this.writeCustomData(GregtechDataCodes.UPDATE_PARTICLE, this::writeParticles);
                }
            } else if (this.beamCount != 0) {
                this.beamTime = 0;
                this.beamCount = 0;
                this.writeCustomData(GregtechDataCodes.UPDATE_PARTICLE, this::writeParticles);
            }
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.writeParticles(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.readParticles(buf);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == GregtechDataCodes.UPDATE_PARTICLE) {
            this.readParticles(buf);
        } else {
            super.receiveCustomData(dataId, buf);
        }
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (this.getWorld().field_72995_K && this.beamParticles != null) {
            for (GTLaserBeamParticle[] particle : this.beamParticles) {
                if (particle[0] == null) continue;
                particle[0].setExpired();
                particle[1].setExpired();
            }
            this.beamParticles = null;
        }
    }

    private void writeParticles(@NotNull PacketBuffer buf) {
        buf.func_150787_b(this.beamCount);
        buf.func_150787_b(this.beamTime);
    }

    @SideOnly(value=Side.CLIENT)
    private void readParticles(@NotNull PacketBuffer buf) {
        this.beamCount = buf.func_150792_a();
        this.beamTime = buf.func_150792_a();
        if (this.beamParticles == null) {
            this.beamParticles = new GTLaserBeamParticle[17][2];
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.getPos());
        EnumFacing relativeUp = RelativeDirection.UP.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing relativeLeft = RelativeDirection.LEFT.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        boolean negativeUp = relativeUp.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
        for (int i = 0; i < this.beamParticles.length; ++i) {
            GTLaserBeamParticle particle = this.beamParticles[i][0];
            if (i < this.beamCount && particle == null) {
                pos.func_189533_g((Vec3i)this.getPos());
                if (negativeUp) {
                    pos.func_189536_c(relativeUp.func_176734_d());
                }
                Vector3 startPos = new Vector3().add((BlockPos)pos.func_189534_c(relativeLeft, i)).add(relativeUp.func_176740_k() == EnumFacing.Axis.X ? 0.0 : 0.5, relativeUp.func_176740_k() == EnumFacing.Axis.Y ? 0.0 : 0.5, relativeUp.func_176740_k() == EnumFacing.Axis.Z ? 0.0 : 0.5);
                Vector3 endPos = startPos.copy().subtract((double)relativeUp.func_82601_c(), (double)relativeUp.func_96559_d(), (double)relativeUp.func_82599_e());
                this.beamParticles[i][0] = this.createALParticles(startPos, endPos);
                pos.func_189533_g((Vec3i)this.getPos());
                if (negativeUp) {
                    pos.func_189536_c(relativeUp.func_176734_d());
                }
                startPos = new Vector3().add((BlockPos)pos.func_189534_c(relativeLeft, i).func_189534_c(this.getFrontFacing().func_176734_d(), 2)).add(relativeUp.func_176740_k() == EnumFacing.Axis.X ? 0.0 : 0.5, relativeUp.func_176740_k() == EnumFacing.Axis.Y ? 0.0 : 0.5, relativeUp.func_176740_k() == EnumFacing.Axis.Z ? 0.0 : 0.5);
                endPos = startPos.copy().subtract((double)relativeUp.func_82601_c(), (double)relativeUp.func_96559_d(), (double)relativeUp.func_82599_e());
                this.beamParticles[i][1] = this.createALParticles(startPos, endPos);
                GTParticleManager.INSTANCE.addEffect(this.beamParticles[i][0]);
                GTParticleManager.INSTANCE.addEffect(this.beamParticles[i][1]);
                continue;
            }
            if (i < this.beamCount || particle == null) continue;
            particle.setExpired();
            this.beamParticles[i][0] = null;
            this.beamParticles[i][1].setExpired();
            this.beamParticles[i][1] = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    private GTLaserBeamParticle createALParticles(Vector3 startPos, Vector3 endPos) {
        return new GTLaserBeamParticle(this, startPos, endPos, this.beamTime).setBody(LASER_LOCATION).setBeamHeight(0.125f).setDoubleVertical(true).setHead(LASER_HEAD_LOCATION).setHeadWidth(0.1f).setEmit(0.2f);
    }

    @Override
    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        if (consumeIfSuccess) {
            return true;
        }
        if (ConfigHolder.machines.orderedAssembly) {
            List<GTRecipeInput> inputs = recipe.getInputs();
            List<IItemHandlerModifiable> itemInputInventory = this.getAbilities(MultiblockAbility.IMPORT_ITEMS);
            if (itemInputInventory.size() < inputs.size()) {
                return false;
            }
            for (int i = 0; i < inputs.size(); ++i) {
                if (inputs.get(i).acceptsStack(itemInputInventory.get(i).getStackInSlot(0))) continue;
                return false;
            }
            if (ConfigHolder.machines.orderedFluidAssembly) {
                inputs = recipe.getFluidInputs();
                List<IFluidTank> fluidInputInventory = this.getAbilities(MultiblockAbility.IMPORT_FLUIDS);
                if (fluidInputInventory.size() < inputs.size()) {
                    return false;
                }
                for (int i = 0; i < inputs.size(); ++i) {
                    if (inputs.get(i).acceptsFluid(fluidInputInventory.get(i).getFluid())) continue;
                    return false;
                }
            }
        }
        if (!ConfigHolder.machines.enableResearch || !recipe.hasProperty(ResearchProperty.getInstance())) {
            return super.checkRecipe(recipe, consumeIfSuccess);
        }
        return MetaTileEntityAssemblyLine.isRecipeAvailable(this.getAbilities(MultiblockAbility.DATA_ACCESS_HATCH), recipe) || MetaTileEntityAssemblyLine.isRecipeAvailable(this.getAbilities(MultiblockAbility.OPTICAL_DATA_RECEPTION), recipe);
    }

    private static boolean isRecipeAvailable(@NotNull Iterable<? extends IDataAccessHatch> hatches, @NotNull Recipe recipe) {
        for (IDataAccessHatch iDataAccessHatch : hatches) {
            if (iDataAccessHatch.isCreative()) {
                return true;
            }
            if (!iDataAccessHatch.isRecipeAvailable(recipe)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        if (ConfigHolder.machines.orderedAssembly && ConfigHolder.machines.orderedFluidAssembly) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.assembly_line.tooltip_ordered_both", (Object[])new Object[0]));
        } else if (ConfigHolder.machines.orderedAssembly) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.assembly_line.tooltip_ordered_items", (Object[])new Object[0]));
        } else if (ConfigHolder.machines.orderedFluidAssembly) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.assembly_line.tooltip_ordered_fluids", (Object[])new Object[0]));
        }
    }
}

