/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.BlockComputerCasing;
import gregtech.common.blocks.BlockFusionCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityActiveTransformer
extends MultiblockWithDisplayBase
implements IControllable {
    private boolean isWorkingEnabled = false;
    private IEnergyContainer powerOutput = new EnergyContainerList(new ArrayList<IEnergyContainer>());
    private IEnergyContainer powerInput = new EnergyContainerList(new ArrayList<IEnergyContainer>());
    private boolean isActive = false;
    private long averageIOLastSec;
    private long netIOLastSec;

    public MetaTileEntityActiveTransformer(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityActiveTransformer(this.metaTileEntityId);
    }

    @Override
    protected void updateFormedValid() {
        if (!this.getWorld().field_72995_K) {
            if (this.getOffsetTimer() % 20L == 0L) {
                this.averageIOLastSec = this.netIOLastSec / 20L;
                this.netIOLastSec = 0L;
            }
            if (this.isWorkingEnabled()) {
                long canDrain = this.powerInput.getEnergyStored();
                long totalDrained = this.powerOutput.changeEnergy(canDrain);
                this.powerInput.removeEnergy(totalDrained);
                this.netIOLastSec += totalDrained;
            }
        }
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        ArrayList<IEnergyContainer> powerInput = new ArrayList<IEnergyContainer>(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        powerInput.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_INPUT_ENERGY));
        ArrayList<IEnergyContainer> powerOutput = new ArrayList<IEnergyContainer>(this.getAbilities(MultiblockAbility.OUTPUT_ENERGY));
        powerOutput.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_OUTPUT_ENERGY));
        powerInput.addAll(this.getAbilities(MultiblockAbility.INPUT_LASER));
        powerOutput.addAll(this.getAbilities(MultiblockAbility.OUTPUT_LASER));
        if (powerInput.isEmpty() || powerOutput.isEmpty()) {
            this.invalidateStructure();
        }
        this.powerInput = new EnergyContainerList(powerInput);
        this.powerOutput = new EnergyContainerList(powerOutput);
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.powerOutput = new EnergyContainerList(new ArrayList<IEnergyContainer>());
        this.powerInput = new EnergyContainerList(new ArrayList<IEnergyContainer>());
        this.setActive(false);
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "XCX", "XXX").aisle("XXX", "XSX", "XXX").where('X', MetaTileEntityActiveTransformer.states(this.getCasingState()).setMinGlobalLimited(12).or(this.getHatchPredicates())).where('S', this.selfPredicate()).where('C', MetaTileEntityActiveTransformer.states(MetaBlocks.FUSION_CASING.getState(BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL))).build();
    }

    private TraceabilityPredicate getHatchPredicates() {
        return MetaTileEntityActiveTransformer.abilities(MultiblockAbility.INPUT_ENERGY).setPreviewCount(1).or(MetaTileEntityActiveTransformer.abilities(MultiblockAbility.OUTPUT_ENERGY).setPreviewCount(2)).or(MetaTileEntityActiveTransformer.abilities(MultiblockAbility.SUBSTATION_INPUT_ENERGY).setPreviewCount(1)).or(MetaTileEntityActiveTransformer.abilities(MultiblockAbility.SUBSTATION_OUTPUT_ENERGY).setPreviewCount(1)).or(MetaTileEntityActiveTransformer.abilities(MultiblockAbility.INPUT_LASER).setPreviewCount(1)).or(MetaTileEntityActiveTransformer.abilities(MultiblockAbility.OUTPUT_LASER).setPreviewCount(1));
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.HIGH_POWER_CASING;
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.HIGH_POWER_CASING);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.DATA_BANK_OVERLAY;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.isWorkingEnabled());
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.setWorkingStatus(true, this.isActive()).setWorkingStatusKeys("gregtech.multiblock.idling", "gregtech.multiblock.idling", "gregtech.machine.active_transformer.routing").addCustom((list, syncer) -> {
            if (this.isStructureFormed()) {
                IKey maxInputFormatted = KeyUtil.number(TextFormatting.WHITE, syncer.syncLong(this.powerInput.getInputVoltage() * this.powerInput.getInputAmperage()), " EU/t");
                list.add((IDrawable)KeyUtil.lang(TextFormatting.GREEN, "gregtech.multiblock.active_transformer.max_in", maxInputFormatted));
                IKey maxOutputFormatted = KeyUtil.number(TextFormatting.WHITE, syncer.syncLong(this.powerOutput.getOutputVoltage() * this.powerOutput.getOutputAmperage()), " EU/t");
                list.add((IDrawable)KeyUtil.lang(TextFormatting.RED, "gregtech.multiblock.active_transformer.max_out", maxOutputFormatted));
                IKey avgIOFormatted = KeyUtil.number(TextFormatting.WHITE, syncer.syncLong(this.averageIOLastSec), " EU/t");
                list.add((IDrawable)KeyUtil.lang(TextFormatting.AQUA, "gregtech.multiblock.active_transformer.average_io", avgIOFormatted));
            }
        }).addWorkingStatusLine();
    }

    @Override
    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.isWorkingEnabled = isWorkingAllowed;
        this.markDirty();
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(this.isWorkingEnabled));
        }
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.isWorkingEnabled;
    }

    public void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.markDirty();
            World world = this.getWorld();
            if (world != null && !world.field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, buf -> buf.writeBoolean(active));
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("isActive", this.isActive);
        data.func_74757_a("isWorkingEnabled", this.isWorkingEnabled);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isActive = data.func_74767_n("isActive");
        this.isWorkingEnabled = data.func_74767_n("isWorkingEnabled");
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.isWorkingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
        this.isWorkingEnabled = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.active_transformer.tooltip1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.active_transformer.tooltip2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.active_transformer.tooltip3", (Object[])new Object[0]) + TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.active_transformer.tooltip3.5", (Object[])new Object[0]));
    }

    public long getAverageIOLastSec() {
        return this.averageIOLastSec;
    }
}

