/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.RichTextWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import gregtech.api.capability.impl.FilteredItemHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuiTheme;
import gregtech.api.mui.GTGuis;
import gregtech.api.mui.sync.GTFluidSyncHandler;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumTank;
import gregtech.common.mui.widget.GTFluidSlot;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityPumpHatch
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<IFluidTank> {
    private static final int FLUID_TANK_SIZE = 1000;

    public MetaTileEntityPumpHatch(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 0);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPumpHatch(this.metaTileEntityId);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("ContainerInventory")) {
            MetaTileEntityQuantumTank.legacyTankItemHandlerNBTReading(this, data.func_74775_l("ContainerInventory"), 0, 1);
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            this.pushFluidsIntoNearbyHandlers(this.getFrontFacing());
            this.fillContainerFromInternalTank();
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            Textures.PIPE_OUT_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{new FluidTank(1000)});
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new FilteredItemHandler((MetaTileEntity)this, 1).setFillPredicate(FilteredItemHandler.getCapabilityFilter(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY));
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new GTItemStackHandler((MetaTileEntity)this, 1);
    }

    @Override
    public MultiblockAbility<IFluidTank> getAbility() {
        return MultiblockAbility.PUMP_FLUID_HATCH;
    }

    @Override
    public ICubeRenderer getBaseTexture() {
        return Textures.PRIMITIVE_PUMP;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.add(this.exportFluids.getTankAt(0));
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager guiSyncManager) {
        guiSyncManager.registerSlotGroup("item_inv", 2);
        GTFluidSyncHandler tankSyncHandler = GTFluidSlot.sync(this.exportFluids.getTankAt(0)).showAmountOnSlot(false).accessibility(true, false);
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, 176, 166).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((Widget)((Widget)GTGuiTextures.DISPLAY.asWidget().left(7)).top(16)).size(81, 55))).child((IWidget)((Widget)((Widget)GTGuiTextures.TANK_ICON.asWidget().left(92)).top(36)).size(14, 15))).child((IWidget)((RichTextWidget)((RichTextWidget)((RichTextWidget)((RichTextWidget)new RichTextWidget().size(75, 47)).pos(10, 20)).textColor(Color.WHITE.main)).alignment(Alignment.TopLeft)).autoUpdate(true).textBuilder(richText -> {
            richText.addLine((IDrawable)IKey.lang((String)"gregtech.gui.fluid_amount"));
            String name = tankSyncHandler.getFluidLocalizedName();
            if (name == null) {
                return;
            }
            richText.addLine((IDrawable)IKey.str((String)name));
            richText.addLine((IDrawable)IKey.str((String)tankSyncHandler.getFormattedFluidAmount()));
        }))).child((IWidget)((GTFluidSlot)new GTFluidSlot().syncHandler(tankSyncHandler).pos(69, 52)).disableBackground())).child((IWidget)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.importItems, (int)0).slotGroup("item_inv").filter(itemStack -> FluidUtil.getFluidHandler((ItemStack)itemStack) != null)).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.IN_SLOT_OVERLAY})).pos(90, 16))).child((IWidget)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.exportItems, (int)0).slotGroup("item_inv").accessibility(false, true)).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.OUT_SLOT_OVERLAY})).pos(90, 53));
    }

    @Override
    public GTGuiTheme getUITheme() {
        return GTGuiTheme.PRIMITIVE;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{1000}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }
}

