/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IDoubleValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.DoubleSyncValue;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.ProgressWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Grid;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import gregtech.api.GTValues;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapPrimitiveMultiblockController;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIFactory;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuiTheme;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTUtility;
import gregtech.client.particle.VanillaParticleEffects;
import gregtech.client.renderer.CubeRendererState;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.cclop.ColourOperation;
import gregtech.client.renderer.cclop.LightMapOperation;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class MetaTileEntityPrimitiveBlastFurnace
extends RecipeMapPrimitiveMultiblockController {
    private static final TraceabilityPredicate SNOW_PREDICATE = new TraceabilityPredicate(bws -> GTUtility.isBlockSnow(bws.getBlockState()));

    public MetaTileEntityPrimitiveBlastFurnace(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.PRIMITIVE_BLAST_FURNACE_RECIPES);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPrimitiveBlastFurnace(this.metaTileEntityId);
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX", "XXX").aisle("XXX", "X&X", "X#X", "X#X").aisle("XXX", "XYX", "XXX", "XXX").where('X', MetaTileEntityPrimitiveBlastFurnace.states(MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.PRIMITIVE_BRICKS))).where('#', MetaTileEntityPrimitiveBlastFurnace.air()).where('&', MetaTileEntityPrimitiveBlastFurnace.air().or(SNOW_PREDICATE)).where('Y', this.selfPredicate()).build();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.PRIMITIVE_BRICKS;
    }

    @Override
    protected MultiblockUIFactory createUIFactory() {
        return new MultiblockUIFactory(this).setSize(176, 166).disableDisplay().disableButtons().addScreenChildren((parent, syncManager) -> {
            UITexture[] importOverlays = new UITexture[]{GTGuiTextures.PRIMITIVE_INGOT_OVERLAY, GTGuiTextures.PRIMITIVE_DUST_OVERLAY, GTGuiTextures.PRIMITIVE_FURNACE_OVERLAY};
            UITexture[] exportOverlays = new UITexture[]{GTGuiTextures.PRIMITIVE_INGOT_OVERLAY, GTGuiTextures.PRIMITIVE_DUST_OVERLAY, GTGuiTextures.PRIMITIVE_DUST_OVERLAY};
            SlotGroup importGroup = new SlotGroup("import", 1, true);
            ((ParentWidget)parent.child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().top(20)).alignX(0.5f)).crossAxisAlignment(Alignment.CrossAxis.CENTER).coverChildren()).child((IWidget)((Grid)new Grid().coverChildren()).mapTo(1, 3, value -> ((ItemSlot)new ItemSlot().background(new IDrawable[]{GTGuiTextures.SLOT_PRIMITIVE, importOverlays[value]})).slot(new ModularSlot((IItemHandler)this.importItems, value).slotGroup(importGroup))).marginRight(6))).child((IWidget)((ProgressWidget)((ProgressWidget)new ProgressWidget().size(20, 15)).marginRight(6)).texture(GTGuiTextures.PRIMITIVE_BLAST_FURNACE_PROGRESS_BAR, 20).value((IDoubleValue)new DoubleSyncValue(this.recipeMapWorkable::getProgressPercent)))).child((IWidget)((Grid)new Grid().coverChildren()).mapTo(3, 3, value -> ((ItemSlot)new ItemSlot().background(new IDrawable[]{GTGuiTextures.SLOT_PRIMITIVE, exportOverlays[value]})).slot(new ModularSlot((IItemHandler)this.exportItems, value).accessibility(false, true)))));
        });
    }

    @Override
    public GTGuiTheme getUITheme() {
        return GTGuiTheme.PRIMITIVE;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.recipeMapWorkable.isActive(), this.recipeMapWorkable.isWorkingEnabled());
        if (this.recipeMapWorkable.isActive() && this.isStructureFormed()) {
            EnumFacing back = this.getFrontFacing().func_176734_d();
            Matrix4 offset = translation.copy().translate((double)back.func_82601_c(), -0.3, (double)back.func_82599_e());
            CubeRendererState op = Textures.RENDER_STATE.get();
            Textures.RENDER_STATE.set(new CubeRendererState(op.layer, CubeRendererState.PASS_MASK, op.world));
            Textures.renderFace(renderState, offset, (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new LightMapOperation(240, 240), new ColourOperation(-1)}), EnumFacing.UP, Cuboid6.full, TextureUtils.getBlockTexture((String)"lava_still"), BloomEffectUtil.getEffectiveBloomLayer());
            Textures.RENDER_STATE.set(op);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.PRIMITIVE_BLAST_FURNACE_OVERLAY;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return false;
    }

    @Override
    public void update() {
        super.update();
        if (this.isActive()) {
            if (this.getWorld().field_72995_K) {
                VanillaParticleEffects.PBF_SMOKE.runEffect(this);
            } else {
                this.damageEntitiesAndBreakSnow();
            }
        }
    }

    private void damageEntitiesAndBreakSnow() {
        BlockPos middlePos = this.getPos();
        middlePos = middlePos.func_177972_a(this.getFrontFacing().func_176734_d());
        this.getWorld().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(middlePos)).forEach(entity -> entity.func_70097_a(DamageSource.field_76371_c, 3.0f));
        if (this.getOffsetTimer() % 10L == 0L) {
            IBlockState state = this.getWorld().func_180495_p(middlePos);
            GTUtility.tryBreakSnow(this.getWorld(), middlePos, state, true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.isActive()) {
            VanillaParticleEffects.defaultFrontEffect((MetaTileEntity)this, 0.3f, EnumParticleTypes.SMOKE_LARGE, EnumParticleTypes.FLAME);
            if (ConfigHolder.machines.machineSounds && GTValues.RNG.nextDouble() < 0.1) {
                BlockPos pos = this.getPos();
                this.getWorld().func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }
}

