/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widgets.TextWidget;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.PropertyFluidFilter;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIFactory;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuiTheme;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockSteamCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.mui.widget.GTFluidSlot;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMultiblockTank
extends MultiblockWithDisplayBase {
    private final boolean isMetal;
    private final int capacity;

    public MetaTileEntityMultiblockTank(ResourceLocation metaTileEntityId, boolean isMetal, int capacity) {
        super(metaTileEntityId);
        this.isMetal = isMetal;
        this.capacity = capacity;
        this.initializeInventory();
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        FilteredFluidHandler tank = new FilteredFluidHandler(this.capacity);
        if (!this.isMetal) {
            tank.setFilter(new PropertyFluidFilter(340, false, false, false, false));
        }
        this.exportFluids = this.importFluids = new FluidTankList(true, new IFluidTank[]{tank});
        this.fluidInventory = tank;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMultiblockTank(this.metaTileEntityId, this.isMetal, this.capacity);
    }

    @Override
    protected void updateFormedValid() {
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "X X", "XXX").aisle("XXX", "XSX", "XXX").where('S', this.selfPredicate()).where('X', MetaTileEntityMultiblockTank.states(this.getCasingState()).setMinGlobalLimited(23).or(MetaTileEntityMultiblockTank.metaTileEntities(this.getValve()).setMaxGlobalLimited(2))).where(' ', MetaTileEntityMultiblockTank.air()).build();
    }

    private IBlockState getCasingState() {
        if (this.isMetal) {
            return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID);
        }
        return MetaBlocks.STEAM_CASING.getState(BlockSteamCasing.SteamCasingType.WOOD_WALL);
    }

    private MetaTileEntity getValve() {
        if (this.isMetal) {
            return MetaTileEntities.STEEL_TANK_VALVE;
        }
        return MetaTileEntities.WOODEN_TANK_VALVE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (this.isMetal) {
            return Textures.SOLID_STEEL_CASING;
        }
        return Textures.WOOD_WALL;
    }

    @Override
    public GTGuiTheme getUITheme() {
        if (this.isMetal) {
            return GTGuiTheme.STEEL;
        }
        return GTGuiTheme.PRIMITIVE;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return false;
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!this.isStructureFormed()) {
            return false;
        }
        return super.onRightClick(playerIn, hand, facing, hitResult);
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return this.isStructureFormed();
    }

    @Override
    protected MultiblockUIFactory createUIFactory() {
        return new MultiblockUIFactory(this).setSize(176, 166).disableDisplay().disableButtons().addScreenChildren((parent, syncManager) -> {
            parent.child((IWidget)new TextWidget(IKey.lang((String)this.getMetaFullName())).pos(5, 5));
            parent.child((IWidget)((GTFluidSlot)((GTFluidSlot)((GTFluidSlot)new GTFluidSlot().pos(52, 18)).size(72, 61)).overlay(new IDrawable[]{GTGuiTextures.PRIMITIVE_LARGE_FLUID_TANK_OVERLAY.asIcon().alignment(Alignment.CenterLeft).size(30, 58)})).syncHandler(GTFluidSlot.sync(this.importFluids.getTankAt(0)).showAmountOnSlot(false).drawAlwaysFull(false)));
        });
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderSided(this.getFrontFacing(), renderState, translation, pipeline);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.MULTIBLOCK_TANK_OVERLAY;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.tank.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.capacity}));
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.isStructureFormed()) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidInventory);
            }
            return null;
        }
        return super.getCapability(capability, side);
    }
}

