/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IDoubleValue;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.DoubleSyncValue;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.SliderWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.BoilerRecipeLogic;
import gregtech.api.capability.impl.CommonFluidFilters;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.ProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.ui.KeyManager;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIBuilder;
import gregtech.api.metatileentity.multiblock.ui.MultiblockUIFactory;
import gregtech.api.metatileentity.multiblock.ui.TemplateBarBuilder;
import gregtech.api.metatileentity.multiblock.ui.UISyncer;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuiTheme;
import gregtech.api.mui.GTGuis;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.util.KeyUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.metatileentities.multi.BoilerType;
import gregtech.core.sound.GTSoundEvents;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLargeBoiler
extends MultiblockWithDisplayBase
implements ProgressBarMultiblock,
IControllable {
    public final BoilerType boilerType;
    protected BoilerRecipeLogic recipeLogic;
    private FluidTankList fluidImportInventory;
    private ItemHandlerList itemImportInventory;
    private FluidTankList steamOutputTank;
    private int throttlePercentage = 100;

    public MetaTileEntityLargeBoiler(ResourceLocation metaTileEntityId, BoilerType boilerType) {
        super(metaTileEntityId);
        this.boilerType = boilerType;
        this.recipeLogic = new BoilerRecipeLogic(this);
        this.resetTileAbilities();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeBoiler(this.metaTileEntityId, this.boilerType);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
        this.throttlePercentage = 100;
        this.recipeLogic.invalidate();
    }

    private void initializeAbilities() {
        this.fluidImportInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.itemImportInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.steamOutputTank = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
    }

    private void resetTileAbilities() {
        this.fluidImportInventory = new FluidTankList(true, new IFluidTank[0]);
        this.itemImportInventory = new ItemHandlerList(Collections.emptyList());
        this.steamOutputTank = new FluidTankList(true, new IFluidTank[0]);
    }

    private TextFormatting getNumberColor(int number) {
        if (number == 0) {
            return TextFormatting.DARK_RED;
        }
        if (number <= 40) {
            return TextFormatting.RED;
        }
        if (number < 100) {
            return TextFormatting.YELLOW;
        }
        return TextFormatting.GREEN;
    }

    @Override
    protected void configureDisplayText(MultiblockUIBuilder builder) {
        builder.setWorkingStatus(this.recipeLogic.isWorkingEnabled(), this.recipeLogic.isActive()).addCustom(this::addCustomData).addWorkingStatusLine();
    }

    @Override
    protected void configureWarningText(MultiblockUIBuilder builder) {
        super.configureWarningText(builder);
        builder.addCustom((manager, syncer) -> {
            if (this.isStructureFormed() && syncer.syncBoolean(this.getWaterFilled() == 0)) {
                manager.add((IDrawable)KeyUtil.lang(TextFormatting.YELLOW, "gregtech.multiblock.large_boiler.no_water", new Object[0]));
                manager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.large_boiler.explosion_tooltip", new Object[0]));
            }
        });
    }

    @Override
    public GTGuiTheme getUITheme() {
        GTGuiTheme gTGuiTheme;
        switch (this.boilerType) {
            case BRONZE: {
                gTGuiTheme = GTGuiTheme.BRONZE;
                break;
            }
            case STEEL: {
                gTGuiTheme = GTGuiTheme.STEEL;
                break;
            }
            default: {
                gTGuiTheme = super.getUITheme();
            }
        }
        return gTGuiTheme;
    }

    @Override
    protected MultiblockUIFactory createUIFactory() {
        return super.createUIFactory().createFlexButton((guiData, syncManager) -> {
            IPanelHandler throttle = syncManager.panel("throttle_panel", this::makeThrottlePanel, true);
            return ((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(18)).overlay(new IDrawable[]{GTGuiTextures.FILTER_SETTINGS_OVERLAY.asIcon().size(16)})).addTooltipLine((IDrawable)IKey.lang((String)"gregtech.multiblock.large_boiler.throttle_button.tooltip"))).onMousePressed(i -> {
                if (throttle.isPanelOpen()) {
                    throttle.closePanel();
                } else {
                    throttle.openPanel();
                }
                return true;
            });
        });
    }

    private void addCustomData(KeyManager keyManager, UISyncer syncer) {
        if (this.isStructureFormed()) {
            int steam = syncer.syncInt(this.recipeLogic.getLastTickSteam());
            int heatScaled = syncer.syncInt(this.recipeLogic.getHeatScaled());
            int throttleAmt = syncer.syncInt(this.getThrottle());
            IKey steamOutput = KeyUtil.number(TextFormatting.AQUA, (long)steam, " L/t");
            keyManager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.large_boiler.steam_output", steamOutput));
            IKey efficiency = KeyUtil.number(this.getNumberColor(heatScaled), (long)heatScaled, "%");
            keyManager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.large_boiler.efficiency", efficiency));
            IKey throttle = KeyUtil.number(this.getNumberColor(throttleAmt), (long)throttleAmt, "%");
            keyManager.add((IDrawable)KeyUtil.lang(TextFormatting.GRAY, "gregtech.multiblock.large_boiler.throttle", throttle));
        }
    }

    private ModularPanel makeThrottlePanel(PanelSyncManager syncManager, IPanelHandler syncHandler) {
        StringSyncValue throttleValue = new StringSyncValue(() -> this.throttlePercentage + "%", str -> {
            try {
                if (str.charAt(str.length() - 1) == '%') {
                    str = str.substring(0, str.length() - 1);
                }
                this.throttlePercentage = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        DoubleSyncValue sliderValue = new DoubleSyncValue(() -> (double)this.getThrottlePercentage() / 100.0, d -> this.setThrottlePercentage((int)(d * 100.0)));
        return (ModularPanel)((ModularPanel)GTGuis.createPopupPanel("boiler_throttle", 116, 53).child((IWidget)((Flow)((Flow)((Flow)((Flow)Flow.row().pos(4, 4)).height(16)).coverChildrenWidth()).child((IWidget)((Widget)new ItemDrawable(this.getStackForm()).asWidget().size(16)).marginRight(4))).child((IWidget)IKey.lang((String)"gregtech.multiblock.large_boiler.throttle.title").asWidget().heightRel(1.0f)))).child((IWidget)((Flow)((Flow)((Flow)((Flow)Flow.row().top(20)).margin(4, 0)).coverChildrenHeight()).child((IWidget)((SliderWidget)((SliderWidget)new SliderWidget().background(new IDrawable[]{new Rectangle().setColor(Color.BLACK.brighter(2)).asIcon().height(8)})).bounds(0.0, 1.0).setAxis(GuiAxis.X).value((IDoubleValue)sliderValue).widthRel(0.7f)).height(20))).child((IWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().widthRel(0.3f)).height(20)).setTextColor(Color.WHITE.darker(1)).setValidator(str -> {
            if (str.charAt(str.length() - 1) == '%') {
                str = str.substring(0, str.length() - 1);
            }
            try {
                long l = Long.parseLong(str);
                if (l < 0L) {
                    l = 0L;
                } else if (l > 100L) {
                    l = 100L;
                }
                return String.valueOf(l);
            }
            catch (NumberFormatException ignored) {
                return throttleValue.getValue();
            }
        }).value((IStringValue)throttleValue).background(new IDrawable[]{GTGuiTextures.DISPLAY})));
    }

    private void setThrottlePercentage(int amount) {
        this.throttlePercentage = amount;
    }

    private int getThrottlePercentage() {
        return this.throttlePercentage;
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.recipeLogic.isActive() && this.recipeLogic.isWorkingEnabled();
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "CCC", "CCC", "CCC").aisle("XXX", "CPC", "CPC", "CCC").aisle("XXX", "CSC", "CCC", "CCC").where('S', this.selfPredicate()).where('P', MetaTileEntityLargeBoiler.states(this.boilerType.pipeState)).where('X', MetaTileEntityLargeBoiler.states(this.boilerType.fireboxState).setMinGlobalLimited(4).or(MetaTileEntityLargeBoiler.abilities(MultiblockAbility.IMPORT_FLUIDS).setMinGlobalLimited(1)).or(MetaTileEntityLargeBoiler.abilities(MultiblockAbility.IMPORT_ITEMS).setMaxGlobalLimited(1)).or(this.autoAbilities())).where('C', MetaTileEntityLargeBoiler.states(this.boilerType.casingState).setMinGlobalLimited(20).or(MetaTileEntityLargeBoiler.abilities(MultiblockAbility.EXPORT_FLUIDS).setMinGlobalLimited(1))).build();
    }

    @Override
    public String[] getDescription() {
        return new String[]{I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.description", (Object[])new Object[0])};
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.rate_tooltip", (Object[])new Object[]{(int)((double)(this.boilerType.steamPerTick() * 20 * this.boilerType.runtimeBoost(20)) / 20.0)}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.heat_time_tooltip", (Object[])new Object[]{this.boilerType.getTicksToBoiling() / 20}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.base_production_fluid", (Object[])new Object[]{this.boilerType.steamPerTick()}));
        tooltip.add(TooltipHelper.BLINKING_RED + I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.explosion_tooltip", (Object[])new Object[0]));
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.recipeLogic.isWorkingEnabled());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return this.boilerType.frontOverlay;
    }

    private boolean isFireboxPart(IMultiblockPart sourcePart) {
        return this.isStructureFormed() && ((MetaTileEntity)((Object)sourcePart)).getPos().func_177956_o() < this.getPos().func_177956_o();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (sourcePart != null && this.isFireboxPart(sourcePart)) {
            return this.isActive() ? this.boilerType.fireboxActiveRenderer : this.boilerType.fireboxIdleRenderer;
        }
        return this.boilerType.casingRenderer;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return true;
    }

    @Override
    public SoundEvent getSound() {
        return GTSoundEvents.BOILER;
    }

    @Override
    protected void updateFormedValid() {
        this.recipeLogic.update();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74768_a("ThrottlePercentage", this.throttlePercentage);
        return super.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.throttlePercentage = data.func_74762_e("ThrottlePercentage");
        super.readFromNBT(data);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.throttlePercentage);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.throttlePercentage = buf.func_150792_a();
    }

    public int getThrottle() {
        return this.throttlePercentage;
    }

    @Override
    public IItemHandlerModifiable getImportItems() {
        return this.itemImportInventory;
    }

    @Override
    public FluidTankList getImportFluids() {
        return this.fluidImportInventory;
    }

    @Override
    public FluidTankList getExportFluids() {
        return this.steamOutputTank;
    }

    @Override
    protected boolean shouldUpdate(MTETrait trait) {
        return !(trait instanceof BoilerRecipeLogic);
    }

    @Override
    public boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    public int getProgressBarCount() {
        return 1;
    }

    @Override
    public void registerBars(List<UnaryOperator<TemplateBarBuilder>> bars, PanelSyncManager syncManager) {
        IntSyncValue waterFilledValue = new IntSyncValue(this::getWaterFilled);
        IntSyncValue waterCapacityValue = new IntSyncValue(this::getWaterCapacity);
        syncManager.syncValue("water_filled", (SyncHandler)waterFilledValue);
        syncManager.syncValue("water_capacity", (SyncHandler)waterCapacityValue);
        bars.add(barTest -> barTest.progress(() -> waterCapacityValue.getIntValue() == 0 ? 0.0 : (double)waterFilledValue.getIntValue() * 1.0 / (double)waterCapacityValue.getIntValue()).texture(GTGuiTextures.PROGRESS_BAR_FLUID_RIG_DEPLETION).tooltipBuilder(tooltip -> {
            if (this.isStructureFormed()) {
                if (waterFilledValue.getIntValue() == 0) {
                    tooltip.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.large_boiler.no_water"));
                } else {
                    tooltip.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.large_boiler.water_bar_hover", (Object[])new Object[]{waterFilledValue.getIntValue(), waterCapacityValue.getIntValue()}));
                }
            } else {
                tooltip.addLine((IDrawable)IKey.lang((String)"gregtech.multiblock.invalid_structure"));
            }
        }));
    }

    private int getWaterFilled() {
        if (!this.isStructureFormed()) {
            return 0;
        }
        List<IFluidTank> tanks = this.getAbilities(MultiblockAbility.IMPORT_FLUIDS);
        int filled = 0;
        for (IFluidTank tank : tanks) {
            if (tank == null || tank.getFluid() == null || !CommonFluidFilters.BOILER_FLUID.test(tank.getFluid())) continue;
            filled += tank.getFluidAmount();
        }
        return filled;
    }

    private int getWaterCapacity() {
        if (!this.isStructureFormed()) {
            return 0;
        }
        List<IFluidTank> tanks = this.getAbilities(MultiblockAbility.IMPORT_FLUIDS);
        int capacity = 0;
        for (IFluidTank tank : tanks) {
            if (tank == null || tank.getFluid() == null || !CommonFluidFilters.BOILER_FLUID.test(tank.getFluid())) continue;
            capacity += tank.getCapacity();
        }
        return capacity;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.recipeLogic.isWorkingEnabled();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.recipeLogic.setWorkingEnabled(isWorkingAllowed);
    }
}

