/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.util.GTLog;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import it.unimi.dsi.fastutil.objects.Object2BooleanFunction;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityWorldAccelerator
extends TieredMetaTileEntity
implements IControllable {
    private static final Map<String, Class<?>> blacklistedClasses = new Object2ObjectOpenHashMap();
    private static final Object2BooleanFunction<Class<? extends TileEntity>> blacklistCache = new Object2BooleanOpenHashMap();
    private static boolean gatheredClasses = false;
    private final int speed;
    private boolean tileMode = false;
    private boolean isActive = false;
    private boolean isPaused = false;
    private static final int[] SUCCESS_LIMITS = new int[]{1, 8, 27, 64, 125, 216, 343, 512};
    private final int successLimit;
    private BlockPos bottomLeftCorner;

    public MetaTileEntityWorldAccelerator(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.speed = (int)Math.pow(2.0, tier);
        this.successLimit = SUCCESS_LIMITS[tier - 1];
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityWorldAccelerator(this.metaTileEntityId, this.getTier());
    }

    @Override
    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        this.energyContainer = EnergyContainerHandler.receiverContainer(this, tierVoltage * 256L, tierVoltage, this.getMaxInputOutputAmperage());
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.world_accelerator.description", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.world_accelerator.power_usage", (Object[])new Object[]{this.getRandomTickModeAmperage(), this.getTEModeAmperage()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.world_accelerator.acceleration", (Object[])new Object[]{this.speed}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.world_accelerator.working_area", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.world_accelerator.working_area_tile", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.world_accelerator.working_area_random", (Object[])new Object[]{this.getTier() * 2 + 1, this.getTier() * 2 + 1}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.toggle_mode_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.soft_mallet.reset", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    protected long getMaxInputOutputAmperage() {
        return 8L;
    }

    protected long getRandomTickModeAmperage() {
        return 3L;
    }

    protected long getTEModeAmperage() {
        return 6L;
    }

    @Override
    public boolean allowTickAcceleration() {
        return false;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            if (this.isPaused && this.isActive) {
                this.setActive(false);
            } else if (!this.isPaused) {
                boolean wasSuccessful;
                boolean bl = wasSuccessful = this.isTEMode() ? this.handleTEMode() : this.handleRandomTickMode();
                if (!wasSuccessful) {
                    this.setActive(false);
                } else if (!this.isActive) {
                    this.setActive(true);
                }
            }
        }
    }

    private boolean handleTEMode() {
        if (!this.drawEnergy(this.getTEModeAmperage() * GTValues.V[this.getTier()])) {
            return false;
        }
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity te = this.getNeighbor(facing);
            if (!(te instanceof ITickable)) continue;
            ITickable tickable = (ITickable)te;
            if (te.func_145837_r() || !MetaTileEntityWorldAccelerator.canTileAccelerate(te)) continue;
            for (int i = 0; i < this.speed; ++i) {
                tickable.func_73660_a();
            }
        }
        return true;
    }

    private boolean handleRandomTickMode() {
        if (!this.drawEnergy(this.getRandomTickModeAmperage() * GTValues.V[this.getTier()])) {
            return false;
        }
        World world = this.getWorld();
        int maxHeight = world.func_72800_K();
        int attempts = this.successLimit * 3;
        BlockPos cornerPos = this.getCornerPos();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(cornerPos);
        int randRange = (this.getTier() << 1) + 1;
        int i = 0;
        for (int j = 0; i < this.successLimit && j < attempts; ++j) {
            int x = GTValues.RNG.nextInt(randRange);
            int y = GTValues.RNG.nextInt(randRange);
            int z = GTValues.RNG.nextInt(randRange);
            mutablePos.func_181079_c(cornerPos.func_177958_n() + x, cornerPos.func_177956_o() + y, cornerPos.func_177952_p() + z);
            if (mutablePos.func_177956_o() > maxHeight || mutablePos.func_177956_o() < 0 || !world.func_175667_e((BlockPos)mutablePos) || mutablePos.equals((Object)this.getPos())) continue;
            IBlockState state = world.func_180495_p((BlockPos)mutablePos);
            Block block = state.func_177230_c();
            if (block.func_149653_t()) {
                block.func_180645_a(world, mutablePos.func_185334_h(), state, world.field_73012_v);
            }
            ++i;
        }
        return true;
    }

    private boolean drawEnergy(long usage) {
        if (this.energyContainer.getEnergyStored() < usage) {
            return false;
        }
        this.energyContainer.removeEnergy(usage);
        return true;
    }

    private BlockPos getCornerPos() {
        if (this.bottomLeftCorner == null) {
            this.bottomLeftCorner = new BlockPos(this.getPos().func_177958_n() - this.getTier(), this.getPos().func_177956_o() - this.getTier(), this.getPos().func_177952_p() - this.getTier());
        }
        return this.bottomLeftCorner;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.isTEMode()) {
            Textures.WORLD_ACCELERATOR_TE_OVERLAY.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive, this.isWorkingEnabled());
        } else {
            Textures.WORLD_ACCELERATOR_OVERLAY.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive, this.isWorkingEnabled());
        }
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!this.getWorld().field_72995_K) {
            if (this.isTEMode()) {
                this.setTEMode(false);
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.world_accelerator.mode_entity", new Object[0]), false);
            } else {
                this.setTEMode(true);
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.world_accelerator.mode_tile", new Object[0]), false);
            }
        }
        return true;
    }

    public void setTEMode(boolean inverted) {
        if (this.tileMode != inverted) {
            this.tileMode = inverted;
            World world = this.getWorld();
            if (world != null && !world.field_72995_K) {
                this.writeCustomData(GregtechDataCodes.SYNC_TILE_MODE, b -> b.writeBoolean(this.tileMode));
                this.notifyBlockUpdate();
                this.markDirty();
            }
        }
    }

    public boolean isTEMode() {
        return this.tileMode;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("TileMode", this.tileMode);
        data.func_74757_a("isPaused", this.isPaused);
        data.func_74757_a("IsActive", this.isActive);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tileMode = data.func_74767_n("TileMode");
        this.isPaused = data.func_74767_n("isPaused");
        this.isActive = data.func_74767_n("IsActive");
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.tileMode);
        buf.writeBoolean(this.isPaused);
        buf.writeBoolean(this.isActive);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.tileMode = buf.readBoolean();
        this.isPaused = buf.readBoolean();
        this.isActive = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.IS_WORKING) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.SYNC_TILE_MODE) {
            this.tileMode = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    protected void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.markDirty();
            World world = this.getWorld();
            if (world != null && !world.field_72995_K) {
                this.writeCustomData(GregtechDataCodes.IS_WORKING, buf -> buf.writeBoolean(active));
            }
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return !this.isPaused;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingEnabled) {
        if (this.isPaused != isWorkingEnabled) {
            this.isPaused = isWorkingEnabled;
            this.notifyBlockUpdate();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    private static void gatherWorldAcceleratorBlacklist() {
        if (!gatheredClasses) {
            for (String name : ConfigHolder.machines.worldAcceleratorBlacklist) {
                if (blacklistedClasses.containsKey(name)) continue;
                try {
                    blacklistedClasses.put(name, Class.forName(name));
                }
                catch (ClassNotFoundException ignored) {
                    GTLog.logger.warn("Could not find class {} for World Accelerator Blacklist!", (Object)name);
                }
            }
            try {
                String cofhTileClass = "cofh.thermalexpansion.block.device.TileDeviceBase";
                blacklistedClasses.put(cofhTileClass, Class.forName(cofhTileClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            gatheredClasses = true;
        }
    }

    private static boolean canTileAccelerate(TileEntity tile) {
        if (tile instanceof IGregTechTileEntity || tile instanceof TileEntityPipeBase) {
            return false;
        }
        MetaTileEntityWorldAccelerator.gatherWorldAcceleratorBlacklist();
        Class<?> tileClass = tile.getClass();
        if (blacklistCache.containsKey(tileClass)) {
            return blacklistCache.getBoolean(tileClass);
        }
        for (Class<?> clazz : blacklistedClasses.values()) {
            if (!clazz.isAssignableFrom(tileClass)) continue;
            blacklistCache.put(tileClass, false);
            return false;
        }
        blacklistCache.put(tileClass, true);
        return true;
    }
}

