/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.FluidContainerSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomTankWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityPump
extends TieredMetaTileEntity {
    private static final Cuboid6 PIPE_CUBOID = new Cuboid6(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final int BASE_PUMP_RANGE = 32;
    private static final int EXTRA_PUMP_RANGE = 8;
    private static final int PUMP_SPEED_BASE = 80;
    private final Deque<BlockPos> fluidSourceBlocks = new ArrayDeque<BlockPos>();
    private final Deque<BlockPos> blocksToCheck = new ArrayDeque<BlockPos>();
    private boolean initializedQueue = false;
    private int pumpHeadY;
    @Nullable
    private FluidStack lockedFluid;
    private boolean locked = false;

    public MetaTileEntityPump(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPump(this.metaTileEntityId, this.getTier());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        ColourMultiplier multiplier = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()));
        IVertexOperation[] coloredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)multiplier);
        for (EnumFacing renderSide : EnumFacing.field_176754_o) {
            if (renderSide == this.getFrontFacing()) {
                Textures.PIPE_OUT_OVERLAY.renderSided(renderSide, renderState, translation, pipeline);
                continue;
            }
            Textures.ADV_PUMP_OVERLAY.renderSided(renderSide, renderState, translation, coloredPipeline);
        }
        Textures.SCREEN.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        Textures.PIPE_IN_OVERLAY.renderSided(EnumFacing.DOWN, renderState, translation, pipeline);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.pumpHeadY);
        buf.writeBoolean(this.locked);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.pumpHeadY = buf.func_150792_a();
        this.locked = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.PUMP_HEAD_LEVEL) {
            this.pumpHeadY = buf.func_150792_a();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{new FluidTank(16000 * Math.max(1, this.getTier()))});
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new GTItemStackHandler((MetaTileEntity)this, 1);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new GTItemStackHandler((MetaTileEntity)this, 1);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        return (T)(side == null || side.func_176740_k() != EnumFacing.Axis.Y ? super.getCapability(capability, side) : null);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        WidgetGroup tankDisplay = new WidgetGroup();
        tankDisplay.addWidget(new ImageWidget(7, 16, 81, 46, GuiTextures.DISPLAY));
        tankDisplay.addWidget(new FluidContainerSlotWidget(this.importItems, 0, 90, 16, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY));
        tankDisplay.addWidget(new SlotWidget((IItemHandler)this.exportItems, 0, 90, 44, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY));
        tankDisplay.addWidget(new ToggleButtonWidget(7, 64, 18, 18, GuiTextures.BUTTON_LOCK, this::isLocked, this::setLocked).setTooltipText("gregtech.gui.fluid_lock.tooltip", new Object[0]).shouldUseBaseBackground());
        TankWidget tankWidget = new PhantomTankWidget(this.exportFluids.getTankAt(0), 67, 41, 18, 18, () -> this.lockedFluid, fs -> {
            if (this.exportFluids.getTankAt(0).getFluidAmount() != 0) {
                return;
            }
            if (fs == null) {
                this.setLocked(false);
                this.lockedFluid = null;
            } else {
                this.setLocked(true);
                this.lockedFluid = fs.copy();
                this.lockedFluid.amount = 1;
            }
        }).setDrawHoveringText(false).setAlwaysShowFull(true);
        tankDisplay.addWidget(tankWidget);
        tankDisplay.addWidget(new LabelWidget(6, 6, this.getMetaFullName(), new Object[0]));
        tankDisplay.addWidget(new LabelWidget(11, 20, "gregtech.gui.fluid_amount", 0xFFFFFF));
        tankDisplay.addWidget(new AdvancedTextWidget(11, 30, this.getFluidAmountText(tankWidget), 0xFFFFFF));
        tankDisplay.addWidget(new AdvancedTextWidget(11, 40, this.getFluidNameText(tankWidget), 0xFFFFFF));
        return ModularUI.defaultBuilder().widget(tankDisplay).bindPlayerInventory(entityPlayer.field_71071_by).build(this.getHolder(), entityPlayer);
    }

    private int getMaxPumpRange() {
        return 32 + 8 * this.getTier();
    }

    private boolean isStraightInPumpRange(BlockPos checkPos) {
        BlockPos pos = this.getPos();
        return checkPos.func_177958_n() == pos.func_177958_n() && checkPos.func_177952_p() == pos.func_177952_p() && pos.func_177956_o() < checkPos.func_177956_o() && pos.func_177956_o() + this.pumpHeadY >= checkPos.func_177956_o();
    }

    private void updateQueueState(int blocksToCheckAmount) {
        BlockPos selfPos = this.getPos().func_177979_c(this.pumpHeadY);
        for (int i = 0; i < blocksToCheckAmount; ++i) {
            BlockPos checkPos = null;
            int amountIterated = 0;
            do {
                if (checkPos == null) continue;
                this.blocksToCheck.push(checkPos);
                ++amountIterated;
            } while ((checkPos = this.blocksToCheck.poll()) != null && !this.getWorld().func_175667_e(checkPos) && amountIterated < this.blocksToCheck.size());
            if (checkPos == null) break;
            this.checkFluidBlockAt(selfPos, checkPos);
        }
        if (this.fluidSourceBlocks.isEmpty()) {
            if (this.getOffsetTimer() % 20L == 0L) {
                IBlockState downBlock;
                BlockPos downPos = selfPos.func_177979_c(1);
                if (downPos.func_177956_o() >= 0 && ((downBlock = this.getWorld().func_180495_p(downPos)).func_177230_c() instanceof BlockLiquid || downBlock.func_177230_c() instanceof IFluidBlock || !downBlock.isSideSolid((IBlockAccess)this.getWorld(), downPos, EnumFacing.UP))) {
                    ++this.pumpHeadY;
                }
                this.writeCustomData(GregtechDataCodes.PUMP_HEAD_LEVEL, b -> b.func_150787_b(this.pumpHeadY));
                this.markDirty();
                this.initializedQueue = false;
            }
            if (!this.initializedQueue || this.getOffsetTimer() % 6000L == 0L || this.isFirstTick()) {
                this.initializedQueue = true;
                this.blocksToCheck.add(selfPos);
            }
        }
    }

    private void checkFluidBlockAt(BlockPos pumpHeadPos, BlockPos checkPos) {
        IBlockState blockHere = this.getWorld().func_180495_p(checkPos);
        boolean shouldCheckNeighbours = this.isStraightInPumpRange(checkPos);
        if (blockHere.func_177230_c() instanceof BlockLiquid || blockHere.func_177230_c() instanceof IFluidBlock) {
            IFluidHandler fluidHandler = FluidUtil.getFluidHandler((World)this.getWorld(), (BlockPos)checkPos, null);
            if (fluidHandler == null) {
                return;
            }
            FluidStack drainStack = fluidHandler.drain(Integer.MAX_VALUE, false);
            if (drainStack != null && drainStack.amount > 0 && (this.lockedFluid == null || drainStack.isFluidEqual(this.lockedFluid))) {
                this.fluidSourceBlocks.add(checkPos);
            }
            shouldCheckNeighbours = true;
        }
        if (shouldCheckNeighbours) {
            int maxPumpRange = this.getMaxPumpRange();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos offsetPos = checkPos.func_177972_a(facing);
                if (offsetPos.func_177951_i((Vec3i)pumpHeadPos) > (double)(maxPumpRange * maxPumpRange) || this.fluidSourceBlocks.contains(offsetPos) || this.blocksToCheck.contains(offsetPos)) continue;
                this.blocksToCheck.add(offsetPos);
            }
        }
    }

    private void tryPumpFirstBlock() {
        BlockPos fluidBlockPos = this.fluidSourceBlocks.poll();
        if (fluidBlockPos == null) {
            return;
        }
        IBlockState blockHere = this.getWorld().func_180495_p(fluidBlockPos);
        if (blockHere.func_177230_c() instanceof BlockLiquid || blockHere.func_177230_c() instanceof IFluidBlock) {
            IFluidHandler fluidHandler = FluidUtil.getFluidHandler((World)this.getWorld(), (BlockPos)fluidBlockPos, null);
            if (fluidHandler == null) {
                return;
            }
            FluidStack drainStack = fluidHandler.drain(Integer.MAX_VALUE, false);
            if (drainStack != null && this.exportFluids.fill(drainStack, false) == drainStack.amount) {
                if (this.locked && this.lockedFluid == null) {
                    this.lockedFluid = drainStack.copy();
                    this.lockedFluid.amount = 1;
                }
                if (this.lockedFluid == null || drainStack.isFluidEqual(this.lockedFluid)) {
                    this.exportFluids.fill(drainStack, true);
                    fluidHandler.drain(drainStack.amount, true);
                    this.fluidSourceBlocks.remove(fluidBlockPos);
                    this.energyContainer.changeEnergy(-GTValues.V[this.getTier()] * 2L);
                }
            }
        }
    }

    private boolean isLocked() {
        return this.locked;
    }

    private void setLocked(boolean locked) {
        if (this.locked == locked) {
            return;
        }
        this.locked = locked;
        FluidStack fs = this.exportFluids.getTankAt(0).getFluid();
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
        if (locked && fs != null) {
            this.lockedFluid = fs.copy();
            this.lockedFluid.amount = 1;
            return;
        }
        this.lockedFluid = null;
    }

    private Consumer<List<ITextComponent>> getFluidNameText(TankWidget tankWidget) {
        return list -> {
            TextComponentTranslation translation = tankWidget.getFluidTextComponent();
            if (translation == null) {
                translation = GTUtility.getFluidTranslation(this.lockedFluid);
            }
            if (translation != null) {
                list.add(translation);
            }
        };
    }

    private Consumer<List<ITextComponent>> getFluidAmountText(TankWidget tankWidget) {
        return list -> {
            String fluidAmount = "";
            if (tankWidget.getFormattedFluidAmount().equals("0")) {
                if (this.lockedFluid != null) {
                    fluidAmount = "0";
                }
            } else {
                fluidAmount = tankWidget.getFormattedFluidAmount();
            }
            if (!fluidAmount.isEmpty()) {
                list.add(new TextComponentString(fluidAmount));
            }
        };
    }

    @Override
    public void update() {
        super.update();
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.pushFluidsIntoNearbyHandlers(this.getFrontFacing());
        this.fillContainerFromInternalTank();
        if (this.energyContainer.getEnergyStored() < GTValues.V[this.getTier()] * 2L) {
            return;
        }
        this.updateQueueState(this.getTier());
        if (this.getOffsetTimer() % (long)this.getPumpingCycleLength() == 0L && !this.fluidSourceBlocks.isEmpty()) {
            this.tryPumpFirstBlock();
        }
    }

    private int getPumpingCycleLength() {
        return 80 / (1 << this.getTier() - 1);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("PumpHeadDepth", this.pumpHeadY);
        data.func_74757_a("IsLocked", this.locked);
        if (this.locked && this.lockedFluid != null) {
            data.func_74782_a("LockedFluid", (NBTBase)this.lockedFluid.writeToNBT(new NBTTagCompound()));
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.pumpHeadY = data.func_74762_e("PumpHeadDepth");
        this.locked = data.func_74767_n("IsLocked");
        this.lockedFluid = this.locked ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)data.func_74775_l("LockedFluid")) : null;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.pump.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.uses_per_op", (Object[])new Object[]{GTValues.V[this.getTier()] * 2L}) + TextFormatting.GRAY + ", " + I18n.func_135052_a((String)"gregtech.machine.pump.tooltip_buckets", (Object[])new Object[]{this.getPumpingCycleLength()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.exportFluids.getTankAt(0).getCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.working_area", (Object[])new Object[]{this.getMaxPumpRange(), this.getMaxPumpRange()}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }
}

