/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.IPassthroughHatch;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.util.Mods;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.PipelineUtil;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityHull
extends MetaTileEntityMultiblockPart
implements IPassthroughHatch,
IMultiblockAbilityPart<IPassthroughHatch> {
    protected IEnergyContainer energyContainer;
    private AENetworkProxy gridProxy;

    public MetaTileEntityHull(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.reinitializeEnergyContainer();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityHull(this.metaTileEntityId, this.getTier());
    }

    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        this.energyContainer = new EnergyContainerHandler(this, tierVoltage * 16L, tierVoltage, 1L, tierVoltage, 1L);
        ((EnergyContainerHandler)this.energyContainer).setSideOutputCondition(s -> s == this.getFrontFacing());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.ENERGY_OUT.renderSided(this.getFrontFacing(), renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier()]));
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return true;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        String tierName = GTValues.VNF[this.getTier()];
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.hull.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in_out", (Object[])new Object[]{this.energyContainer.getInputVoltage(), tierName}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_in_out", (Object[])new Object[]{1}));
    }

    @Override
    public void update() {
        super.update();
        if (this.isFirstTick() && Mods.AppliedEnergistics2.isModLoaded() && this.getProxy() != null) {
            this.getProxy().onReady();
        }
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    @NotNull
    public AECableType getCableConnectionType(@NotNull AEPartLocation part) {
        return AECableType.SMART;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    @Nullable
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null && this.getHolder() instanceof MetaTileEntityHolder) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)((MetaTileEntityHolder)this.getHolder()), "proxy", this.getStackForm(), true);
        }
        return this.gridProxy;
    }

    @Override
    public MultiblockAbility<IPassthroughHatch> getAbility() {
        return MultiblockAbility.PASSTHROUGH_HATCH;
    }

    @Override
    public void registerAbilities(@NotNull AbilityInstances abilityInstances) {
        abilityInstances.add(this);
    }

    @Override
    @NotNull
    public Class<?> getPassthroughType() {
        return IEnergyContainer.class;
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }
}

