/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.layout.Grid;
import gregtech.api.GTValues;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.util.GTTransferUtils;
import gregtech.client.renderer.texture.Textures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityFisher
extends TieredMetaTileEntity {
    private static final int WATER_CHECK_SIZE = 25;
    private final int inventorySize;
    private final long fishingTicks;
    private final long energyAmountPerFish;

    public MetaTileEntityFisher(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.inventorySize = (tier + 1) * (tier + 1);
        this.fishingTicks = 1000L - (long)tier * 200L;
        this.energyAmountPerFish = GTValues.V[tier];
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityFisher(this.metaTileEntityId, this.getTier());
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager guiSyncManager) {
        int rowSize = (int)Math.sqrt(this.inventorySize);
        guiSyncManager.registerSlotGroup("item_in", 1);
        guiSyncManager.registerSlotGroup("item_out", rowSize);
        ArrayList widgets = new ArrayList();
        for (int i = 0; i < rowSize; ++i) {
            widgets.add(new ArrayList());
            for (int j = 0; j < rowSize; ++j) {
                int index = i * rowSize + j;
                ((List)widgets.get(i)).add(new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.exportItems, (int)index).slotGroup("item_out").accessibility(false, true)));
            }
        }
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, 176, 18 + 18 * rowSize + 94).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.importItems, (int)0).slotGroup("item_in")).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.STRING_SLOT_OVERLAY})).pos(16, 9 * (rowSize + 1)))).child((IWidget)((Grid)((Grid)((Grid)new Grid().top(18)).alignX(0.5f)).height(rowSize * 18)).minElementMargin(0, 0).minColWidth(18).minRowHeight(18).matrix(widgets));
    }

    @Override
    public void update() {
        super.update();
        ItemStack baitStack = this.importItems.getStackInSlot(0);
        if (!this.getWorld().field_72995_K && this.energyContainer.getEnergyStored() >= this.energyAmountPerFish && this.getOffsetTimer() % this.fishingTicks == 0L && !baitStack.func_190926_b()) {
            LootTable table;
            List itemStacks;
            WorldServer world = (WorldServer)this.getWorld();
            int waterCount = 0;
            int edgeSize = (int)Math.sqrt(25.0);
            for (int x = 0; x < edgeSize; ++x) {
                for (int z = 0; z < edgeSize; ++z) {
                    BlockPos waterCheckPos = this.getPos().func_177977_b().func_177982_a(x - edgeSize / 2, 0, z - edgeSize / 2);
                    if (!(world.func_180495_p(waterCheckPos).func_177230_c() instanceof BlockLiquid) || world.func_180495_p(waterCheckPos).func_185904_a() != Material.field_151586_h) continue;
                    ++waterCount;
                }
            }
            if (waterCount == 25 && GTTransferUtils.addItemsToItemHandler((IItemHandler)this.exportItems, true, itemStacks = (table = world.func_184146_ak().func_186521_a(LootTableList.field_186387_al)).func_186462_a(world.field_73012_v, new LootContext.Builder(world).func_186471_a()))) {
                GTTransferUtils.addItemsToItemHandler((IItemHandler)this.exportItems, false, itemStacks);
                this.energyContainer.removeEnergy(this.energyAmountPerFish);
                baitStack.func_190918_g(1);
            }
        }
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 5L == 0L) {
            this.pushItemsIntoNearbyHandlers(this.getFrontFacing());
        }
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new GTItemStackHandler(this, 1){

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (OreDictUnifier.hasOreDictionary(stack, "string")) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new GTItemStackHandler((MetaTileEntity)this, this.inventorySize);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.SCREEN.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        Textures.PIPE_OUT_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        Textures.PIPE_IN_OVERLAY.renderSided(EnumFacing.DOWN, renderState, translation, pipeline);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fisher.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fisher.speed", (Object[])new Object[]{this.fishingTicks}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fisher.requirement", (Object[])new Object[]{(int)Math.sqrt(25.0), (int)Math.sqrt(25.0)}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
    }

    @Override
    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }
}

