/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.layout.Grid;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.mui.GTGuis;
import gregtech.api.util.BlockUtility;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GregFakePlayer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.RenderUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityBlockBreaker
extends TieredMetaTileEntity {
    private EnumFacing outputFacing;
    private int breakProgressTicksLeft;
    private float currentBlockHardness;

    public MetaTileEntityBlockBreaker(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityBlockBreaker(this.metaTileEntityId, this.getTier());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.ROCK_BREAKER_OVERLAY.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), false, false);
        Textures.PIPE_OUT_OVERLAY.renderSided(this.getOutputFacing(), renderState, RenderUtil.adjustTrans(translation, this.getOutputFacing(), 2), pipeline);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 5L == 0L) {
            this.pushItemsIntoNearbyHandlers(this.getOutputFacing());
        }
        if (!this.getWorld().field_72995_K) {
            float hardness;
            FakePlayer entityPlayer;
            IBlockState blockState;
            BlockPos blockPos;
            if (this.breakProgressTicksLeft > 0) {
                --this.breakProgressTicksLeft;
                if (this.breakProgressTicksLeft == 0 && this.energyContainer.getEnergyStored() >= (long)this.getEnergyPerBlockBreak()) {
                    blockPos = this.getPos().func_177972_a(this.getFrontFacing());
                    blockState = this.getWorld().func_180495_p(blockPos);
                    entityPlayer = GregFakePlayer.get((WorldServer)this.getWorld());
                    hardness = blockState.func_185887_b(this.getWorld(), blockPos);
                    if (hardness >= 0.0f && this.getWorld().func_175660_a((EntityPlayer)entityPlayer, blockPos) && Math.abs(hardness - this.currentBlockHardness) < 0.5f) {
                        List<ItemStack> drops = this.attemptBreakBlockAndObtainDrops(blockPos, blockState, (EntityPlayer)entityPlayer);
                        this.addToInventoryOrDropItems(drops);
                    }
                    this.breakProgressTicksLeft = 0;
                    this.currentBlockHardness = 0.0f;
                    this.energyContainer.removeEnergy(this.getEnergyPerBlockBreak());
                }
            }
            if (this.breakProgressTicksLeft == 0 && this.isBlockRedstonePowered()) {
                boolean skipBlock;
                blockPos = this.getPos().func_177972_a(this.getFrontFacing());
                blockState = this.getWorld().func_180495_p(blockPos);
                entityPlayer = GregFakePlayer.get((WorldServer)this.getWorld());
                hardness = blockState.func_185887_b(this.getWorld(), blockPos);
                boolean bl = skipBlock = blockState.func_185904_a() == Material.field_151579_a || blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.getWorld(), this.getPos());
                if (hardness >= 0.0f && !skipBlock && this.getWorld().func_175660_a((EntityPlayer)entityPlayer, blockPos)) {
                    this.breakProgressTicksLeft = this.getTicksPerBlockBreak(hardness);
                    this.currentBlockHardness = hardness;
                }
            }
        }
    }

    private void addToInventoryOrDropItems(List<ItemStack> drops) {
        EnumFacing outputFacing = this.getOutputFacing();
        double itemSpawnX = (double)this.getPos().func_177958_n() + 0.5 + (double)outputFacing.func_82601_c();
        double itemSpawnY = (double)this.getPos().func_177956_o() + 0.5 + (double)outputFacing.func_96559_d();
        double itemSpawnZ = (double)this.getPos().func_177952_p() + 0.5 + (double)outputFacing.func_82599_e();
        for (ItemStack itemStack : drops) {
            ItemStack remainStack = GTTransferUtils.insertItem((IItemHandler)this.exportItems, itemStack, false);
            if (remainStack.func_190926_b()) continue;
            EntityItem entityitem = new EntityItem(this.getWorld(), itemSpawnX, itemSpawnY, itemSpawnZ, remainStack);
            entityitem.func_174869_p();
            this.getWorld().func_72838_d((Entity)entityitem);
        }
    }

    private List<ItemStack> attemptBreakBlockAndObtainDrops(BlockPos blockPos, IBlockState blockState, EntityPlayer entityPlayer) {
        TileEntity tileEntity = this.getWorld().func_175625_s(blockPos);
        boolean result = blockState.func_177230_c().removedByPlayer(blockState, this.getWorld(), blockPos, entityPlayer, true);
        if (result) {
            this.getWorld().func_180498_a(null, 2001, blockPos, Block.func_176210_f((IBlockState)blockState));
            blockState.func_177230_c().func_176206_d(this.getWorld(), blockPos, blockState);
            BlockUtility.startCaptureDrops();
            blockState.func_177230_c().func_180657_a(this.getWorld(), entityPlayer, blockPos, blockState, tileEntity, ItemStack.field_190927_a);
            return BlockUtility.stopCaptureDrops();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            EnumFacing currentOutputSide = this.getOutputFacing();
            if (currentOutputSide == facing || this.getFrontFacing() == facing) {
                return false;
            }
            this.setOutputFacing(facing);
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("OutputFacing", this.getOutputFacing().func_176745_a());
        data.func_74768_a("BlockBreakProgress", this.breakProgressTicksLeft);
        data.func_74776_a("BlockHardness", this.currentBlockHardness);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.outputFacing = EnumFacing.field_82609_l[data.func_74762_e("OutputFacing")];
        this.breakProgressTicksLeft = data.func_74762_e("BlockBreakProgress");
        this.currentBlockHardness = data.func_74760_g("BlockHardness");
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte(this.getOutputFacing().func_176745_a());
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_OUTPUT_FACING) {
            this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return super.isValidFrontFacing(facing) && facing != this.outputFacing;
    }

    public EnumFacing getOutputFacing() {
        return this.outputFacing == null ? EnumFacing.SOUTH : this.outputFacing;
    }

    public void setOutputFacing(EnumFacing outputFacing) {
        this.outputFacing = outputFacing;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(GregtechDataCodes.UPDATE_OUTPUT_FACING, buf -> buf.writeByte(outputFacing.func_176745_a()));
            this.markDirty();
        }
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(frontFacing);
        if (this.outputFacing == null) {
            this.setOutputFacing(frontFacing.func_176734_d());
        }
    }

    private int getEnergyPerBlockBreak() {
        return (int)GTValues.V[this.getTier()];
    }

    private int getInventorySize() {
        int sizeRoot = 1 + this.getTier();
        return sizeRoot * sizeRoot;
    }

    private int getTicksPerBlockBreak(float blockHardness) {
        int ticksPerOneDurability = 5;
        int totalTicksPerBlock = (int)Math.ceil((float)ticksPerOneDurability * blockHardness);
        float efficiencyMultiplier = 1.0f - this.getEfficiencyMultiplier();
        return (int)Math.ceil((float)totalTicksPerBlock * efficiencyMultiplier);
    }

    private float getEfficiencyMultiplier() {
        return 1.0f - MathHelper.func_76131_a((float)(1.0f - 0.2f * ((float)this.getTier() - 1.0f)), (float)0.1f, (float)1.0f);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new GTItemStackHandler((MetaTileEntity)this, this.getInventorySize());
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager guiSyncManager) {
        int rowSize = (int)Math.sqrt(this.getInventorySize());
        guiSyncManager.registerSlotGroup("item_inv", rowSize);
        ArrayList widgets = new ArrayList();
        for (int i = 0; i < rowSize; ++i) {
            widgets.add(new ArrayList());
            for (int j = 0; j < rowSize; ++j) {
                int index = i * rowSize + j;
                ((List)widgets.get(i)).add(new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.exportItems, (int)index).slotGroup("item_inv").accessibility(false, true)));
            }
        }
        return (ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, 176, 18 + 18 * rowSize + 94).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((Grid)((Grid)((Grid)new Grid().top(18)).height(rowSize * 18)).minElementMargin(0, 0).minColWidth(18).minRowHeight(18).alignX(0.5f)).matrix(widgets));
    }

    @Override
    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.block_breaker.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.uses_per_op", (Object[])new Object[]{this.getEnergyPerBlockBreak()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])new Object[]{this.getInventorySize()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.block_breaker.speed_bonus", (Object[])new Object[]{(int)(this.getEfficiencyMultiplier() * 100.0f)}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.requires_redstone", (Object[])new Object[0]));
    }

    @Override
    public boolean needsSneakToRotate() {
        return true;
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }
}

