/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.layout.Grid;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.impl.EnergyContainerBatteryBuffer;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.PipelineUtil;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityBatteryBuffer
extends TieredMetaTileEntity
implements IControllable,
IDataInfoProvider {
    private final int inventorySize;
    private boolean allowEnergyOutput = true;

    public MetaTileEntityBatteryBuffer(ResourceLocation metaTileEntityId, int tier, int inventorySize) {
        super(metaTileEntityId, tier);
        this.inventorySize = inventorySize;
        this.initializeInventory();
        this.reinitializeEnergyContainer();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityBatteryBuffer(this.metaTileEntityId, this.getTier(), this.inventorySize);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.ENERGY_OUT.renderSided(this.getFrontFacing(), renderState, translation, PipelineUtil.color(pipeline, GTValues.VC[this.getTier()]));
    }

    @Override
    protected void reinitializeEnergyContainer() {
        this.energyContainer = new EnergyContainerBatteryBuffer(this, this.getTier(), this.inventorySize);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.allowEnergyOutput;
    }

    @Override
    protected boolean shouldUpdate(MTETrait trait) {
        return !(trait instanceof EnergyContainerBatteryBuffer) || this.allowEnergyOutput;
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.allowEnergyOutput = isActivationAllowed;
        this.notifyBlockUpdate();
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return true;
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(this.inventorySize){

            protected void onContentsChanged(int slot) {
                ((EnergyContainerBatteryBuffer)MetaTileEntityBatteryBuffer.this.energyContainer).notifyEnergyListener(false);
                MetaTileEntityBatteryBuffer.this.markDirty();
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
                if (electricItem != null && MetaTileEntityBatteryBuffer.this.getTier() >= electricItem.getTier() || ConfigHolder.compat.energy.nativeEUToFE && stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.itemInventory = this.importItems;
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager guiSyncManager) {
        int rowSize;
        int colSize = rowSize = (int)Math.sqrt(this.inventorySize);
        if (this.inventorySize == 8) {
            rowSize = 4;
            colSize = 2;
        }
        guiSyncManager.registerSlotGroup("item_inv", rowSize);
        int index = 0;
        ArrayList widgets = new ArrayList();
        for (int y = 0; y < colSize; ++y) {
            widgets.add(new ArrayList());
            for (int x = 0; x < rowSize; ++x) {
                ((List)widgets.get(y)).add(new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.importItems, (int)index++).slotGroup("item_inv")).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.BATTERY_OVERLAY}));
            }
        }
        return (ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPanel(this, 176, 18 + 18 * colSize + 94).child((IWidget)IKey.lang((String)this.getMetaFullName()).asWidget().pos(5, 5))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().left(7)).bottom(7))).child((IWidget)((Grid)((Grid)((Grid)((Grid)new Grid().top(18)).height(colSize * 18)).width(rowSize * 18)).minElementMargin(0, 0).minColWidth(18).minRowHeight(18).alignX(0.5f)).matrix(widgets));
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        String tierName = GTValues.VNF[this.getTier()];
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])new Object[]{this.inventorySize}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in_out", (Object[])new Object[]{this.energyContainer.getInputVoltage(), tierName}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_in_till", (Object[])new Object[]{this.energyContainer.getInputAmperage()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_out_till", (Object[])new Object[]{this.energyContainer.getOutputAmperage()}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.soft_mallet.reset", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        NBTTagCompound tagCompound = super.writeToNBT(data);
        tagCompound.func_74757_a("AllowEnergyOutput", this.allowEnergyOutput);
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_150297_b("AllowEnergyOutput", 99)) {
            this.allowEnergyOutput = data.func_74767_n("AllowEnergyOutput");
        }
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new TextComponentTranslation("gregtech.battery_buffer.average_input", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.energyContainer.getInputPerSec() / 20L), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
        list.add((ITextComponent)new TextComponentTranslation("gregtech.battery_buffer.average_output", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers(this.energyContainer.getOutputPerSec() / 20L), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
        return list;
    }
}

