/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.FeCompat;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Mods;
import gregtech.client.particle.VanillaParticleEffects;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.MetaTileEntityClipboard;
import gregtech.common.metatileentities.converter.MetaTileEntityConverter;
import gregtech.common.metatileentities.electric.MetaTileEntityAlarm;
import gregtech.common.metatileentities.electric.MetaTileEntityBatteryBuffer;
import gregtech.common.metatileentities.electric.MetaTileEntityBlockBreaker;
import gregtech.common.metatileentities.electric.MetaTileEntityCharger;
import gregtech.common.metatileentities.electric.MetaTileEntityDiode;
import gregtech.common.metatileentities.electric.MetaTileEntityFisher;
import gregtech.common.metatileentities.electric.MetaTileEntityGasCollector;
import gregtech.common.metatileentities.electric.MetaTileEntityHull;
import gregtech.common.metatileentities.electric.MetaTileEntityItemCollector;
import gregtech.common.metatileentities.electric.MetaTileEntityMagicEnergyAbsorber;
import gregtech.common.metatileentities.electric.MetaTileEntityMiner;
import gregtech.common.metatileentities.electric.MetaTileEntityPump;
import gregtech.common.metatileentities.electric.MetaTileEntityRockBreaker;
import gregtech.common.metatileentities.electric.MetaTileEntitySingleCombustion;
import gregtech.common.metatileentities.electric.MetaTileEntitySingleTurbine;
import gregtech.common.metatileentities.electric.MetaTileEntityTransformer;
import gregtech.common.metatileentities.electric.MetaTileEntityWorldAccelerator;
import gregtech.common.metatileentities.electric.SimpleMachineMetaTileEntityResizable;
import gregtech.common.metatileentities.multi.BoilerType;
import gregtech.common.metatileentities.multi.MetaTileEntityCokeOven;
import gregtech.common.metatileentities.multi.MetaTileEntityCokeOvenHatch;
import gregtech.common.metatileentities.multi.MetaTileEntityLargeBoiler;
import gregtech.common.metatileentities.multi.MetaTileEntityMultiblockTank;
import gregtech.common.metatileentities.multi.MetaTileEntityPrimitiveBlastFurnace;
import gregtech.common.metatileentities.multi.MetaTileEntityPrimitiveWaterPump;
import gregtech.common.metatileentities.multi.MetaTileEntityPumpHatch;
import gregtech.common.metatileentities.multi.MetaTileEntityTankValve;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityActiveTransformer;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityAssemblyLine;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityCleanroom;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityCrackingUnit;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityDataBank;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityDistillationTower;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityElectricBlastFurnace;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityFluidDrill;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityFusionReactor;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityHPCA;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityImplosionCompressor;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityLargeChemicalReactor;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityLargeMiner;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityMultiSmelter;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityNetworkSwitch;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityPowerSubstation;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityProcessingArray;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityPyrolyseOven;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityResearchStation;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityVacuumFreezer;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityCentralMonitor;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityMonitorScreen;
import gregtech.common.metatileentities.multi.electric.generator.MetaTileEntityLargeCombustionEngine;
import gregtech.common.metatileentities.multi.electric.generator.MetaTileEntityLargeTurbine;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityAutoMaintenanceHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityCleaningMaintenanceHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityComputationHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityDataAccessHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityEnergyHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityFluidHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityItemBus;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityLaserHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMachineHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMaintenanceHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMufflerHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiFluidHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityObjectHolder;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityOpticalDataHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityPassthroughHatchFluid;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityPassthroughHatchItem;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityReservoirHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityRotorHolder;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntitySubstationEnergyHatch;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityMEInputBus;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityMEInputHatch;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityMEOutputBus;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityMEOutputHatch;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityMEStockingBus;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityMEStockingHatch;
import gregtech.common.metatileentities.multi.multiblockpart.hpca.MetaTileEntityHPCABridge;
import gregtech.common.metatileentities.multi.multiblockpart.hpca.MetaTileEntityHPCAComputation;
import gregtech.common.metatileentities.multi.multiblockpart.hpca.MetaTileEntityHPCACooler;
import gregtech.common.metatileentities.multi.multiblockpart.hpca.MetaTileEntityHPCAEmpty;
import gregtech.common.metatileentities.multi.steam.MetaTileEntitySteamGrinder;
import gregtech.common.metatileentities.multi.steam.MetaTileEntitySteamOven;
import gregtech.common.metatileentities.primitive.MetaTileEntityCharcoalPileIgniter;
import gregtech.common.metatileentities.steam.SteamAlloySmelter;
import gregtech.common.metatileentities.steam.SteamCompressor;
import gregtech.common.metatileentities.steam.SteamExtractor;
import gregtech.common.metatileentities.steam.SteamFurnace;
import gregtech.common.metatileentities.steam.SteamHammer;
import gregtech.common.metatileentities.steam.SteamMacerator;
import gregtech.common.metatileentities.steam.SteamMiner;
import gregtech.common.metatileentities.steam.SteamRockBreaker;
import gregtech.common.metatileentities.steam.boiler.SteamCoalBoiler;
import gregtech.common.metatileentities.steam.boiler.SteamLavaBoiler;
import gregtech.common.metatileentities.steam.boiler.SteamSolarBoiler;
import gregtech.common.metatileentities.steam.multiblockpart.MetaTileEntitySteamHatch;
import gregtech.common.metatileentities.steam.multiblockpart.MetaTileEntitySteamItemBus;
import gregtech.common.metatileentities.storage.MetaTileEntityBuffer;
import gregtech.common.metatileentities.storage.MetaTileEntityCrate;
import gregtech.common.metatileentities.storage.MetaTileEntityCreativeChest;
import gregtech.common.metatileentities.storage.MetaTileEntityCreativeEnergy;
import gregtech.common.metatileentities.storage.MetaTileEntityCreativeTank;
import gregtech.common.metatileentities.storage.MetaTileEntityDrum;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumChest;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumExtender;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumProxy;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumStorageController;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumTank;
import gregtech.common.metatileentities.storage.MetaTileEntityWorkbench;
import gregtech.common.pipelike.fluidpipe.longdistance.MetaTileEntityLDFluidEndpoint;
import gregtech.common.pipelike.itempipe.longdistance.MetaTileEntityLDItemEndpoint;
import net.minecraft.util.ResourceLocation;

final class MetaTileEntityRegistration {
    private MetaTileEntityRegistration() {
    }

    static void register() {
        MetaTileEntityRegistration.standardSingleblocks();
        MetaTileEntityRegistration.miscSingleblocks();
        MetaTileEntityRegistration.multiblocks();
        MetaTileEntityRegistration.multiblockParts();
    }

    private static void standardSingleblocks() {
        MetaTileEntities.STEAM_BOILER_COAL_BRONZE = MetaTileEntities.registerMetaTileEntity(1, new SteamCoalBoiler(GTUtility.gregtechId("steam_boiler_coal_bronze"), false));
        MetaTileEntities.STEAM_BOILER_COAL_STEEL = MetaTileEntities.registerMetaTileEntity(2, new SteamCoalBoiler(GTUtility.gregtechId("steam_boiler_coal_steel"), true));
        MetaTileEntities.STEAM_BOILER_SOLAR_BRONZE = MetaTileEntities.registerMetaTileEntity(3, new SteamSolarBoiler(GTUtility.gregtechId("steam_boiler_solar_bronze"), false));
        MetaTileEntities.STEAM_BOILER_SOLAR_STEEL = MetaTileEntities.registerMetaTileEntity(4, new SteamSolarBoiler(GTUtility.gregtechId("steam_boiler_solar_steel"), true));
        MetaTileEntities.STEAM_BOILER_LAVA_BRONZE = MetaTileEntities.registerMetaTileEntity(5, new SteamLavaBoiler(GTUtility.gregtechId("steam_boiler_lava_bronze"), false));
        MetaTileEntities.STEAM_BOILER_LAVA_STEEL = MetaTileEntities.registerMetaTileEntity(6, new SteamLavaBoiler(GTUtility.gregtechId("steam_boiler_lava_steel"), true));
        MetaTileEntities.STEAM_EXTRACTOR_BRONZE = MetaTileEntities.registerMetaTileEntity(7, new SteamExtractor(GTUtility.gregtechId("steam_extractor_bronze"), false));
        MetaTileEntities.STEAM_EXTRACTOR_STEEL = MetaTileEntities.registerMetaTileEntity(8, new SteamExtractor(GTUtility.gregtechId("steam_extractor_steel"), true));
        MetaTileEntities.STEAM_MACERATOR_BRONZE = MetaTileEntities.registerMetaTileEntity(9, new SteamMacerator(GTUtility.gregtechId("steam_macerator_bronze"), false));
        MetaTileEntities.STEAM_MACERATOR_STEEL = MetaTileEntities.registerMetaTileEntity(10, new SteamMacerator(GTUtility.gregtechId("steam_macerator_steel"), true));
        MetaTileEntities.STEAM_COMPRESSOR_BRONZE = MetaTileEntities.registerMetaTileEntity(11, new SteamCompressor(GTUtility.gregtechId("steam_compressor_bronze"), false));
        MetaTileEntities.STEAM_COMPRESSOR_STEEL = MetaTileEntities.registerMetaTileEntity(12, new SteamCompressor(GTUtility.gregtechId("steam_compressor_steel"), true));
        MetaTileEntities.STEAM_HAMMER_BRONZE = MetaTileEntities.registerMetaTileEntity(13, new SteamHammer(GTUtility.gregtechId("steam_hammer_bronze"), false));
        MetaTileEntities.STEAM_HAMMER_STEEL = MetaTileEntities.registerMetaTileEntity(14, new SteamHammer(GTUtility.gregtechId("steam_hammer_steel"), true));
        MetaTileEntities.STEAM_FURNACE_BRONZE = MetaTileEntities.registerMetaTileEntity(15, new SteamFurnace(GTUtility.gregtechId("steam_furnace_bronze"), false));
        MetaTileEntities.STEAM_FURNACE_STEEL = MetaTileEntities.registerMetaTileEntity(16, new SteamFurnace(GTUtility.gregtechId("steam_furnace_steel"), true));
        MetaTileEntities.STEAM_ALLOY_SMELTER_BRONZE = MetaTileEntities.registerMetaTileEntity(17, new SteamAlloySmelter(GTUtility.gregtechId("steam_alloy_smelter_bronze"), false));
        MetaTileEntities.STEAM_ALLOY_SMELTER_STEEL = MetaTileEntities.registerMetaTileEntity(18, new SteamAlloySmelter(GTUtility.gregtechId("steam_alloy_smelter_steel"), true));
        MetaTileEntities.STEAM_ROCK_BREAKER_BRONZE = MetaTileEntities.registerMetaTileEntity(19, new SteamRockBreaker(GTUtility.gregtechId("steam_rock_breaker_bronze"), false));
        MetaTileEntities.STEAM_ROCK_BREAKER_STEEL = MetaTileEntities.registerMetaTileEntity(20, new SteamRockBreaker(GTUtility.gregtechId("steam_rock_breaker_steel"), true));
        MetaTileEntities.STEAM_MINER = MetaTileEntities.registerMetaTileEntity(21, new SteamMiner(GTUtility.gregtechId("steam_miner"), 320, 4, 0));
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.ELECTRIC_FURNACE, 50, "electric_furnace", RecipeMaps.FURNACE_RECIPES, Textures.ELECTRIC_FURNACE_OVERLAY, true);
        MetaTileEntities.registerMetaTileEntities(MetaTileEntities.MACERATOR, 65, "macerator", (tier, voltageName) -> {
            int n;
            ResourceLocation resourceLocation = GTUtility.gregtechId(String.format("%s.%s", "macerator", voltageName));
            switch (tier) {
                case 1: 
                case 2: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                default: {
                    n = 4;
                }
            }
            return new SimpleMachineMetaTileEntityResizable(resourceLocation, RecipeMaps.MACERATOR_RECIPES, -1, n, tier <= 2 ? Textures.MACERATOR_OVERLAY : Textures.PULVERIZER_OVERLAY, (int)tier, true, GTUtility.defaultTankSizeFunction, VanillaParticleEffects.TOP_SMOKE_SMALL, null);
        });
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.ALLOY_SMELTER, 80, "alloy_smelter", RecipeMaps.ALLOY_SMELTER_RECIPES, Textures.ALLOY_SMELTER_OVERLAY, true);
        MetaTileEntities.registerMetaTileEntities(MetaTileEntities.ARC_FURNACE, 95, "arc_furnace", (tier, voltageName) -> new SimpleMachineMetaTileEntityResizable(GTUtility.gregtechId(String.format("%s.%s", "arc_furnace", voltageName)), (RecipeMap<?>)RecipeMaps.ARC_FURNACE_RECIPES, -1, tier >= 4 ? 9 : 4, Textures.ARC_FURNACE_OVERLAY, (int)tier, false, GTUtility.hvCappedTankSizeFunction));
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.ASSEMBLER, 110, "assembler", RecipeMaps.ASSEMBLER_RECIPES, Textures.ASSEMBLER_OVERLAY, true, GTUtility.hvCappedTankSizeFunction);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.AUTOCLAVE, 125, "autoclave", RecipeMaps.AUTOCLAVE_RECIPES, Textures.AUTOCLAVE_OVERLAY, false, GTUtility.hvCappedTankSizeFunction);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.BENDER, 140, "bender", RecipeMaps.BENDER_RECIPES, Textures.BENDER_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.BREWERY, 155, "brewery", RecipeMaps.BREWING_RECIPES, Textures.BREWERY_OVERLAY, true, GTUtility.hvCappedTankSizeFunction);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.CANNER, 170, "canner", RecipeMaps.CANNER_RECIPES, Textures.CANNER_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.CENTRIFUGE, 185, "centrifuge", RecipeMaps.CENTRIFUGE_RECIPES, Textures.CENTRIFUGE_OVERLAY, false, GTUtility.largeTankSizeFunction);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.CHEMICAL_BATH, 200, "chemical_bath", RecipeMaps.CHEMICAL_BATH_RECIPES, Textures.CHEMICAL_BATH_OVERLAY, true, GTUtility.hvCappedTankSizeFunction);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.CHEMICAL_REACTOR, 215, "chemical_reactor", RecipeMaps.CHEMICAL_RECIPES, Textures.CHEMICAL_REACTOR_OVERLAY, true, tier -> 16000);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.COMPRESSOR, 230, "compressor", RecipeMaps.COMPRESSOR_RECIPES, Textures.COMPRESSOR_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.CUTTER, 245, "cutter", RecipeMaps.CUTTER_RECIPES, Textures.CUTTER_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.DISTILLERY, 260, "distillery", RecipeMaps.DISTILLERY_RECIPES, Textures.DISTILLERY_OVERLAY, true, GTUtility.hvCappedTankSizeFunction);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.ELECTROLYZER, 275, "electrolyzer", RecipeMaps.ELECTROLYZER_RECIPES, Textures.ELECTROLYZER_OVERLAY, false, GTUtility.largeTankSizeFunction);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.ELECTROMAGNETIC_SEPARATOR, 290, "electromagnetic_separator", RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES, Textures.ELECTROMAGNETIC_SEPARATOR_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.EXTRACTOR, 305, "extractor", RecipeMaps.EXTRACTOR_RECIPES, Textures.EXTRACTOR_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.EXTRUDER, 320, "extruder", RecipeMaps.EXTRUDER_RECIPES, Textures.EXTRUDER_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.FERMENTER, 335, "fermenter", RecipeMaps.FERMENTING_RECIPES, Textures.FERMENTER_OVERLAY, true, GTUtility.hvCappedTankSizeFunction);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.FLUID_HEATER, 380, "fluid_heater", RecipeMaps.FLUID_HEATER_RECIPES, Textures.FLUID_HEATER_OVERLAY, true, GTUtility.hvCappedTankSizeFunction);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.FLUID_SOLIDIFIER, 395, "fluid_solidifier", RecipeMaps.FLUID_SOLIDFICATION_RECIPES, Textures.FLUID_SOLIDIFIER_OVERLAY, true, GTUtility.hvCappedTankSizeFunction);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.FORGE_HAMMER, 410, "forge_hammer", RecipeMaps.FORGE_HAMMER_RECIPES, Textures.FORGE_HAMMER_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.FORMING_PRESS, 425, "forming_press", RecipeMaps.FORMING_PRESS_RECIPES, Textures.FORMING_PRESS_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.LATHE, 440, "lathe", RecipeMaps.LATHE_RECIPES, Textures.LATHE_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.SCANNER, 455, "scanner", RecipeMaps.SCANNER_RECIPES, Textures.SCANNER_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.MIXER, 470, "mixer", RecipeMaps.MIXER_RECIPES, Textures.MIXER_OVERLAY, false, GTUtility.hvCappedTankSizeFunction);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.ORE_WASHER, 485, "ore_washer", RecipeMaps.ORE_WASHER_RECIPES, Textures.ORE_WASHER_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.PACKER, 500, "packer", RecipeMaps.PACKER_RECIPES, Textures.PACKER_OVERLAY, true);
        MetaTileEntities.registerMetaTileEntities(MetaTileEntities.GAS_COLLECTOR, 530, "gas_collector", (tier, voltageName) -> new MetaTileEntityGasCollector(GTUtility.gregtechId(String.format("%s.%s", "gas_collector", voltageName)), RecipeMaps.GAS_COLLECTOR_RECIPES, (ICubeRenderer)Textures.GAS_COLLECTOR_OVERLAY, (int)tier, false, GTUtility.largeTankSizeFunction));
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.POLARIZER, 545, "polarizer", RecipeMaps.POLARIZER_RECIPES, Textures.POLARIZER_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.LASER_ENGRAVER, 560, "laser_engraver", RecipeMaps.LASER_ENGRAVER_RECIPES, Textures.LASER_ENGRAVER_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.SIFTER, 575, "sifter", RecipeMaps.SIFTER_RECIPES, Textures.SIFTER_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.THERMAL_CENTRIFUGE, 605, "thermal_centrifuge", RecipeMaps.THERMAL_CENTRIFUGE_RECIPES, Textures.THERMAL_CENTRIFUGE_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.WIREMILL, 620, "wiremill", RecipeMaps.WIREMILL_RECIPES, Textures.WIREMILL_OVERLAY, true);
        MetaTileEntities.registerSimpleMetaTileEntity(MetaTileEntities.CIRCUIT_ASSEMBLER, 635, "circuit_assembler", RecipeMaps.CIRCUIT_ASSEMBLER_RECIPES, Textures.CIRCUIT_ASSEMBLER_OVERLAY, true, GTUtility.hvCappedTankSizeFunction);
        MetaTileEntities.registerMetaTileEntities(MetaTileEntities.ROCK_BREAKER, 665, "rock_breaker", (tier, voltageName) -> new MetaTileEntityRockBreaker(GTUtility.gregtechId(String.format("%s.%s", "rock_breaker", voltageName)), RecipeMaps.ROCK_BREAKER_RECIPES, Textures.ROCK_BREAKER_OVERLAY, (int)tier));
        MetaTileEntities.COMBUSTION_GENERATOR[0] = MetaTileEntities.registerMetaTileEntity(935, new MetaTileEntitySingleCombustion(GTUtility.gregtechId("combustion_generator.lv"), RecipeMaps.COMBUSTION_GENERATOR_FUELS, Textures.COMBUSTION_GENERATOR_OVERLAY, 1, GTUtility.genericGeneratorTankSizeFunction));
        MetaTileEntities.COMBUSTION_GENERATOR[1] = MetaTileEntities.registerMetaTileEntity(936, new MetaTileEntitySingleCombustion(GTUtility.gregtechId("combustion_generator.mv"), RecipeMaps.COMBUSTION_GENERATOR_FUELS, Textures.COMBUSTION_GENERATOR_OVERLAY, 2, GTUtility.genericGeneratorTankSizeFunction));
        MetaTileEntities.COMBUSTION_GENERATOR[2] = MetaTileEntities.registerMetaTileEntity(937, new MetaTileEntitySingleCombustion(GTUtility.gregtechId("combustion_generator.hv"), RecipeMaps.COMBUSTION_GENERATOR_FUELS, Textures.COMBUSTION_GENERATOR_OVERLAY, 3, GTUtility.genericGeneratorTankSizeFunction));
        MetaTileEntities.STEAM_TURBINE[0] = MetaTileEntities.registerMetaTileEntity(950, new MetaTileEntitySingleTurbine(GTUtility.gregtechId("steam_turbine.lv"), RecipeMaps.STEAM_TURBINE_FUELS, Textures.STEAM_TURBINE_OVERLAY, 1, GTUtility.steamGeneratorTankSizeFunction));
        MetaTileEntities.STEAM_TURBINE[1] = MetaTileEntities.registerMetaTileEntity(951, new MetaTileEntitySingleTurbine(GTUtility.gregtechId("steam_turbine.mv"), RecipeMaps.STEAM_TURBINE_FUELS, Textures.STEAM_TURBINE_OVERLAY, 2, GTUtility.steamGeneratorTankSizeFunction));
        MetaTileEntities.STEAM_TURBINE[2] = MetaTileEntities.registerMetaTileEntity(952, new MetaTileEntitySingleTurbine(GTUtility.gregtechId("steam_turbine.hv"), RecipeMaps.STEAM_TURBINE_FUELS, Textures.STEAM_TURBINE_OVERLAY, 3, GTUtility.steamGeneratorTankSizeFunction));
        MetaTileEntities.GAS_TURBINE[0] = MetaTileEntities.registerMetaTileEntity(965, new MetaTileEntitySingleTurbine(GTUtility.gregtechId("gas_turbine.lv"), RecipeMaps.GAS_TURBINE_FUELS, Textures.GAS_TURBINE_OVERLAY, 1, GTUtility.genericGeneratorTankSizeFunction));
        MetaTileEntities.GAS_TURBINE[1] = MetaTileEntities.registerMetaTileEntity(966, new MetaTileEntitySingleTurbine(GTUtility.gregtechId("gas_turbine.mv"), RecipeMaps.GAS_TURBINE_FUELS, Textures.GAS_TURBINE_OVERLAY, 2, GTUtility.genericGeneratorTankSizeFunction));
        MetaTileEntities.GAS_TURBINE[2] = MetaTileEntities.registerMetaTileEntity(967, new MetaTileEntitySingleTurbine(GTUtility.gregtechId("gas_turbine.hv"), RecipeMaps.GAS_TURBINE_FUELS, Textures.GAS_TURBINE_OVERLAY, 3, GTUtility.genericGeneratorTankSizeFunction));
        int endPos = GregTechAPI.isHighTier() ? MetaTileEntities.HULL.length : 10;
        for (int i = 0; i < endPos; ++i) {
            MetaTileEntities.HULL[i] = new MetaTileEntityHull(GTUtility.gregtechId("hull." + GTValues.VN[i].toLowerCase()), i);
            MetaTileEntities.registerMetaTileEntity(985 + i, MetaTileEntities.HULL[i]);
        }
    }

    private static void miscSingleblocks() {
        String voltageName;
        int i;
        int endPos = GregTechAPI.isHighTier() ? MetaTileEntities.TRANSFORMER.length - 1 : 8;
        for (i = 0; i <= endPos; ++i) {
            MetaTileEntityTransformer transformer = new MetaTileEntityTransformer(GTUtility.gregtechId("transformer." + GTValues.VN[i].toLowerCase()), i, new int[0]);
            MetaTileEntities.TRANSFORMER[i] = MetaTileEntities.registerMetaTileEntity(1000 + i, transformer);
            MetaTileEntityTransformer adjustableTransformer = new MetaTileEntityTransformer(GTUtility.gregtechId("transformer.hi_amp." + GTValues.VN[i].toLowerCase()), i, 2, 4);
            MetaTileEntities.HI_AMP_TRANSFORMER[i] = MetaTileEntities.registerMetaTileEntity(1015 + i, adjustableTransformer);
            adjustableTransformer = new MetaTileEntityTransformer(GTUtility.gregtechId("transformer.adjustable." + GTValues.VN[i].toLowerCase()), i, 1, 2, 4, 16);
            MetaTileEntities.POWER_TRANSFORMER[i] = MetaTileEntities.registerMetaTileEntity(1030 + i, adjustableTransformer);
        }
        MetaTileEntities.MINER[0] = MetaTileEntities.registerMetaTileEntity(5045, new MetaTileEntityMiner(GTUtility.gregtechId("miner.lv"), 1, 160, 8, 1));
        MetaTileEntities.MINER[1] = MetaTileEntities.registerMetaTileEntity(5046, new MetaTileEntityMiner(GTUtility.gregtechId("miner.mv"), 2, 80, 16, 2));
        MetaTileEntities.MINER[2] = MetaTileEntities.registerMetaTileEntity(5047, new MetaTileEntityMiner(GTUtility.gregtechId("miner.hv"), 3, 40, 24, 3));
        MetaTileEntities.ITEM_COLLECTOR[0] = MetaTileEntities.registerMetaTileEntity(5060, new MetaTileEntityItemCollector(GTUtility.gregtechId("item_collector.lv"), 1, 8));
        MetaTileEntities.ITEM_COLLECTOR[1] = MetaTileEntities.registerMetaTileEntity(5061, new MetaTileEntityItemCollector(GTUtility.gregtechId("item_collector.mv"), 2, 16));
        MetaTileEntities.ITEM_COLLECTOR[2] = MetaTileEntities.registerMetaTileEntity(5062, new MetaTileEntityItemCollector(GTUtility.gregtechId("item_collector.hv"), 3, 32));
        MetaTileEntities.ITEM_COLLECTOR[3] = MetaTileEntities.registerMetaTileEntity(5063, new MetaTileEntityItemCollector(GTUtility.gregtechId("item_collector.ev"), 4, 64));
        MetaTileEntities.QUANTUM_STORAGE_CONTROLLER = MetaTileEntities.registerMetaTileEntity(1075, new MetaTileEntityQuantumStorageController(GTUtility.gregtechId("quantum_storage_controller")));
        MetaTileEntities.QUANTUM_STORAGE_PROXY = MetaTileEntities.registerMetaTileEntity(1076, new MetaTileEntityQuantumProxy(GTUtility.gregtechId("quantum_storage_proxy")));
        MetaTileEntities.QUANTUM_STORAGE_EXTENDER = MetaTileEntities.registerMetaTileEntity(1077, new MetaTileEntityQuantumExtender(GTUtility.gregtechId("quantum_storage_extender")));
        endPos = GregTechAPI.isHighTier() ? MetaTileEntities.DIODES.length - 1 : 10;
        for (i = 0; i < endPos; ++i) {
            String diodeId = "diode." + GTValues.VN[i].toLowerCase();
            MetaTileEntityDiode diode = new MetaTileEntityDiode(GTUtility.gregtechId(diodeId), i, 16);
            MetaTileEntities.DIODES[i] = MetaTileEntities.registerMetaTileEntity(5300 + i, diode);
        }
        endPos = GregTechAPI.isHighTier() ? GTValues.V.length : 10;
        MetaTileEntities.BATTERY_BUFFER[0] = new MetaTileEntityBatteryBuffer[endPos];
        MetaTileEntities.BATTERY_BUFFER[1] = new MetaTileEntityBatteryBuffer[endPos];
        MetaTileEntities.BATTERY_BUFFER[2] = new MetaTileEntityBatteryBuffer[endPos];
        for (i = 0; i < endPos; ++i) {
            String bufferIdBase = "battery_buffer." + GTValues.VN[i].toLowerCase() + ".";
            MetaTileEntities.BATTERY_BUFFER[0][i] = MetaTileEntities.registerMetaTileEntity(5315 + i, new MetaTileEntityBatteryBuffer(GTUtility.gregtechId(bufferIdBase + 4), i, 4));
            MetaTileEntities.BATTERY_BUFFER[1][i] = MetaTileEntities.registerMetaTileEntity(5330 + i, new MetaTileEntityBatteryBuffer(GTUtility.gregtechId(bufferIdBase + 8), i, 8));
            MetaTileEntities.BATTERY_BUFFER[2][i] = MetaTileEntities.registerMetaTileEntity(5345 + i, new MetaTileEntityBatteryBuffer(GTUtility.gregtechId(bufferIdBase + 16), i, 16));
        }
        endPos = GregTechAPI.isHighTier() ? MetaTileEntities.CHARGER.length : 10;
        for (i = 0; i < endPos; ++i) {
            String chargerId = "charger." + GTValues.VN[i].toLowerCase();
            MetaTileEntityCharger charger = new MetaTileEntityCharger(GTUtility.gregtechId(chargerId), i, 4);
            MetaTileEntities.CHARGER[i] = MetaTileEntities.registerMetaTileEntity(5375 + i, charger);
        }
        if (ConfigHolder.machines.enableWorldAccelerators) {
            endPos = 9;
            for (i = 1; i < endPos; ++i) {
                MetaTileEntities.WORLD_ACCELERATOR[i] = MetaTileEntities.registerMetaTileEntity(1390 + i, new MetaTileEntityWorldAccelerator(GTUtility.gregtechId("world_accelerator." + GTValues.VN[i].toLowerCase()), i));
            }
        }
        MetaTileEntities.BUFFER[0] = MetaTileEntities.registerMetaTileEntity(5510, new MetaTileEntityBuffer(GTUtility.gregtechId("buffer.lv"), 1));
        MetaTileEntities.BUFFER[1] = MetaTileEntities.registerMetaTileEntity(5511, new MetaTileEntityBuffer(GTUtility.gregtechId("buffer.mv"), 2));
        MetaTileEntities.BUFFER[2] = MetaTileEntities.registerMetaTileEntity(5512, new MetaTileEntityBuffer(GTUtility.gregtechId("buffer.hv"), 3));
        MetaTileEntities.FISHER[0] = MetaTileEntities.registerMetaTileEntity(5515, new MetaTileEntityFisher(GTUtility.gregtechId("fisher.lv"), 1));
        MetaTileEntities.FISHER[1] = MetaTileEntities.registerMetaTileEntity(5516, new MetaTileEntityFisher(GTUtility.gregtechId("fisher.mv"), 2));
        MetaTileEntities.FISHER[2] = MetaTileEntities.registerMetaTileEntity(5517, new MetaTileEntityFisher(GTUtility.gregtechId("fisher.hv"), 3));
        MetaTileEntities.FISHER[3] = MetaTileEntities.registerMetaTileEntity(5518, new MetaTileEntityFisher(GTUtility.gregtechId("fisher.ev"), 4));
        MetaTileEntities.PUMP[0] = MetaTileEntities.registerMetaTileEntity(1530, new MetaTileEntityPump(GTUtility.gregtechId("pump.lv"), 1));
        MetaTileEntities.PUMP[1] = MetaTileEntities.registerMetaTileEntity(1531, new MetaTileEntityPump(GTUtility.gregtechId("pump.mv"), 2));
        MetaTileEntities.PUMP[2] = MetaTileEntities.registerMetaTileEntity(1532, new MetaTileEntityPump(GTUtility.gregtechId("pump.hv"), 3));
        MetaTileEntities.PUMP[3] = MetaTileEntities.registerMetaTileEntity(1533, new MetaTileEntityPump(GTUtility.gregtechId("pump.ev"), 4));
        for (i = 0; i < 5; ++i) {
            voltageName = GTValues.VN[i + 1].toLowerCase();
            MetaTileEntities.QUANTUM_CHEST[i] = new MetaTileEntityQuantumChest(GTUtility.gregtechId("super_chest." + voltageName), i + 1, 4000000L * (long)((int)Math.pow(2.0, i)));
            MetaTileEntities.registerMetaTileEntity(5560 + i, MetaTileEntities.QUANTUM_CHEST[i]);
        }
        for (i = 5; i < MetaTileEntities.QUANTUM_CHEST.length; ++i) {
            voltageName = GTValues.VN[i].toLowerCase();
            long capacity = i == 9 ? Integer.MAX_VALUE : 4000000L * (long)((int)Math.pow(2.0, i));
            MetaTileEntities.QUANTUM_CHEST[i] = new MetaTileEntityQuantumChest(GTUtility.gregtechId("quantum_chest." + voltageName), i, capacity);
            MetaTileEntities.registerMetaTileEntity(5565 + i, MetaTileEntities.QUANTUM_CHEST[i]);
        }
        for (i = 0; i < 5; ++i) {
            voltageName = GTValues.VN[i + 1].toLowerCase();
            MetaTileEntities.QUANTUM_TANK[i] = new MetaTileEntityQuantumTank(GTUtility.gregtechId("super_tank." + voltageName), i + 1, 4000000 * (int)Math.pow(2.0, i));
            MetaTileEntities.registerMetaTileEntity(5575 + i, MetaTileEntities.QUANTUM_TANK[i]);
        }
        for (i = 5; i < MetaTileEntities.QUANTUM_TANK.length; ++i) {
            voltageName = GTValues.VN[i].toLowerCase();
            int capacity = i == 9 ? Integer.MAX_VALUE : 4000000 * (int)Math.pow(2.0, i);
            MetaTileEntities.QUANTUM_TANK[i] = new MetaTileEntityQuantumTank(GTUtility.gregtechId("quantum_tank." + voltageName), i, capacity);
            MetaTileEntities.registerMetaTileEntity(5580 + i, MetaTileEntities.QUANTUM_TANK[i]);
        }
        for (i = 0; i < MetaTileEntities.BLOCK_BREAKER.length; ++i) {
            voltageName = GTValues.VN[i + 1].toLowerCase();
            MetaTileEntities.BLOCK_BREAKER[i] = new MetaTileEntityBlockBreaker(GTUtility.gregtechId("block_breaker." + voltageName), i + 1);
            MetaTileEntities.registerMetaTileEntity(5590 + i, MetaTileEntities.BLOCK_BREAKER[i]);
        }
        MetaTileEntities.WOODEN_DRUM = MetaTileEntities.registerMetaTileEntity(5610, new MetaTileEntityDrum(GTUtility.gregtechId("drum.wood"), Materials.Wood, 16000));
        MetaTileEntities.BRONZE_DRUM = MetaTileEntities.registerMetaTileEntity(5611, new MetaTileEntityDrum(GTUtility.gregtechId("drum.bronze"), Materials.Bronze, 32000));
        MetaTileEntities.STEEL_DRUM = MetaTileEntities.registerMetaTileEntity(5612, new MetaTileEntityDrum(GTUtility.gregtechId("drum.steel"), Materials.Steel, 64000));
        MetaTileEntities.ALUMINIUM_DRUM = MetaTileEntities.registerMetaTileEntity(5613, new MetaTileEntityDrum(GTUtility.gregtechId("drum.aluminium"), Materials.Aluminium, 128000));
        MetaTileEntities.STAINLESS_STEEL_DRUM = MetaTileEntities.registerMetaTileEntity(5614, new MetaTileEntityDrum(GTUtility.gregtechId("drum.stainless_steel"), Materials.StainlessSteel, 256000));
        MetaTileEntities.TITANIUM_DRUM = MetaTileEntities.registerMetaTileEntity(5615, new MetaTileEntityDrum(GTUtility.gregtechId("drum.titanium"), Materials.Titanium, 512000));
        MetaTileEntities.TUNGSTENSTEEL_DRUM = MetaTileEntities.registerMetaTileEntity(5616, new MetaTileEntityDrum(GTUtility.gregtechId("drum.tungstensteel"), Materials.TungstenSteel, 1024000));
        MetaTileEntities.GOLD_DRUM = MetaTileEntities.registerMetaTileEntity(5617, new MetaTileEntityDrum(GTUtility.gregtechId("drum.gold"), Materials.Gold, 32000));
        MetaTileEntities.WOODEN_CRATE = MetaTileEntities.registerMetaTileEntity(5625, new MetaTileEntityCrate(GTUtility.gregtechId("crate.wood"), Materials.Wood, 27, 9));
        MetaTileEntities.BRONZE_CRATE = MetaTileEntities.registerMetaTileEntity(5626, new MetaTileEntityCrate(GTUtility.gregtechId("crate.bronze"), Materials.Bronze, 54, 9));
        MetaTileEntities.STEEL_CRATE = MetaTileEntities.registerMetaTileEntity(5627, new MetaTileEntityCrate(GTUtility.gregtechId("crate.steel"), Materials.Steel, 72, 9));
        MetaTileEntities.ALUMINIUM_CRATE = MetaTileEntities.registerMetaTileEntity(5628, new MetaTileEntityCrate(GTUtility.gregtechId("crate.aluminium"), Materials.Aluminium, 90, 10));
        MetaTileEntities.STAINLESS_STEEL_CRATE = MetaTileEntities.registerMetaTileEntity(5629, new MetaTileEntityCrate(GTUtility.gregtechId("crate.stainless_steel"), Materials.StainlessSteel, 108, 12));
        MetaTileEntities.TITANIUM_CRATE = MetaTileEntities.registerMetaTileEntity(5630, new MetaTileEntityCrate(GTUtility.gregtechId("crate.titanium"), Materials.Titanium, 126, 14));
        MetaTileEntities.TUNGSTENSTEEL_CRATE = MetaTileEntities.registerMetaTileEntity(5631, new MetaTileEntityCrate(GTUtility.gregtechId("crate.tungstensteel"), Materials.TungstenSteel, 144, 16));
        MetaTileEntities.CLIPBOARD_TILE = MetaTileEntities.registerMetaTileEntity(5646, new MetaTileEntityClipboard(GTUtility.gregtechId("clipboard")));
        MetaTileEntities.WORKBENCH = MetaTileEntities.registerMetaTileEntity(5647, new MetaTileEntityWorkbench(GTUtility.gregtechId("workbench")));
        MetaTileEntities.MONITOR_SCREEN = MetaTileEntities.registerMetaTileEntity(5648, new MetaTileEntityMonitorScreen(GTUtility.gregtechId("monitor_screen")));
        MetaTileEntities.CREATIVE_ENERGY = MetaTileEntities.registerMetaTileEntity(5650, new MetaTileEntityCreativeEnergy());
        MetaTileEntities.CREATIVE_CHEST = MetaTileEntities.registerMetaTileEntity(5651, new MetaTileEntityCreativeChest(GTUtility.gregtechId("creative_chest")));
        MetaTileEntities.CREATIVE_TANK = MetaTileEntities.registerMetaTileEntity(5652, new MetaTileEntityCreativeTank(GTUtility.gregtechId("creative_tank")));
        endPos = GregTechAPI.isHighTier() ? MetaTileEntities.ENERGY_CONVERTER[0].length : 10;
        int[] amps = new int[]{1, 4, 8, 16};
        for (int j = 0; j < amps.length; ++j) {
            int offset = j * MetaTileEntities.ENERGY_CONVERTER[0].length;
            for (int i2 = 0; i2 < endPos; ++i2) {
                long eu = (long)amps[j] * GTValues.V[i2];
                long euToFe = FeCompat.toFeLong(eu, FeCompat.ratio(false));
                long feToEu = FeCompat.toEu(Integer.MAX_VALUE, FeCompat.ratio(true));
                if (euToFe > Integer.MAX_VALUE || feToEu < eu) continue;
                String id = "energy_converter." + GTValues.VN[i2].toLowerCase() + "." + amps[j];
                MetaTileEntityConverter converter = new MetaTileEntityConverter(GTUtility.gregtechId(id), i2, amps[j]);
                MetaTileEntities.ENERGY_CONVERTER[j][i2] = MetaTileEntities.registerMetaTileEntity(5670 + offset + i2, converter);
            }
        }
        MetaTileEntities.LONG_DIST_ITEM_ENDPOINT = MetaTileEntities.registerMetaTileEntity(5749, new MetaTileEntityLDItemEndpoint(GTUtility.gregtechId("ld_item_endpoint")));
        MetaTileEntities.LONG_DIST_FLUID_ENDPOINT = MetaTileEntities.registerMetaTileEntity(5750, new MetaTileEntityLDFluidEndpoint(GTUtility.gregtechId("ld_fluid_endpoint")));
        MetaTileEntities.ALARM = MetaTileEntities.registerMetaTileEntity(5760, new MetaTileEntityAlarm(GTUtility.gregtechId("alarm")));
        MetaTileEntities.MAGIC_ENERGY_ABSORBER = MetaTileEntities.registerMetaTileEntity(5761, new MetaTileEntityMagicEnergyAbsorber(GTUtility.gregtechId("magic_energy_absorber")));
    }

    private static void multiblocks() {
        MetaTileEntities.PRIMITIVE_BLAST_FURNACE = MetaTileEntities.registerMetaTileEntity(10000, new MetaTileEntityPrimitiveBlastFurnace(GTUtility.gregtechId("primitive_blast_furnace.bronze")));
        MetaTileEntities.ELECTRIC_BLAST_FURNACE = MetaTileEntities.registerMetaTileEntity(10001, new MetaTileEntityElectricBlastFurnace(GTUtility.gregtechId("electric_blast_furnace")));
        MetaTileEntities.VACUUM_FREEZER = MetaTileEntities.registerMetaTileEntity(10002, new MetaTileEntityVacuumFreezer(GTUtility.gregtechId("vacuum_freezer")));
        MetaTileEntities.IMPLOSION_COMPRESSOR = MetaTileEntities.registerMetaTileEntity(10003, new MetaTileEntityImplosionCompressor(GTUtility.gregtechId("implosion_compressor")));
        MetaTileEntities.PYROLYSE_OVEN = MetaTileEntities.registerMetaTileEntity(10004, new MetaTileEntityPyrolyseOven(GTUtility.gregtechId("pyrolyse_oven")));
        MetaTileEntities.DISTILLATION_TOWER = MetaTileEntities.registerMetaTileEntity(10005, new MetaTileEntityDistillationTower(GTUtility.gregtechId("distillation_tower"), true));
        MetaTileEntities.MULTI_FURNACE = MetaTileEntities.registerMetaTileEntity(10006, new MetaTileEntityMultiSmelter(GTUtility.gregtechId("multi_furnace")));
        MetaTileEntities.LARGE_COMBUSTION_ENGINE = MetaTileEntities.registerMetaTileEntity(10007, new MetaTileEntityLargeCombustionEngine(GTUtility.gregtechId("large_combustion_engine"), 4));
        MetaTileEntities.EXTREME_COMBUSTION_ENGINE = MetaTileEntities.registerMetaTileEntity(10008, new MetaTileEntityLargeCombustionEngine(GTUtility.gregtechId("extreme_combustion_engine"), 5));
        MetaTileEntities.CRACKER = MetaTileEntities.registerMetaTileEntity(10009, new MetaTileEntityCrackingUnit(GTUtility.gregtechId("cracker")));
        MetaTileEntities.LARGE_STEAM_TURBINE = MetaTileEntities.registerMetaTileEntity(10010, new MetaTileEntityLargeTurbine(GTUtility.gregtechId("large_turbine.steam"), RecipeMaps.STEAM_TURBINE_FUELS, 3, MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING), MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.STEEL_GEARBOX), Textures.SOLID_STEEL_CASING, false, Textures.LARGE_STEAM_TURBINE_OVERLAY));
        MetaTileEntities.LARGE_GAS_TURBINE = MetaTileEntities.registerMetaTileEntity(10011, new MetaTileEntityLargeTurbine(GTUtility.gregtechId("large_turbine.gas"), RecipeMaps.GAS_TURBINE_FUELS, 4, MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.STAINLESS_TURBINE_CASING), MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.STAINLESS_STEEL_GEARBOX), Textures.CLEAN_STAINLESS_STEEL_CASING, true, Textures.LARGE_GAS_TURBINE_OVERLAY));
        MetaTileEntities.LARGE_PLASMA_TURBINE = MetaTileEntities.registerMetaTileEntity(10012, new MetaTileEntityLargeTurbine(GTUtility.gregtechId("large_turbine.plasma"), RecipeMaps.PLASMA_GENERATOR_FUELS, 5, MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.TUNGSTENSTEEL_TURBINE_CASING), MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.TUNGSTENSTEEL_GEARBOX), Textures.ROBUST_TUNGSTENSTEEL_CASING, false, Textures.LARGE_PLASMA_TURBINE_OVERLAY));
        MetaTileEntities.LARGE_BRONZE_BOILER = MetaTileEntities.registerMetaTileEntity(10013, new MetaTileEntityLargeBoiler(GTUtility.gregtechId("large_boiler.bronze"), BoilerType.BRONZE));
        MetaTileEntities.LARGE_STEEL_BOILER = MetaTileEntities.registerMetaTileEntity(10014, new MetaTileEntityLargeBoiler(GTUtility.gregtechId("large_boiler.steel"), BoilerType.STEEL));
        MetaTileEntities.LARGE_TITANIUM_BOILER = MetaTileEntities.registerMetaTileEntity(10015, new MetaTileEntityLargeBoiler(GTUtility.gregtechId("large_boiler.titanium"), BoilerType.TITANIUM));
        MetaTileEntities.LARGE_TUNGSTENSTEEL_BOILER = MetaTileEntities.registerMetaTileEntity(10016, new MetaTileEntityLargeBoiler(GTUtility.gregtechId("large_boiler.tungstensteel"), BoilerType.TUNGSTENSTEEL));
        MetaTileEntities.COKE_OVEN = MetaTileEntities.registerMetaTileEntity(10017, new MetaTileEntityCokeOven(GTUtility.gregtechId("coke_oven")));
        MetaTileEntities.COKE_OVEN_HATCH = MetaTileEntities.registerMetaTileEntity(10018, new MetaTileEntityCokeOvenHatch(GTUtility.gregtechId("coke_oven_hatch")));
        MetaTileEntities.ASSEMBLY_LINE = MetaTileEntities.registerMetaTileEntity(10019, new MetaTileEntityAssemblyLine(GTUtility.gregtechId("assembly_line")));
        MetaTileEntities.FUSION_REACTOR[0] = MetaTileEntities.registerMetaTileEntity(10020, new MetaTileEntityFusionReactor(GTUtility.gregtechId("fusion_reactor.luv"), 6));
        MetaTileEntities.FUSION_REACTOR[1] = MetaTileEntities.registerMetaTileEntity(10021, new MetaTileEntityFusionReactor(GTUtility.gregtechId("fusion_reactor.zpm"), 7));
        MetaTileEntities.FUSION_REACTOR[2] = MetaTileEntities.registerMetaTileEntity(10022, new MetaTileEntityFusionReactor(GTUtility.gregtechId("fusion_reactor.uv"), 8));
        MetaTileEntities.LARGE_CHEMICAL_REACTOR = MetaTileEntities.registerMetaTileEntity(10023, new MetaTileEntityLargeChemicalReactor(GTUtility.gregtechId("large_chemical_reactor")));
        MetaTileEntities.STEAM_OVEN = MetaTileEntities.registerMetaTileEntity(10024, new MetaTileEntitySteamOven(GTUtility.gregtechId("steam_oven")));
        MetaTileEntities.STEAM_GRINDER = MetaTileEntities.registerMetaTileEntity(10025, new MetaTileEntitySteamGrinder(GTUtility.gregtechId("steam_grinder")));
        MetaTileEntities.BASIC_LARGE_MINER = MetaTileEntities.registerMetaTileEntity(10026, new MetaTileEntityLargeMiner(GTUtility.gregtechId("large_miner.ev"), 4, 16, 3, 4, Materials.Steel, 8));
        MetaTileEntities.LARGE_MINER = MetaTileEntities.registerMetaTileEntity(10027, new MetaTileEntityLargeMiner(GTUtility.gregtechId("large_miner.iv"), 5, 4, 5, 5, Materials.Titanium, 16));
        MetaTileEntities.ADVANCED_LARGE_MINER = MetaTileEntities.registerMetaTileEntity(10028, new MetaTileEntityLargeMiner(GTUtility.gregtechId("large_miner.luv"), 6, 1, 7, 6, Materials.TungstenSteel, 32));
        MetaTileEntities.CENTRAL_MONITOR = MetaTileEntities.registerMetaTileEntity(10029, new MetaTileEntityCentralMonitor(GTUtility.gregtechId("central_monitor")));
        MetaTileEntities.PROCESSING_ARRAY = MetaTileEntities.registerMetaTileEntity(10030, new MetaTileEntityProcessingArray(GTUtility.gregtechId("processing_array"), 0));
        MetaTileEntities.ADVANCED_PROCESSING_ARRAY = MetaTileEntities.registerMetaTileEntity(10031, new MetaTileEntityProcessingArray(GTUtility.gregtechId("advanced_processing_array"), 1));
        MetaTileEntities.BASIC_FLUID_DRILLING_RIG = MetaTileEntities.registerMetaTileEntity(10032, new MetaTileEntityFluidDrill(GTUtility.gregtechId("fluid_drilling_rig.mv"), 2));
        MetaTileEntities.FLUID_DRILLING_RIG = MetaTileEntities.registerMetaTileEntity(10033, new MetaTileEntityFluidDrill(GTUtility.gregtechId("fluid_drilling_rig.hv"), 3));
        MetaTileEntities.ADVANCED_FLUID_DRILLING_RIG = MetaTileEntities.registerMetaTileEntity(10034, new MetaTileEntityFluidDrill(GTUtility.gregtechId("fluid_drilling_rig.ev"), 4));
        MetaTileEntities.CLEANROOM = MetaTileEntities.registerMetaTileEntity(10035, new MetaTileEntityCleanroom(GTUtility.gregtechId("cleanroom")));
        MetaTileEntities.CHARCOAL_PILE_IGNITER = MetaTileEntities.registerMetaTileEntity(10036, new MetaTileEntityCharcoalPileIgniter(GTUtility.gregtechId("charcoal_pile")));
        MetaTileEntities.DATA_BANK = MetaTileEntities.registerMetaTileEntity(10037, new MetaTileEntityDataBank(GTUtility.gregtechId("data_bank")));
        MetaTileEntities.RESEARCH_STATION = MetaTileEntities.registerMetaTileEntity(10038, new MetaTileEntityResearchStation(GTUtility.gregtechId("research_station")));
        MetaTileEntities.HIGH_PERFORMANCE_COMPUTING_ARRAY = MetaTileEntities.registerMetaTileEntity(10039, new MetaTileEntityHPCA(GTUtility.gregtechId("high_performance_computing_array")));
        MetaTileEntities.NETWORK_SWITCH = MetaTileEntities.registerMetaTileEntity(10040, new MetaTileEntityNetworkSwitch(GTUtility.gregtechId("network_switch")));
        MetaTileEntities.POWER_SUBSTATION = MetaTileEntities.registerMetaTileEntity(10041, new MetaTileEntityPowerSubstation(GTUtility.gregtechId("power_substation")));
        MetaTileEntities.ACTIVE_TRANSFORMER = MetaTileEntities.registerMetaTileEntity(10042, new MetaTileEntityActiveTransformer(GTUtility.gregtechId("active_transformer")));
        MetaTileEntities.WOODEN_TANK = MetaTileEntities.registerMetaTileEntity(10043, new MetaTileEntityMultiblockTank(GTUtility.gregtechId("tank.wood"), false, 250000));
        MetaTileEntities.STEEL_TANK = MetaTileEntities.registerMetaTileEntity(10044, new MetaTileEntityMultiblockTank(GTUtility.gregtechId("tank.steel"), true, 1000000));
        MetaTileEntities.PRIMITIVE_WATER_PUMP = MetaTileEntities.registerMetaTileEntity(10045, new MetaTileEntityPrimitiveWaterPump(GTUtility.gregtechId("primitive_water_pump")));
    }

    private static void multiblockParts() {
        String voltageName;
        int i;
        int endPos = GregTechAPI.isHighTier() ? MetaTileEntities.ITEM_IMPORT_BUS.length : 10;
        for (i = 0; i < endPos; ++i) {
            voltageName = GTValues.VN[i].toLowerCase();
            MetaTileEntities.ITEM_IMPORT_BUS[i] = new MetaTileEntityItemBus(GTUtility.gregtechId("item_bus.import." + voltageName), i, false);
            MetaTileEntities.ITEM_EXPORT_BUS[i] = new MetaTileEntityItemBus(GTUtility.gregtechId("item_bus.export." + voltageName), i, true);
            MetaTileEntities.FLUID_IMPORT_HATCH[i] = new MetaTileEntityFluidHatch(GTUtility.gregtechId("fluid_hatch.import." + voltageName), i, false);
            MetaTileEntities.FLUID_EXPORT_HATCH[i] = new MetaTileEntityFluidHatch(GTUtility.gregtechId("fluid_hatch.export." + voltageName), i, true);
            MetaTileEntities.registerMetaTileEntity(11000 + i, MetaTileEntities.ITEM_IMPORT_BUS[i]);
            MetaTileEntities.registerMetaTileEntity(11015 + i, MetaTileEntities.ITEM_EXPORT_BUS[i]);
            MetaTileEntities.registerMetaTileEntity(11030 + i, MetaTileEntities.FLUID_IMPORT_HATCH[i]);
            MetaTileEntities.registerMetaTileEntity(11045 + i, MetaTileEntities.FLUID_EXPORT_HATCH[i]);
        }
        endPos = GregTechAPI.isHighTier() ? MetaTileEntities.QUADRUPLE_IMPORT_HATCH.length : 10;
        for (i = 4; i < endPos; ++i) {
            String tierName = GTValues.VN[i].toLowerCase();
            MetaTileEntities.QUADRUPLE_IMPORT_HATCH[i] = MetaTileEntities.registerMetaTileEntity(11060 + i, new MetaTileEntityMultiFluidHatch(GTUtility.gregtechId("fluid_hatch.import_4x." + tierName), i, 4, false));
            MetaTileEntities.NONUPLE_IMPORT_HATCH[i] = MetaTileEntities.registerMetaTileEntity(11075 + i, new MetaTileEntityMultiFluidHatch(GTUtility.gregtechId("fluid_hatch.import_9x." + tierName), i, 9, false));
            MetaTileEntities.QUADRUPLE_EXPORT_HATCH[i] = MetaTileEntities.registerMetaTileEntity(11090 + i, new MetaTileEntityMultiFluidHatch(GTUtility.gregtechId("fluid_hatch.export_4x." + tierName), i, 4, true));
            MetaTileEntities.NONUPLE_EXPORT_HATCH[i] = MetaTileEntities.registerMetaTileEntity(11105 + i, new MetaTileEntityMultiFluidHatch(GTUtility.gregtechId("fluid_hatch.export_9x." + tierName), i, 9, true));
        }
        endPos = GregTechAPI.isHighTier() ? MetaTileEntities.ENERGY_INPUT_HATCH.length : 10;
        for (i = 0; i < endPos; ++i) {
            voltageName = GTValues.VN[i].toLowerCase();
            MetaTileEntities.ENERGY_INPUT_HATCH[i] = MetaTileEntities.registerMetaTileEntity(11120 + i, new MetaTileEntityEnergyHatch(GTUtility.gregtechId("energy_hatch.input." + voltageName), i, 2, false));
            MetaTileEntities.ENERGY_OUTPUT_HATCH[i] = MetaTileEntities.registerMetaTileEntity(11135 + i, new MetaTileEntityEnergyHatch(GTUtility.gregtechId("energy_hatch.output." + voltageName), i, 2, true));
            MetaTileEntities.ENERGY_INPUT_HATCH_4A[i] = MetaTileEntities.registerMetaTileEntity(11150 + i, new MetaTileEntityEnergyHatch(GTUtility.gregtechId("energy_hatch.input_4a." + voltageName), i, 4, false));
            MetaTileEntities.ENERGY_OUTPUT_HATCH_4A[i] = MetaTileEntities.registerMetaTileEntity(11165 + i, new MetaTileEntityEnergyHatch(GTUtility.gregtechId("energy_hatch.output_4a." + voltageName), i, 4, true));
            MetaTileEntities.ENERGY_INPUT_HATCH_16A[i] = MetaTileEntities.registerMetaTileEntity(11180 + i, new MetaTileEntityEnergyHatch(GTUtility.gregtechId("energy_hatch.input_16a." + voltageName), i, 16, false));
            MetaTileEntities.ENERGY_OUTPUT_HATCH_16A[i] = MetaTileEntities.registerMetaTileEntity(11195 + i, new MetaTileEntityEnergyHatch(GTUtility.gregtechId("energy_hatch.output_16a." + voltageName), i, 16, true));
            MetaTileEntities.SUBSTATION_ENERGY_INPUT_HATCH[i] = MetaTileEntities.registerMetaTileEntity(11210 + i, new MetaTileEntitySubstationEnergyHatch(GTUtility.gregtechId("substation_hatch.input_64a." + voltageName), i, 64, false));
            MetaTileEntities.SUBSTATION_ENERGY_OUTPUT_HATCH[i] = MetaTileEntities.registerMetaTileEntity(11225 + i, new MetaTileEntitySubstationEnergyHatch(GTUtility.gregtechId("substation_hatch.output_64a." + voltageName), i, 64, true));
        }
        endPos = GregTechAPI.isHighTier() ? MetaTileEntities.LASER_INPUT_HATCH_256.length : 10;
        for (i = 5; i < endPos; ++i) {
            voltageName = GTValues.VN[i].toLowerCase();
            MetaTileEntities.LASER_INPUT_HATCH_256[i] = MetaTileEntities.registerMetaTileEntity(11240 + i, new MetaTileEntityLaserHatch(GTUtility.gregtechId("laser_hatch.target_256a." + voltageName), false, i, 256));
            MetaTileEntities.LASER_OUTPUT_HATCH_256[i] = MetaTileEntities.registerMetaTileEntity(11255 + i, new MetaTileEntityLaserHatch(GTUtility.gregtechId("laser_hatch.source_256a." + voltageName), true, i, 256));
            MetaTileEntities.LASER_INPUT_HATCH_1024[i] = MetaTileEntities.registerMetaTileEntity(11270 + i, new MetaTileEntityLaserHatch(GTUtility.gregtechId("laser_hatch.target_1024a." + voltageName), false, i, 1024));
            MetaTileEntities.LASER_OUTPUT_HATCH_1024[i] = MetaTileEntities.registerMetaTileEntity(11285 + i, new MetaTileEntityLaserHatch(GTUtility.gregtechId("laser_hatch.source_1024a." + voltageName), true, i, 1024));
            MetaTileEntities.LASER_INPUT_HATCH_4096[i] = MetaTileEntities.registerMetaTileEntity(11300 + i, new MetaTileEntityLaserHatch(GTUtility.gregtechId("laser_hatch.target_4096a." + voltageName), false, i, 4096));
            MetaTileEntities.LASER_OUTPUT_HATCH_4096[i] = MetaTileEntities.registerMetaTileEntity(11315 + i, new MetaTileEntityLaserHatch(GTUtility.gregtechId("laser_hatch.source_4096a." + voltageName), true, i, 4096));
        }
        endPos = GregTechAPI.isHighTier() ? MetaTileEntities.ROTOR_HOLDER.length : 9;
        for (i = 3; i < endPos; ++i) {
            MetaTileEntities.ROTOR_HOLDER[i] = MetaTileEntities.registerMetaTileEntity(11450 + i, new MetaTileEntityRotorHolder(GTUtility.gregtechId("rotor_holder." + GTValues.VN[i].toLowerCase()), i));
        }
        endPos = GregTechAPI.isHighTier() ? MetaTileEntities.MUFFLER_HATCH.length : 9;
        for (i = 1; i < endPos; ++i) {
            voltageName = GTValues.VN[i].toLowerCase();
            MetaTileEntities.MUFFLER_HATCH[i] = new MetaTileEntityMufflerHatch(GTUtility.gregtechId("muffler_hatch." + voltageName), i);
            MetaTileEntities.registerMetaTileEntity(11465 + i, MetaTileEntities.MUFFLER_HATCH[i]);
        }
        MetaTileEntities.MAINTENANCE_HATCH = MetaTileEntities.registerMetaTileEntity(11480, new MetaTileEntityMaintenanceHatch(GTUtility.gregtechId("maintenance_hatch"), false));
        MetaTileEntities.CONFIGURABLE_MAINTENANCE_HATCH = MetaTileEntities.registerMetaTileEntity(11481, new MetaTileEntityMaintenanceHatch(GTUtility.gregtechId("maintenance_hatch_configurable"), true));
        MetaTileEntities.AUTO_MAINTENANCE_HATCH = MetaTileEntities.registerMetaTileEntity(11482, new MetaTileEntityAutoMaintenanceHatch(GTUtility.gregtechId("maintenance_hatch_full_auto")));
        MetaTileEntities.CLEANING_MAINTENANCE_HATCH = MetaTileEntities.registerMetaTileEntity(11483, new MetaTileEntityCleaningMaintenanceHatch(GTUtility.gregtechId("maintenance_hatch_cleanroom_auto")));
        MetaTileEntities.MACHINE_HATCH = MetaTileEntities.registerMetaTileEntity(11495, new MetaTileEntityMachineHatch(GTUtility.gregtechId("machine_hatch"), 5));
        MetaTileEntities.PASSTHROUGH_HATCH_ITEM = MetaTileEntities.registerMetaTileEntity(11496, new MetaTileEntityPassthroughHatchItem(GTUtility.gregtechId("passthrough_hatch_item"), 3));
        MetaTileEntities.PASSTHROUGH_HATCH_FLUID = MetaTileEntities.registerMetaTileEntity(11497, new MetaTileEntityPassthroughHatchFluid(GTUtility.gregtechId("passthrough_hatch_fluid"), 3));
        MetaTileEntities.DATA_ACCESS_HATCH = MetaTileEntities.registerMetaTileEntity(11498, new MetaTileEntityDataAccessHatch(GTUtility.gregtechId("data_access_hatch"), 4, false));
        MetaTileEntities.ADVANCED_DATA_ACCESS_HATCH = MetaTileEntities.registerMetaTileEntity(11499, new MetaTileEntityDataAccessHatch(GTUtility.gregtechId("data_access_hatch.advanced"), 6, false));
        MetaTileEntities.CREATIVE_DATA_HATCH = MetaTileEntities.registerMetaTileEntity(11500, new MetaTileEntityDataAccessHatch(GTUtility.gregtechId("data_access_hatch.creative"), 14, true));
        MetaTileEntities.OPTICAL_DATA_HATCH_RECEIVER = MetaTileEntities.registerMetaTileEntity(11501, new MetaTileEntityOpticalDataHatch(GTUtility.gregtechId("data_access_hatch.optical.receiver"), false));
        MetaTileEntities.OPTICAL_DATA_HATCH_TRANSMITTER = MetaTileEntities.registerMetaTileEntity(11502, new MetaTileEntityOpticalDataHatch(GTUtility.gregtechId("data_access_hatch.optical.transmitter"), true));
        MetaTileEntities.COMPUTATION_HATCH_RECEIVER = MetaTileEntities.registerMetaTileEntity(11503, new MetaTileEntityComputationHatch(GTUtility.gregtechId("computation_hatch.receiver"), false));
        MetaTileEntities.COMPUTATION_HATCH_TRANSMITTER = MetaTileEntities.registerMetaTileEntity(11504, new MetaTileEntityComputationHatch(GTUtility.gregtechId("computation_hatch.transmitter"), true));
        MetaTileEntities.RESERVOIR_HATCH = MetaTileEntities.registerMetaTileEntity(11505, new MetaTileEntityReservoirHatch(GTUtility.gregtechId("reservoir_hatch")));
        MetaTileEntities.PUMP_OUTPUT_HATCH = MetaTileEntities.registerMetaTileEntity(11506, new MetaTileEntityPumpHatch(GTUtility.gregtechId("pump_hatch")));
        MetaTileEntities.STEAM_EXPORT_BUS = MetaTileEntities.registerMetaTileEntity(11507, new MetaTileEntitySteamItemBus(GTUtility.gregtechId("steam_export_bus"), true));
        MetaTileEntities.STEAM_IMPORT_BUS = MetaTileEntities.registerMetaTileEntity(11508, new MetaTileEntitySteamItemBus(GTUtility.gregtechId("steam_import_bus"), false));
        MetaTileEntities.STEAM_HATCH = MetaTileEntities.registerMetaTileEntity(11509, new MetaTileEntitySteamHatch(GTUtility.gregtechId("steam_hatch")));
        MetaTileEntities.OBJECT_HOLDER = MetaTileEntities.registerMetaTileEntity(11510, new MetaTileEntityObjectHolder(GTUtility.gregtechId("research_station.object_holder")));
        MetaTileEntities.HPCA_EMPTY_COMPONENT = MetaTileEntities.registerMetaTileEntity(11511, new MetaTileEntityHPCAEmpty(GTUtility.gregtechId("hpca.empty_component")));
        MetaTileEntities.HPCA_COMPUTATION_COMPONENT = MetaTileEntities.registerMetaTileEntity(11512, new MetaTileEntityHPCAComputation(GTUtility.gregtechId("hpca.computation_component"), false));
        MetaTileEntities.HPCA_ADVANCED_COMPUTATION_COMPONENT = MetaTileEntities.registerMetaTileEntity(11513, new MetaTileEntityHPCAComputation(GTUtility.gregtechId("hpca.advanced_computation_component"), true));
        MetaTileEntities.HPCA_HEAT_SINK_COMPONENT = MetaTileEntities.registerMetaTileEntity(11514, new MetaTileEntityHPCACooler(GTUtility.gregtechId("hpca.heat_sink_component"), false));
        MetaTileEntities.HPCA_ACTIVE_COOLER_COMPONENT = MetaTileEntities.registerMetaTileEntity(11515, new MetaTileEntityHPCACooler(GTUtility.gregtechId("hpca.active_cooler_component"), true));
        MetaTileEntities.HPCA_BRIDGE_COMPONENT = MetaTileEntities.registerMetaTileEntity(11516, new MetaTileEntityHPCABridge(GTUtility.gregtechId("hpca.bridge_component")));
        MetaTileEntities.WOODEN_TANK_VALVE = MetaTileEntities.registerMetaTileEntity(11523, new MetaTileEntityTankValve(GTUtility.gregtechId("tank_valve.wood"), false));
        MetaTileEntities.STEEL_TANK_VALVE = MetaTileEntities.registerMetaTileEntity(11524, new MetaTileEntityTankValve(GTUtility.gregtechId("tank_valve.steel"), true));
        if (Mods.AppliedEnergistics2.isModLoaded()) {
            MetaTileEntities.ITEM_IMPORT_BUS_ME = MetaTileEntities.registerMetaTileEntity(11525, new MetaTileEntityMEInputBus(GTUtility.gregtechId("me_import_item_bus")));
            MetaTileEntities.FLUID_IMPORT_HATCH_ME = MetaTileEntities.registerMetaTileEntity(11526, new MetaTileEntityMEInputHatch(GTUtility.gregtechId("me_import_fluid_hatch")));
            MetaTileEntities.STOCKING_BUS_ME = MetaTileEntities.registerMetaTileEntity(11527, new MetaTileEntityMEStockingBus(GTUtility.gregtechId("me_stocking_item_bus")));
            MetaTileEntities.STOCKING_HATCH_ME = MetaTileEntities.registerMetaTileEntity(11528, new MetaTileEntityMEStockingHatch(GTUtility.gregtechId("me_stocking_fluid_hatch")));
            MetaTileEntities.ITEM_EXPORT_BUS_ME = MetaTileEntities.registerMetaTileEntity(11532, new MetaTileEntityMEOutputBus(GTUtility.gregtechId("me_export_item_bus")));
            MetaTileEntities.FLUID_EXPORT_HATCH_ME = MetaTileEntities.registerMetaTileEntity(11533, new MetaTileEntityMEOutputHatch(GTUtility.gregtechId("me_export_fluid_hatch")));
        }
    }
}

