/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.PatternError;
import gregtech.api.util.GTUtility;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class MultiblockBuilderBehavior
implements IItemBehaviour {
    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        PatternError error;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IGregTechTileEntity)) {
            return EnumActionResult.PASS;
        }
        MetaTileEntity mte = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
        if (!(mte instanceof MultiblockControllerBase)) {
            return EnumActionResult.PASS;
        }
        if (!player.func_175151_a(pos, side, player.func_184586_b(hand))) {
            return EnumActionResult.FAIL;
        }
        MultiblockControllerBase multiblock = (MultiblockControllerBase)mte;
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (player.func_70093_af()) {
            if (!multiblock.isStructureFormed()) {
                multiblock.structurePattern.autoBuild(player, multiblock);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        if (!multiblock.isStructureFormed() && (error = multiblock.structurePattern.getError()) != null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.multiblock.pattern.error_message_header", new Object[0]));
            player.func_145747_a((ITextComponent)new TextComponentString(error.getErrorInfo()));
            return EnumActionResult.SUCCESS;
        }
        player.func_145747_a(new TextComponentTranslation("gregtech.multiblock.pattern.no_errors", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void addPropertyOverride(@NotNull Item item) {
        item.func_185043_a(GTUtility.gregtechId("auto_mode"), (stack, world, entity) -> entity != null && entity.func_70093_af() ? 1.0f : 0.0f);
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        lines.add(I18n.func_135052_a((String)"metaitem.tool.multiblock_builder.tooltip2", (Object[])new Object[0]));
    }
}

