/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.factory.HandGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.InteractionSyncHandler;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.layout.Grid;
import gregtech.api.capability.IGhostSlotConfigurable;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.ISubItemHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.mui.factory.MetaItemGuiFactory;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class IntCircuitBehaviour
implements IItemBehaviour,
ItemUIFactory,
ISubItemHandler {
    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        int configuration = IntCircuitIngredient.getCircuitConfiguration(itemStack);
        lines.add(1, I18n.func_135052_a((String)"metaitem.int_circuit.configuration", (Object[])new Object[]{configuration}));
    }

    @Override
    public ActionResult<ItemStack> onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        MetaTileEntity mte = GTUtility.getMetaTileEntity((IBlockAccess)world, pos);
        ItemStack stack = player.func_184586_b(hand);
        if (!(mte instanceof IGhostSlotConfigurable)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K) {
            ((IGhostSlotConfigurable)((Object)mte)).setGhostCircuitConfig(IntCircuitIngredient.getCircuitConfiguration(stack));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            MetaItemGuiFactory.open(player, hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
    }

    @Override
    public ModularPanel buildUI(HandGuiData guiData, PanelSyncManager guiSyncManager) {
        ModularPanel panel = GTGuis.createPanel(guiData.getUsedItemStack(), 176, 120);
        ItemDrawable circuitPreview = new ItemDrawable(guiData.getUsedItemStack());
        for (int i = 0; i <= 32; ++i) {
            int finalI = i;
            guiSyncManager.syncValue("config", i, (SyncHandler)new InteractionSyncHandler().setOnMousePressed(b -> {
                ItemStack item = IntCircuitIngredient.getIntegratedCircuit(finalI);
                item.func_190920_e(guiData.getUsedItemStack().func_190916_E());
                circuitPreview.setItem(item);
                if (Interactable.hasShiftDown()) {
                    panel.animateClose();
                }
                guiData.getPlayer().func_184611_a(guiData.getHand(), item);
            }));
        }
        ArrayList options = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            int index;
            options.add(new ArrayList());
            for (int j = 0; j < 9 && (index = i * 9 + j) <= 32; ++j) {
                ((List)options.get(i)).add(((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(18)).background(new IDrawable[]{GTGuiTextures.SLOT, new ItemDrawable(IntCircuitIngredient.getIntegratedCircuit(index)).asIcon().size(16)})).disableHoverBackground()).syncHandler("config", index));
            }
        }
        return (ModularPanel)((ModularPanel)((ModularPanel)panel.child((IWidget)IKey.lang((String)"metaitem.circuit.integrated.gui").asWidget().pos(5, 5))).child((IWidget)((Widget)((Widget)((Widget)circuitPreview.asIcon().size(16).asWidget().size(18)).top(19)).alignX(0.5f)).background(new IDrawable[]{GTGuiTextures.SLOT}))).child((IWidget)((Grid)((Grid)((Grid)((Grid)new Grid().left(7)).right(7)).top(41)).height(72)).matrix(options).minColWidth(18).minRowHeight(18).minElementMargin(0, 0));
    }

    @Override
    public String getItemSubType(ItemStack itemStack) {
        return Integer.toString(IntCircuitIngredient.getCircuitConfiguration(itemStack));
    }

    @Override
    public void getSubItems(ItemStack itemStack, CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)itemStack.func_77946_l());
    }
}

