/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.inventory.itemsource.sources;

import gregtech.common.inventory.itemsource.sources.InventoryItemSource;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileItemSource
extends InventoryItemSource {
    private final BlockPos blockPos;
    private final EnumFacing accessSide;
    private final BlockPos accessedBlockPos;
    private WeakReference<TileEntity> cachedTileEntity = new WeakReference<Object>(null);

    public TileItemSource(World world, BlockPos blockPos, EnumFacing accessSide) {
        super(world, 0);
        this.blockPos = blockPos;
        this.accessSide = accessSide;
        this.accessedBlockPos = blockPos.func_177972_a(accessSide);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public EnumFacing getAccessSide() {
        return this.accessSide;
    }

    public BlockPos getAccessedBlockPos() {
        return this.accessedBlockPos;
    }

    @Override
    public void computeItemHandler() {
        if (!this.world.func_175667_e(this.accessedBlockPos)) {
            this.itemHandler = EmptyHandler.INSTANCE;
            return;
        }
        TileEntity tileEntity = (TileEntity)this.cachedTileEntity.get();
        if (tileEntity == null || tileEntity.func_145837_r() || !tileEntity.func_174877_v().equals((Object)this.accessedBlockPos)) {
            tileEntity = this.world.func_175625_s(this.accessedBlockPos);
            if (tileEntity == null) {
                this.itemHandler = null;
                return;
            }
            this.cachedTileEntity = new WeakReference<TileEntity>(tileEntity);
        }
        this.itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.accessSide.func_176734_d());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TileItemSource)) {
            return false;
        }
        TileItemSource that = (TileItemSource)o;
        return this.blockPos.equals((Object)that.blockPos) && this.accessSide == that.accessSide;
    }

    public int hashCode() {
        return Objects.hash(this.blockPos, this.accessSide);
    }
}

