/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.terminal.gui.widgets;

import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.gui.widget.terminal.gui.widgets.RectButtonWidget;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;

public class SelectorWidget
extends WidgetGroup {
    protected RectButtonWidget button;
    protected List<String> candidates;
    protected boolean isShow;
    private IGuiTexture background;
    private Consumer<String> onChanged;
    private Consumer<Boolean> onShowChange;
    private boolean isUp;
    private final int fontColor;

    public SelectorWidget(int x, int y, int width, int height, List<String> candidates, int fontColor, Supplier<String> supplier, boolean isClient) {
        super(new Position(x, y), new Size(width, height));
        this.button = new RectButtonWidget(0, 0, width, height);
        this.candidates = candidates;
        this.fontColor = fontColor;
        this.button.setClickListener(d -> {
            if (this.onShowChange != null) {
                this.onShowChange.accept(!this.isShow);
            }
            this.isShow = !this.isShow;
        });
        this.addWidget(this.button);
        this.addWidget(new SimpleTextWidget(width / 2, height / 2, "", fontColor, supplier, isClient));
    }

    public SelectorWidget setIsUp(boolean isUp) {
        this.isUp = isUp;
        return this;
    }

    public SelectorWidget setHoverText(String text) {
        this.button.setHoverText(text);
        return this;
    }

    public SelectorWidget setOnChanged(Consumer<String> onChanged) {
        this.onChanged = onChanged;
        return this;
    }

    public SelectorWidget setOnShowChange(Consumer<Boolean> onShowChange) {
        this.onShowChange = onShowChange;
        return this;
    }

    public SelectorWidget setColors(int stroke, int anima, int fill) {
        this.button.setColors(stroke, anima, fill);
        return this;
    }

    public SelectorWidget setButtonBackground(IGuiTexture guiTexture) {
        this.button.setIcon(guiTexture);
        return this;
    }

    public SelectorWidget setBackground(IGuiTexture background) {
        this.background = background;
        return this;
    }

    public void hide() {
        this.isShow = false;
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        super.drawInForeground(mouseX, mouseY);
        if (this.isShow) {
            int x = this.getPosition().x;
            int width = this.getSize().width;
            int height = this.getSize().height;
            int y = (this.isUp ? -this.candidates.size() : 1) * height + this.getPosition().y;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (String candidate : this.candidates) {
                if (this.background != null) {
                    this.background.draw(x, y, width, height);
                } else {
                    SelectorWidget.drawSolidRect(x, y, width, height, -1442840576);
                }
                fontRenderer.func_78276_b(I18n.func_135052_a((String)candidate, (Object[])new Object[0]), x + 4, y + (height - fontRenderer.field_78288_b) / 2 + 1, this.fontColor);
                y += height;
            }
            y = (this.isUp ? -this.candidates.size() : 1) * height + this.getPosition().y;
            for (String ignored : this.candidates) {
                if (SelectorWidget.isMouseOver(x, y, width, height, mouseX, mouseY)) {
                    SelectorWidget.drawBorder(x, y, width, height, -1, 1);
                }
                y += height;
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isShow) {
            int x = this.getPosition().x;
            int width = this.getSize().width;
            int height = this.getSize().height;
            int y = (this.isUp ? -this.candidates.size() : 1) * height + this.getPosition().y;
            for (String candidate : this.candidates) {
                if (SelectorWidget.isMouseOver(x, y, width, height, mouseX, mouseY)) {
                    if (this.onChanged != null) {
                        this.onChanged.accept(candidate);
                    }
                    this.writeClientAction(2, buffer -> buffer.func_180714_a(candidate));
                    this.isShow = false;
                    return true;
                }
                y += height;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 2 && this.onChanged != null) {
            this.onChanged.accept(buffer.func_150789_c(Short.MAX_VALUE));
        }
    }
}

