/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.terminal;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.common.gui.widget.terminal.menu.IMenuComponent;
import gregtech.common.gui.widget.terminal.util.ISearch;
import gregtech.common.gui.widget.terminal.util.SearchEngine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;

public class SearchComponent<T>
extends WidgetGroup
implements IMenuComponent {
    private static final TextureArea SEARCHING = TextureArea.fullImage("textures/gui/terminal/icon/search_hover.png");
    private static final int SIZE = 10;
    private final SearchEngine<T> engine;
    private final List<Tuple<T, String>> results;
    private final IWidgetSearch<T> search;
    private boolean isUp;
    private int offset;

    public SearchComponent(IWidgetSearch<T> search) {
        super(0, 0, 280, 20);
        this.search = search;
        this.results = new ArrayList<Tuple<T, String>>();
        this.engine = new SearchEngine<Object>(search, r -> this.results.add(new Tuple(r, (Object)search.resultDisplay(r))));
        this.addWidget(new TextFieldWidget(0, 5, 280, 20, new ColorRectTexture(-822083584), null, null).setValidator(s -> true).setTextResponder(s -> {
            this.results.clear();
            this.engine.searchWord((String)s);
            this.offset = 0;
        }, true));
    }

    @Override
    public IGuiTexture buttonIcon() {
        return SEARCHING;
    }

    @Override
    public String hoverText() {
        return "terminal.component.searching";
    }

    public void setUp(boolean up) {
        this.isUp = up;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        int x = this.getPosition().x;
        int width = this.getSize().width;
        int height = this.getSize().height;
        int y = (this.isUp ? -this.results.size() : 1) * height + this.getPosition().y;
        int max = Math.min(this.offset + 10, this.results.size());
        for (int i = this.offset; i < max; ++i) {
            Tuple<T, String> result = this.results.get(i);
            SearchComponent.drawSolidRect(x, y, width, height, -1442840576);
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_78276_b((String)result.func_76340_b(), x + 4, y + (height - fontRenderer.field_78288_b) / 2 + 1, -1);
            if (SearchComponent.isMouseOver(x, y, width, height, mouseX, mouseY)) {
                SearchComponent.drawBorder(x + 1, y + 1, width - 2, height - 2, -1, 1);
            }
            y += height;
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        int x = this.getPosition().x;
        int width = this.getSize().width;
        int height = this.getSize().height;
        int y = (this.isUp ? -this.results.size() : 1) * height + this.getPosition().y;
        int max = Math.min(this.offset + 10, this.results.size());
        for (int i = this.offset; i < max; ++i) {
            Tuple<T, String> result = this.results.get(i);
            if (SearchComponent.isMouseOver(x, y, width, height, mouseX, mouseY)) {
                this.search.selectResult(result.func_76341_a());
                this.engine.dispose();
                return true;
            }
            y += height;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        int max;
        int width;
        int height;
        int x = this.getPosition().x;
        int y = (this.isUp ? -this.results.size() : 1) * (height = this.getSize().height) + this.getPosition().y;
        if (SearchComponent.isMouseOver(x, y, width = this.getSize().width, height * ((max = Math.min(this.offset + 10, this.results.size())) - this.offset), mouseX, mouseY)) {
            this.offset = MathHelper.func_76125_a((int)(this.offset + (wheelDelta > 0 ? -1 : 1)), (int)0, (int)Math.max(0, this.results.size() - 10));
            return true;
        }
        return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
    }

    public static interface IWidgetSearch<T>
    extends ISearch<T> {
        public String resultDisplay(T var1);

        public void selectResult(T var1);
    }
}

