/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.prospector;

import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.client.utils.RenderUtil;
import gregtech.common.gui.widget.prospector.ProspectorMode;
import gregtech.core.network.packets.PacketProspecting;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ProspectingTexture
extends AbstractTexture {
    public static final String SELECTED_ALL = "[all]";
    private String selected = "[all]";
    private boolean darkMode;
    private int imageWidth = -1;
    private int imageHeight = -1;
    public final HashMap<Byte, String>[][] map;
    public static HashMap<Byte, String> emptyTag = new HashMap();
    private int playerXGui;
    private int playerYGui;
    private final ProspectorMode mode;
    private final int radius;

    public ProspectingTexture(ProspectorMode mode, int radius, boolean darkMode) {
        this.darkMode = darkMode;
        this.radius = radius;
        this.mode = mode;
        this.map = this.mode == ProspectorMode.FLUID ? new HashMap[radius * 2 - 1][radius * 2 - 1] : new HashMap[(radius * 2 - 1) * 16][(radius * 2 - 1) * 16];
    }

    public void updateTexture(PacketProspecting packet) {
        int playerChunkX = packet.playerChunkX;
        int playerChunkZ = packet.playerChunkZ;
        this.playerXGui = packet.posX - (playerChunkX - this.radius + 1) * 16 + (packet.posX > 0 ? 1 : 0);
        this.playerYGui = packet.posZ - (playerChunkZ - this.radius + 1) * 16 + (packet.posX > 0 ? 1 : 0);
        int ox = packet.chunkX > 0 && playerChunkX > 0 || packet.chunkX < 0 && playerChunkX < 0 ? Math.abs(Math.abs(packet.chunkX) - Math.abs(playerChunkX)) : Math.abs(playerChunkX) + Math.abs(packet.chunkX);
        if (playerChunkX > packet.chunkX) {
            ox = -ox;
        }
        int oy = packet.chunkZ > 0 && playerChunkZ > 0 || packet.chunkZ < 0 && playerChunkZ < 0 ? Math.abs(Math.abs(packet.chunkZ) - Math.abs(playerChunkZ)) : Math.abs(playerChunkZ) + Math.abs(packet.chunkZ);
        if (playerChunkZ > packet.chunkZ) {
            oy = -oy;
        }
        int currentColumn = this.radius - 1 + ox;
        int currentRow = this.radius - 1 + oy;
        if (currentRow < 0) {
            return;
        }
        if (this.mode == ProspectorMode.FLUID) {
            this.map[currentColumn][currentRow] = packet.map[0][0] == null ? emptyTag : packet.map[0][0];
        } else {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.map[x + currentColumn * 16][z + currentRow * 16] = packet.map[x][z] == null ? emptyTag : packet.map[x][z];
                }
            }
        }
        this.func_110551_a(null);
    }

    private BufferedImage getImage() {
        int wh = (this.radius * 2 - 1) * 16;
        BufferedImage image = new BufferedImage(wh, wh, 2);
        WritableRaster raster = image.getRaster();
        for (int i = 0; i < wh; ++i) {
            for (int j = 0; j < wh; ++j) {
                HashMap<Byte, String> data = this.map[this.mode == ProspectorMode.ORE ? i : i / 16][this.mode == ProspectorMode.ORE ? j : j / 16];
                image.setRGB(i, j, data == null ^ this.darkMode ? Color.darkGray.getRGB() : Color.WHITE.getRGB());
                if (this.mode == ProspectorMode.ORE && data != null) {
                    for (String orePrefix : data.values()) {
                        if (!this.selected.equals(SELECTED_ALL) && !this.selected.equals(orePrefix)) continue;
                        MaterialStack mterialStack = OreDictUnifier.getMaterial(OreDictUnifier.get(orePrefix));
                        image.setRGB(i, j, mterialStack == null ? orePrefix.hashCode() : mterialStack.material.getMaterialRGB() | 0xFF000000);
                        break;
                    }
                }
                if (i % 16 != 0 && j % 16 != 0) continue;
                raster.setSample(i, j, 0, raster.getSample(i, j, 0) / 2);
                raster.setSample(i, j, 1, raster.getSample(i, j, 1) / 2);
                raster.setSample(i, j, 2, raster.getSample(i, j, 2) / 2);
            }
        }
        return image;
    }

    public void func_110551_a(@Nullable IResourceManager resourceManager) {
        this.func_147631_c();
        int tId = this.func_110552_b();
        if (tId < 0) {
            return;
        }
        TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)this.getImage(), (boolean)false, (boolean)false);
        this.imageWidth = (this.radius * 2 - 1) * 16;
        this.imageHeight = (this.radius * 2 - 1) * 16;
    }

    public void loadTexture(@Nullable IResourceManager resourceManager, String selected) {
        this.selected = selected;
        this.func_110551_a(resourceManager);
    }

    public void loadTexture(@Nullable IResourceManager resourceManager, boolean darkMode) {
        this.darkMode = darkMode;
        this.func_110551_a(resourceManager);
    }

    public String getSelected() {
        return this.selected;
    }

    public void draw(int x, int y) {
        if (this.field_110553_a < 0) {
            return;
        }
        GlStateManager.func_179144_i((int)this.func_110552_b());
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.imageWidth, (int)this.imageHeight, (float)this.imageWidth, (float)this.imageHeight);
        if (this.mode == ProspectorMode.FLUID) {
            for (int cx = 0; cx < this.radius * 2 - 1; ++cx) {
                for (int cz = 0; cz < this.radius * 2 - 1; ++cz) {
                    if (this.map[cx][cz] == null || this.map[cx][cz].isEmpty()) continue;
                    Fluid fluid = FluidRegistry.getFluid((String)this.map[cx][cz].get((byte)1));
                    if (!this.selected.equals(SELECTED_ALL) && !this.selected.equals(fluid.getName())) continue;
                    RenderUtil.drawFluidForGui(new FluidStack(fluid, 1), 1, x + cx * 16 + 1, y + cz * 16 + 1, 16, 16);
                }
            }
        }
        if (this.playerXGui % 16 > 7 || this.playerXGui % 16 == 0) {
            Gui.func_73734_a((int)(x + this.playerXGui - 1), (int)y, (int)(x + this.playerXGui), (int)(y + this.imageHeight), (int)Color.RED.getRGB());
        } else {
            Gui.func_73734_a((int)(x + this.playerXGui), (int)y, (int)(x + this.playerXGui + 1), (int)(y + this.imageHeight), (int)Color.RED.getRGB());
        }
        if (this.playerYGui % 16 > 7 || this.playerYGui % 16 == 0) {
            Gui.func_73734_a((int)x, (int)(y + this.playerYGui - 1), (int)(x + this.imageWidth), (int)(y + this.playerYGui), (int)Color.RED.getRGB());
        } else {
            Gui.func_73734_a((int)x, (int)(y + this.playerYGui), (int)(x + this.imageWidth), (int)(y + this.playerYGui + 1), (int)Color.RED.getRGB());
        }
    }
}

