/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng.slot;

import appeng.api.storage.data.IAEFluidStack;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.client.utils.RenderUtil;
import gregtech.common.gui.widget.appeng.AEListGridWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AEFluidDisplayWidget
extends Widget {
    private final AEListGridWidget<IAEFluidStack> gridWidget;
    private final int index;

    public AEFluidDisplayWidget(int x, int y, AEListGridWidget<IAEFluidStack> gridWidget, int index) {
        super(new Position(x, y), new Size(18, 18));
        this.gridWidget = gridWidget;
        this.index = index;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        Position position = this.getPosition();
        IAEFluidStack fluid = this.gridWidget.getAt(this.index);
        GuiTextures.FLUID_SLOT.draw(position.x, position.y, 18, 18);
        GuiTextures.NUMBER_BACKGROUND.draw(position.x + 18, position.y, 140, 18);
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (fluid != null) {
            RenderUtil.drawFluidForGui(fluid.getFluidStack(), fluid.getFluidStack().amount, stackX, stackY, 17, 17);
            String amountStr = String.format("x%,d", fluid.getStackSize());
            AEFluidDisplayWidget.drawText(amountStr, stackX + 20, stackY + 5, 1.0f, -1);
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            AEFluidDisplayWidget.drawSelectionOverlay(stackX, stackY, 16, 16);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        IAEFluidStack fluid;
        if (this.isMouseOverElement(mouseX, mouseY) && (fluid = this.gridWidget.getAt(this.index)) != null) {
            ArrayList<String> hoverStringList = new ArrayList<String>();
            hoverStringList.add(fluid.getFluidStack().getLocalizedName());
            hoverStringList.add(String.format("%,d L", fluid.getStackSize()));
            List<String> formula = FluidTooltipUtil.getFluidTooltip(fluid.getFluidStack());
            if (formula != null) {
                for (String s : formula) {
                    if (s.isEmpty()) continue;
                    hoverStringList.add(s);
                }
            }
            this.drawHoveringText(ItemStack.field_190927_a, hoverStringList, -1, mouseX, mouseY);
        }
    }
}

