/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import appeng.util.item.ItemList;
import gregtech.common.gui.widget.appeng.AEListGridWidget;
import gregtech.common.gui.widget.appeng.slot.AEItemDisplayWidget;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class AEItemGridWidget
extends AEListGridWidget<IAEItemStack> {
    private final Object2LongMap<IAEItemStack> changeMap = new Object2LongOpenHashMap();
    protected final IItemList<IAEItemStack> cached = new ItemList();
    protected final IItemList<IAEItemStack> displayList = new ItemList();

    public AEItemGridWidget(int x, int y, int slotsY, IItemList<IAEItemStack> internalList) {
        super(x, y, slotsY, internalList);
    }

    @Override
    public IAEItemStack getAt(int index) {
        int cnt = 0;
        for (IAEItemStack item : this.displayList) {
            if (cnt == index) {
                return item;
            }
            ++cnt;
        }
        return null;
    }

    @Override
    protected void addSlotRows(int amount) {
        for (int i = 0; i < amount; ++i) {
            int widgetAmount = this.widgets.size();
            AEItemDisplayWidget widget = new AEItemDisplayWidget(0, 0, this, widgetAmount);
            this.addWidget(widget);
        }
    }

    @Override
    protected void writeListChange() {
        this.changeMap.clear();
        for (IAEItemStack item : this.cached) {
            if (this.list.findPrecise((IAEStack)item) != null && ((IAEItemStack)this.list.findPrecise((IAEStack)item)).getStackSize() != 0L) continue;
            this.changeMap.put((Object)item.copy(), -item.getStackSize());
            item.reset();
        }
        for (IAEItemStack item : this.list) {
            IAEItemStack cachedItem = (IAEItemStack)this.cached.findPrecise((IAEStack)item);
            if (cachedItem == null || cachedItem.getStackSize() == 0L) {
                this.changeMap.put((Object)item.copy(), item.getStackSize());
                this.cached.add((IAEStack)item.copy());
                continue;
            }
            if (cachedItem.getStackSize() == item.getStackSize()) continue;
            this.changeMap.put((Object)item.copy(), item.getStackSize() - cachedItem.getStackSize());
            this.cached.add((IAEStack)((IAEItemStack)item.copy().setStackSize(item.getStackSize() - cachedItem.getStackSize())));
        }
        this.writeUpdateInfo(3, buf -> {
            buf.func_150787_b(this.changeMap.size());
            for (IAEItemStack item : this.changeMap.keySet()) {
                buf.func_150788_a(item.createItemStack());
                buf.func_179254_b(((Long)this.changeMap.get((Object)item)).longValue());
            }
        });
    }

    @Override
    protected void readListChange(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        try {
            for (int i = 0; i < size; ++i) {
                ItemStack item = buffer.func_150791_c();
                item.func_190920_e(1);
                long delta = buffer.func_179260_f();
                if (item.func_190926_b()) continue;
                this.displayList.add((IAEStack)((IAEItemStack)AEItemStack.fromItemStack((ItemStack)item).setStackSize(delta)));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

