/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.FluidList;
import gregtech.common.gui.widget.appeng.AEListGridWidget;
import gregtech.common.gui.widget.appeng.slot.AEFluidDisplayWidget;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class AEFluidGridWidget
extends AEListGridWidget<IAEFluidStack> {
    private final Object2LongMap<IAEFluidStack> changeMap = new Object2LongOpenHashMap();
    protected final IItemList<IAEFluidStack> cached = new FluidList();
    protected final IItemList<IAEFluidStack> displayList = new FluidList();

    public AEFluidGridWidget(int x, int y, int slotsY, IItemList<IAEFluidStack> internalList) {
        super(x, y, slotsY, internalList);
    }

    @Override
    public IAEFluidStack getAt(int index) {
        int cnt = 0;
        for (IAEFluidStack fluid : this.displayList) {
            if (cnt == index) {
                return fluid;
            }
            ++cnt;
        }
        return null;
    }

    @Override
    protected void addSlotRows(int amount) {
        for (int i = 0; i < amount; ++i) {
            int widgetAmount = this.widgets.size();
            AEFluidDisplayWidget widget = new AEFluidDisplayWidget(0, 0, this, widgetAmount);
            this.addWidget(widget);
        }
    }

    @Override
    protected void writeListChange() {
        this.changeMap.clear();
        for (IAEFluidStack fluid : this.cached) {
            if (this.list.findPrecise((IAEStack)fluid) != null && ((IAEFluidStack)this.list.findPrecise((IAEStack)fluid)).getStackSize() != 0L) continue;
            this.changeMap.put((Object)fluid.copy(), -fluid.getStackSize());
            fluid.reset();
        }
        for (IAEFluidStack fluid : this.list) {
            IAEFluidStack cachedFluid = (IAEFluidStack)this.cached.findPrecise((IAEStack)fluid);
            if (cachedFluid == null || cachedFluid.getStackSize() == 0L) {
                this.changeMap.put((Object)fluid.copy(), fluid.getStackSize());
                this.cached.add((IAEStack)fluid.copy());
                continue;
            }
            if (cachedFluid.getStackSize() == fluid.getStackSize()) continue;
            this.changeMap.put((Object)fluid.copy(), fluid.getStackSize() - cachedFluid.getStackSize());
            this.cached.add((IAEStack)((IAEFluidStack)fluid.copy().setStackSize(fluid.getStackSize() - cachedFluid.getStackSize())));
        }
        this.writeUpdateInfo(3, buf -> {
            buf.func_150787_b(this.changeMap.size());
            for (IAEFluidStack fluid : this.changeMap.keySet()) {
                buf.func_180714_a(fluid.getFluid().getName());
                buf.func_179254_b(((Long)this.changeMap.get((Object)fluid)).longValue());
            }
        });
    }

    @Override
    protected void readListChange(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            FluidStack fluid = FluidRegistry.getFluidStack((String)buffer.func_150789_c(0x7FFFFFF), (int)1);
            long delta = buffer.func_179260_f();
            if (fluid == null) continue;
            this.displayList.add((IAEStack)((IAEFluidStack)AEFluidStack.fromFluidStack((FluidStack)fluid).setStackSize(delta)));
        }
    }
}

