/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.impl;

import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.FakeModularGuiContainer;
import gregtech.common.metatileentities.MetaTileEntityClipboard;
import gregtech.core.network.packets.PacketClipboardUIWidgetUpdate;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;

public class FakeModularUIContainerClipboard
extends FakeModularGuiContainer {
    private final List<ItemStack> inventoryItemStacks = new ArrayList<ItemStack>();
    public final List<Slot> inventorySlots = new ArrayList<Slot>();
    public int windowId;
    public MetaTileEntityClipboard clipboard;

    public FakeModularUIContainerClipboard(ModularUI modularUI, MetaTileEntityClipboard clipboard) {
        super(modularUI);
        this.clipboard = clipboard;
    }

    @Override
    protected void addSlotToContainer(Slot slotIn) {
        slotIn.field_75222_d = this.inventorySlots.size();
        this.inventorySlots.add(slotIn);
        this.inventoryItemStacks.add(ItemStack.field_190927_a);
    }

    @Override
    public void handleSlotUpdate(PacketBuffer updateData) {
        try {
            int size = updateData.func_150792_a();
            for (int i = 0; i < size; ++i) {
                this.inventorySlots.get(updateData.func_150792_a()).func_75215_d(updateData.func_150791_c());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void handleClientAction(PacketBuffer buffer) {
        Widget widget;
        int windowId = buffer.func_150792_a();
        if (windowId == this.windowId && (widget = (Widget)this.modularUI.guiWidgets.get((Object)buffer.func_150792_a())) != null) {
            widget.handleClientAction(buffer.func_150792_a(), buffer);
        }
    }

    @Override
    public boolean detectSyncedPacket(PacketBuffer buffer) {
        return this.windowId == buffer.func_150792_a();
    }

    @Override
    public void detectAndSendChanges() {
        ArrayList<Tuple> toUpdate = new ArrayList<Tuple>();
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            ItemStack real = this.inventorySlots.get(i).func_75211_c();
            ItemStack fake = this.inventoryItemStacks.get(i);
            if (ItemStack.func_77989_b((ItemStack)fake, (ItemStack)real)) continue;
            boolean clientStackChanged = !ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)fake, (ItemStack)real);
            fake = real.func_190926_b() ? ItemStack.field_190927_a : real.func_77946_l();
            this.inventoryItemStacks.set(i, fake);
            if (!clientStackChanged) continue;
            toUpdate.add(new Tuple((Object)i, (Object)fake));
        }
        this.modularUI.guiWidgets.values().forEach(Widget::detectAndSendChanges);
    }

    @Override
    public void writeClientAction(Widget widget, int updateId, Consumer<PacketBuffer> payloadWriter) {
        int widgetId = (Integer)this.modularUI.guiWidgets.inverse().get((Object)widget);
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_150787_b(this.windowId);
        packetBuffer.func_150787_b(widgetId);
        packetBuffer.func_150787_b(updateId);
        payloadWriter.accept(packetBuffer);
        GregTechAPI.networkHandler.sendToServer(new PacketClipboardUIWidgetUpdate(this.clipboard.getWorld().field_73011_w.getDimension(), this.clipboard.getPos(), updateId, packetBuffer));
    }

    @Override
    public void writeUpdateInfo(Widget widget, int updateId, Consumer<PacketBuffer> payloadWriter) {
        this.clipboard.writeCustomData(GregtechDataCodes.UPDATE_UI + (Integer)this.modularUI.guiWidgets.inverse().get((Object)widget), buf -> {
            buf.func_150787_b(this.windowId);
            buf.func_150787_b(((Integer)this.modularUI.guiWidgets.inverse().get((Object)widget)).intValue());
            buf.func_150787_b(updateId);
            payloadWriter.accept((PacketBuffer)buf);
        });
    }
}

