/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.entities;

import gregtech.api.util.GTTeleporter;
import gregtech.api.util.TeleportHandler;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PortalEntity
extends Entity {
    private double targetX = 0.0;
    private double targetY = 0.0;
    private double targetZ = 0.0;
    private int targetDim = 0;
    private int timeToDespawn = 200;

    public PortalEntity(World worldIn) {
        super(worldIn);
        this.field_184245_j = -1;
    }

    public PortalEntity(World worldIn, double x, double y, double z) {
        super(worldIn);
        this.func_70107_b(x, y, z);
        this.field_184245_j = -1;
    }

    protected void func_70088_a() {
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        this.targetX = nbtTagCompound.func_74769_h("targetX");
        this.targetY = nbtTagCompound.func_74769_h("targetY");
        this.targetZ = nbtTagCompound.func_74769_h("targetZ");
        this.targetDim = nbtTagCompound.func_74762_e("targetDim");
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74780_a("targetX", this.targetX);
        nbtTagCompound.func_74780_a("targetY", this.targetY);
        nbtTagCompound.func_74780_a("targetZ", this.targetZ);
        nbtTagCompound.func_74768_a("targetDim", this.targetDim);
    }

    public void func_70071_h_() {
        if (this.timeToDespawn <= 0) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        if (this.timeToDespawn == 200) {
            this.func_184185_a(GTSoundEvents.PORTAL_OPENING, 0.7f, 1.0f);
        } else if (this.timeToDespawn == 10) {
            this.func_184185_a(GTSoundEvents.PORTAL_CLOSING, 0.7f, 1.0f);
        }
        this.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), null);
            for (Entity entity : list) {
                if (entity instanceof PortalEntity) continue;
                GTTeleporter teleporter = new GTTeleporter(TeleportHandler.getWorldByDimensionID(this.targetDim), this.targetX, this.targetY, this.targetZ);
                TeleportHandler.teleport(entity, this.targetDim, (ITeleporter)teleporter, this.targetX + entity.func_70040_Z().field_72450_a, this.targetY, this.targetZ + entity.func_70040_Z().field_72449_c);
            }
        }
        --this.timeToDespawn;
    }

    public void func_70101_b(float yaw, float pitch) {
        super.func_70101_b(yaw, pitch);
    }

    public void setTargetCoordinates(int dimension, double x, double y, double z) {
        this.targetDim = dimension;
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean isOpening() {
        return this.timeToDespawn >= 190;
    }

    public boolean isClosing() {
        return this.timeToDespawn <= 10;
    }

    public int getTimeToDespawn() {
        return this.timeToDespawn;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }
}

