/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.crafting;

import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class ToolHeadReplaceRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static final Map<OrePrefix, IGTTool[]> TOOL_HEAD_TO_TOOL_MAP = new HashMap<OrePrefix, IGTTool[]>();

    public static void setToolHeadForTool(OrePrefix toolHead, IGTTool tool) {
        if (!tool.isElectric()) {
            return;
        }
        ToolHeadReplaceRecipe.TOOL_HEAD_TO_TOOL_MAP.computeIfAbsent((OrePrefix)toolHead, (Function<OrePrefix, IGTTool[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setToolHeadForTool$0(gregtech.api.unification.ore.OrePrefix ), (Lgregtech/api/unification/ore/OrePrefix;)[Lgregtech/api/items/toolitem/IGTTool;)())[tool.getElectricTier()] = tool;
    }

    public boolean func_77569_a(@NotNull InventoryCrafting inv, @NotNull World world) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            list.add(stack);
            if (list.size() <= 2) continue;
            return false;
        }
        if (list.size() == 2) {
            UnificationEntry toolHead;
            IGTTool tool;
            ItemStack stack1 = (ItemStack)list.get(0);
            ItemStack stack2 = (ItemStack)list.get(1);
            if (stack1.func_77973_b() instanceof IGTTool) {
                tool = (IGTTool)stack1.func_77973_b();
                toolHead = OreDictUnifier.getUnificationEntry(stack2);
            } else if (stack2.func_77973_b() instanceof IGTTool) {
                tool = (IGTTool)stack2.func_77973_b();
                toolHead = OreDictUnifier.getUnificationEntry(stack1);
            } else {
                return false;
            }
            if (!tool.isElectric()) {
                return false;
            }
            if (toolHead == null) {
                return false;
            }
            IGTTool[] output = TOOL_HEAD_TO_TOOL_MAP.get(toolHead.orePrefix);
            return output != null && output[tool.getElectricTier()] != null;
        }
        return false;
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull InventoryCrafting inv) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            list.add(itemstack);
        }
        if (list.size() == 2) {
            UnificationEntry toolHead;
            ItemStack toolStack;
            IGTTool tool;
            ItemStack first = (ItemStack)list.get(0);
            ItemStack second = (ItemStack)list.get(1);
            if (first.func_77973_b() instanceof IGTTool) {
                tool = (IGTTool)first.func_77973_b();
                toolStack = first;
                toolHead = OreDictUnifier.getUnificationEntry(second);
            } else if (second.func_77973_b() instanceof IGTTool) {
                tool = (IGTTool)second.func_77973_b();
                toolStack = second;
                toolHead = OreDictUnifier.getUnificationEntry(first);
            } else {
                return ItemStack.field_190927_a;
            }
            if (!tool.isElectric()) {
                return ItemStack.field_190927_a;
            }
            if (toolHead == null) {
                return ItemStack.field_190927_a;
            }
            IGTTool[] toolArray = TOOL_HEAD_TO_TOOL_MAP.get(toolHead.orePrefix);
            IGTTool newTool = toolArray[tool.getElectricTier()];
            if (newTool == null) {
                return ItemStack.field_190927_a;
            }
            return newTool.get(toolHead.material, tool.getCharge(toolStack), tool.getMaxCharge(toolStack));
        }
        return ItemStack.field_190927_a;
    }

    @NotNull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @NotNull
    public NonNullList<ItemStack> func_179532_b(@NotNull InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    private static /* synthetic */ IGTTool[] lambda$setToolHeadForTool$0(OrePrefix p) {
        return new IGTTool[14];
    }
}

