/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.readers;

import gregtech.api.util.GTUtility;
import gregtech.common.covers.filter.readers.BaseFilterReader;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class SimpleItemFilterReader
extends BaseFilterReader
implements IItemHandlerModifiable {
    public static final String COUNT = "Count";
    protected static final String LEGACY_ITEM_KEY = "ItemFilter";
    protected static final String LEGACY_STACK_SIZE = "BigStackSize";
    public static final String RESPECT_NBT = "IgnoreNBT";
    public static final String RESPECT_DAMAGE = "IgnoreDamage";

    public SimpleItemFilterReader(ItemStack container, int slots) {
        super(container, slots);
    }

    public void setIgnoreDamage(boolean ignoreDamage) {
        if (!this.getStackTag().func_74767_n(RESPECT_DAMAGE) == ignoreDamage) {
            return;
        }
        if (ignoreDamage) {
            this.getStackTag().func_82580_o(RESPECT_DAMAGE);
        } else {
            this.getStackTag().func_74757_a(RESPECT_DAMAGE, true);
        }
        this.markDirty();
    }

    public int getSlots() {
        return this.getSize();
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        if (!this.getStackTag().func_74767_n(RESPECT_NBT) == ignoreNBT) {
            return;
        }
        if (ignoreNBT) {
            this.getStackTag().func_82580_o(RESPECT_NBT);
        } else {
            this.getStackTag().func_74757_a(RESPECT_NBT, true);
        }
        this.markDirty();
    }

    public boolean isIgnoreDamage() {
        return !this.getStackTag().func_74767_n(RESPECT_DAMAGE);
    }

    public boolean isIgnoreNBT() {
        return !this.getStackTag().func_74767_n(RESPECT_NBT);
    }

    public int getSlotLimit(int slot) {
        return this.getMaxTransferRate();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (this.validateSlotIndex(slot)) {
            NBTTagCompound item = this.getTagAt(slot);
            return item.func_82582_d() ? ItemStack.field_190927_a : new ItemStack(item);
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.validateSlotIndex(slot)) {
            if (!stack.func_190926_b()) {
                stack.func_190920_e(Math.min(stack.func_190916_E(), this.isBlacklistFilter() ? 1 : this.getMaxTransferRate()));
            }
            NBTTagList list = this.getInventoryNbt();
            list.func_150304_a(slot, (NBTBase)(stack.func_190926_b() ? new NBTTagCompound() : stack.serializeNBT()));
            this.markDirty();
        }
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return stack;
        }
        ItemStack existing = this.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.setStackInSlot(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                this.setStackInSlot(slot, existing);
            }
        }
        return reachedLimit ? GTUtility.copy(stack.func_190916_E() - limit, stack) : ItemStack.field_190927_a;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
        }
        return GTUtility.copy(toExtract, existing);
    }

    protected int getStackLimit(int slot, @NotNull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    @Override
    public void onTransferRateChange() {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack itemStack = this.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            itemStack.func_190920_e(Math.min(itemStack.func_190916_E(), this.isBlacklistFilter() ? 1 : this.getMaxTransferRate()));
            this.setStackInSlot(i, itemStack);
        }
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b(RESPECT_DAMAGE)) {
            this.setIgnoreDamage(nbt.func_74767_n(RESPECT_DAMAGE));
        }
        if (nbt.func_74764_b(RESPECT_NBT)) {
            this.setIgnoreNBT(nbt.func_74767_n(RESPECT_NBT));
        }
    }

    @Override
    public void handleLegacyNBT(NBTTagCompound tag) {
        super.handleLegacyNBT(tag);
        NBTTagCompound legacyFilter = tag.func_74775_l("Filter");
        if (legacyFilter.func_74764_b(LEGACY_ITEM_KEY)) {
            ItemStackHandler temp = new ItemStackHandler();
            NBTTagCompound legacyTag = legacyFilter.func_74775_l(LEGACY_ITEM_KEY);
            NBTTagCompound stackSizes = legacyTag.func_74775_l(LEGACY_STACK_SIZE);
            temp.deserializeNBT(legacyTag);
            for (int i = 0; i < temp.getSlots(); ++i) {
                ItemStack stack = temp.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                if (stackSizes.func_74764_b(String.valueOf(i))) {
                    stack.func_190920_e(stackSizes.func_74762_e(String.valueOf(i)));
                }
                NBTTagCompound stackTag = stack.serializeNBT();
                stackTag.func_74768_a(COUNT, stack.func_190916_E());
                this.getInventoryNbt().func_150304_a(i, (NBTBase)stackTag);
            }
        }
    }
}

