/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.readers;

import gregtech.common.covers.filter.readers.BaseFilterReader;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.jetbrains.annotations.Nullable;

public class SimpleFluidFilterReader
extends BaseFilterReader {
    protected WritableFluidTank[] fluidTanks;
    protected static final String CAPACITY = "Capacity";
    protected static final String LEGACY_FLUIDFILTER_KEY = "FluidFilter";

    public SimpleFluidFilterReader(ItemStack container, int slots) {
        super(container, slots);
        this.fluidTanks = new WritableFluidTank[slots];
        for (int i = 0; i < this.fluidTanks.length; ++i) {
            this.fluidTanks[i] = new WritableFluidTank(this, this.getInventoryNbt().func_150305_b(i));
        }
        this.setCapacity(this.getStackTag().func_74764_b(CAPACITY) ? this.getCapacity() : 1000);
    }

    public final boolean shouldShowAmount() {
        return this.getMaxTransferRate() > 1;
    }

    @Nullable
    public FluidStack getFluidStack(int i) {
        return this.getFluidTank(i).getFluid();
    }

    public void setCapacity(int capacity) {
        this.getStackTag().func_74768_a(CAPACITY, capacity);
        this.markDirty();
    }

    public int getCapacity() {
        return this.getStackTag().func_74762_e(CAPACITY);
    }

    public WritableFluidTank getFluidTank(int i) {
        return this.fluidTanks[i];
    }

    public void setFluidAmounts(int amount) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.getFluidTank(i).setFluidAmount(amount);
        }
    }

    @Override
    public void onTransferRateChange() {
        for (int i = 0; i < this.getSize(); ++i) {
            FluidStack stack = this.getFluidStack(i);
            if (stack == null) continue;
            this.getFluidTank(i).setFluidAmount(Math.min(stack.amount, this.getMaxTransferRate()));
        }
        this.setCapacity(this.getMaxTransferRate());
    }

    @Override
    public void handleLegacyNBT(NBTTagCompound tag) {
        super.handleLegacyNBT(tag);
        NBTTagCompound legacyFilter = tag.func_74775_l("Filter");
        NBTTagList filterSlots = legacyFilter.func_150295_c(LEGACY_FLUIDFILTER_KEY, 10);
        for (int i = 0; i < filterSlots.func_74745_c(); ++i) {
            NBTTagCompound stackTag = filterSlots.func_150305_b(i);
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stackTag);
            if (fluidStack == null) continue;
            int slot = stackTag.func_74762_e("Slot");
            this.getFluidTank(slot).setFluid(fluidStack);
        }
    }

    public class WritableFluidTank
    extends FluidTank {
        private final NBTTagCompound fluidTank;
        private final SimpleFluidFilterReader filterReader;
        protected static final String FLUID_AMOUNT = "Amount";
        protected static final String FLUID = "Fluid";
        protected static final String EMPTY = "Empty";

        protected WritableFluidTank(SimpleFluidFilterReader filterReader, NBTTagCompound fluidTank) {
            super(0);
            this.filterReader = filterReader;
            this.fluidTank = fluidTank;
        }

        public void setFluidAmount(int amount) {
            if (amount <= 0) {
                this.setFluid(null);
            } else if (this.fluidTank.func_74764_b(FLUID)) {
                this.fluidTank.func_74775_l(FLUID).func_74768_a(FLUID_AMOUNT, amount);
                SimpleFluidFilterReader.this.markDirty();
            }
        }

        public boolean isEmpty() {
            return !this.fluidTank.func_74764_b(FLUID);
        }

        @Nullable
        protected NBTTagCompound getFluidTag() {
            if (this.isEmpty()) {
                return null;
            }
            return this.fluidTank.func_74775_l(FLUID);
        }

        @Nullable
        public FluidStack getFluid() {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)this.getFluidTag());
        }

        public void setFluid(@Nullable FluidStack stack) {
            if (stack == null) {
                this.fluidTank.func_82580_o(FLUID);
            } else {
                this.fluidTank.func_74782_a(FLUID, (NBTBase)stack.writeToNBT(new NBTTagCompound()));
            }
            SimpleFluidFilterReader.this.markDirty();
        }

        public boolean showAmount() {
            return this.filterReader.shouldShowAmount();
        }

        public int getFluidAmount() {
            return this.fluidTank.func_74775_l(FLUID).func_74762_e(FLUID_AMOUNT);
        }

        public int getCapacity() {
            return this.filterReader.getCapacity();
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.isEmpty() || !this.getFluid().isFluidEqual(resource)) {
                this.setFluid(resource);
                if (!this.showAmount()) {
                    this.setFluidAmount(1);
                }
                return resource.amount;
            }
            if (this.showAmount()) {
                FluidStack fluid = this.getFluid();
                int accepted = Math.min(resource.amount, this.getCapacity() - fluid.amount);
                fluid.amount += accepted;
                this.setFluid(fluid);
                return accepted;
            }
            return 0;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.isEmpty()) {
                return null;
            }
            FluidStack fluid = this.getFluid();
            fluid.amount -= Math.min(fluid.amount, maxDrain);
            this.setFluidAmount(fluid.amount);
            SimpleFluidFilterReader.this.markDirty();
            return fluid;
        }
    }
}

