/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.readers;

import gregtech.api.util.oreglob.OreGlob;
import gregtech.api.util.oreglob.OreGlobCompileResult;
import gregtech.common.covers.filter.oreglob.impl.ImpossibleOreGlob;
import gregtech.common.covers.filter.readers.SimpleItemFilterReader;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class OreDictFilterReader
extends SimpleItemFilterReader {
    private static final String EXPRESSION = "OreDictionaryFilter";
    private static final String CASE_SENSITIVE = "caseSensitive";
    private static final String MATCH_ALL = "matchAll";
    private OreGlob glob = ImpossibleOreGlob.getInstance();
    private OreGlobCompileResult result;

    public OreDictFilterReader(ItemStack container) {
        super(container, 0);
    }

    public void setExpression(String expression) {
        if (this.getStackTag().func_74779_i(EXPRESSION).equals(expression)) {
            return;
        }
        this.getStackTag().func_74778_a(EXPRESSION, expression);
        this.recompile();
        this.markDirty();
    }

    public String getExpression() {
        return this.getStackTag().func_74779_i(EXPRESSION);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (this.isCaseSensitive() == caseSensitive) {
            return;
        }
        if (!caseSensitive) {
            this.getStackTag().func_74757_a(CASE_SENSITIVE, false);
        } else {
            this.getStackTag().func_82580_o(CASE_SENSITIVE);
        }
        this.recompile();
        this.markDirty();
    }

    public boolean isCaseSensitive() {
        return !this.getStackTag().func_74764_b(CASE_SENSITIVE);
    }

    public void setMatchAll(boolean matchAll) {
        if (this.shouldMatchAll() == matchAll) {
            return;
        }
        if (!matchAll) {
            this.getStackTag().func_74757_a(MATCH_ALL, false);
        } else {
            this.getStackTag().func_82580_o(MATCH_ALL);
        }
        this.markDirty();
    }

    public boolean shouldMatchAll() {
        return !this.getStackTag().func_74764_b(MATCH_ALL);
    }

    @NotNull
    public OreGlob getGlob() {
        return this.glob;
    }

    public OreGlobCompileResult getResult() {
        return this.result;
    }

    public void recompile() {
        String expr = this.getExpression();
        if (!expr.isEmpty()) {
            this.result = OreGlob.compile(expr, !this.isCaseSensitive());
            this.glob = this.result.getInstance();
        } else {
            this.glob = ImpossibleOreGlob.getInstance();
            this.result = null;
        }
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b(EXPRESSION)) {
            this.setExpression(nbt.func_74779_i(EXPRESSION));
        }
        if (nbt.func_74764_b(CASE_SENSITIVE)) {
            this.setCaseSensitive(nbt.func_74767_n(CASE_SENSITIVE));
        }
        if (nbt.func_74764_b(MATCH_ALL)) {
            this.setMatchAll(nbt.func_74767_n(MATCH_ALL));
        }
    }

    @Override
    public void handleLegacyNBT(NBTTagCompound tag) {
        super.handleLegacyNBT(tag);
        NBTTagCompound legacyFilter = tag.func_74775_l("Filter");
        if (legacyFilter.func_74764_b(EXPRESSION)) {
            this.setExpression(legacyFilter.func_74779_i(EXPRESSION));
        }
        if (legacyFilter.func_74764_b(CASE_SENSITIVE)) {
            this.setCaseSensitive(legacyFilter.func_74767_n(CASE_SENSITIVE));
        }
        if (legacyFilter.func_74764_b(MATCH_ALL)) {
            this.setMatchAll(legacyFilter.func_74767_n(MATCH_ALL));
        }
    }
}

