/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.readers;

import gregtech.api.util.IDirtyNotifiable;
import gregtech.common.covers.filter.readers.FilterReader;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class BaseFilterReader
implements FilterReader,
INBTSerializable<NBTTagCompound> {
    protected ItemStack container;
    private IDirtyNotifiable dirtyNotifiable;
    private final int size;
    private int maxTransferRate = 1;
    protected static final String BLACKLIST = "IsBlacklist";
    protected static final String FILTER_CONTENTS = "FilterSlots";
    protected static final String KEY_LEGACY_FILTER = "Filter";

    public BaseFilterReader(ItemStack container, int slots) {
        this.container = container;
        this.size = slots;
    }

    @Override
    public ItemStack getContainer() {
        return this.container;
    }

    @Override
    public void readStack(@NotNull ItemStack stack) {
        this.container = stack;
    }

    @Override
    @NotNull
    public NBTTagList getInventoryNbt() {
        NBTTagCompound nbt = this.getStackTag();
        if (!nbt.func_74764_b(FILTER_CONTENTS)) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.getSize(); ++i) {
                list.func_74742_a((NBTBase)new NBTTagCompound());
            }
            nbt.func_74782_a(FILTER_CONTENTS, (NBTBase)list);
        }
        return nbt.func_150295_c(FILTER_CONTENTS, 10);
    }

    @Override
    @NotNull
    public NBTTagCompound getStackTag() {
        NBTTagCompound nbt = this.container.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            this.container.func_77982_d(nbt);
        }
        return nbt;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public final void setDirtyNotifiable(IDirtyNotifiable dirtyNotifiable) {
        this.dirtyNotifiable = dirtyNotifiable;
    }

    public final void markDirty() {
        if (this.dirtyNotifiable != null) {
            this.dirtyNotifiable.markAsDirty();
        }
    }

    public void onTransferRateChange() {
    }

    public final void setBlacklistFilter(boolean blacklistFilter) {
        if (this.getStackTag().func_74767_n(BLACKLIST) != blacklistFilter) {
            if (blacklistFilter) {
                this.getStackTag().func_74757_a(BLACKLIST, true);
            } else {
                this.getStackTag().func_82580_o(BLACKLIST);
            }
            this.onTransferRateChange();
            this.markDirty();
        }
    }

    public final boolean isBlacklistFilter() {
        return this.getStackTag().func_74767_n(BLACKLIST);
    }

    public void setMaxTransferRate(int transferRate) {
        if (this.maxTransferRate != (transferRate = MathHelper.func_76125_a((int)transferRate, (int)1, (int)Integer.MAX_VALUE))) {
            this.maxTransferRate = transferRate;
            this.onTransferRateChange();
        }
    }

    public int getMaxTransferRate() {
        return this.isBlacklistFilter() ? 1 : this.maxTransferRate;
    }

    @Override
    public boolean validateSlotIndex(int slot) {
        return slot >= 0 && slot < this.getSize();
    }

    public NBTTagCompound serializeNBT() {
        return this.getStackTag();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(BLACKLIST)) {
            this.setBlacklistFilter(nbt.func_74767_n(BLACKLIST));
        }
    }

    public void handleLegacyNBT(NBTTagCompound tag) {
        if (tag.func_74764_b(BLACKLIST)) {
            this.setBlacklistFilter(tag.func_74767_n(BLACKLIST));
        }
    }
}

