/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.node;

import gregtech.common.covers.filter.oreglob.node.BranchType;
import gregtech.common.covers.filter.oreglob.node.MatchDescription;
import gregtech.common.covers.filter.oreglob.node.NodeVisitor;
import gregtech.common.covers.filter.oreglob.node.OreGlobNode;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class BranchNode
extends OreGlobNode {
    final BranchType type;
    final List<OreGlobNode> expressions;

    BranchNode(BranchType type, List<OreGlobNode> expressions) {
        this.type = type;
        this.expressions = expressions;
    }

    @Override
    public void visit(NodeVisitor visitor) {
        if (this.expressions.size() == 1) {
            visitor.group(this.expressions.get(0), this.isNegated());
        } else {
            visitor.branch(this.type, this.expressions, this.isNegated());
        }
    }

    @Override
    protected MatchDescription getIndividualNodeMatchDescription() {
        MatchDescription matchDescription;
        block0 : switch (this.expressions.size()) {
            case 0: {
                if (this.type == BranchType.AND) {
                    matchDescription = MatchDescription.EVERYTHING;
                    break;
                }
                matchDescription = MatchDescription.NOTHING;
                break;
            }
            case 1: {
                matchDescription = this.expressions.get(0).getMatchDescription();
                break;
            }
            default: {
                switch (this.type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case OR: {
                        MatchDescription union = MatchDescription.NOTHING;
                        for (OreGlobNode node : this.expressions) {
                            union = union.or(node.getMatchDescription());
                        }
                        matchDescription = union;
                        break block0;
                    }
                    case AND: {
                        MatchDescription intersection = MatchDescription.EVERYTHING;
                        for (OreGlobNode node : this.expressions) {
                            intersection = intersection.and(node.getMatchDescription());
                        }
                        matchDescription = intersection;
                        break block0;
                    }
                    case XOR: 
                }
                MatchDescription disjunction = MatchDescription.NOTHING;
                for (OreGlobNode node : this.expressions) {
                    disjunction = disjunction.xor(node.getMatchDescription());
                }
                matchDescription = disjunction;
                break;
            }
        }
        MatchDescription description = matchDescription;
        return this.isNegated() ? description.complement() : description;
    }

    @Override
    public boolean isPropertyEqualTo(@NotNull OreGlobNode node) {
        if (!(node instanceof BranchNode)) {
            return false;
        }
        BranchNode br = (BranchNode)node;
        if (this.type != br.type) {
            return false;
        }
        if (this.expressions.size() != br.expressions.size()) {
            return false;
        }
        boolean[] matchFlag = new boolean[this.expressions.size()];
        for (OreGlobNode node1 : this.expressions) {
            boolean matched = false;
            for (int i2 = 0; i2 < br.expressions.size(); ++i2) {
                if (matchFlag[i2] || !node1.isStructurallyEqualTo(br.expressions.get(i2))) continue;
                matchFlag[i2] = true;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }
}

