/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.impl;

import gregtech.api.util.oreglob.OreGlobCompileResult;
import gregtech.common.covers.filter.oreglob.impl.ImpossibleOreGlob;
import gregtech.common.covers.filter.oreglob.impl.NodeOreGlob;
import gregtech.common.covers.filter.oreglob.impl.OreGlobMessages;
import gregtech.common.covers.filter.oreglob.node.OreGlobNode;
import gregtech.common.covers.filter.oreglob.node.OreGlobNodes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class OreGlobParser {
    private static final int CHAR_EOF = -1;
    private final String input;
    private final List<OreGlobCompileResult.Report> reports = new ArrayList<OreGlobCompileResult.Report>();
    private boolean error;
    private boolean ignoreCase;
    private int inputIndex;
    private TokenType tokenType;
    private int tokenStart;
    private int tokenLength;
    @Nullable
    private String tokenLiteralValue;

    public OreGlobParser(String input, boolean ignoreCase) {
        this.input = input;
        this.ignoreCase = ignoreCase;
    }

    private int readNextChar() {
        if (this.input.length() <= this.inputIndex) {
            return -1;
        }
        int i = this.inputIndex;
        this.inputIndex += Character.isSurrogate(this.input.charAt(i)) ? 2 : 1;
        return this.input.codePointAt(i);
    }

    private void advance() {
        block12: while (true) {
            int start = this.inputIndex;
            switch (this.readNextChar()) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block12;
                }
                case 40: {
                    this.setCurrentToken(TokenType.LPAR, start, 1);
                    break block12;
                }
                case 41: {
                    this.setCurrentToken(TokenType.RPAR, start, 1);
                    break block12;
                }
                case 124: {
                    this.setCurrentToken(TokenType.OR, start, 1);
                    break block12;
                }
                case 38: {
                    this.setCurrentToken(TokenType.AND, start, 1);
                    break block12;
                }
                case 33: {
                    this.setCurrentToken(TokenType.NOT, start, 1);
                    break block12;
                }
                case 94: {
                    this.setCurrentToken(TokenType.XOR, start, 1);
                    break block12;
                }
                case 42: {
                    this.setCurrentToken(TokenType.ANY, start, 1);
                    break block12;
                }
                case 63: {
                    this.setCurrentToken(TokenType.ANY_CHAR, start, 1);
                    break block12;
                }
                case -1: {
                    this.setCurrentToken(TokenType.EOF, this.input.length(), 0);
                    break block12;
                }
                default: {
                    this.inputIndex = start;
                    String literalValue = this.gatherLiteralValue();
                    this.setCurrentToken(TokenType.LITERAL, start, this.inputIndex - start, literalValue);
                }
            }
            break;
        }
    }

    private void setCurrentToken(TokenType type, int start, int len) {
        this.setCurrentToken(type, start, len, null);
    }

    private void setCurrentToken(TokenType type, int start, int len, @Nullable String literalValue) {
        this.tokenType = type;
        this.tokenStart = start;
        this.tokenLength = len;
        this.tokenLiteralValue = literalValue;
    }

    private String getTokenSection() {
        return this.tokenType == TokenType.EOF ? OreGlobMessages.compileEOF() : this.input.substring(this.tokenStart, this.tokenStart + this.tokenLength);
    }

    private String gatherLiteralValue() {
        StringBuilder stb = new StringBuilder();
        while (true) {
            int i = this.inputIndex;
            int c = this.readNextChar();
            switch (c) {
                case 92: {
                    c = this.readNextChar();
                    if (c != -1) break;
                    this.error(OreGlobMessages.compileErrorEOFAfterEscape(), i, 1);
                    return stb.toString();
                }
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 33: 
                case 36: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 63: 
                case 94: 
                case 124: {
                    this.inputIndex = i;
                    return stb.toString();
                }
            }
            if (c > 65535) {
                this.error(OreGlobMessages.compileErrorInvalidChar(c), i, 1);
                c = 63;
            }
            stb.appendCodePoint(c);
        }
    }

    private boolean advanceIf(TokenType type) {
        if (this.tokenType != type) {
            return false;
        }
        this.advance();
        return true;
    }

    public OreGlobCompileResult compile() {
        this.advance();
        if (this.tokenType != TokenType.EOF) {
            OreGlobNode expr = this.or();
            if (this.tokenType != TokenType.EOF) {
                this.error(OreGlobMessages.compileErrorUnexpectedTokenAfterEOF(this.getTokenSection()));
            }
            if (!this.error) {
                return new OreGlobCompileResult(new NodeOreGlob(expr), this.reports);
            }
        }
        return new OreGlobCompileResult(ImpossibleOreGlob.getInstance(), this.reports);
    }

    private OreGlobNode or() {
        OreGlobNode expr = this.and();
        if (!this.advanceIf(TokenType.OR)) {
            return expr;
        }
        ArrayList<OreGlobNode> nodes = new ArrayList<OreGlobNode>();
        nodes.add(expr);
        while (true) {
            if (this.advanceIf(TokenType.OR)) {
                continue;
            }
            nodes.add(this.and());
            if (!this.advanceIf(TokenType.OR)) break;
        }
        return OreGlobNodes.or(nodes);
    }

    private OreGlobNode and() {
        OreGlobNode expr = this.xor();
        if (!this.advanceIf(TokenType.AND)) {
            return expr;
        }
        ArrayList<OreGlobNode> nodes = new ArrayList<OreGlobNode>();
        nodes.add(expr);
        while (true) {
            if (this.advanceIf(TokenType.AND)) {
                continue;
            }
            nodes.add(this.xor());
            if (!this.advanceIf(TokenType.AND)) break;
        }
        return OreGlobNodes.and(nodes);
    }

    private OreGlobNode xor() {
        OreGlobNode expr = this.not(false);
        if (!this.advanceIf(TokenType.XOR)) {
            return expr;
        }
        ArrayList<OreGlobNode> nodes = new ArrayList<OreGlobNode>();
        nodes.add(expr);
        do {
            nodes.add(this.not(false));
        } while (this.advanceIf(TokenType.XOR));
        return OreGlobNodes.xor(nodes);
    }

    private OreGlobNode not(boolean nested) {
        OreGlobNode root;
        boolean not = false;
        while (this.advanceIf(TokenType.NOT)) {
            not = !not;
        }
        if (not && this.advanceIf(TokenType.LPAR)) {
            not = false;
            if (this.advanceIf(TokenType.RPAR)) {
                root = OreGlobNodes.not(OreGlobNodes.empty());
            } else {
                root = OreGlobNodes.not(this.or());
                switch (this.tokenType) {
                    case RPAR: {
                        this.advance();
                        break;
                    }
                    case EOF: {
                        break;
                    }
                    default: {
                        this.error(OreGlobMessages.compileErrorUnexpectedToken(this.getTokenSection()));
                        break;
                    }
                }
            }
        } else {
            if (not && nested) {
                this.warn(OreGlobMessages.compileWarnNestedNegation());
            }
            root = this.primary();
        }
        switch (this.tokenType) {
            case NOT: 
            case LITERAL: 
            case LPAR: 
            case ANY: 
            case ANY_CHAR: {
                int tokenStart = this.tokenStart;
                OreGlobNode node = this.not(nested || not);
                if (OreGlobNodes.isNegatedMatch(root) && OreGlobNodes.isNegatedMatch(node)) {
                    this.warn(OreGlobMessages.compileWarnConsecutiveNegation(), tokenStart, tokenStart + this.tokenLength - tokenStart);
                }
                root = OreGlobNodes.append(root, node);
            }
        }
        return not ? OreGlobNodes.not(root) : root;
    }

    private OreGlobNode primary() {
        OreGlobNode oreGlobNode;
        block0 : switch (this.tokenType) {
            case LITERAL: {
                if (this.tokenLiteralValue != null) {
                    OreGlobNode result = OreGlobNodes.match(this.tokenLiteralValue, this.ignoreCase);
                    this.advance();
                    oreGlobNode = result;
                    break;
                }
                this.error("Literal token without value");
                this.advance();
                oreGlobNode = OreGlobNodes.error();
                break;
            }
            case LPAR: {
                this.advance();
                switch (this.tokenType) {
                    case RPAR: {
                        this.advance();
                        oreGlobNode = OreGlobNodes.empty();
                        break block0;
                    }
                    case EOF: {
                        oreGlobNode = OreGlobNodes.empty();
                        break block0;
                    }
                }
                OreGlobNode result = this.or();
                this.advanceIf(TokenType.RPAR);
                oreGlobNode = result;
                break;
            }
            case ANY: {
                oreGlobNode = this.nOrMore(0, true);
                break;
            }
            case ANY_CHAR: {
                oreGlobNode = this.nOrMore(1, false);
                break;
            }
            case EOF: {
                this.error(OreGlobMessages.compileErrorUnexpectedEOF());
                oreGlobNode = OreGlobNodes.error();
                break;
            }
            default: {
                this.error(OreGlobMessages.compileErrorUnexpectedToken(this.getTokenSection()));
                this.advance();
                oreGlobNode = OreGlobNodes.error();
            }
        }
        return oreGlobNode;
    }

    private OreGlobNode nOrMore(int n, boolean more) {
        block4: while (true) {
            this.advance();
            switch (this.tokenType) {
                case ANY_CHAR: {
                    ++n;
                    continue block4;
                }
                case ANY: {
                    more = true;
                    continue block4;
                }
            }
            break;
        }
        return OreGlobNodes.chars(n, more);
    }

    private void error(String message) {
        this.error(message, this.tokenStart, this.tokenLength);
    }

    private void error(String message, int start, int len) {
        this.error = true;
        this.reports.add(new OreGlobCompileResult.Report(message, true, start, len));
    }

    private void warn(String message) {
        this.warn(message, this.tokenStart, this.tokenLength);
    }

    private void warn(String message, int start, int len) {
        this.reports.add(new OreGlobCompileResult.Report(message, false, start, len));
    }

    static enum TokenType {
        LITERAL,
        LPAR,
        RPAR,
        OR,
        AND,
        NOT,
        XOR,
        ANY,
        ANY_CHAR,
        EOF;

    }
}

