/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.impl;

import gregtech.api.util.oreglob.OreGlobTextBuilder;
import gregtech.api.util.oreglob.VisualizationHint;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

final class NodeVisualXMLHandler
extends DefaultHandler {
    private final OreGlobTextBuilder builder;
    private final List<Formatting> formatStack = new ArrayList<Formatting>();
    private boolean start;
    @Nullable
    private Formatting lastAppliedFormatting;

    NodeVisualXMLHandler(@NotNull OreGlobTextBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (qName) {
            case "text": {
                this.pushFormatting(VisualizationHint.TEXT);
                break;
            }
            case "node": {
                this.pushFormatting(VisualizationHint.NODE);
                break;
            }
            case "value": {
                this.pushFormatting(VisualizationHint.VALUE);
                break;
            }
            case "not": {
                this.pushFormatting(VisualizationHint.NOT);
                break;
            }
            case "label": {
                this.pushFormatting(VisualizationHint.LABEL);
                break;
            }
            case "logic": {
                this.pushFormatting(VisualizationHint.LOGIC);
                break;
            }
            case "error": {
                this.pushFormatting(VisualizationHint.ERROR);
                break;
            }
            case "root": {
                if (!this.start) {
                    this.start = true;
                    break;
                }
                this.appendXmlError("Unknown element: <root>");
                break;
            }
            default: {
                this.appendXmlError("Unknown element: <" + qName + ">");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        block18: {
            switch (qName) {
                case "text": {
                    if (!this.popFormatting(VisualizationHint.TEXT)) break;
                    break block18;
                }
                case "node": {
                    if (!this.popFormatting(VisualizationHint.NODE)) break;
                    break block18;
                }
                case "value": {
                    if (!this.popFormatting(VisualizationHint.VALUE)) break;
                    break block18;
                }
                case "not": {
                    if (!this.popFormatting(VisualizationHint.NOT)) break;
                    break block18;
                }
                case "label": {
                    if (!this.popFormatting(VisualizationHint.LABEL)) break;
                    break block18;
                }
                case "logic": {
                    if (!this.popFormatting(VisualizationHint.LOGIC)) break;
                    break block18;
                }
                case "error": {
                    if (!this.popFormatting(VisualizationHint.ERROR)) break;
                    break block18;
                }
                default: {
                    break block18;
                }
            }
            this.appendXmlError("Cannot end formatting: <" + qName + ">");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.applyFormatting();
        this.builder.getStringBuilder().append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.builder.getStringBuilder().append(ch, start, length);
    }

    @Nullable
    private Formatting getActiveFormatting() {
        return this.formatStack.isEmpty() ? null : this.formatStack.get(this.formatStack.size() - 1);
    }

    private void pushFormatting(@NotNull VisualizationHint hint) {
        Formatting prev = this.getActiveFormatting();
        TextFormatting color = this.builder.getFormatting().getFormat(hint);
        this.formatStack.add(new Formatting(hint, (TextFormatting)(color != null ? color : (prev != null ? prev.format : null))));
    }

    private boolean popFormatting(@Nullable VisualizationHint hint) {
        Formatting activeFormatting = this.getActiveFormatting();
        if (activeFormatting != null && activeFormatting.visualizationHint == hint) {
            this.formatStack.remove(this.formatStack.size() - 1);
            return true;
        }
        return false;
    }

    private void applyFormatting() {
        Formatting formatting = this.getActiveFormatting();
        if (formatting == null ? this.lastAppliedFormatting == null || this.lastAppliedFormatting.isSame(null) : formatting.isSame(this.lastAppliedFormatting)) {
            return;
        }
        if (formatting != null) {
            formatting.apply(this.builder.getStringBuilder());
        } else {
            this.builder.getStringBuilder().append(TextFormatting.RESET);
        }
        this.lastAppliedFormatting = formatting;
    }

    private void appendXmlError(@NotNull String text) {
        this.pushFormatting(VisualizationHint.ERROR);
        this.applyFormatting();
        this.builder.getStringBuilder().append("** ").append(text).append(" **");
        this.popFormatting(VisualizationHint.ERROR);
    }

    private static final class Formatting {
        @Nullable
        final VisualizationHint visualizationHint;
        @Nullable
        final TextFormatting format;

        private Formatting(@Nullable VisualizationHint visualizationHint, @Nullable TextFormatting format) {
            this.visualizationHint = visualizationHint;
            this.format = format;
        }

        public void apply(@NotNull StringBuilder stringBuilder) {
            stringBuilder.append(this.format);
        }

        public boolean isSame(@Nullable Formatting other) {
            return other == null ? this.format == null : this.format == other.format;
        }
    }
}

