/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.BoolValue;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.unification.stack.ItemAndMetadata;
import gregtech.common.covers.filter.BaseFilter;
import gregtech.common.covers.filter.IFilter;
import gregtech.common.covers.filter.MatchResult;
import gregtech.common.covers.filter.readers.SmartItemFilterReader;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import org.jetbrains.annotations.NotNull;

public class SmartItemFilter
extends BaseFilter {
    private final SmartItemFilterReader filterReader;

    public SmartItemFilter(ItemStack stack) {
        this.filterReader = new SmartItemFilterReader(stack);
    }

    @Override
    public SmartItemFilterReader getFilterReader() {
        return this.filterReader;
    }

    public SmartFilteringMode getFilteringMode() {
        return this.filterReader.getFilteringMode();
    }

    @Override
    public int getTransferLimit(ItemStack stack, int globalTransferLimit) {
        ItemAndMetadata itemAndMetadata = new ItemAndMetadata(stack);
        SmartFilteringMode filterMode = this.filterReader.getFilteringMode();
        int cachedTransferRateValue = (Integer)filterMode.transferStackSizesCache.getOrDefault((Object)itemAndMetadata, (Object)-1);
        if (cachedTransferRateValue == -1) {
            ItemStack infinitelyBigStack = stack.func_77946_l();
            infinitelyBigStack.func_190920_e(Integer.MAX_VALUE);
            Recipe recipe = filterMode.recipeMap.findRecipe(Long.MAX_VALUE, Collections.singletonList(infinitelyBigStack), Collections.emptyList());
            if (recipe == null) {
                filterMode.transferStackSizesCache.put((Object)itemAndMetadata, 0);
                cachedTransferRateValue = 0;
            } else {
                GTRecipeInput inputIngredient = recipe.getInputs().iterator().next();
                filterMode.transferStackSizesCache.put((Object)itemAndMetadata, inputIngredient.getAmount());
                cachedTransferRateValue = inputIngredient.getAmount();
            }
        }
        return cachedTransferRateValue;
    }

    @Override
    public MatchResult matchItem(ItemStack itemStack) {
        ItemStack stack = itemStack.func_77946_l();
        stack.func_190920_e(this.getTransferLimit(itemStack, Integer.MAX_VALUE));
        return MatchResult.create(stack.func_190916_E() > 0 != this.isBlacklistFilter(), stack, this.getFilteringMode().ordinal());
    }

    @Override
    public boolean testItem(ItemStack toTest) {
        return this.getTransferLimit(toTest, Integer.MAX_VALUE) > 0;
    }

    @Override
    public IFilter.FilterType getType() {
        return IFilter.FilterType.ITEM;
    }

    @Override
    public void initUI(Consumer<gregtech.api.gui.Widget> widgetGroup) {
        widgetGroup.accept(new CycleButtonWidget(10, 0, 75, 20, SmartFilteringMode.class, this.filterReader::getFilteringMode, this.filterReader::setFilteringMode).setTooltipHoverString("cover.smart_item_filter.filtering_mode.description"));
    }

    @Override
    @NotNull
    public ModularPanel createPopupPanel(PanelSyncManager syncManager) {
        return (ModularPanel)((ModularPanel)GTGuis.createPopupPanel("smart_item_filter", 125, 81, false).child((IWidget)CoverWithUI.createTitleRow(this.getContainerStack()))).child((IWidget)((Widget)this.createWidgets(syncManager).top(22)).left(4));
    }

    @Override
    @NotNull
    public ModularPanel createPanel(PanelSyncManager syncManager) {
        return (ModularPanel)GTGuis.createPanel("smart_item_filter", 100, 100).padding(7);
    }

    @Override
    @NotNull
    public Widget<?> createWidgets(PanelSyncManager syncManager) {
        EnumSyncValue filterMode = new EnumSyncValue(SmartFilteringMode.class, this.filterReader::getFilteringMode, this.filterReader::setFilteringMode);
        syncManager.syncValue("filter_mode", (SyncHandler)filterMode);
        return (Widget)((Flow)((Flow)Flow.row().coverChildren()).child((IWidget)((Flow)((Flow)((Flow)((Flow)Flow.column().coverChildren()).marginRight(4)).child(this.createFilterModeButton((EnumSyncValue<SmartFilteringMode>)filterMode, SmartFilteringMode.ELECTROLYZER))).child(this.createFilterModeButton((EnumSyncValue<SmartFilteringMode>)filterMode, SmartFilteringMode.CENTRIFUGE))).child(this.createFilterModeButton((EnumSyncValue<SmartFilteringMode>)filterMode, SmartFilteringMode.SIFTER)))).child(this.createBlacklistUI());
    }

    private Widget<ToggleButton> createFilterModeButton(EnumSyncValue<SmartFilteringMode> value, SmartFilteringMode mode) {
        return ((ToggleButton)((ToggleButton)new ToggleButton().height(18)).width(90)).value((IBoolValue)this.boolValueOf(value, mode)).background(new IDrawable[]{GTGuiTextures.MC_BUTTON}).selectedBackground(new IDrawable[]{GTGuiTextures.MC_BUTTON_DISABLED}).overlay(new IDrawable[]{IKey.lang((String)mode.func_176610_l()).color(Integer.valueOf(Color.WHITE.darker(1)))});
    }

    protected <T extends Enum<T>> BoolValue.Dynamic boolValueOf(EnumSyncValue<T> syncValue, T value) {
        return new BoolValue.Dynamic(() -> syncValue.getValue() == value, $ -> syncValue.setValue((Object)value));
    }

    @Override
    public boolean showGlobalTransferLimitSlider() {
        return true;
    }

    public static enum SmartFilteringMode implements IStringSerializable
    {
        ELECTROLYZER("cover.smart_item_filter.filtering_mode.electrolyzer", RecipeMaps.ELECTROLYZER_RECIPES),
        CENTRIFUGE("cover.smart_item_filter.filtering_mode.centrifuge", RecipeMaps.CENTRIFUGE_RECIPES),
        SIFTER("cover.smart_item_filter.filtering_mode.sifter", RecipeMaps.SIFTER_RECIPES);

        public static final SmartFilteringMode[] VALUES;
        private final Object2IntOpenHashMap<ItemAndMetadata> transferStackSizesCache = new Object2IntOpenHashMap();
        public final String localeName;
        public final RecipeMap<?> recipeMap;

        private SmartFilteringMode(String localeName, RecipeMap<?> recipeMap) {
            this.localeName = localeName;
            this.recipeMap = recipeMap;
        }

        @NotNull
        public String func_176610_l() {
            return this.localeName;
        }

        static {
            VALUES = SmartFilteringMode.values();
        }
    }

    private static class ItemAndMetadataAndStackSize {
        public final ItemAndMetadata itemAndMetadata;
        public final int transferStackSize;

        public ItemAndMetadataAndStackSize(ItemAndMetadata itemAndMetadata, int transferStackSize) {
            this.itemAndMetadata = itemAndMetadata;
            this.transferStackSize = transferStackSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemAndMetadataAndStackSize)) {
                return false;
            }
            ItemAndMetadataAndStackSize that = (ItemAndMetadataAndStackSize)o;
            return this.itemAndMetadata.equals(that.itemAndMetadata);
        }

        public int hashCode() {
            return this.itemAndMetadata.hashCode();
        }
    }
}

