/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IIntValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.CycleButtonWidget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.covers.CoverItemVoidingAdvanced;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.common.covers.TransferMode;
import gregtech.common.covers.VoidingMode;
import gregtech.common.covers.filter.BaseFilter;
import gregtech.common.covers.filter.IFilter;
import gregtech.common.covers.filter.MatchResult;
import gregtech.common.covers.filter.readers.SimpleItemFilterReader;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class SimpleItemFilter
extends BaseFilter {
    private static final int MAX_MATCH_SLOTS = 9;
    private final SimpleItemFilterReader filterReader;

    public SimpleItemFilter(ItemStack stack) {
        this.filterReader = new SimpleItemFilterReader(stack, 9);
    }

    @Override
    public SimpleItemFilterReader getFilterReader() {
        return this.filterReader;
    }

    @Override
    public MatchResult matchItem(ItemStack itemStack) {
        int matchedSlot = SimpleItemFilter.itemFilterMatch((IItemHandler)this.filterReader, this.filterReader.isIgnoreDamage(), this.filterReader.isIgnoreNBT(), itemStack);
        return MatchResult.create(matchedSlot != -1 == !this.isBlacklistFilter(), this.filterReader.getStackInSlot(matchedSlot), matchedSlot);
    }

    @Override
    public boolean testItem(ItemStack toTest) {
        int matchedSlot = SimpleItemFilter.itemFilterMatch((IItemHandler)this.filterReader, this.filterReader.isIgnoreDamage(), this.filterReader.isIgnoreNBT(), toTest);
        return matchedSlot != -1;
    }

    @Override
    public int getTransferLimit(int matchSlot, int transferSize) {
        ItemStack stackInFilterSlot = this.filterReader.getStackInSlot(matchSlot);
        return Math.min(stackInFilterSlot.func_190916_E(), transferSize);
    }

    @Override
    public IFilter.FilterType getType() {
        return IFilter.FilterType.ITEM;
    }

    @Override
    public int getTransferLimit(ItemStack stack, int transferSize) {
        int matchedSlot = SimpleItemFilter.itemFilterMatch((IItemHandler)this.filterReader, this.filterReader.isIgnoreDamage(), this.filterReader.isIgnoreNBT(), stack);
        return this.getTransferLimit(matchedSlot, transferSize);
    }

    @Override
    public void initUI(Consumer<gregtech.api.gui.Widget> widgetGroup) {
        for (int i = 0; i < 9; ++i) {
            widgetGroup.accept(new PhantomSlotWidget(this.filterReader, i, 10 + 18 * (i % 3), 18 * (i / 3)).setBackgroundTexture(GuiTextures.SLOT));
        }
        widgetGroup.accept(new ToggleButtonWidget(74, 0, 20, 20, GuiTextures.BUTTON_FILTER_DAMAGE, this.filterReader::isIgnoreDamage, this.filterReader::setIgnoreDamage).setTooltipText("cover.item_filter.ignore_damage", new Object[0]));
        widgetGroup.accept(new ToggleButtonWidget(99, 0, 20, 20, GuiTextures.BUTTON_FILTER_NBT, this.filterReader::isIgnoreNBT, this.filterReader::setIgnoreNBT).setTooltipText("cover.item_filter.ignore_nbt", new Object[0]));
    }

    @Override
    @NotNull
    public ModularPanel createPopupPanel(PanelSyncManager syncManager) {
        return (ModularPanel)((ModularPanel)GTGuis.createPopupPanel("simple_item_filter", 98, 81, false).child((IWidget)CoverWithUI.createTitleRow(this.getContainerStack()))).child((IWidget)((Widget)this.createWidgets(syncManager).top(22)).left(4));
    }

    @Override
    @NotNull
    public ModularPanel createPanel(PanelSyncManager syncManager) {
        return GTGuis.createPanel("simple_item_filter", 176, 166);
    }

    @Override
    @NotNull
    public Widget<?> createWidgets(PanelSyncManager syncManager) {
        SlotGroup filterInventory = new SlotGroup("filter_inv", 3, 1000, true);
        BooleanSyncValue ignoreDamage = new BooleanSyncValue(this.filterReader::isIgnoreDamage, this.filterReader::setIgnoreDamage);
        BooleanSyncValue ignoreNBT = new BooleanSyncValue(this.filterReader::isIgnoreNBT, this.filterReader::setIgnoreNBT);
        syncManager.registerSlotGroup(filterInventory);
        return (Widget)((Flow)((Flow)Flow.row().coverChildren()).child((IWidget)SlotGroupWidget.builder().matrix(new String[]{"XXX", "XXX", "XXX"}).key('X', index -> ((ItemSlot)((ItemSlot)new ItemSlot().tooltip(tooltip -> {
            tooltip.setAutoUpdate(true);
            tooltip.textColor(Color.GREY.main);
        })).tooltipBuilder(tooltip -> {
            CoverItemVoidingAdvanced coverItem;
            IDirtyNotifiable patt5734$temp;
            CoverRoboticArm coverArm;
            IDirtyNotifiable patt5530$temp = this.dirtyNotifiable;
            if (patt5530$temp instanceof CoverRoboticArm && (coverArm = (CoverRoboticArm)patt5530$temp).getTransferMode() != TransferMode.TRANSFER_ANY || (patt5734$temp = this.dirtyNotifiable) instanceof CoverItemVoidingAdvanced && (coverItem = (CoverItemVoidingAdvanced)patt5734$temp).getVoidingMode() != VoidingMode.VOID_ANY) {
                tooltip.addLine((IDrawable)IKey.lang((String)"cover.item_filter.config_amount"));
                int count = this.filterReader.getTagAt(index).func_74762_e("Count");
                if (count > 0) {
                    tooltip.addLine((IDrawable)IKey.str((String)"Count: %s", (Object[])new Object[]{TextFormattingUtil.formatNumbers(count)}));
                }
            }
        })).slot(SyncHandlers.phantomItemSlot((IItemHandlerModifiable)this.filterReader, (int)index).ignoreMaxStackSize(true).slotGroup(filterInventory).changeListener((newItem, onlyAmountChanged, client, init) -> {
            if (onlyAmountChanged && !init) {
                this.markDirty();
            }
        }))).build().marginRight(4))).child((IWidget)((Flow)((Flow)((Flow)((Flow)Flow.column().width(18)).coverChildren()).child(this.createBlacklistUI())).child((IWidget)new CycleButtonWidget().value((IIntValue)ignoreDamage).stateBackground(0, (IDrawable)GTGuiTextures.BUTTON_IGNORE_DAMAGE[0]).stateBackground(1, (IDrawable)GTGuiTextures.BUTTON_IGNORE_DAMAGE[1]).addTooltip(0, (IDrawable)IKey.lang((String)"cover.item_filter.ignore_damage.disabled")).addTooltip(1, (IDrawable)IKey.lang((String)"cover.item_filter.ignore_damage.enabled")))).child((IWidget)new CycleButtonWidget().value((IIntValue)ignoreNBT).stateBackground(0, (IDrawable)GTGuiTextures.BUTTON_IGNORE_NBT[0]).stateBackground(1, (IDrawable)GTGuiTextures.BUTTON_IGNORE_NBT[1]).addTooltip(0, (IDrawable)IKey.lang((String)"cover.item_filter.ignore_nbt.disabled")).addTooltip(1, (IDrawable)IKey.lang((String)"cover.item_filter.ignore_nbt.enabled"))));
    }

    public static int itemFilterMatch(IItemHandler filterSlots, boolean ignoreDamage, boolean ignoreNBTData, ItemStack itemStack) {
        for (int i = 0; i < filterSlots.getSlots(); ++i) {
            ItemStack filterStack = filterSlots.getStackInSlot(i);
            if (filterStack.func_190926_b() || !SimpleItemFilter.areItemsEqual(ignoreDamage, ignoreNBTData, filterStack, itemStack)) continue;
            return i;
        }
        return -1;
    }

    private static boolean areItemsEqual(boolean ignoreDamage, boolean ignoreNBTData, ItemStack filterStack, ItemStack itemStack) {
        if (ignoreDamage ? !filterStack.func_185136_b(itemStack) : !filterStack.func_77969_a(itemStack)) {
            return false;
        }
        return ignoreNBTData || ItemStack.func_77970_a((ItemStack)filterStack, (ItemStack)itemStack);
    }
}

