/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.widgets.PhantomFluidWidget;
import gregtech.api.mui.GTGuis;
import gregtech.common.covers.filter.BaseFilter;
import gregtech.common.covers.filter.IFilter;
import gregtech.common.covers.filter.MatchResult;
import gregtech.common.covers.filter.readers.SimpleFluidFilterReader;
import gregtech.common.mui.widget.GTFluidSlot;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;

public class SimpleFluidFilter
extends BaseFilter {
    private static final int MAX_FLUID_SLOTS = 9;
    private final SimpleFluidFilterReader filterReader;

    public SimpleFluidFilter(ItemStack stack) {
        this.filterReader = new SimpleFluidFilterReader(stack, 9);
    }

    @Override
    public SimpleFluidFilterReader getFilterReader() {
        return this.filterReader;
    }

    public void configureFilterTanks(int amount) {
        this.filterReader.setFluidAmounts(amount);
        this.markDirty();
    }

    @Override
    @NotNull
    public ModularPanel createPopupPanel(PanelSyncManager syncManager) {
        return (ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPopupPanel("simple_fluid_filter", 98, 81, false).padding(4)).child((IWidget)CoverWithUI.createTitleRow(this.getContainerStack()))).child((IWidget)this.createWidgets(syncManager).top(22));
    }

    @Override
    @NotNull
    public ModularPanel createPanel(PanelSyncManager syncManager) {
        return GTGuis.createPanel(this.getContainerStack(), 176, 168);
    }

    @Override
    @NotNull
    public Widget<?> createWidgets(PanelSyncManager syncManager) {
        return (Widget)((Flow)((Flow)((Flow)Flow.row().coverChildrenHeight()).widthRel(1.0f)).child((IWidget)SlotGroupWidget.builder().matrix(new String[]{"FFF", "FFF", "FFF"}).key('F', i -> new GTFluidSlot().syncHandler(GTFluidSlot.sync((IFluidTank)this.filterReader.getFluidTank(i)).phantom(true).showAmountOnSlot(this.getFilterReader()::shouldShowAmount).showAmountInTooltip(this.getFilterReader()::shouldShowAmount))).build().marginRight(4))).child(this.createBlacklistUI());
    }

    @Override
    public MatchResult matchFluid(FluidStack fluidStack) {
        int index = -1;
        FluidStack returnable = null;
        for (int i = 0; i < this.filterReader.getSize(); ++i) {
            FluidStack fluid = this.filterReader.getFluidStack(i);
            if (fluid == null || !fluid.isFluidEqual(fluidStack)) continue;
            index = i;
            returnable = fluid.copy();
            break;
        }
        return MatchResult.create(index != -1, returnable, index);
    }

    @Override
    public boolean testFluid(FluidStack toTest) {
        for (int i = 0; i < this.filterReader.getSize(); ++i) {
            FluidStack fluid = this.filterReader.getFluidStack(i);
            if (fluid == null || !fluid.isFluidEqual(toTest)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initUI(Consumer<gregtech.api.gui.Widget> widgetGroup) {
        for (int i = 0; i < 9; ++i) {
            widgetGroup.accept(new PhantomFluidWidget(10 + 18 * (i % 3), 18 * (i / 3), 18, 18, this.filterReader.getFluidTank(i)).setBackgroundTexture(GuiTextures.SLOT));
        }
    }

    @Override
    public int getTransferLimit(FluidStack fluidStack, int transferSize) {
        int limit = 0;
        for (int i = 0; i < this.filterReader.getSize(); ++i) {
            FluidStack fluid = this.filterReader.getFluidStack(i);
            if (fluid == null || !fluid.isFluidEqual(fluidStack)) continue;
            limit = fluid.amount;
        }
        return this.isBlacklistFilter() ? transferSize : limit;
    }

    @Override
    public IFilter.FilterType getType() {
        return IFilter.FilterType.FLUID;
    }
}

