/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IIntValue;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.utils.BooleanConsumer;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.CycleButtonWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.stack.ItemVariantMap;
import gregtech.api.unification.stack.MultiItemVariantMap;
import gregtech.api.unification.stack.SingleItemVariantMap;
import gregtech.api.util.oreglob.OreGlobCompileResult;
import gregtech.common.covers.filter.BaseFilter;
import gregtech.common.covers.filter.IFilter;
import gregtech.common.covers.filter.MatchResult;
import gregtech.common.covers.filter.readers.OreDictFilterReader;
import gregtech.common.mui.widget.HighlightedTextField;
import gregtech.common.mui.widget.orefilter.OreFilterTestSlot;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class OreDictionaryItemFilter
extends BaseFilter {
    private final Map<Item, ItemVariantMap.Mutable<Boolean>> matchCache = new Object2ObjectOpenHashMap();
    private final SingleItemVariantMap<Boolean> noOreDictMatch = new SingleItemVariantMap();
    private final OreDictFilterReader filterReader;

    public OreDictionaryItemFilter(ItemStack stack) {
        this.filterReader = new OreDictFilterReader(stack);
        this.recompile();
    }

    @Override
    public OreDictFilterReader getFilterReader() {
        return this.filterReader;
    }

    @NotNull
    public String getExpression() {
        return this.filterReader.getExpression();
    }

    protected void recompile() {
        this.clearCache();
        this.filterReader.recompile();
    }

    protected void clearCache() {
        this.matchCache.clear();
        this.noOreDictMatch.clear();
    }

    @Override
    public void initUI(Consumer<gregtech.api.gui.Widget> widgetGroup) {
    }

    @Override
    @NotNull
    public ModularPanel createPopupPanel(PanelSyncManager syncManager) {
        return (ModularPanel)((ModularPanel)((ModularPanel)GTGuis.createPopupPanel("ore_dict_filter", 188, 76, false).padding(7)).child((IWidget)CoverWithUI.createTitleRow(this.getContainerStack()))).child((IWidget)this.createWidgets(syncManager).top(22));
    }

    @Override
    @NotNull
    public ModularPanel createPanel(PanelSyncManager syncManager) {
        return GTGuis.createPanel("ore_dict_filter", 100, 100);
    }

    @Override
    @NotNull
    public Widget<?> createWidgets(PanelSyncManager syncManager) {
        ArrayList oreSlots = new ArrayList();
        StringSyncValue expression = new StringSyncValue(this.filterReader::getExpression, this.filterReader::setExpression);
        BooleanConsumer setCaseSensitive = b -> {
            this.filterReader.setCaseSensitive(b);
            if (!syncManager.isClient()) {
                return;
            }
            for (OreFilterTestSlot slot : oreSlots) {
                slot.updatePreview();
            }
        };
        BooleanConsumer setMatchAll = b -> {
            this.clearCache();
            this.filterReader.setMatchAll(b);
            if (!syncManager.isClient()) {
                return;
            }
            for (OreFilterTestSlot slot : oreSlots) {
                slot.setMatchAll(b);
            }
        };
        BooleanSyncValue caseSensitive = new BooleanSyncValue(this.filterReader::isCaseSensitive, setCaseSensitive);
        BooleanSyncValue matchAll = new BooleanSyncValue(this.filterReader::shouldMatchAll, setMatchAll);
        return (Widget)((Flow)((Flow)((Flow)Flow.column().widthRel(1.0f)).coverChildrenHeight()).child((IWidget)((TextFieldWidget)((TextFieldWidget)new HighlightedTextField().setHighlightRule(this::highlightRule).onUnfocus(() -> {
            for (OreFilterTestSlot slot : oreSlots) {
                slot.updatePreview();
            }
        }).setTextColor(Color.WHITE.darker(1)).value((IStringValue)expression).marginBottom(4)).height(18)).widthRel(1.0f))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().coverChildrenHeight()).widthRel(1.0f)).child((IWidget)((Flow)((Flow)((Flow)((Flow)Flow.column().height(18)).coverChildrenWidth()).marginRight(2)).child((IWidget)((Widget)((Widget)GTGuiTextures.OREDICT_INFO.asWidget().size(8)).top(0)).addTooltipLine((IDrawable)IKey.lang((String)"cover.ore_dictionary_filter.info")))).child((IWidget)((Widget)((Widget)((Widget)new Widget().size(8)).bottom(0)).onUpdateListener(this::getStatusIcon).tooltipBuilder(this::createStatusTooltip)).tooltip(tooltip -> tooltip.setAutoUpdate(true))))).child((IWidget)SlotGroupWidget.builder().row("XXXXX").key('X', i -> {
            OreFilterTestSlot slot = new OreFilterTestSlot().setGlobSupplier(this.filterReader::getGlob);
            slot.setMatchAll(this.filterReader.shouldMatchAll());
            oreSlots.add(slot);
            return slot;
        }).build().marginRight(2))).child((IWidget)((CycleButtonWidget)((CycleButtonWidget)new CycleButtonWidget().size(18)).value((IIntValue)caseSensitive).marginRight(2)).stateBackground(0, (IDrawable)GTGuiTextures.BUTTON_CASE_SENSITIVE[0]).stateBackground(1, (IDrawable)GTGuiTextures.BUTTON_CASE_SENSITIVE[1]).addTooltip(0, (IDrawable)IKey.lang((String)"cover.ore_dictionary_filter.button.case_sensitive.disabled")).addTooltip(1, (IDrawable)IKey.lang((String)"cover.ore_dictionary_filter.button.case_sensitive.enabled")))).child((IWidget)((CycleButtonWidget)((CycleButtonWidget)new CycleButtonWidget().size(18)).value((IIntValue)matchAll).marginRight(2)).stateBackground(0, (IDrawable)GTGuiTextures.BUTTON_MATCH_ALL[0]).stateBackground(1, (IDrawable)GTGuiTextures.BUTTON_MATCH_ALL[1]).addTooltip(0, (IDrawable)IKey.lang((String)"cover.ore_dictionary_filter.button.match_all.disabled")).addTooltip(1, (IDrawable)IKey.lang((String)"cover.ore_dictionary_filter.button.match_all.enabled")))).child(this.createBlacklistUI()));
    }

    protected void getStatusIcon(Widget<?> widget) {
        OreGlobCompileResult result = this.filterReader.getResult();
        UITexture texture = result == null ? GTGuiTextures.OREDICT_WAITING : (result.getReports().length == 0 ? GTGuiTextures.OREDICT_SUCCESS : (result.hasError() ? GTGuiTextures.OREDICT_ERROR : GTGuiTextures.OREDICT_WARN));
        widget.background(new IDrawable[]{texture});
    }

    protected void createStatusTooltip(RichTooltip tooltip) {
        OreGlobCompileResult result = this.filterReader.getResult();
        if (result == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        int error = 0;
        int warn = 0;
        for (OreGlobCompileResult.Report report : result.getReports()) {
            if (report.isError()) {
                ++error;
            } else {
                ++warn;
            }
            list.add((report.isError() ? TextFormatting.RED : TextFormatting.GOLD) + report.toString());
        }
        if (error > 0) {
            if (warn > 0) {
                list.add(0, I18n.func_135052_a((String)"cover.ore_dictionary_filter.status.err_warn", (Object[])new Object[]{error, warn}));
            } else {
                list.add(0, I18n.func_135052_a((String)"cover.ore_dictionary_filter.status.err", (Object[])new Object[]{error}));
            }
        } else {
            if (warn > 0) {
                list.add(0, I18n.func_135052_a((String)"cover.ore_dictionary_filter.status.warn", (Object[])new Object[]{warn}));
            } else {
                list.add(I18n.func_135052_a((String)"cover.ore_dictionary_filter.status.no_issues", (Object[])new Object[0]));
            }
            list.add("");
            list.add(I18n.func_135052_a((String)"cover.ore_dictionary_filter.status.explain", (Object[])new Object[0]));
            list.add("");
            list.addAll(result.getInstance().toFormattedString());
        }
        tooltip.addStringLines(list);
    }

    protected String highlightRule(String text) {
        StringBuilder builder = new StringBuilder(text);
        block6: for (int i = 0; i < builder.length(); ++i) {
            switch (builder.charAt(i)) {
                case '&': 
                case '(': 
                case ')': 
                case '^': 
                case '|': {
                    builder.insert(i, TextFormatting.GOLD);
                    i += 2;
                    break;
                }
                case '*': 
                case '?': {
                    builder.insert(i, TextFormatting.GREEN);
                    i += 2;
                    break;
                }
                case '!': {
                    builder.insert(i, TextFormatting.RED);
                    i += 2;
                    break;
                }
                case '\\': {
                    builder.insert(i++, TextFormatting.YELLOW);
                    i += 2;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            builder.insert(i + 1, TextFormatting.RESET);
        }
        return builder.toString();
    }

    @Override
    public MatchResult matchItem(ItemStack itemStack) {
        boolean match = this.matchesItemStack(itemStack);
        return MatchResult.create(match != this.isBlacklistFilter(), match ? itemStack.func_77946_l() : ItemStack.field_190927_a, -1);
    }

    @Override
    public boolean testItem(ItemStack toTest) {
        return this.matchesItemStack(toTest);
    }

    @Override
    public IFilter.FilterType getType() {
        return IFilter.FilterType.ITEM;
    }

    public boolean matchesItemStack(@NotNull ItemStack itemStack) {
        Boolean cached;
        OreGlobCompileResult result = this.filterReader.getResult();
        if (result == null || result.hasError()) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        ItemVariantMap<Set<String>> oreDictEntry = OreDictUnifier.getOreDictionaryEntry(item);
        if (oreDictEntry == null) {
            Boolean cached2 = this.noOreDictMatch.getEntry();
            if (cached2 == null) {
                cached2 = this.filterReader.getGlob().matches("");
            }
            this.matchCache.put(item, this.noOreDictMatch);
            return cached2;
        }
        ItemVariantMap.Mutable<Boolean> cacheEntry = this.matchCache.get(item);
        if (cacheEntry != null && (cached = (Boolean)cacheEntry.get(itemStack)) != null) {
            return cached;
        }
        if (cacheEntry == null) {
            if (oreDictEntry.isEmpty()) {
                cached = this.noOreDictMatch.getEntry();
                if (cached == null) {
                    cached = this.filterReader.getGlob().matches("");
                    this.noOreDictMatch.put(cached);
                }
                this.matchCache.put(item, this.noOreDictMatch);
                return cached;
            }
            cacheEntry = !item.func_77614_k() || !oreDictEntry.hasNonWildcardEntry() ? new SingleItemVariantMap<Boolean>() : new MultiItemVariantMap<Boolean>();
            this.matchCache.put(item, cacheEntry);
        }
        boolean matches = this.filterReader.shouldMatchAll() ? this.filterReader.getGlob().matchesAll(itemStack) : this.filterReader.getGlob().matchesAny(itemStack);
        cacheEntry.put(itemStack, (Boolean)matches);
        return matches;
    }

    @Override
    public boolean showGlobalTransferLimitSlider() {
        return true;
    }
}

