/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MatchResult {
    public static final MatchResult NONE = new MatchResult(false, null, -1);
    public static final MatchResult ANY = new MatchResult(true, null, -1);
    private final boolean matched;
    private final Object matchedObject;
    private final int filterIndex;

    private MatchResult(boolean matched, Object matchedObject, int filterIndex) {
        this.matched = matched;
        this.matchedObject = matchedObject;
        this.filterIndex = filterIndex;
    }

    public boolean isMatched() {
        return this.matched;
    }

    public Object getMatchedObject() {
        return this.matchedObject;
    }

    @NotNull
    public ItemStack getItemStack() {
        ItemStack stack;
        Object object = this.matchedObject;
        return object instanceof ItemStack ? (stack = (ItemStack)object) : ItemStack.field_190927_a;
    }

    @Nullable
    public FluidStack getFluidStack() {
        FluidStack stack;
        Object object = this.matchedObject;
        return object instanceof FluidStack ? (stack = (FluidStack)object) : null;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public static MatchResult create(boolean matched, Object matchedStack, int filterIndex) {
        return new MatchResult(matched, matchedStack, filterIndex);
    }
}

